// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about an evaluation form used in a contact evaluation.
 */
public class EvaluationFormContent private constructor(builder: Builder) {
    /**
     * The description of the evaluation form.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) for the evaluation form resource.
     */
    public val evaluationFormArn: kotlin.String = requireNotNull(builder.evaluationFormArn) { "A non-null value must be provided for evaluationFormArn" }
    /**
     * The unique identifier for the evaluation form.
     */
    public val evaluationFormId: kotlin.String = requireNotNull(builder.evaluationFormId) { "A non-null value must be provided for evaluationFormId" }
    /**
     * A version of the evaluation form.
     */
    public val evaluationFormVersion: kotlin.Int = builder.evaluationFormVersion
    /**
     * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
     */
    public val items: List<EvaluationFormItem> = requireNotNull(builder.items) { "A non-null value must be provided for items" }
    /**
     * A scoring strategy of the evaluation form.
     */
    public val scoringStrategy: aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy? = builder.scoringStrategy
    /**
     * A title of the evaluation form.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.EvaluationFormContent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationFormContent(")
        append("description=$description,")
        append("evaluationFormArn=$evaluationFormArn,")
        append("evaluationFormId=$evaluationFormId,")
        append("evaluationFormVersion=$evaluationFormVersion,")
        append("items=$items,")
        append("scoringStrategy=$scoringStrategy,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (evaluationFormArn.hashCode())
        result = 31 * result + (evaluationFormId.hashCode())
        result = 31 * result + (evaluationFormVersion)
        result = 31 * result + (items.hashCode())
        result = 31 * result + (scoringStrategy?.hashCode() ?: 0)
        result = 31 * result + (title.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationFormContent

        if (description != other.description) return false
        if (evaluationFormArn != other.evaluationFormArn) return false
        if (evaluationFormId != other.evaluationFormId) return false
        if (evaluationFormVersion != other.evaluationFormVersion) return false
        if (items != other.items) return false
        if (scoringStrategy != other.scoringStrategy) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.EvaluationFormContent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the evaluation form.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the evaluation form resource.
         */
        public var evaluationFormArn: kotlin.String? = null
        /**
         * The unique identifier for the evaluation form.
         */
        public var evaluationFormId: kotlin.String? = null
        /**
         * A version of the evaluation form.
         */
        public var evaluationFormVersion: kotlin.Int = 0
        /**
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
         */
        public var items: List<EvaluationFormItem>? = null
        /**
         * A scoring strategy of the evaluation form.
         */
        public var scoringStrategy: aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy? = null
        /**
         * A title of the evaluation form.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.EvaluationFormContent) : this() {
            this.description = x.description
            this.evaluationFormArn = x.evaluationFormArn
            this.evaluationFormId = x.evaluationFormId
            this.evaluationFormVersion = x.evaluationFormVersion
            this.items = x.items
            this.scoringStrategy = x.scoringStrategy
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.EvaluationFormContent = EvaluationFormContent(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy] inside the given [block]
         */
        public fun scoringStrategy(block: aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy.Builder.() -> kotlin.Unit) {
            this.scoringStrategy = aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (evaluationFormArn == null) evaluationFormArn = ""
            if (evaluationFormId == null) evaluationFormId = ""
            if (items == null) items = emptyList()
            if (title == null) title = ""
            return this
        }
    }
}
