// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateViewRequest private constructor(builder: Builder) {
    /**
     * A unique Id for each create view request to avoid duplicate view creation. For example, the view is idempotent ClientToken is provided.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * View content containing all content necessary to render a view except for runtime input data.
     *
     * The total uncompressed content has a maximum file size of 400kB.
     */
    public val content: aws.sdk.kotlin.services.connect.model.ViewInputContent? = builder.content
    /**
     * The description of the view.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of the view.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates the view status as either `SAVED` or `PUBLISHED`. The `PUBLISHED` status will initiate validation on the content.
     */
    public val status: aws.sdk.kotlin.services.connect.model.ViewStatus? = builder.status
    /**
     * The tags associated with the view resource (not specific to view version).These tags can be used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateViewRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateViewRequest(")
        append("clientToken=$clientToken,")
        append("content=$content,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("name=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateViewRequest

        if (clientToken != other.clientToken) return false
        if (content != other.content) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateViewRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique Id for each create view request to avoid duplicate view creation. For example, the view is idempotent ClientToken is provided.
         */
        public var clientToken: kotlin.String? = null
        /**
         * View content containing all content necessary to render a view except for runtime input data.
         *
         * The total uncompressed content has a maximum file size of 400kB.
         */
        public var content: aws.sdk.kotlin.services.connect.model.ViewInputContent? = null
        /**
         * The description of the view.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of the view.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates the view status as either `SAVED` or `PUBLISHED`. The `PUBLISHED` status will initiate validation on the content.
         */
        public var status: aws.sdk.kotlin.services.connect.model.ViewStatus? = null
        /**
         * The tags associated with the view resource (not specific to view version).These tags can be used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateViewRequest) : this() {
            this.clientToken = x.clientToken
            this.content = x.content
            this.description = x.description
            this.instanceId = x.instanceId
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateViewRequest = CreateViewRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ViewInputContent] inside the given [block]
         */
        public fun content(block: aws.sdk.kotlin.services.connect.model.ViewInputContent.Builder.() -> kotlin.Unit) {
            this.content = aws.sdk.kotlin.services.connect.model.ViewInputContent.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
