// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information of returned contact.
 */
public class ContactSearchSummary private constructor(builder: Builder) {
    /**
     * Information about the agent who accepted the contact.
     */
    public val agentInfo: aws.sdk.kotlin.services.connect.model.ContactSearchSummaryAgentInfo? = builder.agentInfo
    /**
     * The Amazon Resource Name (ARN) of the contact.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * How the contact reached your contact center.
     */
    public val channel: aws.sdk.kotlin.services.connect.model.Channel? = builder.channel
    /**
     * The timestamp when the customer endpoint disconnected from Amazon Connect.
     */
    public val disconnectTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.disconnectTimestamp
    /**
     * The identifier of the contact summary.
     */
    public val id: kotlin.String? = builder.id
    /**
     * If this contact is related to other contacts, this is the ID of the initial contact.
     */
    public val initialContactId: kotlin.String? = builder.initialContactId
    /**
     * Indicates how the contact was initiated.
     */
    public val initiationMethod: aws.sdk.kotlin.services.connect.model.ContactInitiationMethod? = builder.initiationMethod
    /**
     * The date and time this contact was initiated, in UTC time. For `INBOUND`, this is when the contact arrived. For `OUTBOUND`, this is when the agent began dialing. For `CALLBACK`, this is when the callback contact was created. For `TRANSFER` and `QUEUE_TRANSFER`, this is when the transfer was initiated. For API, this is when the request arrived. For `EXTERNAL_OUTBOUND`, this is when the agent started dialing the external participant. For `MONITOR`, this is when the supervisor started listening to a contact.
     */
    public val initiationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.initiationTimestamp
    /**
     * If this contact is not the first contact, this is the ID of the previous contact.
     */
    public val previousContactId: kotlin.String? = builder.previousContactId
    /**
     * If this contact was queued, this contains information about the queue.
     */
    public val queueInfo: aws.sdk.kotlin.services.connect.model.ContactSearchSummaryQueueInfo? = builder.queueInfo
    /**
     * The timestamp, in Unix epoch time format, at which to start running the inbound flow.
     */
    public val scheduledTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ContactSearchSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContactSearchSummary(")
        append("agentInfo=$agentInfo,")
        append("arn=$arn,")
        append("channel=$channel,")
        append("disconnectTimestamp=$disconnectTimestamp,")
        append("id=$id,")
        append("initialContactId=$initialContactId,")
        append("initiationMethod=$initiationMethod,")
        append("initiationTimestamp=$initiationTimestamp,")
        append("previousContactId=$previousContactId,")
        append("queueInfo=$queueInfo,")
        append("scheduledTimestamp=$scheduledTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentInfo?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (channel?.hashCode() ?: 0)
        result = 31 * result + (disconnectTimestamp?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (initialContactId?.hashCode() ?: 0)
        result = 31 * result + (initiationMethod?.hashCode() ?: 0)
        result = 31 * result + (initiationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (previousContactId?.hashCode() ?: 0)
        result = 31 * result + (queueInfo?.hashCode() ?: 0)
        result = 31 * result + (scheduledTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContactSearchSummary

        if (agentInfo != other.agentInfo) return false
        if (arn != other.arn) return false
        if (channel != other.channel) return false
        if (disconnectTimestamp != other.disconnectTimestamp) return false
        if (id != other.id) return false
        if (initialContactId != other.initialContactId) return false
        if (initiationMethod != other.initiationMethod) return false
        if (initiationTimestamp != other.initiationTimestamp) return false
        if (previousContactId != other.previousContactId) return false
        if (queueInfo != other.queueInfo) return false
        if (scheduledTimestamp != other.scheduledTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ContactSearchSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the agent who accepted the contact.
         */
        public var agentInfo: aws.sdk.kotlin.services.connect.model.ContactSearchSummaryAgentInfo? = null
        /**
         * The Amazon Resource Name (ARN) of the contact.
         */
        public var arn: kotlin.String? = null
        /**
         * How the contact reached your contact center.
         */
        public var channel: aws.sdk.kotlin.services.connect.model.Channel? = null
        /**
         * The timestamp when the customer endpoint disconnected from Amazon Connect.
         */
        public var disconnectTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the contact summary.
         */
        public var id: kotlin.String? = null
        /**
         * If this contact is related to other contacts, this is the ID of the initial contact.
         */
        public var initialContactId: kotlin.String? = null
        /**
         * Indicates how the contact was initiated.
         */
        public var initiationMethod: aws.sdk.kotlin.services.connect.model.ContactInitiationMethod? = null
        /**
         * The date and time this contact was initiated, in UTC time. For `INBOUND`, this is when the contact arrived. For `OUTBOUND`, this is when the agent began dialing. For `CALLBACK`, this is when the callback contact was created. For `TRANSFER` and `QUEUE_TRANSFER`, this is when the transfer was initiated. For API, this is when the request arrived. For `EXTERNAL_OUTBOUND`, this is when the agent started dialing the external participant. For `MONITOR`, this is when the supervisor started listening to a contact.
         */
        public var initiationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If this contact is not the first contact, this is the ID of the previous contact.
         */
        public var previousContactId: kotlin.String? = null
        /**
         * If this contact was queued, this contains information about the queue.
         */
        public var queueInfo: aws.sdk.kotlin.services.connect.model.ContactSearchSummaryQueueInfo? = null
        /**
         * The timestamp, in Unix epoch time format, at which to start running the inbound flow.
         */
        public var scheduledTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ContactSearchSummary) : this() {
            this.agentInfo = x.agentInfo
            this.arn = x.arn
            this.channel = x.channel
            this.disconnectTimestamp = x.disconnectTimestamp
            this.id = x.id
            this.initialContactId = x.initialContactId
            this.initiationMethod = x.initiationMethod
            this.initiationTimestamp = x.initiationTimestamp
            this.previousContactId = x.previousContactId
            this.queueInfo = x.queueInfo
            this.scheduledTimestamp = x.scheduledTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ContactSearchSummary = ContactSearchSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ContactSearchSummaryAgentInfo] inside the given [block]
         */
        public fun agentInfo(block: aws.sdk.kotlin.services.connect.model.ContactSearchSummaryAgentInfo.Builder.() -> kotlin.Unit) {
            this.agentInfo = aws.sdk.kotlin.services.connect.model.ContactSearchSummaryAgentInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ContactSearchSummaryQueueInfo] inside the given [block]
         */
        public fun queueInfo(block: aws.sdk.kotlin.services.connect.model.ContactSearchSummaryQueueInfo.Builder.() -> kotlin.Unit) {
            this.queueInfo = aws.sdk.kotlin.services.connect.model.ContactSearchSummaryQueueInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
