// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a contact.
 */
public class Contact private constructor(builder: Builder) {
    /**
     * Information about the agent who accepted the contact.
     */
    public val agentInfo: aws.sdk.kotlin.services.connect.model.AgentInfo? = builder.agentInfo
    /**
     * The Amazon Resource Name (ARN) for the contact.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * How the contact reached your contact center.
     */
    public val channel: aws.sdk.kotlin.services.connect.model.Channel? = builder.channel
    /**
     * The description of the contact.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The timestamp when the customer endpoint disconnected from Amazon Connect.
     */
    public val disconnectTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.disconnectTimestamp
    /**
     * The identifier for the contact.
     */
    public val id: kotlin.String? = builder.id
    /**
     * If this contact is related to other contacts, this is the ID of the initial contact.
     */
    public val initialContactId: kotlin.String? = builder.initialContactId
    /**
     * Indicates how the contact was initiated.
     */
    public val initiationMethod: aws.sdk.kotlin.services.connect.model.ContactInitiationMethod? = builder.initiationMethod
    /**
     * The date and time this contact was initiated, in UTC time. For `INBOUND`, this is when the contact arrived. For `OUTBOUND`, this is when the agent began dialing. For `CALLBACK`, this is when the callback contact was created. For `TRANSFER` and `QUEUE_TRANSFER`, this is when the transfer was initiated. For `API`, this is when the request arrived. For `EXTERNAL_OUTBOUND`, this is when the agent started dialing the external participant. For `MONITOR`, this is when the supervisor started listening to a contact.
     */
    public val initiationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.initiationTimestamp
    /**
     * The timestamp when the contact was last paused.
     */
    public val lastPausedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastPausedTimestamp
    /**
     * The timestamp when the contact was last resumed.
     */
    public val lastResumedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastResumedTimestamp
    /**
     * The timestamp when contact was last updated.
     */
    public val lastUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTimestamp
    /**
     * The name of the contact.
     */
    public val name: kotlin.String? = builder.name
    /**
     * If this contact is not the first contact, this is the ID of the previous contact.
     */
    public val previousContactId: kotlin.String? = builder.previousContactId
    /**
     * If this contact was queued, this contains information about the queue.
     */
    public val queueInfo: aws.sdk.kotlin.services.connect.model.QueueInfo? = builder.queueInfo
    /**
     * An integer that represents the queue priority to be applied to the contact (lower priorities are routed preferentially). Cannot be specified if the QueueTimeAdjustmentSeconds is specified. Must be statically defined, must be larger than zero, and a valid integer value. Default Value is 5.
     */
    public val queuePriority: kotlin.Long? = builder.queuePriority
    /**
     * An integer that represents the queue time adjust to be applied to the contact, in seconds (longer / larger queue time are routed preferentially). Cannot be specified if the QueuePriority is specified. Must be statically defined and a valid integer value.
     */
    public val queueTimeAdjustmentSeconds: kotlin.Int? = builder.queueTimeAdjustmentSeconds
    /**
     * The contactId that is [related](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html#relatedcontactid) to this contact.
     */
    public val relatedContactId: kotlin.String? = builder.relatedContactId
    /**
     * The timestamp, in Unix epoch time format, at which to start running the inbound flow.
     */
    public val scheduledTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTimestamp
    /**
     * Tags associated with the contact. This contains both Amazon Web Services generated and user-defined tags.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Total pause count for a contact.
     */
    public val totalPauseCount: kotlin.Int? = builder.totalPauseCount
    /**
     * Total pause duration for a contact in seconds.
     */
    public val totalPauseDurationInSeconds: kotlin.Int? = builder.totalPauseDurationInSeconds
    /**
     * Information about Amazon Connect Wisdom.
     */
    public val wisdomInfo: aws.sdk.kotlin.services.connect.model.WisdomInfo? = builder.wisdomInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.Contact = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Contact(")
        append("agentInfo=$agentInfo,")
        append("arn=$arn,")
        append("channel=$channel,")
        append("description=*** Sensitive Data Redacted ***,")
        append("disconnectTimestamp=$disconnectTimestamp,")
        append("id=$id,")
        append("initialContactId=$initialContactId,")
        append("initiationMethod=$initiationMethod,")
        append("initiationTimestamp=$initiationTimestamp,")
        append("lastPausedTimestamp=$lastPausedTimestamp,")
        append("lastResumedTimestamp=$lastResumedTimestamp,")
        append("lastUpdateTimestamp=$lastUpdateTimestamp,")
        append("name=*** Sensitive Data Redacted ***,")
        append("previousContactId=$previousContactId,")
        append("queueInfo=$queueInfo,")
        append("queuePriority=$queuePriority,")
        append("queueTimeAdjustmentSeconds=$queueTimeAdjustmentSeconds,")
        append("relatedContactId=$relatedContactId,")
        append("scheduledTimestamp=$scheduledTimestamp,")
        append("tags=$tags,")
        append("totalPauseCount=$totalPauseCount,")
        append("totalPauseDurationInSeconds=$totalPauseDurationInSeconds,")
        append("wisdomInfo=$wisdomInfo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentInfo?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (channel?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disconnectTimestamp?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (initialContactId?.hashCode() ?: 0)
        result = 31 * result + (initiationMethod?.hashCode() ?: 0)
        result = 31 * result + (initiationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastPausedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastResumedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (previousContactId?.hashCode() ?: 0)
        result = 31 * result + (queueInfo?.hashCode() ?: 0)
        result = 31 * result + (queuePriority?.hashCode() ?: 0)
        result = 31 * result + (queueTimeAdjustmentSeconds ?: 0)
        result = 31 * result + (relatedContactId?.hashCode() ?: 0)
        result = 31 * result + (scheduledTimestamp?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalPauseCount ?: 0)
        result = 31 * result + (totalPauseDurationInSeconds ?: 0)
        result = 31 * result + (wisdomInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Contact

        if (agentInfo != other.agentInfo) return false
        if (arn != other.arn) return false
        if (channel != other.channel) return false
        if (description != other.description) return false
        if (disconnectTimestamp != other.disconnectTimestamp) return false
        if (id != other.id) return false
        if (initialContactId != other.initialContactId) return false
        if (initiationMethod != other.initiationMethod) return false
        if (initiationTimestamp != other.initiationTimestamp) return false
        if (lastPausedTimestamp != other.lastPausedTimestamp) return false
        if (lastResumedTimestamp != other.lastResumedTimestamp) return false
        if (lastUpdateTimestamp != other.lastUpdateTimestamp) return false
        if (name != other.name) return false
        if (previousContactId != other.previousContactId) return false
        if (queueInfo != other.queueInfo) return false
        if (queuePriority != other.queuePriority) return false
        if (queueTimeAdjustmentSeconds != other.queueTimeAdjustmentSeconds) return false
        if (relatedContactId != other.relatedContactId) return false
        if (scheduledTimestamp != other.scheduledTimestamp) return false
        if (tags != other.tags) return false
        if (totalPauseCount != other.totalPauseCount) return false
        if (totalPauseDurationInSeconds != other.totalPauseDurationInSeconds) return false
        if (wisdomInfo != other.wisdomInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.Contact = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the agent who accepted the contact.
         */
        public var agentInfo: aws.sdk.kotlin.services.connect.model.AgentInfo? = null
        /**
         * The Amazon Resource Name (ARN) for the contact.
         */
        public var arn: kotlin.String? = null
        /**
         * How the contact reached your contact center.
         */
        public var channel: aws.sdk.kotlin.services.connect.model.Channel? = null
        /**
         * The description of the contact.
         */
        public var description: kotlin.String? = null
        /**
         * The timestamp when the customer endpoint disconnected from Amazon Connect.
         */
        public var disconnectTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier for the contact.
         */
        public var id: kotlin.String? = null
        /**
         * If this contact is related to other contacts, this is the ID of the initial contact.
         */
        public var initialContactId: kotlin.String? = null
        /**
         * Indicates how the contact was initiated.
         */
        public var initiationMethod: aws.sdk.kotlin.services.connect.model.ContactInitiationMethod? = null
        /**
         * The date and time this contact was initiated, in UTC time. For `INBOUND`, this is when the contact arrived. For `OUTBOUND`, this is when the agent began dialing. For `CALLBACK`, this is when the callback contact was created. For `TRANSFER` and `QUEUE_TRANSFER`, this is when the transfer was initiated. For `API`, this is when the request arrived. For `EXTERNAL_OUTBOUND`, this is when the agent started dialing the external participant. For `MONITOR`, this is when the supervisor started listening to a contact.
         */
        public var initiationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when the contact was last paused.
         */
        public var lastPausedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when the contact was last resumed.
         */
        public var lastResumedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when contact was last updated.
         */
        public var lastUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the contact.
         */
        public var name: kotlin.String? = null
        /**
         * If this contact is not the first contact, this is the ID of the previous contact.
         */
        public var previousContactId: kotlin.String? = null
        /**
         * If this contact was queued, this contains information about the queue.
         */
        public var queueInfo: aws.sdk.kotlin.services.connect.model.QueueInfo? = null
        /**
         * An integer that represents the queue priority to be applied to the contact (lower priorities are routed preferentially). Cannot be specified if the QueueTimeAdjustmentSeconds is specified. Must be statically defined, must be larger than zero, and a valid integer value. Default Value is 5.
         */
        public var queuePriority: kotlin.Long? = null
        /**
         * An integer that represents the queue time adjust to be applied to the contact, in seconds (longer / larger queue time are routed preferentially). Cannot be specified if the QueuePriority is specified. Must be statically defined and a valid integer value.
         */
        public var queueTimeAdjustmentSeconds: kotlin.Int? = null
        /**
         * The contactId that is [related](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html#relatedcontactid) to this contact.
         */
        public var relatedContactId: kotlin.String? = null
        /**
         * The timestamp, in Unix epoch time format, at which to start running the inbound flow.
         */
        public var scheduledTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Tags associated with the contact. This contains both Amazon Web Services generated and user-defined tags.
         */
        public var tags: Map<String, String>? = null
        /**
         * Total pause count for a contact.
         */
        public var totalPauseCount: kotlin.Int? = null
        /**
         * Total pause duration for a contact in seconds.
         */
        public var totalPauseDurationInSeconds: kotlin.Int? = null
        /**
         * Information about Amazon Connect Wisdom.
         */
        public var wisdomInfo: aws.sdk.kotlin.services.connect.model.WisdomInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.Contact) : this() {
            this.agentInfo = x.agentInfo
            this.arn = x.arn
            this.channel = x.channel
            this.description = x.description
            this.disconnectTimestamp = x.disconnectTimestamp
            this.id = x.id
            this.initialContactId = x.initialContactId
            this.initiationMethod = x.initiationMethod
            this.initiationTimestamp = x.initiationTimestamp
            this.lastPausedTimestamp = x.lastPausedTimestamp
            this.lastResumedTimestamp = x.lastResumedTimestamp
            this.lastUpdateTimestamp = x.lastUpdateTimestamp
            this.name = x.name
            this.previousContactId = x.previousContactId
            this.queueInfo = x.queueInfo
            this.queuePriority = x.queuePriority
            this.queueTimeAdjustmentSeconds = x.queueTimeAdjustmentSeconds
            this.relatedContactId = x.relatedContactId
            this.scheduledTimestamp = x.scheduledTimestamp
            this.tags = x.tags
            this.totalPauseCount = x.totalPauseCount
            this.totalPauseDurationInSeconds = x.totalPauseDurationInSeconds
            this.wisdomInfo = x.wisdomInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.Contact = Contact(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.AgentInfo] inside the given [block]
         */
        public fun agentInfo(block: aws.sdk.kotlin.services.connect.model.AgentInfo.Builder.() -> kotlin.Unit) {
            this.agentInfo = aws.sdk.kotlin.services.connect.model.AgentInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.QueueInfo] inside the given [block]
         */
        public fun queueInfo(block: aws.sdk.kotlin.services.connect.model.QueueInfo.Builder.() -> kotlin.Unit) {
            this.queueInfo = aws.sdk.kotlin.services.connect.model.QueueInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.WisdomInfo] inside the given [block]
         */
        public fun wisdomInfo(block: aws.sdk.kotlin.services.connect.model.WisdomInfo.Builder.() -> kotlin.Unit) {
            this.wisdomInfo = aws.sdk.kotlin.services.connect.model.WisdomInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
