// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.connect.auth.ConnectAuthSchemeProvider
import aws.sdk.kotlin.services.connect.auth.DefaultConnectAuthSchemeProvider
import aws.sdk.kotlin.services.connect.endpoints.ConnectEndpointParameters
import aws.sdk.kotlin.services.connect.endpoints.ConnectEndpointProvider
import aws.sdk.kotlin.services.connect.endpoints.DefaultConnectEndpointProvider
import aws.sdk.kotlin.services.connect.model.ActivateEvaluationFormRequest
import aws.sdk.kotlin.services.connect.model.ActivateEvaluationFormResponse
import aws.sdk.kotlin.services.connect.model.AssociateAnalyticsDataSetRequest
import aws.sdk.kotlin.services.connect.model.AssociateAnalyticsDataSetResponse
import aws.sdk.kotlin.services.connect.model.AssociateApprovedOriginRequest
import aws.sdk.kotlin.services.connect.model.AssociateApprovedOriginResponse
import aws.sdk.kotlin.services.connect.model.AssociateBotRequest
import aws.sdk.kotlin.services.connect.model.AssociateBotResponse
import aws.sdk.kotlin.services.connect.model.AssociateDefaultVocabularyRequest
import aws.sdk.kotlin.services.connect.model.AssociateDefaultVocabularyResponse
import aws.sdk.kotlin.services.connect.model.AssociateFlowRequest
import aws.sdk.kotlin.services.connect.model.AssociateFlowResponse
import aws.sdk.kotlin.services.connect.model.AssociateInstanceStorageConfigRequest
import aws.sdk.kotlin.services.connect.model.AssociateInstanceStorageConfigResponse
import aws.sdk.kotlin.services.connect.model.AssociateLambdaFunctionRequest
import aws.sdk.kotlin.services.connect.model.AssociateLambdaFunctionResponse
import aws.sdk.kotlin.services.connect.model.AssociateLexBotRequest
import aws.sdk.kotlin.services.connect.model.AssociateLexBotResponse
import aws.sdk.kotlin.services.connect.model.AssociatePhoneNumberContactFlowRequest
import aws.sdk.kotlin.services.connect.model.AssociatePhoneNumberContactFlowResponse
import aws.sdk.kotlin.services.connect.model.AssociateQueueQuickConnectsRequest
import aws.sdk.kotlin.services.connect.model.AssociateQueueQuickConnectsResponse
import aws.sdk.kotlin.services.connect.model.AssociateRoutingProfileQueuesRequest
import aws.sdk.kotlin.services.connect.model.AssociateRoutingProfileQueuesResponse
import aws.sdk.kotlin.services.connect.model.AssociateSecurityKeyRequest
import aws.sdk.kotlin.services.connect.model.AssociateSecurityKeyResponse
import aws.sdk.kotlin.services.connect.model.AssociateTrafficDistributionGroupUserRequest
import aws.sdk.kotlin.services.connect.model.AssociateTrafficDistributionGroupUserResponse
import aws.sdk.kotlin.services.connect.model.AssociateUserProficienciesRequest
import aws.sdk.kotlin.services.connect.model.AssociateUserProficienciesResponse
import aws.sdk.kotlin.services.connect.model.BatchAssociateAnalyticsDataSetRequest
import aws.sdk.kotlin.services.connect.model.BatchAssociateAnalyticsDataSetResponse
import aws.sdk.kotlin.services.connect.model.BatchDisassociateAnalyticsDataSetRequest
import aws.sdk.kotlin.services.connect.model.BatchDisassociateAnalyticsDataSetResponse
import aws.sdk.kotlin.services.connect.model.BatchGetAttachedFileMetadataRequest
import aws.sdk.kotlin.services.connect.model.BatchGetAttachedFileMetadataResponse
import aws.sdk.kotlin.services.connect.model.BatchGetFlowAssociationRequest
import aws.sdk.kotlin.services.connect.model.BatchGetFlowAssociationResponse
import aws.sdk.kotlin.services.connect.model.BatchPutContactRequest
import aws.sdk.kotlin.services.connect.model.BatchPutContactResponse
import aws.sdk.kotlin.services.connect.model.ClaimPhoneNumberRequest
import aws.sdk.kotlin.services.connect.model.ClaimPhoneNumberResponse
import aws.sdk.kotlin.services.connect.model.CompleteAttachedFileUploadRequest
import aws.sdk.kotlin.services.connect.model.CompleteAttachedFileUploadResponse
import aws.sdk.kotlin.services.connect.model.CreateAgentStatusRequest
import aws.sdk.kotlin.services.connect.model.CreateAgentStatusResponse
import aws.sdk.kotlin.services.connect.model.CreateContactFlowModuleRequest
import aws.sdk.kotlin.services.connect.model.CreateContactFlowModuleResponse
import aws.sdk.kotlin.services.connect.model.CreateContactFlowRequest
import aws.sdk.kotlin.services.connect.model.CreateContactFlowResponse
import aws.sdk.kotlin.services.connect.model.CreateEvaluationFormRequest
import aws.sdk.kotlin.services.connect.model.CreateEvaluationFormResponse
import aws.sdk.kotlin.services.connect.model.CreateHoursOfOperationRequest
import aws.sdk.kotlin.services.connect.model.CreateHoursOfOperationResponse
import aws.sdk.kotlin.services.connect.model.CreateInstanceRequest
import aws.sdk.kotlin.services.connect.model.CreateInstanceResponse
import aws.sdk.kotlin.services.connect.model.CreateIntegrationAssociationRequest
import aws.sdk.kotlin.services.connect.model.CreateIntegrationAssociationResponse
import aws.sdk.kotlin.services.connect.model.CreateParticipantRequest
import aws.sdk.kotlin.services.connect.model.CreateParticipantResponse
import aws.sdk.kotlin.services.connect.model.CreatePersistentContactAssociationRequest
import aws.sdk.kotlin.services.connect.model.CreatePersistentContactAssociationResponse
import aws.sdk.kotlin.services.connect.model.CreatePredefinedAttributeRequest
import aws.sdk.kotlin.services.connect.model.CreatePredefinedAttributeResponse
import aws.sdk.kotlin.services.connect.model.CreatePromptRequest
import aws.sdk.kotlin.services.connect.model.CreatePromptResponse
import aws.sdk.kotlin.services.connect.model.CreateQueueRequest
import aws.sdk.kotlin.services.connect.model.CreateQueueResponse
import aws.sdk.kotlin.services.connect.model.CreateQuickConnectRequest
import aws.sdk.kotlin.services.connect.model.CreateQuickConnectResponse
import aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest
import aws.sdk.kotlin.services.connect.model.CreateRoutingProfileResponse
import aws.sdk.kotlin.services.connect.model.CreateRuleRequest
import aws.sdk.kotlin.services.connect.model.CreateRuleResponse
import aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest
import aws.sdk.kotlin.services.connect.model.CreateSecurityProfileResponse
import aws.sdk.kotlin.services.connect.model.CreateTaskTemplateRequest
import aws.sdk.kotlin.services.connect.model.CreateTaskTemplateResponse
import aws.sdk.kotlin.services.connect.model.CreateTrafficDistributionGroupRequest
import aws.sdk.kotlin.services.connect.model.CreateTrafficDistributionGroupResponse
import aws.sdk.kotlin.services.connect.model.CreateUseCaseRequest
import aws.sdk.kotlin.services.connect.model.CreateUseCaseResponse
import aws.sdk.kotlin.services.connect.model.CreateUserHierarchyGroupRequest
import aws.sdk.kotlin.services.connect.model.CreateUserHierarchyGroupResponse
import aws.sdk.kotlin.services.connect.model.CreateUserRequest
import aws.sdk.kotlin.services.connect.model.CreateUserResponse
import aws.sdk.kotlin.services.connect.model.CreateViewRequest
import aws.sdk.kotlin.services.connect.model.CreateViewResponse
import aws.sdk.kotlin.services.connect.model.CreateViewVersionRequest
import aws.sdk.kotlin.services.connect.model.CreateViewVersionResponse
import aws.sdk.kotlin.services.connect.model.CreateVocabularyRequest
import aws.sdk.kotlin.services.connect.model.CreateVocabularyResponse
import aws.sdk.kotlin.services.connect.model.DeactivateEvaluationFormRequest
import aws.sdk.kotlin.services.connect.model.DeactivateEvaluationFormResponse
import aws.sdk.kotlin.services.connect.model.DeleteAttachedFileRequest
import aws.sdk.kotlin.services.connect.model.DeleteAttachedFileResponse
import aws.sdk.kotlin.services.connect.model.DeleteContactEvaluationRequest
import aws.sdk.kotlin.services.connect.model.DeleteContactEvaluationResponse
import aws.sdk.kotlin.services.connect.model.DeleteContactFlowModuleRequest
import aws.sdk.kotlin.services.connect.model.DeleteContactFlowModuleResponse
import aws.sdk.kotlin.services.connect.model.DeleteContactFlowRequest
import aws.sdk.kotlin.services.connect.model.DeleteContactFlowResponse
import aws.sdk.kotlin.services.connect.model.DeleteEvaluationFormRequest
import aws.sdk.kotlin.services.connect.model.DeleteEvaluationFormResponse
import aws.sdk.kotlin.services.connect.model.DeleteHoursOfOperationRequest
import aws.sdk.kotlin.services.connect.model.DeleteHoursOfOperationResponse
import aws.sdk.kotlin.services.connect.model.DeleteInstanceRequest
import aws.sdk.kotlin.services.connect.model.DeleteInstanceResponse
import aws.sdk.kotlin.services.connect.model.DeleteIntegrationAssociationRequest
import aws.sdk.kotlin.services.connect.model.DeleteIntegrationAssociationResponse
import aws.sdk.kotlin.services.connect.model.DeletePredefinedAttributeRequest
import aws.sdk.kotlin.services.connect.model.DeletePredefinedAttributeResponse
import aws.sdk.kotlin.services.connect.model.DeletePromptRequest
import aws.sdk.kotlin.services.connect.model.DeletePromptResponse
import aws.sdk.kotlin.services.connect.model.DeleteQueueRequest
import aws.sdk.kotlin.services.connect.model.DeleteQueueResponse
import aws.sdk.kotlin.services.connect.model.DeleteQuickConnectRequest
import aws.sdk.kotlin.services.connect.model.DeleteQuickConnectResponse
import aws.sdk.kotlin.services.connect.model.DeleteRoutingProfileRequest
import aws.sdk.kotlin.services.connect.model.DeleteRoutingProfileResponse
import aws.sdk.kotlin.services.connect.model.DeleteRuleRequest
import aws.sdk.kotlin.services.connect.model.DeleteRuleResponse
import aws.sdk.kotlin.services.connect.model.DeleteSecurityProfileRequest
import aws.sdk.kotlin.services.connect.model.DeleteSecurityProfileResponse
import aws.sdk.kotlin.services.connect.model.DeleteTaskTemplateRequest
import aws.sdk.kotlin.services.connect.model.DeleteTaskTemplateResponse
import aws.sdk.kotlin.services.connect.model.DeleteTrafficDistributionGroupRequest
import aws.sdk.kotlin.services.connect.model.DeleteTrafficDistributionGroupResponse
import aws.sdk.kotlin.services.connect.model.DeleteUseCaseRequest
import aws.sdk.kotlin.services.connect.model.DeleteUseCaseResponse
import aws.sdk.kotlin.services.connect.model.DeleteUserHierarchyGroupRequest
import aws.sdk.kotlin.services.connect.model.DeleteUserHierarchyGroupResponse
import aws.sdk.kotlin.services.connect.model.DeleteUserRequest
import aws.sdk.kotlin.services.connect.model.DeleteUserResponse
import aws.sdk.kotlin.services.connect.model.DeleteViewRequest
import aws.sdk.kotlin.services.connect.model.DeleteViewResponse
import aws.sdk.kotlin.services.connect.model.DeleteViewVersionRequest
import aws.sdk.kotlin.services.connect.model.DeleteViewVersionResponse
import aws.sdk.kotlin.services.connect.model.DeleteVocabularyRequest
import aws.sdk.kotlin.services.connect.model.DeleteVocabularyResponse
import aws.sdk.kotlin.services.connect.model.DescribeAgentStatusRequest
import aws.sdk.kotlin.services.connect.model.DescribeAgentStatusResponse
import aws.sdk.kotlin.services.connect.model.DescribeContactEvaluationRequest
import aws.sdk.kotlin.services.connect.model.DescribeContactEvaluationResponse
import aws.sdk.kotlin.services.connect.model.DescribeContactFlowModuleRequest
import aws.sdk.kotlin.services.connect.model.DescribeContactFlowModuleResponse
import aws.sdk.kotlin.services.connect.model.DescribeContactFlowRequest
import aws.sdk.kotlin.services.connect.model.DescribeContactFlowResponse
import aws.sdk.kotlin.services.connect.model.DescribeContactRequest
import aws.sdk.kotlin.services.connect.model.DescribeContactResponse
import aws.sdk.kotlin.services.connect.model.DescribeEvaluationFormRequest
import aws.sdk.kotlin.services.connect.model.DescribeEvaluationFormResponse
import aws.sdk.kotlin.services.connect.model.DescribeHoursOfOperationRequest
import aws.sdk.kotlin.services.connect.model.DescribeHoursOfOperationResponse
import aws.sdk.kotlin.services.connect.model.DescribeInstanceAttributeRequest
import aws.sdk.kotlin.services.connect.model.DescribeInstanceAttributeResponse
import aws.sdk.kotlin.services.connect.model.DescribeInstanceRequest
import aws.sdk.kotlin.services.connect.model.DescribeInstanceResponse
import aws.sdk.kotlin.services.connect.model.DescribeInstanceStorageConfigRequest
import aws.sdk.kotlin.services.connect.model.DescribeInstanceStorageConfigResponse
import aws.sdk.kotlin.services.connect.model.DescribePhoneNumberRequest
import aws.sdk.kotlin.services.connect.model.DescribePhoneNumberResponse
import aws.sdk.kotlin.services.connect.model.DescribePredefinedAttributeRequest
import aws.sdk.kotlin.services.connect.model.DescribePredefinedAttributeResponse
import aws.sdk.kotlin.services.connect.model.DescribePromptRequest
import aws.sdk.kotlin.services.connect.model.DescribePromptResponse
import aws.sdk.kotlin.services.connect.model.DescribeQueueRequest
import aws.sdk.kotlin.services.connect.model.DescribeQueueResponse
import aws.sdk.kotlin.services.connect.model.DescribeQuickConnectRequest
import aws.sdk.kotlin.services.connect.model.DescribeQuickConnectResponse
import aws.sdk.kotlin.services.connect.model.DescribeRoutingProfileRequest
import aws.sdk.kotlin.services.connect.model.DescribeRoutingProfileResponse
import aws.sdk.kotlin.services.connect.model.DescribeRuleRequest
import aws.sdk.kotlin.services.connect.model.DescribeRuleResponse
import aws.sdk.kotlin.services.connect.model.DescribeSecurityProfileRequest
import aws.sdk.kotlin.services.connect.model.DescribeSecurityProfileResponse
import aws.sdk.kotlin.services.connect.model.DescribeTrafficDistributionGroupRequest
import aws.sdk.kotlin.services.connect.model.DescribeTrafficDistributionGroupResponse
import aws.sdk.kotlin.services.connect.model.DescribeUserHierarchyGroupRequest
import aws.sdk.kotlin.services.connect.model.DescribeUserHierarchyGroupResponse
import aws.sdk.kotlin.services.connect.model.DescribeUserHierarchyStructureRequest
import aws.sdk.kotlin.services.connect.model.DescribeUserHierarchyStructureResponse
import aws.sdk.kotlin.services.connect.model.DescribeUserRequest
import aws.sdk.kotlin.services.connect.model.DescribeUserResponse
import aws.sdk.kotlin.services.connect.model.DescribeViewRequest
import aws.sdk.kotlin.services.connect.model.DescribeViewResponse
import aws.sdk.kotlin.services.connect.model.DescribeVocabularyRequest
import aws.sdk.kotlin.services.connect.model.DescribeVocabularyResponse
import aws.sdk.kotlin.services.connect.model.DisassociateAnalyticsDataSetRequest
import aws.sdk.kotlin.services.connect.model.DisassociateAnalyticsDataSetResponse
import aws.sdk.kotlin.services.connect.model.DisassociateApprovedOriginRequest
import aws.sdk.kotlin.services.connect.model.DisassociateApprovedOriginResponse
import aws.sdk.kotlin.services.connect.model.DisassociateBotRequest
import aws.sdk.kotlin.services.connect.model.DisassociateBotResponse
import aws.sdk.kotlin.services.connect.model.DisassociateFlowRequest
import aws.sdk.kotlin.services.connect.model.DisassociateFlowResponse
import aws.sdk.kotlin.services.connect.model.DisassociateInstanceStorageConfigRequest
import aws.sdk.kotlin.services.connect.model.DisassociateInstanceStorageConfigResponse
import aws.sdk.kotlin.services.connect.model.DisassociateLambdaFunctionRequest
import aws.sdk.kotlin.services.connect.model.DisassociateLambdaFunctionResponse
import aws.sdk.kotlin.services.connect.model.DisassociateLexBotRequest
import aws.sdk.kotlin.services.connect.model.DisassociateLexBotResponse
import aws.sdk.kotlin.services.connect.model.DisassociatePhoneNumberContactFlowRequest
import aws.sdk.kotlin.services.connect.model.DisassociatePhoneNumberContactFlowResponse
import aws.sdk.kotlin.services.connect.model.DisassociateQueueQuickConnectsRequest
import aws.sdk.kotlin.services.connect.model.DisassociateQueueQuickConnectsResponse
import aws.sdk.kotlin.services.connect.model.DisassociateRoutingProfileQueuesRequest
import aws.sdk.kotlin.services.connect.model.DisassociateRoutingProfileQueuesResponse
import aws.sdk.kotlin.services.connect.model.DisassociateSecurityKeyRequest
import aws.sdk.kotlin.services.connect.model.DisassociateSecurityKeyResponse
import aws.sdk.kotlin.services.connect.model.DisassociateTrafficDistributionGroupUserRequest
import aws.sdk.kotlin.services.connect.model.DisassociateTrafficDistributionGroupUserResponse
import aws.sdk.kotlin.services.connect.model.DisassociateUserProficienciesRequest
import aws.sdk.kotlin.services.connect.model.DisassociateUserProficienciesResponse
import aws.sdk.kotlin.services.connect.model.DismissUserContactRequest
import aws.sdk.kotlin.services.connect.model.DismissUserContactResponse
import aws.sdk.kotlin.services.connect.model.GetAttachedFileRequest
import aws.sdk.kotlin.services.connect.model.GetAttachedFileResponse
import aws.sdk.kotlin.services.connect.model.GetContactAttributesRequest
import aws.sdk.kotlin.services.connect.model.GetContactAttributesResponse
import aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataRequest
import aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataResponse
import aws.sdk.kotlin.services.connect.model.GetCurrentUserDataRequest
import aws.sdk.kotlin.services.connect.model.GetCurrentUserDataResponse
import aws.sdk.kotlin.services.connect.model.GetFederationTokenRequest
import aws.sdk.kotlin.services.connect.model.GetFederationTokenResponse
import aws.sdk.kotlin.services.connect.model.GetFlowAssociationRequest
import aws.sdk.kotlin.services.connect.model.GetFlowAssociationResponse
import aws.sdk.kotlin.services.connect.model.GetMetricDataRequest
import aws.sdk.kotlin.services.connect.model.GetMetricDataResponse
import aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request
import aws.sdk.kotlin.services.connect.model.GetMetricDataV2Response
import aws.sdk.kotlin.services.connect.model.GetPromptFileRequest
import aws.sdk.kotlin.services.connect.model.GetPromptFileResponse
import aws.sdk.kotlin.services.connect.model.GetTaskTemplateRequest
import aws.sdk.kotlin.services.connect.model.GetTaskTemplateResponse
import aws.sdk.kotlin.services.connect.model.GetTrafficDistributionRequest
import aws.sdk.kotlin.services.connect.model.GetTrafficDistributionResponse
import aws.sdk.kotlin.services.connect.model.ImportPhoneNumberRequest
import aws.sdk.kotlin.services.connect.model.ImportPhoneNumberResponse
import aws.sdk.kotlin.services.connect.model.ListAgentStatusesRequest
import aws.sdk.kotlin.services.connect.model.ListAgentStatusesResponse
import aws.sdk.kotlin.services.connect.model.ListAnalyticsDataAssociationsRequest
import aws.sdk.kotlin.services.connect.model.ListAnalyticsDataAssociationsResponse
import aws.sdk.kotlin.services.connect.model.ListApprovedOriginsRequest
import aws.sdk.kotlin.services.connect.model.ListApprovedOriginsResponse
import aws.sdk.kotlin.services.connect.model.ListBotsRequest
import aws.sdk.kotlin.services.connect.model.ListBotsResponse
import aws.sdk.kotlin.services.connect.model.ListContactEvaluationsRequest
import aws.sdk.kotlin.services.connect.model.ListContactEvaluationsResponse
import aws.sdk.kotlin.services.connect.model.ListContactFlowModulesRequest
import aws.sdk.kotlin.services.connect.model.ListContactFlowModulesResponse
import aws.sdk.kotlin.services.connect.model.ListContactFlowsRequest
import aws.sdk.kotlin.services.connect.model.ListContactFlowsResponse
import aws.sdk.kotlin.services.connect.model.ListContactReferencesRequest
import aws.sdk.kotlin.services.connect.model.ListContactReferencesResponse
import aws.sdk.kotlin.services.connect.model.ListDefaultVocabulariesRequest
import aws.sdk.kotlin.services.connect.model.ListDefaultVocabulariesResponse
import aws.sdk.kotlin.services.connect.model.ListEvaluationFormVersionsRequest
import aws.sdk.kotlin.services.connect.model.ListEvaluationFormVersionsResponse
import aws.sdk.kotlin.services.connect.model.ListEvaluationFormsRequest
import aws.sdk.kotlin.services.connect.model.ListEvaluationFormsResponse
import aws.sdk.kotlin.services.connect.model.ListFlowAssociationsRequest
import aws.sdk.kotlin.services.connect.model.ListFlowAssociationsResponse
import aws.sdk.kotlin.services.connect.model.ListHoursOfOperationsRequest
import aws.sdk.kotlin.services.connect.model.ListHoursOfOperationsResponse
import aws.sdk.kotlin.services.connect.model.ListInstanceAttributesRequest
import aws.sdk.kotlin.services.connect.model.ListInstanceAttributesResponse
import aws.sdk.kotlin.services.connect.model.ListInstanceStorageConfigsRequest
import aws.sdk.kotlin.services.connect.model.ListInstanceStorageConfigsResponse
import aws.sdk.kotlin.services.connect.model.ListInstancesRequest
import aws.sdk.kotlin.services.connect.model.ListInstancesResponse
import aws.sdk.kotlin.services.connect.model.ListIntegrationAssociationsRequest
import aws.sdk.kotlin.services.connect.model.ListIntegrationAssociationsResponse
import aws.sdk.kotlin.services.connect.model.ListLambdaFunctionsRequest
import aws.sdk.kotlin.services.connect.model.ListLambdaFunctionsResponse
import aws.sdk.kotlin.services.connect.model.ListLexBotsRequest
import aws.sdk.kotlin.services.connect.model.ListLexBotsResponse
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersRequest
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersResponse
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersV2Request
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersV2Response
import aws.sdk.kotlin.services.connect.model.ListPredefinedAttributesRequest
import aws.sdk.kotlin.services.connect.model.ListPredefinedAttributesResponse
import aws.sdk.kotlin.services.connect.model.ListPromptsRequest
import aws.sdk.kotlin.services.connect.model.ListPromptsResponse
import aws.sdk.kotlin.services.connect.model.ListQueueQuickConnectsRequest
import aws.sdk.kotlin.services.connect.model.ListQueueQuickConnectsResponse
import aws.sdk.kotlin.services.connect.model.ListQueuesRequest
import aws.sdk.kotlin.services.connect.model.ListQueuesResponse
import aws.sdk.kotlin.services.connect.model.ListQuickConnectsRequest
import aws.sdk.kotlin.services.connect.model.ListQuickConnectsResponse
import aws.sdk.kotlin.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Request
import aws.sdk.kotlin.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Response
import aws.sdk.kotlin.services.connect.model.ListRoutingProfileQueuesRequest
import aws.sdk.kotlin.services.connect.model.ListRoutingProfileQueuesResponse
import aws.sdk.kotlin.services.connect.model.ListRoutingProfilesRequest
import aws.sdk.kotlin.services.connect.model.ListRoutingProfilesResponse
import aws.sdk.kotlin.services.connect.model.ListRulesRequest
import aws.sdk.kotlin.services.connect.model.ListRulesResponse
import aws.sdk.kotlin.services.connect.model.ListSecurityKeysRequest
import aws.sdk.kotlin.services.connect.model.ListSecurityKeysResponse
import aws.sdk.kotlin.services.connect.model.ListSecurityProfileApplicationsRequest
import aws.sdk.kotlin.services.connect.model.ListSecurityProfileApplicationsResponse
import aws.sdk.kotlin.services.connect.model.ListSecurityProfilePermissionsRequest
import aws.sdk.kotlin.services.connect.model.ListSecurityProfilePermissionsResponse
import aws.sdk.kotlin.services.connect.model.ListSecurityProfilesRequest
import aws.sdk.kotlin.services.connect.model.ListSecurityProfilesResponse
import aws.sdk.kotlin.services.connect.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.connect.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.connect.model.ListTaskTemplatesRequest
import aws.sdk.kotlin.services.connect.model.ListTaskTemplatesResponse
import aws.sdk.kotlin.services.connect.model.ListTrafficDistributionGroupUsersRequest
import aws.sdk.kotlin.services.connect.model.ListTrafficDistributionGroupUsersResponse
import aws.sdk.kotlin.services.connect.model.ListTrafficDistributionGroupsRequest
import aws.sdk.kotlin.services.connect.model.ListTrafficDistributionGroupsResponse
import aws.sdk.kotlin.services.connect.model.ListUseCasesRequest
import aws.sdk.kotlin.services.connect.model.ListUseCasesResponse
import aws.sdk.kotlin.services.connect.model.ListUserHierarchyGroupsRequest
import aws.sdk.kotlin.services.connect.model.ListUserHierarchyGroupsResponse
import aws.sdk.kotlin.services.connect.model.ListUserProficienciesRequest
import aws.sdk.kotlin.services.connect.model.ListUserProficienciesResponse
import aws.sdk.kotlin.services.connect.model.ListUsersRequest
import aws.sdk.kotlin.services.connect.model.ListUsersResponse
import aws.sdk.kotlin.services.connect.model.ListViewVersionsRequest
import aws.sdk.kotlin.services.connect.model.ListViewVersionsResponse
import aws.sdk.kotlin.services.connect.model.ListViewsRequest
import aws.sdk.kotlin.services.connect.model.ListViewsResponse
import aws.sdk.kotlin.services.connect.model.MonitorContactRequest
import aws.sdk.kotlin.services.connect.model.MonitorContactResponse
import aws.sdk.kotlin.services.connect.model.PauseContactRequest
import aws.sdk.kotlin.services.connect.model.PauseContactResponse
import aws.sdk.kotlin.services.connect.model.PutUserStatusRequest
import aws.sdk.kotlin.services.connect.model.PutUserStatusResponse
import aws.sdk.kotlin.services.connect.model.ReleasePhoneNumberRequest
import aws.sdk.kotlin.services.connect.model.ReleasePhoneNumberResponse
import aws.sdk.kotlin.services.connect.model.ReplicateInstanceRequest
import aws.sdk.kotlin.services.connect.model.ReplicateInstanceResponse
import aws.sdk.kotlin.services.connect.model.ResumeContactRecordingRequest
import aws.sdk.kotlin.services.connect.model.ResumeContactRecordingResponse
import aws.sdk.kotlin.services.connect.model.ResumeContactRequest
import aws.sdk.kotlin.services.connect.model.ResumeContactResponse
import aws.sdk.kotlin.services.connect.model.SearchAvailablePhoneNumbersRequest
import aws.sdk.kotlin.services.connect.model.SearchAvailablePhoneNumbersResponse
import aws.sdk.kotlin.services.connect.model.SearchContactFlowModulesRequest
import aws.sdk.kotlin.services.connect.model.SearchContactFlowModulesResponse
import aws.sdk.kotlin.services.connect.model.SearchContactFlowsRequest
import aws.sdk.kotlin.services.connect.model.SearchContactFlowsResponse
import aws.sdk.kotlin.services.connect.model.SearchContactsRequest
import aws.sdk.kotlin.services.connect.model.SearchContactsResponse
import aws.sdk.kotlin.services.connect.model.SearchHoursOfOperationsRequest
import aws.sdk.kotlin.services.connect.model.SearchHoursOfOperationsResponse
import aws.sdk.kotlin.services.connect.model.SearchPredefinedAttributesRequest
import aws.sdk.kotlin.services.connect.model.SearchPredefinedAttributesResponse
import aws.sdk.kotlin.services.connect.model.SearchPromptsRequest
import aws.sdk.kotlin.services.connect.model.SearchPromptsResponse
import aws.sdk.kotlin.services.connect.model.SearchQueuesRequest
import aws.sdk.kotlin.services.connect.model.SearchQueuesResponse
import aws.sdk.kotlin.services.connect.model.SearchQuickConnectsRequest
import aws.sdk.kotlin.services.connect.model.SearchQuickConnectsResponse
import aws.sdk.kotlin.services.connect.model.SearchResourceTagsRequest
import aws.sdk.kotlin.services.connect.model.SearchResourceTagsResponse
import aws.sdk.kotlin.services.connect.model.SearchRoutingProfilesRequest
import aws.sdk.kotlin.services.connect.model.SearchRoutingProfilesResponse
import aws.sdk.kotlin.services.connect.model.SearchSecurityProfilesRequest
import aws.sdk.kotlin.services.connect.model.SearchSecurityProfilesResponse
import aws.sdk.kotlin.services.connect.model.SearchUsersRequest
import aws.sdk.kotlin.services.connect.model.SearchUsersResponse
import aws.sdk.kotlin.services.connect.model.SearchVocabulariesRequest
import aws.sdk.kotlin.services.connect.model.SearchVocabulariesResponse
import aws.sdk.kotlin.services.connect.model.SendChatIntegrationEventRequest
import aws.sdk.kotlin.services.connect.model.SendChatIntegrationEventResponse
import aws.sdk.kotlin.services.connect.model.StartAttachedFileUploadRequest
import aws.sdk.kotlin.services.connect.model.StartAttachedFileUploadResponse
import aws.sdk.kotlin.services.connect.model.StartChatContactRequest
import aws.sdk.kotlin.services.connect.model.StartChatContactResponse
import aws.sdk.kotlin.services.connect.model.StartContactEvaluationRequest
import aws.sdk.kotlin.services.connect.model.StartContactEvaluationResponse
import aws.sdk.kotlin.services.connect.model.StartContactRecordingRequest
import aws.sdk.kotlin.services.connect.model.StartContactRecordingResponse
import aws.sdk.kotlin.services.connect.model.StartContactStreamingRequest
import aws.sdk.kotlin.services.connect.model.StartContactStreamingResponse
import aws.sdk.kotlin.services.connect.model.StartOutboundVoiceContactRequest
import aws.sdk.kotlin.services.connect.model.StartOutboundVoiceContactResponse
import aws.sdk.kotlin.services.connect.model.StartTaskContactRequest
import aws.sdk.kotlin.services.connect.model.StartTaskContactResponse
import aws.sdk.kotlin.services.connect.model.StartWebRtcContactRequest
import aws.sdk.kotlin.services.connect.model.StartWebRtcContactResponse
import aws.sdk.kotlin.services.connect.model.StopContactRecordingRequest
import aws.sdk.kotlin.services.connect.model.StopContactRecordingResponse
import aws.sdk.kotlin.services.connect.model.StopContactRequest
import aws.sdk.kotlin.services.connect.model.StopContactResponse
import aws.sdk.kotlin.services.connect.model.StopContactStreamingRequest
import aws.sdk.kotlin.services.connect.model.StopContactStreamingResponse
import aws.sdk.kotlin.services.connect.model.SubmitContactEvaluationRequest
import aws.sdk.kotlin.services.connect.model.SubmitContactEvaluationResponse
import aws.sdk.kotlin.services.connect.model.SuspendContactRecordingRequest
import aws.sdk.kotlin.services.connect.model.SuspendContactRecordingResponse
import aws.sdk.kotlin.services.connect.model.TagContactRequest
import aws.sdk.kotlin.services.connect.model.TagContactResponse
import aws.sdk.kotlin.services.connect.model.TagResourceRequest
import aws.sdk.kotlin.services.connect.model.TagResourceResponse
import aws.sdk.kotlin.services.connect.model.TransferContactRequest
import aws.sdk.kotlin.services.connect.model.TransferContactResponse
import aws.sdk.kotlin.services.connect.model.UntagContactRequest
import aws.sdk.kotlin.services.connect.model.UntagContactResponse
import aws.sdk.kotlin.services.connect.model.UntagResourceRequest
import aws.sdk.kotlin.services.connect.model.UntagResourceResponse
import aws.sdk.kotlin.services.connect.model.UpdateAgentStatusRequest
import aws.sdk.kotlin.services.connect.model.UpdateAgentStatusResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactAttributesRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactAttributesResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactEvaluationRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactEvaluationResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowContentRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowContentResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowMetadataRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowMetadataResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowModuleContentRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowModuleContentResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowModuleMetadataRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowModuleMetadataResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowNameRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactFlowNameResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactRoutingDataRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactRoutingDataResponse
import aws.sdk.kotlin.services.connect.model.UpdateContactScheduleRequest
import aws.sdk.kotlin.services.connect.model.UpdateContactScheduleResponse
import aws.sdk.kotlin.services.connect.model.UpdateEvaluationFormRequest
import aws.sdk.kotlin.services.connect.model.UpdateEvaluationFormResponse
import aws.sdk.kotlin.services.connect.model.UpdateHoursOfOperationRequest
import aws.sdk.kotlin.services.connect.model.UpdateHoursOfOperationResponse
import aws.sdk.kotlin.services.connect.model.UpdateInstanceAttributeRequest
import aws.sdk.kotlin.services.connect.model.UpdateInstanceAttributeResponse
import aws.sdk.kotlin.services.connect.model.UpdateInstanceStorageConfigRequest
import aws.sdk.kotlin.services.connect.model.UpdateInstanceStorageConfigResponse
import aws.sdk.kotlin.services.connect.model.UpdateParticipantRoleConfigRequest
import aws.sdk.kotlin.services.connect.model.UpdateParticipantRoleConfigResponse
import aws.sdk.kotlin.services.connect.model.UpdatePhoneNumberMetadataRequest
import aws.sdk.kotlin.services.connect.model.UpdatePhoneNumberMetadataResponse
import aws.sdk.kotlin.services.connect.model.UpdatePhoneNumberRequest
import aws.sdk.kotlin.services.connect.model.UpdatePhoneNumberResponse
import aws.sdk.kotlin.services.connect.model.UpdatePredefinedAttributeRequest
import aws.sdk.kotlin.services.connect.model.UpdatePredefinedAttributeResponse
import aws.sdk.kotlin.services.connect.model.UpdatePromptRequest
import aws.sdk.kotlin.services.connect.model.UpdatePromptResponse
import aws.sdk.kotlin.services.connect.model.UpdateQueueHoursOfOperationRequest
import aws.sdk.kotlin.services.connect.model.UpdateQueueHoursOfOperationResponse
import aws.sdk.kotlin.services.connect.model.UpdateQueueMaxContactsRequest
import aws.sdk.kotlin.services.connect.model.UpdateQueueMaxContactsResponse
import aws.sdk.kotlin.services.connect.model.UpdateQueueNameRequest
import aws.sdk.kotlin.services.connect.model.UpdateQueueNameResponse
import aws.sdk.kotlin.services.connect.model.UpdateQueueOutboundCallerConfigRequest
import aws.sdk.kotlin.services.connect.model.UpdateQueueOutboundCallerConfigResponse
import aws.sdk.kotlin.services.connect.model.UpdateQueueStatusRequest
import aws.sdk.kotlin.services.connect.model.UpdateQueueStatusResponse
import aws.sdk.kotlin.services.connect.model.UpdateQuickConnectConfigRequest
import aws.sdk.kotlin.services.connect.model.UpdateQuickConnectConfigResponse
import aws.sdk.kotlin.services.connect.model.UpdateQuickConnectNameRequest
import aws.sdk.kotlin.services.connect.model.UpdateQuickConnectNameResponse
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerResponse
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileConcurrencyRequest
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileConcurrencyResponse
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueResponse
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileNameRequest
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileNameResponse
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileQueuesRequest
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileQueuesResponse
import aws.sdk.kotlin.services.connect.model.UpdateRuleRequest
import aws.sdk.kotlin.services.connect.model.UpdateRuleResponse
import aws.sdk.kotlin.services.connect.model.UpdateSecurityProfileRequest
import aws.sdk.kotlin.services.connect.model.UpdateSecurityProfileResponse
import aws.sdk.kotlin.services.connect.model.UpdateTaskTemplateRequest
import aws.sdk.kotlin.services.connect.model.UpdateTaskTemplateResponse
import aws.sdk.kotlin.services.connect.model.UpdateTrafficDistributionRequest
import aws.sdk.kotlin.services.connect.model.UpdateTrafficDistributionResponse
import aws.sdk.kotlin.services.connect.model.UpdateUserHierarchyGroupNameRequest
import aws.sdk.kotlin.services.connect.model.UpdateUserHierarchyGroupNameResponse
import aws.sdk.kotlin.services.connect.model.UpdateUserHierarchyRequest
import aws.sdk.kotlin.services.connect.model.UpdateUserHierarchyResponse
import aws.sdk.kotlin.services.connect.model.UpdateUserHierarchyStructureRequest
import aws.sdk.kotlin.services.connect.model.UpdateUserHierarchyStructureResponse
import aws.sdk.kotlin.services.connect.model.UpdateUserIdentityInfoRequest
import aws.sdk.kotlin.services.connect.model.UpdateUserIdentityInfoResponse
import aws.sdk.kotlin.services.connect.model.UpdateUserPhoneConfigRequest
import aws.sdk.kotlin.services.connect.model.UpdateUserPhoneConfigResponse
import aws.sdk.kotlin.services.connect.model.UpdateUserProficienciesRequest
import aws.sdk.kotlin.services.connect.model.UpdateUserProficienciesResponse
import aws.sdk.kotlin.services.connect.model.UpdateUserRoutingProfileRequest
import aws.sdk.kotlin.services.connect.model.UpdateUserRoutingProfileResponse
import aws.sdk.kotlin.services.connect.model.UpdateUserSecurityProfilesRequest
import aws.sdk.kotlin.services.connect.model.UpdateUserSecurityProfilesResponse
import aws.sdk.kotlin.services.connect.model.UpdateViewContentRequest
import aws.sdk.kotlin.services.connect.model.UpdateViewContentResponse
import aws.sdk.kotlin.services.connect.model.UpdateViewMetadataRequest
import aws.sdk.kotlin.services.connect.model.UpdateViewMetadataResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Connect"
public const val SdkVersion: String = "1.2.13"
public const val ServiceApiVersion: String = "2017-08-08"

/**
 * Amazon Connect is a cloud-based contact center solution that you use to set up and manage a customer contact center and provide reliable customer engagement at any scale.
 *
 * Amazon Connect provides metrics and real-time reporting that enable you to optimize contact routing. You can also resolve customer issues more efficiently by getting customers in touch with the appropriate agents.
 *
 * There are limits to the number of Amazon Connect resources that you can create. There are also limits to the number of requests that you can make per second. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
 *
 * You can connect programmatically to an Amazon Web Services service by using an endpoint. For a list of Amazon Connect endpoints, see [Amazon Connect Endpoints](https://docs.aws.amazon.com/general/latest/gr/connect_region.html).
 */
public interface ConnectClient : SdkClient {
    /**
     * ConnectClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ConnectClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Connect",
                "CONNECT",
                "connect",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ConnectClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ConnectClient = DefaultConnectClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ConnectEndpointProvider = builder.endpointProvider ?: DefaultConnectEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ConnectAuthSchemeProvider = builder.authSchemeProvider ?: DefaultConnectAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Connect"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ConnectEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ConnectAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it is available to start new evaluations based on the form.
     */
    public suspend fun activateEvaluationForm(input: ActivateEvaluationFormRequest): ActivateEvaluationFormResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates the specified dataset for a Amazon Connect instance with the target account. You can associate only one dataset in a single call.
     */
    public suspend fun associateAnalyticsDataSet(input: AssociateAnalyticsDataSetRequest): AssociateAnalyticsDataSetResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates an approved origin to an Amazon Connect instance.
     */
    public suspend fun associateApprovedOrigin(input: AssociateApprovedOriginRequest): AssociateApprovedOriginResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    public suspend fun associateBot(input: AssociateBotRequest): AssociateBotResponse

    /**
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.
     */
    public suspend fun associateDefaultVocabulary(input: AssociateDefaultVocabularyRequest): AssociateDefaultVocabularyResponse

    /**
     * Associates a connect resource to a flow.
     */
    public suspend fun associateFlow(input: AssociateFlowRequest): AssociateFlowResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing chat transcripts.
     *
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     */
    public suspend fun associateInstanceStorageConfig(input: AssociateInstanceStorageConfigRequest): AssociateInstanceStorageConfigResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     */
    public suspend fun associateLambdaFunction(input: AssociateLambdaFunctionRequest): AssociateLambdaFunctionResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports the association of Amazon Lex V1 bots.
     */
    public suspend fun associateLexBot(input: AssociateLexBotRequest): AssociateLexBotResponse

    /**
     * Associates a flow with a phone number claimed to your Amazon Connect instance.
     *
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    public suspend fun associatePhoneNumberContactFlow(input: AssociatePhoneNumberContactFlowRequest): AssociatePhoneNumberContactFlowResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a set of quick connects with a queue.
     */
    public suspend fun associateQueueQuickConnects(input: AssociateQueueQuickConnectsRequest): AssociateQueueQuickConnectsResponse

    /**
     * Associates a set of queues with a routing profile.
     */
    public suspend fun associateRoutingProfileQueues(input: AssociateRoutingProfileQueuesRequest): AssociateRoutingProfileQueuesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a security key to the instance.
     */
    public suspend fun associateSecurityKey(input: AssociateSecurityKeyRequest): AssociateSecurityKeyResponse

    /**
     * Associates an agent with a traffic distribution group.
     */
    public suspend fun associateTrafficDistributionGroupUser(input: AssociateTrafficDistributionGroupUserRequest): AssociateTrafficDistributionGroupUserResponse

    /**
     * >Associates a set of proficiencies with a user.
     */
    public suspend fun associateUserProficiencies(input: AssociateUserProficienciesRequest): AssociateUserProficienciesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a list of analytics datasets for a given Amazon Connect instance to a target account. You can associate multiple datasets in a single call.
     */
    public suspend fun batchAssociateAnalyticsDataSet(input: BatchAssociateAnalyticsDataSetRequest): BatchAssociateAnalyticsDataSetResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Removes a list of analytics datasets associated with a given Amazon Connect instance. You can disassociate multiple datasets in a single call.
     */
    public suspend fun batchDisassociateAnalyticsDataSet(input: BatchDisassociateAnalyticsDataSetRequest): BatchDisassociateAnalyticsDataSetResponse

    /**
     * Allows you to retrieve metadata about multiple attached files on an associated resource. Each attached file provided in the input list must be associated with the input AssociatedResourceArn.
     */
    public suspend fun batchGetAttachedFileMetadata(input: BatchGetAttachedFileMetadataRequest): BatchGetAttachedFileMetadataResponse

    /**
     * Retrieve the flow associations for the given resources.
     */
    public suspend fun batchGetFlowAssociation(input: BatchGetFlowAssociationRequest): BatchGetFlowAssociationResponse

    /**
     * Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call this API.
     *
     * Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial requests via the [PutDialRequestBatch](https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html) API. It then uses BatchPutContact to create contacts corresponding to those dial requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting voice call uses the same contactId that was created by BatchPutContact.
     */
    public suspend fun batchPutContact(input: BatchPutContactRequest): BatchPutContactResponse

    /**
     * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group was created.
     *
     * For more information about how to use this operation, see [Claim a phone number in your country](https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html) and [Claim phone numbers to traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     *
     * You can call the [SearchAvailablePhoneNumbers](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html) API for available phone numbers that you can claim. Call the [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API to verify the status of a previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) operation.
     *
     * If you plan to claim and release numbers frequently during a 30 day period, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until 30 days past the oldest number released has expired.
     *
     * By default you can claim and release up to 200% of your maximum number of active phone numbers during any 30 day period. If you claim and release phone numbers using the UI or API during a rolling 30 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming any more numbers until 30 days past the oldest number released has expired.
     *
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 30 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     */
    public suspend fun claimPhoneNumber(input: ClaimPhoneNumberRequest): ClaimPhoneNumberResponse

    /**
     * Allows you to confirm that the attached file has been uploaded using the pre-signed URL provided in the StartAttachedFileUpload API.
     */
    public suspend fun completeAttachedFileUpload(input: CompleteAttachedFileUploadRequest): CompleteAttachedFileUploadResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates an agent status for the specified Amazon Connect instance.
     */
    public suspend fun createAgentStatus(input: CreateAgentStatusRequest): CreateAgentStatusResponse

    /**
     * Creates a flow for the specified Amazon Connect instance.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    public suspend fun createContactFlow(input: CreateContactFlowRequest): CreateContactFlowResponse

    /**
     * Creates a flow module for the specified Amazon Connect instance.
     */
    public suspend fun createContactFlowModule(input: CreateContactFlowModuleRequest): CreateContactFlowModuleResponse

    /**
     * Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions related to agent performance, and create sections to organize such questions. Question and section identifiers cannot be duplicated within the same evaluation form.
     */
    public suspend fun createEvaluationForm(input: CreateEvaluationFormRequest): CreateEvaluationFormResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates hours of operation.
     */
    public suspend fun createHoursOfOperation(input: CreateHoursOfOperationRequest): CreateHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    public suspend fun createInstance(input: CreateInstanceRequest): CreateInstanceResponse

    /**
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     */
    public suspend fun createIntegrationAssociation(input: CreateIntegrationAssociationRequest): CreateIntegrationAssociationResponse

    /**
     * Adds a new participant into an on-going chat contact. For more information, see [Customize chat flow experiences by integrating custom participants](https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html).
     */
    public suspend fun createParticipant(input: CreateParticipantRequest): CreateParticipantResponse

    /**
     * Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun createPersistentContactAssociation(input: CreatePersistentContactAssociationRequest): CreatePersistentContactAssociationResponse

    /**
     * Creates a new predefined attribute for the specified Amazon Connect instance.
     */
    public suspend fun createPredefinedAttribute(input: CreatePredefinedAttributeRequest): CreatePredefinedAttributeResponse

    /**
     * Creates a prompt. For more information about prompts, such as supported file types and maximum length, see [Create prompts](https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html) in the *Amazon Connect Administrator's Guide*.
     */
    public suspend fun createPrompt(input: CreatePromptRequest): CreatePromptResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates a new queue for the specified Amazon Connect instance.
     *
     * + If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for `OutboundCallerIdNumberId`. However, if the phone number is claimed to a traffic distribution group that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     * + Only use the phone number ARN format that doesn't contain `instance` in the path, for example, `arn:aws:connect:us-east-1:1234567890:phone-number/uuid`. This is the same ARN format that is returned when you call the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API.
     * + If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic distribution group, see [Allow or Deny queue API actions for phone numbers in a replica Region](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region).
     */
    public suspend fun createQueue(input: CreateQueueRequest): CreateQueueResponse

    /**
     * Creates a quick connect for the specified Amazon Connect instance.
     */
    public suspend fun createQuickConnect(input: CreateQuickConnectRequest): CreateQuickConnectResponse

    /**
     * Creates a new routing profile.
     */
    public suspend fun createRoutingProfile(input: CreateRoutingProfileRequest): CreateRoutingProfileResponse

    /**
     * Creates a rule for the specified Amazon Connect instance.
     *
     * Use the [Rules Function language](https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html) to code conditions for the rule.
     */
    public suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse

    /**
     * Creates a security profile.
     */
    public suspend fun createSecurityProfile(input: CreateSecurityProfileRequest): CreateSecurityProfileResponse

    /**
     * Creates a new task template in the specified Amazon Connect instance.
     */
    public suspend fun createTaskTemplate(input: CreateTaskTemplateRequest): CreateTaskTemplateResponse

    /**
     * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
     *
     * The `SignInConfig` distribution is available only on a default `TrafficDistributionGroup` (see the `IsDefault` parameter in the [TrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html) data type). If you call `UpdateTrafficDistribution` with a modified `SignInConfig` and a non-default `TrafficDistributionGroup`, an `InvalidRequestException` is returned.
     *
     * For more information about creating traffic distribution groups, see [Set up traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun createTrafficDistributionGroup(input: CreateTrafficDistributionGroupRequest): CreateTrafficDistributionGroupResponse

    /**
     * Creates a use case for an integration association.
     */
    public suspend fun createUseCase(input: CreateUseCaseRequest): CreateUseCaseResponse

    /**
     * Creates a user account for the specified Amazon Connect instance.
     *
     * Certain [UserIdentityInfo](https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html) parameters are required in some situations. For example, `Email` is required if you are using SAML for identity management. `FirstName` and `LastName` are required if you are using Amazon Connect or SAML for identity management.
     *
     * For information about how to create users using the Amazon Connect admin website, see [Add Users](https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates a new user hierarchy group.
     */
    public suspend fun createUserHierarchyGroup(input: CreateUserHierarchyGroupRequest): CreateUserHierarchyGroupResponse

    /**
     * Creates a new view with the possible status of `SAVED` or `PUBLISHED`.
     *
     * The views will have a unique name for each connect instance.
     *
     * It performs basic content validation if the status is `SAVED` or full content validation if the status is set to `PUBLISHED`. An error is returned if validation fails. It associates either the `$SAVED` qualifier or both of the `$SAVED` and `$LATEST` qualifiers with the provided view content based on the status. The view is idempotent if ClientToken is provided.
     */
    public suspend fun createView(input: CreateViewRequest): CreateViewResponse

    /**
     * Publishes a new version of the view identifier.
     *
     * Versions are immutable and monotonically increasing.
     *
     * It returns the highest version if there is no change in content compared to that version. An error is displayed if the supplied ViewContentSha256 is different from the ViewContentSha256 of the `$LATEST` alias.
     */
    public suspend fun createViewVersion(input: CreateViewVersionRequest): CreateViewVersionResponse

    /**
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.
     */
    public suspend fun createVocabulary(input: CreateVocabularyRequest): CreateVocabularyResponse

    /**
     * Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no longer available for users to start new evaluations based on the form.
     */
    public suspend fun deactivateEvaluationForm(input: DeactivateEvaluationFormRequest): DeactivateEvaluationFormResponse

    /**
     * Deletes an attached file along with the underlying S3 Object.
     *
     * The attached file is **permanently deleted** if S3 bucket versioning is not enabled.
     */
    public suspend fun deleteAttachedFile(input: DeleteAttachedFileRequest): DeleteAttachedFileResponse

    /**
     * Deletes a contact evaluation in the specified Amazon Connect instance.
     */
    public suspend fun deleteContactEvaluation(input: DeleteContactEvaluationRequest): DeleteContactEvaluationResponse

    /**
     * Deletes a flow for the specified Amazon Connect instance.
     */
    public suspend fun deleteContactFlow(input: DeleteContactFlowRequest): DeleteContactFlowResponse

    /**
     * Deletes the specified flow module.
     */
    public suspend fun deleteContactFlowModule(input: DeleteContactFlowModuleRequest): DeleteContactFlowModuleResponse

    /**
     * Deletes an evaluation form in the specified Amazon Connect instance.
     * + If the version property is provided, only the specified version of the evaluation form is deleted.
     * + If no version is provided, then the full form (all versions) is deleted.
     */
    public suspend fun deleteEvaluationForm(input: DeleteEvaluationFormRequest): DeleteEvaluationFormResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes an hours of operation.
     */
    public suspend fun deleteHoursOfOperation(input: DeleteHoursOfOperationRequest): DeleteHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the Amazon Connect instance.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    public suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse

    /**
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.
     */
    public suspend fun deleteIntegrationAssociation(input: DeleteIntegrationAssociationRequest): DeleteIntegrationAssociationResponse

    /**
     * Deletes a predefined attribute from the specified Amazon Connect instance.
     */
    public suspend fun deletePredefinedAttribute(input: DeletePredefinedAttributeRequest): DeletePredefinedAttributeResponse

    /**
     * Deletes a prompt.
     */
    public suspend fun deletePrompt(input: DeletePromptRequest): DeletePromptResponse

    /**
     * Deletes a queue.
     */
    public suspend fun deleteQueue(input: DeleteQueueRequest): DeleteQueueResponse

    /**
     * Deletes a quick connect.
     *
     * After calling [DeleteUser](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html), it's important to call `DeleteQuickConnect` to delete any records related to the deleted users. This will help you:
     * + Avoid dangling resources that impact your service quotas.
     * + Remove deleted users so they don't appear to agents as transfer options.
     * + Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using [Amazon Connect Global Resiliency](https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html).
     */
    public suspend fun deleteQuickConnect(input: DeleteQuickConnectRequest): DeleteQuickConnectResponse

    /**
     * Deletes a routing profile.
     */
    public suspend fun deleteRoutingProfile(input: DeleteRoutingProfileRequest): DeleteRoutingProfileResponse

    /**
     * Deletes a rule for the specified Amazon Connect instance.
     */
    public suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse

    /**
     * Deletes a security profile.
     */
    public suspend fun deleteSecurityProfile(input: DeleteSecurityProfileRequest): DeleteSecurityProfileResponse

    /**
     * Deletes the task template.
     */
    public suspend fun deleteTaskTemplate(input: DeleteTaskTemplateRequest): DeleteTaskTemplateResponse

    /**
     * Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution group is created.
     *
     * For more information about deleting traffic distribution groups, see [Delete traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun deleteTrafficDistributionGroup(input: DeleteTrafficDistributionGroupRequest): DeleteTrafficDistributionGroupResponse

    /**
     * Deletes a use case from an integration association.
     */
    public suspend fun deleteUseCase(input: DeleteUseCaseRequest): DeleteUseCaseResponse

    /**
     * Deletes a user account from the specified Amazon Connect instance.
     *
     * For information about what happens to a user's data when their account is deleted, see [Delete Users from Your Amazon Connect Instance](https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html) in the *Amazon Connect Administrator Guide*.
     *
     * After calling DeleteUser, call [DeleteQuickConnect](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html) to delete any records related to the deleted users. This will help you:
     * + Avoid dangling resources that impact your service quotas.
     * + Remove deleted users so they don't appear to agents as transfer options.
     * + Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using [Amazon Connect Global Resiliency](https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html).
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.
     */
    public suspend fun deleteUserHierarchyGroup(input: DeleteUserHierarchyGroupRequest): DeleteUserHierarchyGroupResponse

    /**
     * Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).
     */
    public suspend fun deleteView(input: DeleteViewRequest): DeleteViewResponse

    /**
     * Deletes the particular version specified in `ViewVersion` identifier.
     */
    public suspend fun deleteViewVersion(input: DeleteViewVersionRequest): DeleteViewVersionResponse

    /**
     * Deletes the vocabulary that has the given identifier.
     */
    public suspend fun deleteVocabulary(input: DeleteVocabularyRequest): DeleteVocabularyResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes an agent status.
     */
    public suspend fun describeAgentStatus(input: DescribeAgentStatusRequest): DescribeAgentStatusResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified contact.
     *
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     *
     * Only data from November 12, 2021, and later is returned by this API.
     */
    public suspend fun describeContact(input: DescribeContactRequest): DescribeContactResponse

    /**
     * Describes a contact evaluation in the specified Amazon Connect instance.
     */
    public suspend fun describeContactEvaluation(input: DescribeContactEvaluationRequest): DescribeContactEvaluationResponse

    /**
     * Describes the specified flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     *
     * Use the `$SAVED` alias in the request to describe the `SAVED` content of a Flow. For example, `arn:aws:.../contact-flow/{id}:$SAVED`. Once a contact flow is published, `$SAVED` needs to be supplied to view saved content that has not been published.
     *
     * In the response, **Status** indicates the flow status as either `SAVED` or `PUBLISHED`. The `PUBLISHED` status will initiate validation on the content. `SAVED` does not initiate validation of the content. `SAVED` | `PUBLISHED`
     */
    public suspend fun describeContactFlow(input: DescribeContactFlowRequest): DescribeContactFlowResponse

    /**
     * Describes the specified flow module.
     *
     * Use the `$SAVED` alias in the request to describe the `SAVED` content of a Flow. For example, `arn:aws:.../contact-flow/{id}:$SAVED`. Once a contact flow is published, `$SAVED` needs to be supplied to view saved content that has not been published.
     */
    public suspend fun describeContactFlowModule(input: DescribeContactFlowModuleRequest): DescribeContactFlowModuleResponse

    /**
     * Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided, the latest version of the evaluation form is described.
     */
    public suspend fun describeEvaluationForm(input: DescribeEvaluationFormRequest): DescribeEvaluationFormResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the hours of operation.
     */
    public suspend fun describeHoursOfOperation(input: DescribeHoursOfOperationRequest): DescribeHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable.
     *
     * If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     */
    public suspend fun describeInstance(input: DescribeInstanceRequest): DescribeInstanceResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified instance attribute.
     */
    public suspend fun describeInstanceAttribute(input: DescribeInstanceAttributeRequest): DescribeInstanceAttributeResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     */
    public suspend fun describeInstanceStorageConfig(input: DescribeInstanceStorageConfigRequest): DescribeInstanceStorageConfigResponse

    /**
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution group.
     *
     * If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    public suspend fun describePhoneNumber(input: DescribePhoneNumberRequest): DescribePhoneNumberResponse

    /**
     * Describes a predefined attribute for the specified Amazon Connect instance.
     */
    public suspend fun describePredefinedAttribute(input: DescribePredefinedAttributeRequest): DescribePredefinedAttributeResponse

    /**
     * Describes the prompt.
     */
    public suspend fun describePrompt(input: DescribePromptRequest): DescribePromptResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified queue.
     */
    public suspend fun describeQueue(input: DescribeQueueRequest): DescribeQueueResponse

    /**
     * Describes the quick connect.
     */
    public suspend fun describeQuickConnect(input: DescribeQuickConnectRequest): DescribeQuickConnectResponse

    /**
     * Describes the specified routing profile.
     */
    public suspend fun describeRoutingProfile(input: DescribeRoutingProfileRequest): DescribeRoutingProfileResponse

    /**
     * Describes a rule for the specified Amazon Connect instance.
     */
    public suspend fun describeRule(input: DescribeRuleRequest): DescribeRuleResponse

    /**
     * Gets basic information about the security profle.
     */
    public suspend fun describeSecurityProfile(input: DescribeSecurityProfileRequest): DescribeSecurityProfileResponse

    /**
     * Gets details and status of a traffic distribution group.
     */
    public suspend fun describeTrafficDistributionGroup(input: DescribeTrafficDistributionGroupRequest): DescribeTrafficDistributionGroupResponse

    /**
     * Describes the specified user. You can [find the instance ID in the Amazon Connect console](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
     */
    public suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Describes the specified hierarchy group.
     */
    public suspend fun describeUserHierarchyGroup(input: DescribeUserHierarchyGroupRequest): DescribeUserHierarchyGroupResponse

    /**
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     */
    public suspend fun describeUserHierarchyStructure(input: DescribeUserHierarchyStructureRequest): DescribeUserHierarchyStructureResponse

    /**
     * Retrieves the view for the specified Amazon Connect instance and view identifier.
     *
     * The view identifier can be supplied as a ViewId or ARN.
     *
     * `$SAVED` needs to be supplied if a view is unpublished.
     *
     * The view identifier can contain an optional qualifier, for example, `<view-id>:$SAVED`, which is either an actual version number or an Amazon Connect managed qualifier `$SAVED | $LATEST`. If it is not supplied, then `$LATEST` is assumed for customer managed views and an error is returned if there is no published content available. Version 1 is assumed for Amazon Web Services managed views.
     */
    public suspend fun describeView(input: DescribeViewRequest): DescribeViewResponse

    /**
     * Describes the specified vocabulary.
     */
    public suspend fun describeVocabulary(input: DescribeVocabularyRequest): DescribeVocabularyResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Removes the dataset ID associated with a given Amazon Connect instance.
     */
    public suspend fun disassociateAnalyticsDataSet(input: DisassociateAnalyticsDataSetRequest): DisassociateAnalyticsDataSetResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes access to integrated applications from Amazon Connect.
     */
    public suspend fun disassociateApprovedOrigin(input: DisassociateApprovedOriginRequest): DisassociateApprovedOriginResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    public suspend fun disassociateBot(input: DisassociateBotRequest): DisassociateBotResponse

    /**
     * Disassociates a connect resource from a flow.
     */
    public suspend fun disassociateFlow(input: DisassociateFlowRequest): DisassociateFlowResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Removes the storage type configurations for the specified resource type and association ID.
     */
    public suspend fun disassociateInstanceStorageConfig(input: DisassociateInstanceStorageConfigRequest): DisassociateInstanceStorageConfigResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Remove the Lambda function from the dropdown options available in the relevant flow blocks.
     */
    public suspend fun disassociateLambdaFunction(input: DisassociateLambdaFunctionRequest): DisassociateLambdaFunctionResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     */
    public suspend fun disassociateLexBot(input: DisassociateLexBotRequest): DisassociateLexBotResponse

    /**
     * Removes the flow association from a phone number claimed to your Amazon Connect instance.
     *
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    public suspend fun disassociatePhoneNumberContactFlow(input: DisassociatePhoneNumberContactFlowRequest): DisassociatePhoneNumberContactFlowResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Disassociates a set of quick connects from a queue.
     */
    public suspend fun disassociateQueueQuickConnects(input: DisassociateQueueQuickConnectsRequest): DisassociateQueueQuickConnectsResponse

    /**
     * Disassociates a set of queues from a routing profile.
     */
    public suspend fun disassociateRoutingProfileQueues(input: DisassociateRoutingProfileQueuesRequest): DisassociateRoutingProfileQueuesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the specified security key.
     */
    public suspend fun disassociateSecurityKey(input: DisassociateSecurityKeyRequest): DisassociateSecurityKeyResponse

    /**
     * Disassociates an agent from a traffic distribution group.
     */
    public suspend fun disassociateTrafficDistributionGroupUser(input: DisassociateTrafficDistributionGroupUserRequest): DisassociateTrafficDistributionGroupUserResponse

    /**
     * Disassociates a set of proficiencies from a user.
     */
    public suspend fun disassociateUserProficiencies(input: DisassociateUserProficienciesRequest): DisassociateUserProficienciesResponse

    /**
     * Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to receive a new routed contact. Contacts can only be dismissed if they are in a `MISSED`, `ERROR`, `ENDED`, or `REJECTED` state in the [Agent Event Stream](https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
     */
    public suspend fun dismissUserContact(input: DismissUserContactRequest): DismissUserContactResponse

    /**
     * Provides a pre-signed URL for download of an approved attached file. This API also returns metadata about the attached file. It will only return a downloadURL if the status of the attached file is `APPROVED`.
     */
    public suspend fun getAttachedFile(input: GetAttachedFileRequest): GetAttachedFileResponse

    /**
     * Retrieves the contact attributes for the specified contact.
     */
    public suspend fun getContactAttributes(input: GetContactAttributesRequest): GetContactAttributesResponse

    /**
     * Gets the real-time metric data from the specified Amazon Connect instance.
     *
     * For a description of each metric, see [Real-time Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun getCurrentMetricData(input: GetCurrentMetricDataRequest): GetCurrentMetricDataResponse

    /**
     * Gets the real-time active user data from the specified Amazon Connect instance.
     */
    public suspend fun getCurrentUserData(input: GetCurrentUserDataRequest): GetCurrentUserDataResponse

    /**
     * Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect user which corresponds to the IAM credentials that were used to invoke this action.
     *
     * For more information about how SAML sign-in works in Amazon Connect, see *Amazon Connect Administrator Guide*[.](https://docs.aws.amazon.com/connect/latest/adminguide/configure-saml.html )
     *
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears:
     *
     * `Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect`
     */
    public suspend fun getFederationToken(input: GetFederationTokenRequest): GetFederationTokenResponse

    /**
     * Retrieves the flow associated for a given resource.
     */
    public suspend fun getFlowAssociation(input: GetFlowAssociationRequest): GetFlowAssociationResponse

    /**
     * Gets historical metric data from the specified Amazon Connect instance.
     *
     * For a description of each historical metric, see [Historical Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     *
     * We recommend using the [GetMetricDataV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html) API. It provides more flexibility, features, and the ability to query longer time ranges than `GetMetricData`. Use it to retrieve historical agent and contact metrics for the last 3 months, at varying intervals. You can also use it to build custom dashboards to measure historical queue and agent performance. For example, you can track the number of incoming contacts for the last 7 days, with data split by day, to see how contact volume changed per day of the week.
     */
    public suspend fun getMetricData(input: GetMetricDataRequest): GetMetricDataResponse

    /**
     * Gets metric data from the specified Amazon Connect instance.
     *
     * `GetMetricDataV2` offers more features than [GetMetricData](https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html), the previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve historical data for the last 3 months, at varying intervals.
     *
     * For a description of the historical metrics that are supported by `GetMetricDataV2` and `GetMetricData`, see [Historical metrics definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator's Guide*.
     */
    public suspend fun getMetricDataV2(input: GetMetricDataV2Request): GetMetricDataV2Response

    /**
     * Gets the prompt file.
     */
    public suspend fun getPromptFile(input: GetPromptFileRequest): GetPromptFileResponse

    /**
     * Gets details about a specific task template in the specified Amazon Connect instance.
     */
    public suspend fun getTaskTemplate(input: GetTaskTemplateRequest): GetTaskTemplateResponse

    /**
     * Retrieves the current traffic distribution for a given traffic distribution group.
     */
    public suspend fun getTrafficDistribution(input: GetTrafficDistributionRequest): GetTrafficDistributionResponse

    /**
     * Imports a claimed phone number from an external service, such as Amazon Pinpoint, into an Amazon Connect instance. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance was created.
     */
    public suspend fun importPhoneNumber(input: ImportPhoneNumberRequest): ImportPhoneNumberResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists agent statuses.
     */
    public suspend fun listAgentStatuses(input: ListAgentStatusesRequest): ListAgentStatusesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the association status of requested dataset ID for a given Amazon Connect instance.
     */
    public suspend fun listAnalyticsDataAssociations(input: ListAnalyticsDataAssociationsRequest): ListAnalyticsDataAssociationsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all approved origins associated with the instance.
     */
    public suspend fun listApprovedOrigins(input: ListApprovedOriginsRequest): ListApprovedOriginsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance. Use this API to returns both Amazon Lex V1 and V2 bots.
     */
    public suspend fun listBots(input: ListBotsRequest): ListBotsResponse

    /**
     * Lists contact evaluations in the specified Amazon Connect instance.
     */
    public suspend fun listContactEvaluations(input: ListContactEvaluationsRequest): ListContactEvaluationsResponse

    /**
     * Provides information about the flow modules for the specified Amazon Connect instance.
     */
    public suspend fun listContactFlowModules(input: ListContactFlowModulesRequest): ListContactFlowModulesResponse

    /**
     * Provides information about the flows for the specified Amazon Connect instance.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     *
     * For more information about flows, see [Flows](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun listContactFlows(input: ListContactFlowsRequest): ListContactFlowsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified `referenceTypes`, returns a list of references associated with the contact. *References* are links to documents that are related to a contact, such as emails, attachments, or URLs.
     */
    public suspend fun listContactReferences(input: ListContactReferencesRequest): ListContactReferencesResponse

    /**
     * Lists the default vocabularies for the specified Amazon Connect instance.
     */
    public suspend fun listDefaultVocabularies(input: ListDefaultVocabulariesRequest): ListDefaultVocabulariesResponse

    /**
     * Lists versions of an evaluation form in the specified Amazon Connect instance.
     */
    public suspend fun listEvaluationFormVersions(input: ListEvaluationFormVersionsRequest): ListEvaluationFormVersionsResponse

    /**
     * Lists evaluation forms in the specified Amazon Connect instance.
     */
    public suspend fun listEvaluationForms(input: ListEvaluationFormsRequest): ListEvaluationFormsResponse

    /**
     * List the flow association based on the filters.
     */
    public suspend fun listFlowAssociations(input: ListFlowAssociationsRequest): ListFlowAssociationsResponse

    /**
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     *
     * For more information about hours of operation, see [Set the Hours of Operation for a Queue](https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun listHoursOfOperations(input: ListHoursOfOperationsRequest): ListHoursOfOperationsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all attribute types for the given instance.
     */
    public suspend fun listInstanceAttributes(input: ListInstanceAttributesRequest): ListInstanceAttributesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of storage configs for the identified instance and resource type.
     */
    public suspend fun listInstanceStorageConfigs(input: ListInstanceStorageConfigsRequest): ListInstanceStorageConfigsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren't successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.
     */
    public suspend fun listInstances(input: ListInstancesRequest = ListInstancesRequest { }): ListInstancesResponse

    /**
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.
     */
    public suspend fun listIntegrationAssociations(input: ListIntegrationAssociationsRequest): ListIntegrationAssociationsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant flow blocks.
     */
    public suspend fun listLambdaFunctions(input: ListLambdaFunctionsRequest): ListLambdaFunctionsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all the Amazon Lex V1 bots currently associated with the instance. To return both Amazon Lex V1 and V2 bots, use the [ListBots](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListBots.html) API.
     */
    public suspend fun listLexBots(input: ListLexBotsRequest): ListLexBotsResponse

    /**
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     *
     * + We recommend using [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) to return phone number types. ListPhoneNumbers doesn't support number types `UIFN`, `SHARED`, `THIRD_PARTY_TF`, and `THIRD_PARTY_DID`. While it returns numbers of those types, it incorrectly lists them as `TOLL_FREE` or `DID`.
     * + The phone number `Arn` value that is returned from each of the items in the [PhoneNumberSummaryList](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html#connect-ListPhoneNumbers-response-PhoneNumberSummaryList) cannot be used to tag phone number resources. It will fail with a `ResourceNotFoundException`. Instead, use the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API. It returns the new phone number ARN that can be used to tag phone number resources.
     */
    public suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest): ListPhoneNumbersResponse

    /**
     * Lists phone numbers claimed to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with traffic distribution group.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     *
     * + When given an instance ARN, `ListPhoneNumbersV2` returns only the phone numbers claimed to the instance.
     * + When given a traffic distribution group ARN `ListPhoneNumbersV2` returns only the phone numbers claimed to the traffic distribution group.
     */
    public suspend fun listPhoneNumbersV2(input: ListPhoneNumbersV2Request = ListPhoneNumbersV2Request { }): ListPhoneNumbersV2Response

    /**
     * Lists predefined attributes for the specified Amazon Connect instance.
     */
    public suspend fun listPredefinedAttributes(input: ListPredefinedAttributesRequest): ListPredefinedAttributesResponse

    /**
     * Provides information about the prompts for the specified Amazon Connect instance.
     */
    public suspend fun listPrompts(input: ListPromptsRequest): ListPromptsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the quick connects associated with a queue.
     */
    public suspend fun listQueueQuickConnects(input: ListQueueQuickConnectsRequest): ListQueueQuickConnectsResponse

    /**
     * Provides information about the queues for the specified Amazon Connect instance.
     *
     * If you do not specify a `QueueTypes` parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.
     *
     * For more information about queues, see [Queues: Standard and Agent](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun listQueues(input: ListQueuesRequest): ListQueuesResponse

    /**
     * Provides information about the quick connects for the specified Amazon Connect instance.
     */
    public suspend fun listQuickConnects(input: ListQuickConnectsRequest): ListQuickConnectsResponse

    /**
     * Provides a list of analysis segments for a real-time analysis session.
     */
    public suspend fun listRealtimeContactAnalysisSegmentsV2(input: ListRealtimeContactAnalysisSegmentsV2Request): ListRealtimeContactAnalysisSegmentsV2Response

    /**
     * Lists the queues associated with a routing profile.
     */
    public suspend fun listRoutingProfileQueues(input: ListRoutingProfileQueuesRequest): ListRoutingProfileQueuesResponse

    /**
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     *
     * For more information about routing profiles, see [Routing Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html) and [Create a Routing Profile](https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun listRoutingProfiles(input: ListRoutingProfilesRequest): ListRoutingProfilesResponse

    /**
     * List all rules for the specified Amazon Connect instance.
     */
    public suspend fun listRules(input: ListRulesRequest): ListRulesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all security keys associated with the instance.
     */
    public suspend fun listSecurityKeys(input: ListSecurityKeysRequest): ListSecurityKeysResponse

    /**
     * Returns a list of third-party applications in a specific security profile.
     */
    public suspend fun listSecurityProfileApplications(input: ListSecurityProfileApplicationsRequest): ListSecurityProfileApplicationsResponse

    /**
     * Lists the permissions granted to a security profile.
     */
    public suspend fun listSecurityProfilePermissions(input: ListSecurityProfilePermissionsRequest): ListSecurityProfilePermissionsResponse

    /**
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     *
     * For more information about security profiles, see [Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun listSecurityProfiles(input: ListSecurityProfilesRequest): ListSecurityProfilesResponse

    /**
     * Lists the tags for the specified resource.
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists task templates for the specified Amazon Connect instance.
     */
    public suspend fun listTaskTemplates(input: ListTaskTemplatesRequest): ListTaskTemplatesResponse

    /**
     * Lists traffic distribution group users.
     */
    public suspend fun listTrafficDistributionGroupUsers(input: ListTrafficDistributionGroupUsersRequest): ListTrafficDistributionGroupUsersResponse

    /**
     * Lists traffic distribution groups.
     */
    public suspend fun listTrafficDistributionGroups(input: ListTrafficDistributionGroupsRequest = ListTrafficDistributionGroupsRequest { }): ListTrafficDistributionGroupsResponse

    /**
     * Lists the use cases for the integration association.
     */
    public suspend fun listUseCases(input: ListUseCasesRequest): ListUseCasesResponse

    /**
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     *
     * For more information about agent hierarchies, see [Set Up Agent Hierarchies](https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun listUserHierarchyGroups(input: ListUserHierarchyGroupsRequest): ListUserHierarchyGroupsResponse

    /**
     * Lists proficiencies associated with a user.
     */
    public suspend fun listUserProficiencies(input: ListUserProficienciesRequest): ListUserProficienciesResponse

    /**
     * Provides summary information about the users for the specified Amazon Connect instance.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Returns all the available versions for the specified Amazon Connect instance and view identifier.
     *
     * Results will be sorted from highest to lowest.
     */
    public suspend fun listViewVersions(input: ListViewVersionsRequest): ListViewVersionsResponse

    /**
     * Returns views in the given instance.
     *
     * Results are sorted primarily by type, and secondarily by name.
     */
    public suspend fun listViews(input: ListViewsRequest): ListViewsResponse

    /**
     * Initiates silent monitoring of a contact. The Contact Control Panel (CCP) of the user specified by *userId* will be set to silent monitoring mode on the contact.
     */
    public suspend fun monitorContact(input: MonitorContactRequest): MonitorContactResponse

    /**
     * Allows pausing an ongoing task contact.
     */
    public suspend fun pauseContact(input: PauseContactRequest): PauseContactResponse

    /**
     * Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact, this sets the agent's next status.
     *
     * For more information, see [Agent status](https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html) and [Set your next status](https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun putUserStatus(input: PutUserStatusRequest): PutUserStatusResponse

    /**
     * Releases a phone number previously claimed to an Amazon Connect instance or traffic distribution group. You can call this API only in the Amazon Web Services Region where the number was claimed.
     *
     * To release phone numbers from a traffic distribution group, use the `ReleasePhoneNumber` API, not the Amazon Connect admin website.
     *
     * After releasing a phone number, the phone number enters into a cooldown period of 30 days. It cannot be searched for or claimed again until the period has ended. If you accidentally release a phone number, contact Amazon Web Services Support.
     *
     * If you plan to claim and release numbers frequently during a 30 day period, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until 30 days past the oldest number released has expired.
     *
     * By default you can claim and release up to 200% of your maximum number of active phone numbers during any 30 day period. If you claim and release phone numbers using the UI or API during a rolling 30 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming any more numbers until 30 days past the oldest number released has expired.
     *
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 30 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     */
    public suspend fun releasePhoneNumber(input: ReleasePhoneNumberRequest): ReleasePhoneNumberResponse

    /**
     * Replicates an Amazon Connect instance in the specified Amazon Web Services Region and copies configuration information for Amazon Connect resources across Amazon Web Services Regions.
     *
     * For more information about replicating an Amazon Connect instance, see [Create a replica of your existing Amazon Connect instance](https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun replicateInstance(input: ReplicateInstanceRequest): ReplicateInstanceResponse

    /**
     * Allows resuming a task contact in a paused state.
     */
    public suspend fun resumeContact(input: ResumeContactRequest): ResumeContactResponse

    /**
     * When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording whatever recording is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would resume.
     *
     * Voice and screen recordings are supported.
     */
    public suspend fun resumeContactRecording(input: ResumeContactRecordingRequest): ResumeContactRecordingResponse

    /**
     * Searches for available phone numbers that you can claim to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with the traffic distribution group.
     */
    public suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest): SearchAvailablePhoneNumbersResponse

    /**
     * Searches the flow modules in an Amazon Connect instance, with optional filtering.
     */
    public suspend fun searchContactFlowModules(input: SearchContactFlowModulesRequest): SearchContactFlowModulesResponse

    /**
     * Searches the contact flows in an Amazon Connect instance, with optional filtering.
     */
    public suspend fun searchContactFlows(input: SearchContactFlowsRequest): SearchContactFlowsResponse

    /**
     * Searches contacts in an Amazon Connect instance.
     */
    public suspend fun searchContacts(input: SearchContactsRequest): SearchContactsResponse

    /**
     * Searches the hours of operation in an Amazon Connect instance, with optional filtering.
     */
    public suspend fun searchHoursOfOperations(input: SearchHoursOfOperationsRequest): SearchHoursOfOperationsResponse

    /**
     * Predefined attributes that meet certain criteria.
     */
    public suspend fun searchPredefinedAttributes(input: SearchPredefinedAttributesRequest): SearchPredefinedAttributesResponse

    /**
     * Searches prompts in an Amazon Connect instance, with optional filtering.
     */
    public suspend fun searchPrompts(input: SearchPromptsRequest): SearchPromptsResponse

    /**
     * Searches queues in an Amazon Connect instance, with optional filtering.
     */
    public suspend fun searchQueues(input: SearchQueuesRequest): SearchQueuesResponse

    /**
     * Searches quick connects in an Amazon Connect instance, with optional filtering.
     */
    public suspend fun searchQuickConnects(input: SearchQuickConnectsRequest): SearchQuickConnectsResponse

    /**
     * Searches tags used in an Amazon Connect instance using optional search criteria.
     */
    public suspend fun searchResourceTags(input: SearchResourceTagsRequest): SearchResourceTagsResponse

    /**
     * Searches routing profiles in an Amazon Connect instance, with optional filtering.
     */
    public suspend fun searchRoutingProfiles(input: SearchRoutingProfilesRequest): SearchRoutingProfilesResponse

    /**
     * Searches security profiles in an Amazon Connect instance, with optional filtering.
     */
    public suspend fun searchSecurityProfiles(input: SearchSecurityProfilesRequest): SearchSecurityProfilesResponse

    /**
     * Searches users in an Amazon Connect instance, with optional filtering.
     *
     * `AfterContactWorkTimeLimit` is returned in milliseconds.
     */
    public suspend fun searchUsers(input: SearchUsersRequest): SearchUsersResponse

    /**
     * Searches for vocabularies within a specific Amazon Connect instance using `State`, `NameStartsWith`, and `LanguageCode`.
     */
    public suspend fun searchVocabularies(input: SearchVocabulariesRequest): SearchVocabulariesResponse

    /**
     * Processes chat integration events from Amazon Web Services or external integrations to Amazon Connect. A chat integration event includes:
     * + SourceId, DestinationId, and Subtype: a set of identifiers, uniquely representing a chat
     * +  ChatEvent: details of the chat action to perform such as sending a message, event, or disconnecting from a chat
     *
     * When a chat integration event is sent with chat identifiers that do not map to an active chat contact, a new chat contact is also created before handling chat action.
     *
     * Access to this API is currently restricted to Amazon Pinpoint for supporting SMS integration.
     */
    public suspend fun sendChatIntegrationEvent(input: SendChatIntegrationEventRequest): SendChatIntegrationEventResponse

    /**
     * Provides a pre-signed Amazon S3 URL in response for uploading your content.
     *
     * You may only use this API to upload attachments to a [Connect Case](https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html).
     */
    public suspend fun startAttachedFileUpload(input: StartAttachedFileUploadRequest): StartAttachedFileUploadResponse

    /**
     * Initiates a flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) API in the Amazon Connect Participant Service.
     *
     * When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) with WEBSOCKET and CONNECTION_CREDENTIALS.
     *
     * A 429 error occurs in the following situations:
     * + API rate limit is exceeded. API TPS throttling returns a `TooManyRequests` exception.
     * + The [quota for concurrent active chats](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) is exceeded. Active chat throttling returns a `LimitExceededException`.
     *
     * If you use the `ChatDurationInMinutes` parameter and receive a 400 error, your account may not support the ability to configure custom chat durations. For more information, contact Amazon Web Services Support.
     *
     * For more information about chat, see [Chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun startChatContact(input: StartChatContactRequest): StartChatContactResponse

    /**
     * Starts an empty evaluation in the specified Amazon Connect instance, using the given evaluation form for the particular contact. The evaluation form version used for the contact evaluation corresponds to the currently activated version. If no version is activated for the evaluation form, the contact evaluation cannot be started.
     *
     * Evaluations created through the public API do not contain answer values suggested from automation.
     */
    public suspend fun startContactEvaluation(input: StartContactEvaluationRequest): StartContactEvaluationResponse

    /**
     * Starts recording the contact:
     * + If the API is called *before* the agent joins the call, recording starts when the agent joins the call.
     * + If the API is called *after* the agent joins the call, recording starts at the time of the API call.
     *
     * StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.
     *
     * You can use this API to override the recording behavior configured in the [Set recording behavior](https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html) block.
     *
     * Only voice recordings are supported at this time.
     */
    public suspend fun startContactRecording(input: StartContactRecordingRequest): StartContactRecordingResponse

    /**
     * Initiates real-time message streaming for a new chat contact.
     *
     *  For more information about message streaming, see [Enable real-time chat message streaming](https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun startContactStreaming(input: StartContactStreamingRequest): StartContactStreamingResponse

    /**
     * Places an outbound call to a contact, and then initiates the flow. It performs the actions in the flow that's specified (in `ContactFlowId`).
     *
     * Agents do not initiate the outbound API, which means that they do not dial the contact. If the flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.
     *
     * There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.
     *
     * UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     *
     * Campaign calls are not allowed by default. Before you can make a call with `TrafficType` = `CAMPAIGN`, you must submit a service quota increase request to the quota [Amazon Connect campaigns](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#outbound-communications-quotas).
     */
    public suspend fun startOutboundVoiceContact(input: StartOutboundVoiceContactRequest): StartOutboundVoiceContactResponse

    /**
     * Initiates a flow to start a new task contact. For more information about task contacts, see [Concepts: Tasks in Amazon Connect](https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html) in the *Amazon Connect Administrator Guide*.
     *
     * When using `PreviousContactId` and `RelatedContactId` input parameters, note the following:
     * + `PreviousContactId`
     *    + Any updates to user-defined task contact attributes on any contact linked through the same `PreviousContactId` will affect every contact in the chain.
     *    + There can be a maximum of 12 linked task contacts in a chain. That is, 12 task contacts can be created that share the same `PreviousContactId`.
     * + `RelatedContactId`
     *    + Copies contact attributes from the related task contact to the new contact.
     *    + Any update on attributes in a new task contact does not update attributes on previous contact.
     *    + There’s no limit on the number of task contacts that can be created that use the same `RelatedContactId`.
     *
     * In addition, when calling StartTaskContact include only one of these parameters: `ContactFlowID`, `QuickConnectID`, or `TaskTemplateID`. Only one parameter is required as long as the task template has a flow configured to run it. If more than one parameter is specified, or only the `TaskTemplateID` is specified but it does not have a flow configured, the request returns an error because Amazon Connect cannot identify the unique flow to run when the task is created.
     *
     * A `ServiceQuotaExceededException` occurs when the number of open tasks exceeds the active tasks quota or there are already 12 tasks referencing the same `PreviousContactId`. For more information about service quotas for task contacts, see [Amazon Connect service quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun startTaskContact(input: StartTaskContactRequest): StartTaskContactResponse

    /**
     * Places an inbound in-app, web, or video call to a contact, and then initiates the flow. It performs the actions in the flow that are specified (in ContactFlowId) and present in the Amazon Connect instance (specified as InstanceId).
     */
    public suspend fun startWebRtcContact(input: StartWebRtcContactRequest): StartWebRtcContactResponse

    /**
     * Ends the specified contact. Use this API to stop queued callbacks. It does not work for voice contacts that use the following initiation methods:
     * + DISCONNECT
     * + TRANSFER
     * + QUEUE_TRANSFER
     *
     * Chat and task contacts can be terminated in any state, regardless of initiation method.
     */
    public suspend fun stopContact(input: StopContactRequest): StopContactResponse

    /**
     * Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
     *
     * Only voice recordings are supported at this time.
     */
    public suspend fun stopContactRecording(input: StopContactRecordingRequest): StopContactRecordingResponse

    /**
     * Ends message streaming on a specified contact. To restart message streaming on that contact, call the [StartContactStreaming](https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html) API.
     */
    public suspend fun stopContactStreaming(input: StopContactStreamingRequest): StopContactStreamingResponse

    /**
     * Submits a contact evaluation in the specified Amazon Connect instance. Answers included in the request are merged with existing answers for the given evaluation. If no answers or notes are passed, the evaluation is submitted with the existing answers and notes. You can delete an answer or note by passing an empty object (`{}`) to the question identifier.
     *
     * If a contact evaluation is already in submitted state, this operation will trigger a resubmission.
     */
    public suspend fun submitContactEvaluation(input: SubmitContactEvaluationRequest): SubmitContactEvaluationResponse

    /**
     * When a contact is being recorded, this API suspends recording whatever is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would be suspended. For example, you might suspend the screen recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording the screen.
     *
     * The period of time that the recording is suspended is filled with silence in the final recording.
     *
     * Voice and screen recordings are supported.
     */
    public suspend fun suspendContactRecording(input: SuspendContactRecordingRequest): SuspendContactRecordingResponse

    /**
     * Adds the specified tags to the contact resource. For more information about this API is used, see [Set up granular billing for a detailed view of your Amazon Connect usage](https://docs.aws.amazon.com/connect/latest/adminguide/granular-billing.html).
     */
    public suspend fun tagContact(input: TagContactRequest): TagContactResponse

    /**
     * Adds the specified tags to the specified resource.
     *
     * Some of the supported resource types are agents, routing profiles, queues, quick connects, contact flows, agent statuses, hours of operation, phone numbers, security profiles, and task templates. For a complete list, see [Tagging resources in Amazon Connect](https://docs.aws.amazon.com/connect/latest/adminguide/tagging.html).
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Transfers contacts from one agent or queue to another agent or queue at any point after a contact is created. You can transfer a contact to another queue by providing the flow which orchestrates the contact to the destination queue. This gives you more control over contact handling and helps you adhere to the service level agreement (SLA) guaranteed to your customers.
     *
     * Note the following requirements:
     * + Transfer is supported for only `TASK` contacts.
     * + Do not use both `QueueId` and `UserId` in the same call.
     * + The following flow types are supported: Inbound flow, Transfer to agent flow, and Transfer to queue flow.
     * + The `TransferContact` API can be called only on active contacts.
     * + A contact cannot be transferred more than 11 times.
     */
    public suspend fun transferContact(input: TransferContactRequest): TransferContactResponse

    /**
     * Removes the specified tags from the contact resource. For more information about this API is used, see [Set up granular billing for a detailed view of your Amazon Connect usage](https://docs.aws.amazon.com/connect/latest/adminguide/granular-billing.html).
     */
    public suspend fun untagContact(input: UntagContactRequest): UntagContactResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates agent status.
     */
    public suspend fun updateAgentStatus(input: UpdateAgentStatusRequest): UpdateAgentStatusResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.
     *
     * You can add or update user-defined contact information for both ongoing and completed contacts.
     */
    public suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse

    /**
     * Creates or updates user-defined contact attributes associated with the specified contact.
     *
     * You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer's name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.
     *
     * Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about contact record retention and the maximum size of the contact record attributes section, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun updateContactAttributes(input: UpdateContactAttributesRequest): UpdateContactAttributesResponse

    /**
     * Updates details about a contact evaluation in the specified Amazon Connect instance. A contact evaluation must be in draft state. Answers included in the request are merged with existing answers for the given evaluation. An answer or note can be deleted by passing an empty object (`{}`) to the question identifier.
     */
    public suspend fun updateContactEvaluation(input: UpdateContactEvaluationRequest): UpdateContactEvaluationResponse

    /**
     * Updates the specified flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     *
     * Use the `$SAVED` alias in the request to describe the `SAVED` content of a Flow. For example, `arn:aws:.../contact-flow/{id}:$SAVED`. Once a contact flow is published, `$SAVED` needs to be supplied to view saved content that has not been published.
     */
    public suspend fun updateContactFlowContent(input: UpdateContactFlowContentRequest): UpdateContactFlowContentResponse

    /**
     * Updates metadata about specified flow.
     */
    public suspend fun updateContactFlowMetadata(input: UpdateContactFlowMetadataRequest): UpdateContactFlowMetadataResponse

    /**
     * Updates specified flow module for the specified Amazon Connect instance.
     *
     * Use the `$SAVED` alias in the request to describe the `SAVED` content of a Flow. For example, `arn:aws:.../contact-flow/{id}:$SAVED`. Once a contact flow is published, `$SAVED` needs to be supplied to view saved content that has not been published.
     */
    public suspend fun updateContactFlowModuleContent(input: UpdateContactFlowModuleContentRequest): UpdateContactFlowModuleContentResponse

    /**
     * Updates metadata about specified flow module.
     */
    public suspend fun updateContactFlowModuleMetadata(input: UpdateContactFlowModuleMetadataRequest): UpdateContactFlowModuleMetadataResponse

    /**
     * The name of the flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    public suspend fun updateContactFlowName(input: UpdateContactFlowNameRequest): UpdateContactFlowNameResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates routing priority and age on the contact (**QueuePriority** and **QueueTimeAdjustmentInSeconds**). These properties can be used to change a customer's position in the queue. For example, you can move a contact to the back of the queue by setting a lower routing priority relative to other contacts in queue; or you can move a contact to the front of the queue by increasing the routing age which will make the contact look artificially older and therefore higher up in the first-in-first-out routing order. Note that adjusting the routing age of a contact affects only its position in queue, and not its actual queue wait time as reported through metrics. These properties can also be updated by using [the Set routing priority / age flow block](https://docs.aws.amazon.com/connect/latest/adminguide/change-routing-priority.html).
     */
    public suspend fun updateContactRoutingData(input: UpdateContactRoutingDataRequest): UpdateContactRoutingDataResponse

    /**
     * Updates the scheduled time of a task contact that is already scheduled.
     */
    public suspend fun updateContactSchedule(input: UpdateContactScheduleRequest): UpdateContactScheduleResponse

    /**
     * Updates details about a specific evaluation form version in the specified Amazon Connect instance. Question and section identifiers cannot be duplicated within the same evaluation form.
     *
     * This operation does not support partial updates. Instead it does a full update of evaluation form content.
     */
    public suspend fun updateEvaluationForm(input: UpdateEvaluationFormRequest): UpdateEvaluationFormResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation.
     */
    public suspend fun updateHoursOfOperation(input: UpdateHoursOfOperationRequest): UpdateHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the value for the specified attribute type.
     */
    public suspend fun updateInstanceAttribute(input: UpdateInstanceAttributeRequest): UpdateInstanceAttributeResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates an existing configuration for a resource type. This API is idempotent.
     */
    public suspend fun updateInstanceStorageConfig(input: UpdateInstanceStorageConfigRequest): UpdateInstanceStorageConfigResponse

    /**
     * Updates timeouts for when human chat participants are to be considered idle, and when agents are automatically disconnected from a chat due to idleness. You can set four timers:
     * + Customer idle timeout
     * + Customer auto-disconnect timeout
     * + Agent idle timeout
     * + Agent auto-disconnect timeout
     *
     * For more information about how chat timeouts work, see [Set up chat timeouts for human participants](https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html).
     */
    public suspend fun updateParticipantRoleConfig(input: UpdateParticipantRoleConfigRequest): UpdateParticipantRoleConfigResponse

    /**
     * Updates your claimed phone number from its current Amazon Connect instance or traffic distribution group to another Amazon Connect instance or traffic distribution group in the same Amazon Web Services Region.
     *
     * After using this API, you must verify that the phone number is attached to the correct flow in the target instance or traffic distribution group. You need to do this because the API switches only the phone number to a new instance or traffic distribution group. It doesn't migrate the flow configuration of the phone number, too.
     *
     * You can call [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API to verify the status of a previous [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation.
     */
    public suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse

    /**
     * Updates a phone number’s metadata.
     *
     * To verify the status of a previous UpdatePhoneNumberMetadata operation, call the [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API.
     */
    public suspend fun updatePhoneNumberMetadata(input: UpdatePhoneNumberMetadataRequest): UpdatePhoneNumberMetadataResponse

    /**
     * Updates a predefined attribute for the specified Amazon Connect instance.
     */
    public suspend fun updatePredefinedAttribute(input: UpdatePredefinedAttributeRequest): UpdatePredefinedAttributeResponse

    /**
     * Updates a prompt.
     */
    public suspend fun updatePrompt(input: UpdatePromptRequest): UpdatePromptResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation for the specified queue.
     */
    public suspend fun updateQueueHoursOfOperation(input: UpdateQueueHoursOfOperationRequest): UpdateQueueHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the maximum number of contacts allowed in a queue before it is considered full.
     */
    public suspend fun updateQueueMaxContacts(input: UpdateQueueMaxContactsRequest): UpdateQueueMaxContactsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the name and description of a queue. At least `Name` or `Description` must be provided.
     */
    public suspend fun updateQueueName(input: UpdateQueueNameRequest): UpdateQueueNameResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.
     *
     * + If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for `OutboundCallerIdNumberId`. However, if the phone number is claimed to a traffic distribution group that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     * + Only use the phone number ARN format that doesn't contain `instance` in the path, for example, `arn:aws:connect:us-east-1:1234567890:phone-number/uuid`. This is the same ARN format that is returned when you call the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API.
     * + If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic distribution group, see [Allow or Deny queue API actions for phone numbers in a replica Region](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region).
     */
    public suspend fun updateQueueOutboundCallerConfig(input: UpdateQueueOutboundCallerConfigRequest): UpdateQueueOutboundCallerConfigResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the status of the queue.
     */
    public suspend fun updateQueueStatus(input: UpdateQueueStatusRequest): UpdateQueueStatusResponse

    /**
     * Updates the configuration settings for the specified quick connect.
     */
    public suspend fun updateQuickConnectConfig(input: UpdateQuickConnectConfigRequest): UpdateQuickConnectConfigResponse

    /**
     * Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    public suspend fun updateQuickConnectName(input: UpdateQuickConnectNameRequest): UpdateQuickConnectNameResponse

    /**
     * Whether agents with this routing profile will have their routing order calculated based on *time since their last inbound contact* or *longest idle time*.
     */
    public suspend fun updateRoutingProfileAgentAvailabilityTimer(input: UpdateRoutingProfileAgentAvailabilityTimerRequest): UpdateRoutingProfileAgentAvailabilityTimerResponse

    /**
     * Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
     */
    public suspend fun updateRoutingProfileConcurrency(input: UpdateRoutingProfileConcurrencyRequest): UpdateRoutingProfileConcurrencyResponse

    /**
     * Updates the default outbound queue of a routing profile.
     */
    public suspend fun updateRoutingProfileDefaultOutboundQueue(input: UpdateRoutingProfileDefaultOutboundQueueRequest): UpdateRoutingProfileDefaultOutboundQueueResponse

    /**
     * Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    public suspend fun updateRoutingProfileName(input: UpdateRoutingProfileNameRequest): UpdateRoutingProfileNameResponse

    /**
     * Updates the properties associated with a set of queues for a routing profile.
     */
    public suspend fun updateRoutingProfileQueues(input: UpdateRoutingProfileQueuesRequest): UpdateRoutingProfileQueuesResponse

    /**
     * Updates a rule for the specified Amazon Connect instance.
     *
     * Use the [Rules Function language](https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html) to code conditions for the rule.
     */
    public suspend fun updateRule(input: UpdateRuleRequest): UpdateRuleResponse

    /**
     * Updates a security profile.
     */
    public suspend fun updateSecurityProfile(input: UpdateSecurityProfileRequest): UpdateSecurityProfileResponse

    /**
     * Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.
     */
    public suspend fun updateTaskTemplate(input: UpdateTaskTemplateRequest): UpdateTaskTemplateResponse

    /**
     * Updates the traffic distribution for a given traffic distribution group.
     *
     * The `SignInConfig` distribution is available only on a default `TrafficDistributionGroup` (see the `IsDefault` parameter in the [TrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html) data type). If you call `UpdateTrafficDistribution` with a modified `SignInConfig` and a non-default `TrafficDistributionGroup`, an `InvalidRequestException` is returned.
     *
     * For more information about updating a traffic distribution group, see [Update telephony traffic distribution across Amazon Web Services Regions ](https://docs.aws.amazon.com/connect/latest/adminguide/update-telephony-traffic-distribution.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun updateTrafficDistribution(input: UpdateTrafficDistributionRequest): UpdateTrafficDistributionResponse

    /**
     * Assigns the specified hierarchy group to the specified user.
     */
    public suspend fun updateUserHierarchy(input: UpdateUserHierarchyRequest): UpdateUserHierarchyResponse

    /**
     * Updates the name of the user hierarchy group.
     */
    public suspend fun updateUserHierarchyGroupName(input: UpdateUserHierarchyGroupNameRequest): UpdateUserHierarchyGroupNameResponse

    /**
     * Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
     */
    public suspend fun updateUserHierarchyStructure(input: UpdateUserHierarchyStructureRequest): UpdateUserHierarchyStructureResponse

    /**
     * Updates the identity information for the specified user.
     *
     * We strongly recommend limiting who has the ability to invoke `UpdateUserIdentityInfo`. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker's email address, and then reset the password through email. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun updateUserIdentityInfo(input: UpdateUserIdentityInfoRequest): UpdateUserIdentityInfoResponse

    /**
     * Updates the phone configuration settings for the specified user.
     */
    public suspend fun updateUserPhoneConfig(input: UpdateUserPhoneConfigRequest): UpdateUserPhoneConfigResponse

    /**
     * Updates the properties associated with the proficiencies of a user.
     */
    public suspend fun updateUserProficiencies(input: UpdateUserProficienciesRequest): UpdateUserProficienciesResponse

    /**
     * Assigns the specified routing profile to the specified user.
     */
    public suspend fun updateUserRoutingProfile(input: UpdateUserRoutingProfileRequest): UpdateUserRoutingProfileResponse

    /**
     * Assigns the specified security profiles to the specified user.
     */
    public suspend fun updateUserSecurityProfiles(input: UpdateUserSecurityProfilesRequest): UpdateUserSecurityProfilesResponse

    /**
     * Updates the view content of the given view identifier in the specified Amazon Connect instance.
     *
     * It performs content validation if `Status` is set to `SAVED` and performs full content validation if `Status` is `PUBLISHED`. Note that the `$SAVED` alias' content will always be updated, but the `$LATEST` alias' content will only be updated if `Status` is `PUBLISHED`.
     */
    public suspend fun updateViewContent(input: UpdateViewContentRequest): UpdateViewContentResponse

    /**
     * Updates the view metadata. Note that either `Name` or `Description` must be provided.
     */
    public suspend fun updateViewMetadata(input: UpdateViewMetadataRequest): UpdateViewMetadataResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ConnectClient.withConfig(block: ConnectClient.Config.Builder.() -> Unit): ConnectClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultConnectClient(newConfig)
}

/**
 * Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it is available to start new evaluations based on the form.
 */
public suspend inline fun ConnectClient.activateEvaluationForm(crossinline block: ActivateEvaluationFormRequest.Builder.() -> Unit): ActivateEvaluationFormResponse = activateEvaluationForm(ActivateEvaluationFormRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Associates the specified dataset for a Amazon Connect instance with the target account. You can associate only one dataset in a single call.
 */
public suspend inline fun ConnectClient.associateAnalyticsDataSet(crossinline block: AssociateAnalyticsDataSetRequest.Builder.() -> Unit): AssociateAnalyticsDataSetResponse = associateAnalyticsDataSet(AssociateAnalyticsDataSetRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Associates an approved origin to an Amazon Connect instance.
 */
public suspend inline fun ConnectClient.associateApprovedOrigin(crossinline block: AssociateApprovedOriginRequest.Builder.() -> Unit): AssociateApprovedOriginResponse = associateApprovedOrigin(AssociateApprovedOriginRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
 */
public suspend inline fun ConnectClient.associateBot(crossinline block: AssociateBotRequest.Builder.() -> Unit): AssociateBotResponse = associateBot(AssociateBotRequest.Builder().apply(block).build())

/**
 * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.
 */
public suspend inline fun ConnectClient.associateDefaultVocabulary(crossinline block: AssociateDefaultVocabularyRequest.Builder.() -> Unit): AssociateDefaultVocabularyResponse = associateDefaultVocabulary(AssociateDefaultVocabularyRequest.Builder().apply(block).build())

/**
 * Associates a connect resource to a flow.
 */
public suspend inline fun ConnectClient.associateFlow(crossinline block: AssociateFlowRequest.Builder.() -> Unit): AssociateFlowResponse = associateFlow(AssociateFlowRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing chat transcripts.
 *
 * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
 */
public suspend inline fun ConnectClient.associateInstanceStorageConfig(crossinline block: AssociateInstanceStorageConfigRequest.Builder.() -> Unit): AssociateInstanceStorageConfigResponse = associateInstanceStorageConfig(AssociateInstanceStorageConfigRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Allows the specified Amazon Connect instance to access the specified Lambda function.
 */
public suspend inline fun ConnectClient.associateLambdaFunction(crossinline block: AssociateLambdaFunctionRequest.Builder.() -> Unit): AssociateLambdaFunctionResponse = associateLambdaFunction(AssociateLambdaFunctionRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports the association of Amazon Lex V1 bots.
 */
public suspend inline fun ConnectClient.associateLexBot(crossinline block: AssociateLexBotRequest.Builder.() -> Unit): AssociateLexBotResponse = associateLexBot(AssociateLexBotRequest.Builder().apply(block).build())

/**
 * Associates a flow with a phone number claimed to your Amazon Connect instance.
 *
 * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
 */
public suspend inline fun ConnectClient.associatePhoneNumberContactFlow(crossinline block: AssociatePhoneNumberContactFlowRequest.Builder.() -> Unit): AssociatePhoneNumberContactFlowResponse = associatePhoneNumberContactFlow(AssociatePhoneNumberContactFlowRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Associates a set of quick connects with a queue.
 */
public suspend inline fun ConnectClient.associateQueueQuickConnects(crossinline block: AssociateQueueQuickConnectsRequest.Builder.() -> Unit): AssociateQueueQuickConnectsResponse = associateQueueQuickConnects(AssociateQueueQuickConnectsRequest.Builder().apply(block).build())

/**
 * Associates a set of queues with a routing profile.
 */
public suspend inline fun ConnectClient.associateRoutingProfileQueues(crossinline block: AssociateRoutingProfileQueuesRequest.Builder.() -> Unit): AssociateRoutingProfileQueuesResponse = associateRoutingProfileQueues(AssociateRoutingProfileQueuesRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Associates a security key to the instance.
 */
public suspend inline fun ConnectClient.associateSecurityKey(crossinline block: AssociateSecurityKeyRequest.Builder.() -> Unit): AssociateSecurityKeyResponse = associateSecurityKey(AssociateSecurityKeyRequest.Builder().apply(block).build())

/**
 * Associates an agent with a traffic distribution group.
 */
public suspend inline fun ConnectClient.associateTrafficDistributionGroupUser(crossinline block: AssociateTrafficDistributionGroupUserRequest.Builder.() -> Unit): AssociateTrafficDistributionGroupUserResponse = associateTrafficDistributionGroupUser(AssociateTrafficDistributionGroupUserRequest.Builder().apply(block).build())

/**
 * >Associates a set of proficiencies with a user.
 */
public suspend inline fun ConnectClient.associateUserProficiencies(crossinline block: AssociateUserProficienciesRequest.Builder.() -> Unit): AssociateUserProficienciesResponse = associateUserProficiencies(AssociateUserProficienciesRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Associates a list of analytics datasets for a given Amazon Connect instance to a target account. You can associate multiple datasets in a single call.
 */
public suspend inline fun ConnectClient.batchAssociateAnalyticsDataSet(crossinline block: BatchAssociateAnalyticsDataSetRequest.Builder.() -> Unit): BatchAssociateAnalyticsDataSetResponse = batchAssociateAnalyticsDataSet(BatchAssociateAnalyticsDataSetRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Removes a list of analytics datasets associated with a given Amazon Connect instance. You can disassociate multiple datasets in a single call.
 */
public suspend inline fun ConnectClient.batchDisassociateAnalyticsDataSet(crossinline block: BatchDisassociateAnalyticsDataSetRequest.Builder.() -> Unit): BatchDisassociateAnalyticsDataSetResponse = batchDisassociateAnalyticsDataSet(BatchDisassociateAnalyticsDataSetRequest.Builder().apply(block).build())

/**
 * Allows you to retrieve metadata about multiple attached files on an associated resource. Each attached file provided in the input list must be associated with the input AssociatedResourceArn.
 */
public suspend inline fun ConnectClient.batchGetAttachedFileMetadata(crossinline block: BatchGetAttachedFileMetadataRequest.Builder.() -> Unit): BatchGetAttachedFileMetadataResponse = batchGetAttachedFileMetadata(BatchGetAttachedFileMetadataRequest.Builder().apply(block).build())

/**
 * Retrieve the flow associations for the given resources.
 */
public suspend inline fun ConnectClient.batchGetFlowAssociation(crossinline block: BatchGetFlowAssociationRequest.Builder.() -> Unit): BatchGetFlowAssociationResponse = batchGetFlowAssociation(BatchGetFlowAssociationRequest.Builder().apply(block).build())

/**
 * Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call this API.
 *
 * Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial requests via the [PutDialRequestBatch](https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html) API. It then uses BatchPutContact to create contacts corresponding to those dial requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting voice call uses the same contactId that was created by BatchPutContact.
 */
public suspend inline fun ConnectClient.batchPutContact(crossinline block: BatchPutContactRequest.Builder.() -> Unit): BatchPutContactResponse = batchPutContact(BatchPutContactRequest.Builder().apply(block).build())

/**
 * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group was created.
 *
 * For more information about how to use this operation, see [Claim a phone number in your country](https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html) and [Claim phone numbers to traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
 *
 * You can call the [SearchAvailablePhoneNumbers](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html) API for available phone numbers that you can claim. Call the [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API to verify the status of a previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) operation.
 *
 * If you plan to claim and release numbers frequently during a 30 day period, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until 30 days past the oldest number released has expired.
 *
 * By default you can claim and release up to 200% of your maximum number of active phone numbers during any 30 day period. If you claim and release phone numbers using the UI or API during a rolling 30 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming any more numbers until 30 days past the oldest number released has expired.
 *
 * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 30 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
 */
public suspend inline fun ConnectClient.claimPhoneNumber(crossinline block: ClaimPhoneNumberRequest.Builder.() -> Unit): ClaimPhoneNumberResponse = claimPhoneNumber(ClaimPhoneNumberRequest.Builder().apply(block).build())

/**
 * Allows you to confirm that the attached file has been uploaded using the pre-signed URL provided in the StartAttachedFileUpload API.
 */
public suspend inline fun ConnectClient.completeAttachedFileUpload(crossinline block: CompleteAttachedFileUploadRequest.Builder.() -> Unit): CompleteAttachedFileUploadResponse = completeAttachedFileUpload(CompleteAttachedFileUploadRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Creates an agent status for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.createAgentStatus(crossinline block: CreateAgentStatusRequest.Builder.() -> Unit): CreateAgentStatusResponse = createAgentStatus(CreateAgentStatusRequest.Builder().apply(block).build())

/**
 * Creates a flow for the specified Amazon Connect instance.
 *
 * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
 */
public suspend inline fun ConnectClient.createContactFlow(crossinline block: CreateContactFlowRequest.Builder.() -> Unit): CreateContactFlowResponse = createContactFlow(CreateContactFlowRequest.Builder().apply(block).build())

/**
 * Creates a flow module for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.createContactFlowModule(crossinline block: CreateContactFlowModuleRequest.Builder.() -> Unit): CreateContactFlowModuleResponse = createContactFlowModule(CreateContactFlowModuleRequest.Builder().apply(block).build())

/**
 * Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions related to agent performance, and create sections to organize such questions. Question and section identifiers cannot be duplicated within the same evaluation form.
 */
public suspend inline fun ConnectClient.createEvaluationForm(crossinline block: CreateEvaluationFormRequest.Builder.() -> Unit): CreateEvaluationFormResponse = createEvaluationForm(CreateEvaluationFormRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Creates hours of operation.
 */
public suspend inline fun ConnectClient.createHoursOfOperation(crossinline block: CreateHoursOfOperationRequest.Builder.() -> Unit): CreateHoursOfOperationResponse = createHoursOfOperation(CreateHoursOfOperationRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect.
 *
 * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
 */
public suspend inline fun ConnectClient.createInstance(crossinline block: CreateInstanceRequest.Builder.() -> Unit): CreateInstanceResponse = createInstance(CreateInstanceRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services resource association with an Amazon Connect instance.
 */
public suspend inline fun ConnectClient.createIntegrationAssociation(crossinline block: CreateIntegrationAssociationRequest.Builder.() -> Unit): CreateIntegrationAssociationResponse = createIntegrationAssociation(CreateIntegrationAssociationRequest.Builder().apply(block).build())

/**
 * Adds a new participant into an on-going chat contact. For more information, see [Customize chat flow experiences by integrating custom participants](https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html).
 */
public suspend inline fun ConnectClient.createParticipant(crossinline block: CreateParticipantRequest.Builder.() -> Unit): CreateParticipantResponse = createParticipant(CreateParticipantRequest.Builder().apply(block).build())

/**
 * Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.createPersistentContactAssociation(crossinline block: CreatePersistentContactAssociationRequest.Builder.() -> Unit): CreatePersistentContactAssociationResponse = createPersistentContactAssociation(CreatePersistentContactAssociationRequest.Builder().apply(block).build())

/**
 * Creates a new predefined attribute for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.createPredefinedAttribute(crossinline block: CreatePredefinedAttributeRequest.Builder.() -> Unit): CreatePredefinedAttributeResponse = createPredefinedAttribute(CreatePredefinedAttributeRequest.Builder().apply(block).build())

/**
 * Creates a prompt. For more information about prompts, such as supported file types and maximum length, see [Create prompts](https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html) in the *Amazon Connect Administrator's Guide*.
 */
public suspend inline fun ConnectClient.createPrompt(crossinline block: CreatePromptRequest.Builder.() -> Unit): CreatePromptResponse = createPrompt(CreatePromptRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Creates a new queue for the specified Amazon Connect instance.
 *
 * + If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for `OutboundCallerIdNumberId`. However, if the phone number is claimed to a traffic distribution group that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
 * + Only use the phone number ARN format that doesn't contain `instance` in the path, for example, `arn:aws:connect:us-east-1:1234567890:phone-number/uuid`. This is the same ARN format that is returned when you call the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API.
 * + If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic distribution group, see [Allow or Deny queue API actions for phone numbers in a replica Region](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region).
 */
public suspend inline fun ConnectClient.createQueue(crossinline block: CreateQueueRequest.Builder.() -> Unit): CreateQueueResponse = createQueue(CreateQueueRequest.Builder().apply(block).build())

/**
 * Creates a quick connect for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.createQuickConnect(crossinline block: CreateQuickConnectRequest.Builder.() -> Unit): CreateQuickConnectResponse = createQuickConnect(CreateQuickConnectRequest.Builder().apply(block).build())

/**
 * Creates a new routing profile.
 */
public suspend inline fun ConnectClient.createRoutingProfile(crossinline block: CreateRoutingProfileRequest.Builder.() -> Unit): CreateRoutingProfileResponse = createRoutingProfile(CreateRoutingProfileRequest.Builder().apply(block).build())

/**
 * Creates a rule for the specified Amazon Connect instance.
 *
 * Use the [Rules Function language](https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html) to code conditions for the rule.
 */
public suspend inline fun ConnectClient.createRule(crossinline block: CreateRuleRequest.Builder.() -> Unit): CreateRuleResponse = createRule(CreateRuleRequest.Builder().apply(block).build())

/**
 * Creates a security profile.
 */
public suspend inline fun ConnectClient.createSecurityProfile(crossinline block: CreateSecurityProfileRequest.Builder.() -> Unit): CreateSecurityProfileResponse = createSecurityProfile(CreateSecurityProfileRequest.Builder().apply(block).build())

/**
 * Creates a new task template in the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.createTaskTemplate(crossinline block: CreateTaskTemplateRequest.Builder.() -> Unit): CreateTaskTemplateResponse = createTaskTemplate(CreateTaskTemplateRequest.Builder().apply(block).build())

/**
 * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
 *
 * The `SignInConfig` distribution is available only on a default `TrafficDistributionGroup` (see the `IsDefault` parameter in the [TrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html) data type). If you call `UpdateTrafficDistribution` with a modified `SignInConfig` and a non-default `TrafficDistributionGroup`, an `InvalidRequestException` is returned.
 *
 * For more information about creating traffic distribution groups, see [Set up traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.createTrafficDistributionGroup(crossinline block: CreateTrafficDistributionGroupRequest.Builder.() -> Unit): CreateTrafficDistributionGroupResponse = createTrafficDistributionGroup(CreateTrafficDistributionGroupRequest.Builder().apply(block).build())

/**
 * Creates a use case for an integration association.
 */
public suspend inline fun ConnectClient.createUseCase(crossinline block: CreateUseCaseRequest.Builder.() -> Unit): CreateUseCaseResponse = createUseCase(CreateUseCaseRequest.Builder().apply(block).build())

/**
 * Creates a user account for the specified Amazon Connect instance.
 *
 * Certain [UserIdentityInfo](https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html) parameters are required in some situations. For example, `Email` is required if you are using SAML for identity management. `FirstName` and `LastName` are required if you are using Amazon Connect or SAML for identity management.
 *
 * For information about how to create users using the Amazon Connect admin website, see [Add Users](https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Creates a new user hierarchy group.
 */
public suspend inline fun ConnectClient.createUserHierarchyGroup(crossinline block: CreateUserHierarchyGroupRequest.Builder.() -> Unit): CreateUserHierarchyGroupResponse = createUserHierarchyGroup(CreateUserHierarchyGroupRequest.Builder().apply(block).build())

/**
 * Creates a new view with the possible status of `SAVED` or `PUBLISHED`.
 *
 * The views will have a unique name for each connect instance.
 *
 * It performs basic content validation if the status is `SAVED` or full content validation if the status is set to `PUBLISHED`. An error is returned if validation fails. It associates either the `$SAVED` qualifier or both of the `$SAVED` and `$LATEST` qualifiers with the provided view content based on the status. The view is idempotent if ClientToken is provided.
 */
public suspend inline fun ConnectClient.createView(crossinline block: CreateViewRequest.Builder.() -> Unit): CreateViewResponse = createView(CreateViewRequest.Builder().apply(block).build())

/**
 * Publishes a new version of the view identifier.
 *
 * Versions are immutable and monotonically increasing.
 *
 * It returns the highest version if there is no change in content compared to that version. An error is displayed if the supplied ViewContentSha256 is different from the ViewContentSha256 of the `$LATEST` alias.
 */
public suspend inline fun ConnectClient.createViewVersion(crossinline block: CreateViewVersionRequest.Builder.() -> Unit): CreateViewVersionResponse = createViewVersion(CreateViewVersionRequest.Builder().apply(block).build())

/**
 * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.
 */
public suspend inline fun ConnectClient.createVocabulary(crossinline block: CreateVocabularyRequest.Builder.() -> Unit): CreateVocabularyResponse = createVocabulary(CreateVocabularyRequest.Builder().apply(block).build())

/**
 * Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no longer available for users to start new evaluations based on the form.
 */
public suspend inline fun ConnectClient.deactivateEvaluationForm(crossinline block: DeactivateEvaluationFormRequest.Builder.() -> Unit): DeactivateEvaluationFormResponse = deactivateEvaluationForm(DeactivateEvaluationFormRequest.Builder().apply(block).build())

/**
 * Deletes an attached file along with the underlying S3 Object.
 *
 * The attached file is **permanently deleted** if S3 bucket versioning is not enabled.
 */
public suspend inline fun ConnectClient.deleteAttachedFile(crossinline block: DeleteAttachedFileRequest.Builder.() -> Unit): DeleteAttachedFileResponse = deleteAttachedFile(DeleteAttachedFileRequest.Builder().apply(block).build())

/**
 * Deletes a contact evaluation in the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.deleteContactEvaluation(crossinline block: DeleteContactEvaluationRequest.Builder.() -> Unit): DeleteContactEvaluationResponse = deleteContactEvaluation(DeleteContactEvaluationRequest.Builder().apply(block).build())

/**
 * Deletes a flow for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.deleteContactFlow(crossinline block: DeleteContactFlowRequest.Builder.() -> Unit): DeleteContactFlowResponse = deleteContactFlow(DeleteContactFlowRequest.Builder().apply(block).build())

/**
 * Deletes the specified flow module.
 */
public suspend inline fun ConnectClient.deleteContactFlowModule(crossinline block: DeleteContactFlowModuleRequest.Builder.() -> Unit): DeleteContactFlowModuleResponse = deleteContactFlowModule(DeleteContactFlowModuleRequest.Builder().apply(block).build())

/**
 * Deletes an evaluation form in the specified Amazon Connect instance.
 * + If the version property is provided, only the specified version of the evaluation form is deleted.
 * + If no version is provided, then the full form (all versions) is deleted.
 */
public suspend inline fun ConnectClient.deleteEvaluationForm(crossinline block: DeleteEvaluationFormRequest.Builder.() -> Unit): DeleteEvaluationFormResponse = deleteEvaluationForm(DeleteEvaluationFormRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Deletes an hours of operation.
 */
public suspend inline fun ConnectClient.deleteHoursOfOperation(crossinline block: DeleteHoursOfOperationRequest.Builder.() -> Unit): DeleteHoursOfOperationResponse = deleteHoursOfOperation(DeleteHoursOfOperationRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Deletes the Amazon Connect instance.
 *
 * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
 */
public suspend inline fun ConnectClient.deleteInstance(crossinline block: DeleteInstanceRequest.Builder.() -> Unit): DeleteInstanceResponse = deleteInstance(DeleteInstanceRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.
 */
public suspend inline fun ConnectClient.deleteIntegrationAssociation(crossinline block: DeleteIntegrationAssociationRequest.Builder.() -> Unit): DeleteIntegrationAssociationResponse = deleteIntegrationAssociation(DeleteIntegrationAssociationRequest.Builder().apply(block).build())

/**
 * Deletes a predefined attribute from the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.deletePredefinedAttribute(crossinline block: DeletePredefinedAttributeRequest.Builder.() -> Unit): DeletePredefinedAttributeResponse = deletePredefinedAttribute(DeletePredefinedAttributeRequest.Builder().apply(block).build())

/**
 * Deletes a prompt.
 */
public suspend inline fun ConnectClient.deletePrompt(crossinline block: DeletePromptRequest.Builder.() -> Unit): DeletePromptResponse = deletePrompt(DeletePromptRequest.Builder().apply(block).build())

/**
 * Deletes a queue.
 */
public suspend inline fun ConnectClient.deleteQueue(crossinline block: DeleteQueueRequest.Builder.() -> Unit): DeleteQueueResponse = deleteQueue(DeleteQueueRequest.Builder().apply(block).build())

/**
 * Deletes a quick connect.
 *
 * After calling [DeleteUser](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html), it's important to call `DeleteQuickConnect` to delete any records related to the deleted users. This will help you:
 * + Avoid dangling resources that impact your service quotas.
 * + Remove deleted users so they don't appear to agents as transfer options.
 * + Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using [Amazon Connect Global Resiliency](https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html).
 */
public suspend inline fun ConnectClient.deleteQuickConnect(crossinline block: DeleteQuickConnectRequest.Builder.() -> Unit): DeleteQuickConnectResponse = deleteQuickConnect(DeleteQuickConnectRequest.Builder().apply(block).build())

/**
 * Deletes a routing profile.
 */
public suspend inline fun ConnectClient.deleteRoutingProfile(crossinline block: DeleteRoutingProfileRequest.Builder.() -> Unit): DeleteRoutingProfileResponse = deleteRoutingProfile(DeleteRoutingProfileRequest.Builder().apply(block).build())

/**
 * Deletes a rule for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.deleteRule(crossinline block: DeleteRuleRequest.Builder.() -> Unit): DeleteRuleResponse = deleteRule(DeleteRuleRequest.Builder().apply(block).build())

/**
 * Deletes a security profile.
 */
public suspend inline fun ConnectClient.deleteSecurityProfile(crossinline block: DeleteSecurityProfileRequest.Builder.() -> Unit): DeleteSecurityProfileResponse = deleteSecurityProfile(DeleteSecurityProfileRequest.Builder().apply(block).build())

/**
 * Deletes the task template.
 */
public suspend inline fun ConnectClient.deleteTaskTemplate(crossinline block: DeleteTaskTemplateRequest.Builder.() -> Unit): DeleteTaskTemplateResponse = deleteTaskTemplate(DeleteTaskTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution group is created.
 *
 * For more information about deleting traffic distribution groups, see [Delete traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.deleteTrafficDistributionGroup(crossinline block: DeleteTrafficDistributionGroupRequest.Builder.() -> Unit): DeleteTrafficDistributionGroupResponse = deleteTrafficDistributionGroup(DeleteTrafficDistributionGroupRequest.Builder().apply(block).build())

/**
 * Deletes a use case from an integration association.
 */
public suspend inline fun ConnectClient.deleteUseCase(crossinline block: DeleteUseCaseRequest.Builder.() -> Unit): DeleteUseCaseResponse = deleteUseCase(DeleteUseCaseRequest.Builder().apply(block).build())

/**
 * Deletes a user account from the specified Amazon Connect instance.
 *
 * For information about what happens to a user's data when their account is deleted, see [Delete Users from Your Amazon Connect Instance](https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html) in the *Amazon Connect Administrator Guide*.
 *
 * After calling DeleteUser, call [DeleteQuickConnect](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html) to delete any records related to the deleted users. This will help you:
 * + Avoid dangling resources that impact your service quotas.
 * + Remove deleted users so they don't appear to agents as transfer options.
 * + Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using [Amazon Connect Global Resiliency](https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html).
 */
public suspend inline fun ConnectClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.
 */
public suspend inline fun ConnectClient.deleteUserHierarchyGroup(crossinline block: DeleteUserHierarchyGroupRequest.Builder.() -> Unit): DeleteUserHierarchyGroupResponse = deleteUserHierarchyGroup(DeleteUserHierarchyGroupRequest.Builder().apply(block).build())

/**
 * Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).
 */
public suspend inline fun ConnectClient.deleteView(crossinline block: DeleteViewRequest.Builder.() -> Unit): DeleteViewResponse = deleteView(DeleteViewRequest.Builder().apply(block).build())

/**
 * Deletes the particular version specified in `ViewVersion` identifier.
 */
public suspend inline fun ConnectClient.deleteViewVersion(crossinline block: DeleteViewVersionRequest.Builder.() -> Unit): DeleteViewVersionResponse = deleteViewVersion(DeleteViewVersionRequest.Builder().apply(block).build())

/**
 * Deletes the vocabulary that has the given identifier.
 */
public suspend inline fun ConnectClient.deleteVocabulary(crossinline block: DeleteVocabularyRequest.Builder.() -> Unit): DeleteVocabularyResponse = deleteVocabulary(DeleteVocabularyRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Describes an agent status.
 */
public suspend inline fun ConnectClient.describeAgentStatus(crossinline block: DescribeAgentStatusRequest.Builder.() -> Unit): DescribeAgentStatusResponse = describeAgentStatus(DescribeAgentStatusRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Describes the specified contact.
 *
 * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
 *
 * Only data from November 12, 2021, and later is returned by this API.
 */
public suspend inline fun ConnectClient.describeContact(crossinline block: DescribeContactRequest.Builder.() -> Unit): DescribeContactResponse = describeContact(DescribeContactRequest.Builder().apply(block).build())

/**
 * Describes a contact evaluation in the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.describeContactEvaluation(crossinline block: DescribeContactEvaluationRequest.Builder.() -> Unit): DescribeContactEvaluationResponse = describeContactEvaluation(DescribeContactEvaluationRequest.Builder().apply(block).build())

/**
 * Describes the specified flow.
 *
 * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
 *
 * Use the `$SAVED` alias in the request to describe the `SAVED` content of a Flow. For example, `arn:aws:.../contact-flow/{id}:$SAVED`. Once a contact flow is published, `$SAVED` needs to be supplied to view saved content that has not been published.
 *
 * In the response, **Status** indicates the flow status as either `SAVED` or `PUBLISHED`. The `PUBLISHED` status will initiate validation on the content. `SAVED` does not initiate validation of the content. `SAVED` | `PUBLISHED`
 */
public suspend inline fun ConnectClient.describeContactFlow(crossinline block: DescribeContactFlowRequest.Builder.() -> Unit): DescribeContactFlowResponse = describeContactFlow(DescribeContactFlowRequest.Builder().apply(block).build())

/**
 * Describes the specified flow module.
 *
 * Use the `$SAVED` alias in the request to describe the `SAVED` content of a Flow. For example, `arn:aws:.../contact-flow/{id}:$SAVED`. Once a contact flow is published, `$SAVED` needs to be supplied to view saved content that has not been published.
 */
public suspend inline fun ConnectClient.describeContactFlowModule(crossinline block: DescribeContactFlowModuleRequest.Builder.() -> Unit): DescribeContactFlowModuleResponse = describeContactFlowModule(DescribeContactFlowModuleRequest.Builder().apply(block).build())

/**
 * Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided, the latest version of the evaluation form is described.
 */
public suspend inline fun ConnectClient.describeEvaluationForm(crossinline block: DescribeEvaluationFormRequest.Builder.() -> Unit): DescribeEvaluationFormResponse = describeEvaluationForm(DescribeEvaluationFormRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Describes the hours of operation.
 */
public suspend inline fun ConnectClient.describeHoursOfOperation(crossinline block: DescribeHoursOfOperationRequest.Builder.() -> Unit): DescribeHoursOfOperationResponse = describeHoursOfOperation(DescribeHoursOfOperationRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable.
 *
 * If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
 */
public suspend inline fun ConnectClient.describeInstance(crossinline block: DescribeInstanceRequest.Builder.() -> Unit): DescribeInstanceResponse = describeInstance(DescribeInstanceRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Describes the specified instance attribute.
 */
public suspend inline fun ConnectClient.describeInstanceAttribute(crossinline block: DescribeInstanceAttributeRequest.Builder.() -> Unit): DescribeInstanceAttributeResponse = describeInstanceAttribute(DescribeInstanceAttributeRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
 */
public suspend inline fun ConnectClient.describeInstanceStorageConfig(crossinline block: DescribeInstanceStorageConfigRequest.Builder.() -> Unit): DescribeInstanceStorageConfigResponse = describeInstanceStorageConfig(DescribeInstanceStorageConfigRequest.Builder().apply(block).build())

/**
 * Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution group.
 *
 * If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
 */
public suspend inline fun ConnectClient.describePhoneNumber(crossinline block: DescribePhoneNumberRequest.Builder.() -> Unit): DescribePhoneNumberResponse = describePhoneNumber(DescribePhoneNumberRequest.Builder().apply(block).build())

/**
 * Describes a predefined attribute for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.describePredefinedAttribute(crossinline block: DescribePredefinedAttributeRequest.Builder.() -> Unit): DescribePredefinedAttributeResponse = describePredefinedAttribute(DescribePredefinedAttributeRequest.Builder().apply(block).build())

/**
 * Describes the prompt.
 */
public suspend inline fun ConnectClient.describePrompt(crossinline block: DescribePromptRequest.Builder.() -> Unit): DescribePromptResponse = describePrompt(DescribePromptRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Describes the specified queue.
 */
public suspend inline fun ConnectClient.describeQueue(crossinline block: DescribeQueueRequest.Builder.() -> Unit): DescribeQueueResponse = describeQueue(DescribeQueueRequest.Builder().apply(block).build())

/**
 * Describes the quick connect.
 */
public suspend inline fun ConnectClient.describeQuickConnect(crossinline block: DescribeQuickConnectRequest.Builder.() -> Unit): DescribeQuickConnectResponse = describeQuickConnect(DescribeQuickConnectRequest.Builder().apply(block).build())

/**
 * Describes the specified routing profile.
 */
public suspend inline fun ConnectClient.describeRoutingProfile(crossinline block: DescribeRoutingProfileRequest.Builder.() -> Unit): DescribeRoutingProfileResponse = describeRoutingProfile(DescribeRoutingProfileRequest.Builder().apply(block).build())

/**
 * Describes a rule for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.describeRule(crossinline block: DescribeRuleRequest.Builder.() -> Unit): DescribeRuleResponse = describeRule(DescribeRuleRequest.Builder().apply(block).build())

/**
 * Gets basic information about the security profle.
 */
public suspend inline fun ConnectClient.describeSecurityProfile(crossinline block: DescribeSecurityProfileRequest.Builder.() -> Unit): DescribeSecurityProfileResponse = describeSecurityProfile(DescribeSecurityProfileRequest.Builder().apply(block).build())

/**
 * Gets details and status of a traffic distribution group.
 */
public suspend inline fun ConnectClient.describeTrafficDistributionGroup(crossinline block: DescribeTrafficDistributionGroupRequest.Builder.() -> Unit): DescribeTrafficDistributionGroupResponse = describeTrafficDistributionGroup(DescribeTrafficDistributionGroupRequest.Builder().apply(block).build())

/**
 * Describes the specified user. You can [find the instance ID in the Amazon Connect console](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
 */
public suspend inline fun ConnectClient.describeUser(crossinline block: DescribeUserRequest.Builder.() -> Unit): DescribeUserResponse = describeUser(DescribeUserRequest.Builder().apply(block).build())

/**
 * Describes the specified hierarchy group.
 */
public suspend inline fun ConnectClient.describeUserHierarchyGroup(crossinline block: DescribeUserHierarchyGroupRequest.Builder.() -> Unit): DescribeUserHierarchyGroupResponse = describeUserHierarchyGroup(DescribeUserHierarchyGroupRequest.Builder().apply(block).build())

/**
 * Describes the hierarchy structure of the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.describeUserHierarchyStructure(crossinline block: DescribeUserHierarchyStructureRequest.Builder.() -> Unit): DescribeUserHierarchyStructureResponse = describeUserHierarchyStructure(DescribeUserHierarchyStructureRequest.Builder().apply(block).build())

/**
 * Retrieves the view for the specified Amazon Connect instance and view identifier.
 *
 * The view identifier can be supplied as a ViewId or ARN.
 *
 * `$SAVED` needs to be supplied if a view is unpublished.
 *
 * The view identifier can contain an optional qualifier, for example, `<view-id>:$SAVED`, which is either an actual version number or an Amazon Connect managed qualifier `$SAVED | $LATEST`. If it is not supplied, then `$LATEST` is assumed for customer managed views and an error is returned if there is no published content available. Version 1 is assumed for Amazon Web Services managed views.
 */
public suspend inline fun ConnectClient.describeView(crossinline block: DescribeViewRequest.Builder.() -> Unit): DescribeViewResponse = describeView(DescribeViewRequest.Builder().apply(block).build())

/**
 * Describes the specified vocabulary.
 */
public suspend inline fun ConnectClient.describeVocabulary(crossinline block: DescribeVocabularyRequest.Builder.() -> Unit): DescribeVocabularyResponse = describeVocabulary(DescribeVocabularyRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Removes the dataset ID associated with a given Amazon Connect instance.
 */
public suspend inline fun ConnectClient.disassociateAnalyticsDataSet(crossinline block: DisassociateAnalyticsDataSetRequest.Builder.() -> Unit): DisassociateAnalyticsDataSetResponse = disassociateAnalyticsDataSet(DisassociateAnalyticsDataSetRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Revokes access to integrated applications from Amazon Connect.
 */
public suspend inline fun ConnectClient.disassociateApprovedOrigin(crossinline block: DisassociateApprovedOriginRequest.Builder.() -> Unit): DisassociateApprovedOriginResponse = disassociateApprovedOrigin(DisassociateApprovedOriginRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
 */
public suspend inline fun ConnectClient.disassociateBot(crossinline block: DisassociateBotRequest.Builder.() -> Unit): DisassociateBotResponse = disassociateBot(DisassociateBotRequest.Builder().apply(block).build())

/**
 * Disassociates a connect resource from a flow.
 */
public suspend inline fun ConnectClient.disassociateFlow(crossinline block: DisassociateFlowRequest.Builder.() -> Unit): DisassociateFlowResponse = disassociateFlow(DisassociateFlowRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Removes the storage type configurations for the specified resource type and association ID.
 */
public suspend inline fun ConnectClient.disassociateInstanceStorageConfig(crossinline block: DisassociateInstanceStorageConfigRequest.Builder.() -> Unit): DisassociateInstanceStorageConfigResponse = disassociateInstanceStorageConfig(DisassociateInstanceStorageConfigRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Remove the Lambda function from the dropdown options available in the relevant flow blocks.
 */
public suspend inline fun ConnectClient.disassociateLambdaFunction(crossinline block: DisassociateLambdaFunctionRequest.Builder.() -> Unit): DisassociateLambdaFunctionResponse = disassociateLambdaFunction(DisassociateLambdaFunctionRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
 */
public suspend inline fun ConnectClient.disassociateLexBot(crossinline block: DisassociateLexBotRequest.Builder.() -> Unit): DisassociateLexBotResponse = disassociateLexBot(DisassociateLexBotRequest.Builder().apply(block).build())

/**
 * Removes the flow association from a phone number claimed to your Amazon Connect instance.
 *
 * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
 */
public suspend inline fun ConnectClient.disassociatePhoneNumberContactFlow(crossinline block: DisassociatePhoneNumberContactFlowRequest.Builder.() -> Unit): DisassociatePhoneNumberContactFlowResponse = disassociatePhoneNumberContactFlow(DisassociatePhoneNumberContactFlowRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Disassociates a set of quick connects from a queue.
 */
public suspend inline fun ConnectClient.disassociateQueueQuickConnects(crossinline block: DisassociateQueueQuickConnectsRequest.Builder.() -> Unit): DisassociateQueueQuickConnectsResponse = disassociateQueueQuickConnects(DisassociateQueueQuickConnectsRequest.Builder().apply(block).build())

/**
 * Disassociates a set of queues from a routing profile.
 */
public suspend inline fun ConnectClient.disassociateRoutingProfileQueues(crossinline block: DisassociateRoutingProfileQueuesRequest.Builder.() -> Unit): DisassociateRoutingProfileQueuesResponse = disassociateRoutingProfileQueues(DisassociateRoutingProfileQueuesRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Deletes the specified security key.
 */
public suspend inline fun ConnectClient.disassociateSecurityKey(crossinline block: DisassociateSecurityKeyRequest.Builder.() -> Unit): DisassociateSecurityKeyResponse = disassociateSecurityKey(DisassociateSecurityKeyRequest.Builder().apply(block).build())

/**
 * Disassociates an agent from a traffic distribution group.
 */
public suspend inline fun ConnectClient.disassociateTrafficDistributionGroupUser(crossinline block: DisassociateTrafficDistributionGroupUserRequest.Builder.() -> Unit): DisassociateTrafficDistributionGroupUserResponse = disassociateTrafficDistributionGroupUser(DisassociateTrafficDistributionGroupUserRequest.Builder().apply(block).build())

/**
 * Disassociates a set of proficiencies from a user.
 */
public suspend inline fun ConnectClient.disassociateUserProficiencies(crossinline block: DisassociateUserProficienciesRequest.Builder.() -> Unit): DisassociateUserProficienciesResponse = disassociateUserProficiencies(DisassociateUserProficienciesRequest.Builder().apply(block).build())

/**
 * Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to receive a new routed contact. Contacts can only be dismissed if they are in a `MISSED`, `ERROR`, `ENDED`, or `REJECTED` state in the [Agent Event Stream](https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
 */
public suspend inline fun ConnectClient.dismissUserContact(crossinline block: DismissUserContactRequest.Builder.() -> Unit): DismissUserContactResponse = dismissUserContact(DismissUserContactRequest.Builder().apply(block).build())

/**
 * Provides a pre-signed URL for download of an approved attached file. This API also returns metadata about the attached file. It will only return a downloadURL if the status of the attached file is `APPROVED`.
 */
public suspend inline fun ConnectClient.getAttachedFile(crossinline block: GetAttachedFileRequest.Builder.() -> Unit): GetAttachedFileResponse = getAttachedFile(GetAttachedFileRequest.Builder().apply(block).build())

/**
 * Retrieves the contact attributes for the specified contact.
 */
public suspend inline fun ConnectClient.getContactAttributes(crossinline block: GetContactAttributesRequest.Builder.() -> Unit): GetContactAttributesResponse = getContactAttributes(GetContactAttributesRequest.Builder().apply(block).build())

/**
 * Gets the real-time metric data from the specified Amazon Connect instance.
 *
 * For a description of each metric, see [Real-time Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.getCurrentMetricData(crossinline block: GetCurrentMetricDataRequest.Builder.() -> Unit): GetCurrentMetricDataResponse = getCurrentMetricData(GetCurrentMetricDataRequest.Builder().apply(block).build())

/**
 * Gets the real-time active user data from the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.getCurrentUserData(crossinline block: GetCurrentUserDataRequest.Builder.() -> Unit): GetCurrentUserDataResponse = getCurrentUserData(GetCurrentUserDataRequest.Builder().apply(block).build())

/**
 * Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect user which corresponds to the IAM credentials that were used to invoke this action.
 *
 * For more information about how SAML sign-in works in Amazon Connect, see *Amazon Connect Administrator Guide*[.](https://docs.aws.amazon.com/connect/latest/adminguide/configure-saml.html )
 *
 * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears:
 *
 * `Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect`
 */
public suspend inline fun ConnectClient.getFederationToken(crossinline block: GetFederationTokenRequest.Builder.() -> Unit): GetFederationTokenResponse = getFederationToken(GetFederationTokenRequest.Builder().apply(block).build())

/**
 * Retrieves the flow associated for a given resource.
 */
public suspend inline fun ConnectClient.getFlowAssociation(crossinline block: GetFlowAssociationRequest.Builder.() -> Unit): GetFlowAssociationResponse = getFlowAssociation(GetFlowAssociationRequest.Builder().apply(block).build())

/**
 * Gets historical metric data from the specified Amazon Connect instance.
 *
 * For a description of each historical metric, see [Historical Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
 *
 * We recommend using the [GetMetricDataV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html) API. It provides more flexibility, features, and the ability to query longer time ranges than `GetMetricData`. Use it to retrieve historical agent and contact metrics for the last 3 months, at varying intervals. You can also use it to build custom dashboards to measure historical queue and agent performance. For example, you can track the number of incoming contacts for the last 7 days, with data split by day, to see how contact volume changed per day of the week.
 */
public suspend inline fun ConnectClient.getMetricData(crossinline block: GetMetricDataRequest.Builder.() -> Unit): GetMetricDataResponse = getMetricData(GetMetricDataRequest.Builder().apply(block).build())

/**
 * Gets metric data from the specified Amazon Connect instance.
 *
 * `GetMetricDataV2` offers more features than [GetMetricData](https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html), the previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve historical data for the last 3 months, at varying intervals.
 *
 * For a description of the historical metrics that are supported by `GetMetricDataV2` and `GetMetricData`, see [Historical metrics definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator's Guide*.
 */
public suspend inline fun ConnectClient.getMetricDataV2(crossinline block: GetMetricDataV2Request.Builder.() -> Unit): GetMetricDataV2Response = getMetricDataV2(GetMetricDataV2Request.Builder().apply(block).build())

/**
 * Gets the prompt file.
 */
public suspend inline fun ConnectClient.getPromptFile(crossinline block: GetPromptFileRequest.Builder.() -> Unit): GetPromptFileResponse = getPromptFile(GetPromptFileRequest.Builder().apply(block).build())

/**
 * Gets details about a specific task template in the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.getTaskTemplate(crossinline block: GetTaskTemplateRequest.Builder.() -> Unit): GetTaskTemplateResponse = getTaskTemplate(GetTaskTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves the current traffic distribution for a given traffic distribution group.
 */
public suspend inline fun ConnectClient.getTrafficDistribution(crossinline block: GetTrafficDistributionRequest.Builder.() -> Unit): GetTrafficDistributionResponse = getTrafficDistribution(GetTrafficDistributionRequest.Builder().apply(block).build())

/**
 * Imports a claimed phone number from an external service, such as Amazon Pinpoint, into an Amazon Connect instance. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance was created.
 */
public suspend inline fun ConnectClient.importPhoneNumber(crossinline block: ImportPhoneNumberRequest.Builder.() -> Unit): ImportPhoneNumberResponse = importPhoneNumber(ImportPhoneNumberRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Lists agent statuses.
 */
public suspend inline fun ConnectClient.listAgentStatuses(crossinline block: ListAgentStatusesRequest.Builder.() -> Unit): ListAgentStatusesResponse = listAgentStatuses(ListAgentStatusesRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Lists the association status of requested dataset ID for a given Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listAnalyticsDataAssociations(crossinline block: ListAnalyticsDataAssociationsRequest.Builder.() -> Unit): ListAnalyticsDataAssociationsResponse = listAnalyticsDataAssociations(ListAnalyticsDataAssociationsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Returns a paginated list of all approved origins associated with the instance.
 */
public suspend inline fun ConnectClient.listApprovedOrigins(crossinline block: ListApprovedOriginsRequest.Builder.() -> Unit): ListApprovedOriginsResponse = listApprovedOrigins(ListApprovedOriginsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance. Use this API to returns both Amazon Lex V1 and V2 bots.
 */
public suspend inline fun ConnectClient.listBots(crossinline block: ListBotsRequest.Builder.() -> Unit): ListBotsResponse = listBots(ListBotsRequest.Builder().apply(block).build())

/**
 * Lists contact evaluations in the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listContactEvaluations(crossinline block: ListContactEvaluationsRequest.Builder.() -> Unit): ListContactEvaluationsResponse = listContactEvaluations(ListContactEvaluationsRequest.Builder().apply(block).build())

/**
 * Provides information about the flow modules for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listContactFlowModules(crossinline block: ListContactFlowModulesRequest.Builder.() -> Unit): ListContactFlowModulesResponse = listContactFlowModules(ListContactFlowModulesRequest.Builder().apply(block).build())

/**
 * Provides information about the flows for the specified Amazon Connect instance.
 *
 * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
 *
 * For more information about flows, see [Flows](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.listContactFlows(crossinline block: ListContactFlowsRequest.Builder.() -> Unit): ListContactFlowsResponse = listContactFlows(ListContactFlowsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * For the specified `referenceTypes`, returns a list of references associated with the contact. *References* are links to documents that are related to a contact, such as emails, attachments, or URLs.
 */
public suspend inline fun ConnectClient.listContactReferences(crossinline block: ListContactReferencesRequest.Builder.() -> Unit): ListContactReferencesResponse = listContactReferences(ListContactReferencesRequest.Builder().apply(block).build())

/**
 * Lists the default vocabularies for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listDefaultVocabularies(crossinline block: ListDefaultVocabulariesRequest.Builder.() -> Unit): ListDefaultVocabulariesResponse = listDefaultVocabularies(ListDefaultVocabulariesRequest.Builder().apply(block).build())

/**
 * Lists versions of an evaluation form in the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listEvaluationFormVersions(crossinline block: ListEvaluationFormVersionsRequest.Builder.() -> Unit): ListEvaluationFormVersionsResponse = listEvaluationFormVersions(ListEvaluationFormVersionsRequest.Builder().apply(block).build())

/**
 * Lists evaluation forms in the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listEvaluationForms(crossinline block: ListEvaluationFormsRequest.Builder.() -> Unit): ListEvaluationFormsResponse = listEvaluationForms(ListEvaluationFormsRequest.Builder().apply(block).build())

/**
 * List the flow association based on the filters.
 */
public suspend inline fun ConnectClient.listFlowAssociations(crossinline block: ListFlowAssociationsRequest.Builder.() -> Unit): ListFlowAssociationsResponse = listFlowAssociations(ListFlowAssociationsRequest.Builder().apply(block).build())

/**
 * Provides information about the hours of operation for the specified Amazon Connect instance.
 *
 * For more information about hours of operation, see [Set the Hours of Operation for a Queue](https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.listHoursOfOperations(crossinline block: ListHoursOfOperationsRequest.Builder.() -> Unit): ListHoursOfOperationsResponse = listHoursOfOperations(ListHoursOfOperationsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Returns a paginated list of all attribute types for the given instance.
 */
public suspend inline fun ConnectClient.listInstanceAttributes(crossinline block: ListInstanceAttributesRequest.Builder.() -> Unit): ListInstanceAttributesResponse = listInstanceAttributes(ListInstanceAttributesRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Returns a paginated list of storage configs for the identified instance and resource type.
 */
public suspend inline fun ConnectClient.listInstanceStorageConfigs(crossinline block: ListInstanceStorageConfigsRequest.Builder.() -> Unit): ListInstanceStorageConfigsResponse = listInstanceStorageConfigs(ListInstanceStorageConfigsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren't successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.
 */
public suspend inline fun ConnectClient.listInstances(crossinline block: ListInstancesRequest.Builder.() -> Unit): ListInstancesResponse = listInstances(ListInstancesRequest.Builder().apply(block).build())

/**
 * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listIntegrationAssociations(crossinline block: ListIntegrationAssociationsRequest.Builder.() -> Unit): ListIntegrationAssociationsResponse = listIntegrationAssociations(ListIntegrationAssociationsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant flow blocks.
 */
public suspend inline fun ConnectClient.listLambdaFunctions(crossinline block: ListLambdaFunctionsRequest.Builder.() -> Unit): ListLambdaFunctionsResponse = listLambdaFunctions(ListLambdaFunctionsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Returns a paginated list of all the Amazon Lex V1 bots currently associated with the instance. To return both Amazon Lex V1 and V2 bots, use the [ListBots](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListBots.html) API.
 */
public suspend inline fun ConnectClient.listLexBots(crossinline block: ListLexBotsRequest.Builder.() -> Unit): ListLexBotsResponse = listLexBots(ListLexBotsRequest.Builder().apply(block).build())

/**
 * Provides information about the phone numbers for the specified Amazon Connect instance.
 *
 * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
 *
 * + We recommend using [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) to return phone number types. ListPhoneNumbers doesn't support number types `UIFN`, `SHARED`, `THIRD_PARTY_TF`, and `THIRD_PARTY_DID`. While it returns numbers of those types, it incorrectly lists them as `TOLL_FREE` or `DID`.
 * + The phone number `Arn` value that is returned from each of the items in the [PhoneNumberSummaryList](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html#connect-ListPhoneNumbers-response-PhoneNumberSummaryList) cannot be used to tag phone number resources. It will fail with a `ResourceNotFoundException`. Instead, use the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API. It returns the new phone number ARN that can be used to tag phone number resources.
 */
public suspend inline fun ConnectClient.listPhoneNumbers(crossinline block: ListPhoneNumbersRequest.Builder.() -> Unit): ListPhoneNumbersResponse = listPhoneNumbers(ListPhoneNumbersRequest.Builder().apply(block).build())

/**
 * Lists phone numbers claimed to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with traffic distribution group.
 *
 * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
 *
 * + When given an instance ARN, `ListPhoneNumbersV2` returns only the phone numbers claimed to the instance.
 * + When given a traffic distribution group ARN `ListPhoneNumbersV2` returns only the phone numbers claimed to the traffic distribution group.
 */
public suspend inline fun ConnectClient.listPhoneNumbersV2(crossinline block: ListPhoneNumbersV2Request.Builder.() -> Unit): ListPhoneNumbersV2Response = listPhoneNumbersV2(ListPhoneNumbersV2Request.Builder().apply(block).build())

/**
 * Lists predefined attributes for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listPredefinedAttributes(crossinline block: ListPredefinedAttributesRequest.Builder.() -> Unit): ListPredefinedAttributesResponse = listPredefinedAttributes(ListPredefinedAttributesRequest.Builder().apply(block).build())

/**
 * Provides information about the prompts for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listPrompts(crossinline block: ListPromptsRequest.Builder.() -> Unit): ListPromptsResponse = listPrompts(ListPromptsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Lists the quick connects associated with a queue.
 */
public suspend inline fun ConnectClient.listQueueQuickConnects(crossinline block: ListQueueQuickConnectsRequest.Builder.() -> Unit): ListQueueQuickConnectsResponse = listQueueQuickConnects(ListQueueQuickConnectsRequest.Builder().apply(block).build())

/**
 * Provides information about the queues for the specified Amazon Connect instance.
 *
 * If you do not specify a `QueueTypes` parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.
 *
 * For more information about queues, see [Queues: Standard and Agent](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.listQueues(crossinline block: ListQueuesRequest.Builder.() -> Unit): ListQueuesResponse = listQueues(ListQueuesRequest.Builder().apply(block).build())

/**
 * Provides information about the quick connects for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listQuickConnects(crossinline block: ListQuickConnectsRequest.Builder.() -> Unit): ListQuickConnectsResponse = listQuickConnects(ListQuickConnectsRequest.Builder().apply(block).build())

/**
 * Provides a list of analysis segments for a real-time analysis session.
 */
public suspend inline fun ConnectClient.listRealtimeContactAnalysisSegmentsV2(crossinline block: ListRealtimeContactAnalysisSegmentsV2Request.Builder.() -> Unit): ListRealtimeContactAnalysisSegmentsV2Response = listRealtimeContactAnalysisSegmentsV2(ListRealtimeContactAnalysisSegmentsV2Request.Builder().apply(block).build())

/**
 * Lists the queues associated with a routing profile.
 */
public suspend inline fun ConnectClient.listRoutingProfileQueues(crossinline block: ListRoutingProfileQueuesRequest.Builder.() -> Unit): ListRoutingProfileQueuesResponse = listRoutingProfileQueues(ListRoutingProfileQueuesRequest.Builder().apply(block).build())

/**
 * Provides summary information about the routing profiles for the specified Amazon Connect instance.
 *
 * For more information about routing profiles, see [Routing Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html) and [Create a Routing Profile](https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.listRoutingProfiles(crossinline block: ListRoutingProfilesRequest.Builder.() -> Unit): ListRoutingProfilesResponse = listRoutingProfiles(ListRoutingProfilesRequest.Builder().apply(block).build())

/**
 * List all rules for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listRules(crossinline block: ListRulesRequest.Builder.() -> Unit): ListRulesResponse = listRules(ListRulesRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Returns a paginated list of all security keys associated with the instance.
 */
public suspend inline fun ConnectClient.listSecurityKeys(crossinline block: ListSecurityKeysRequest.Builder.() -> Unit): ListSecurityKeysResponse = listSecurityKeys(ListSecurityKeysRequest.Builder().apply(block).build())

/**
 * Returns a list of third-party applications in a specific security profile.
 */
public suspend inline fun ConnectClient.listSecurityProfileApplications(crossinline block: ListSecurityProfileApplicationsRequest.Builder.() -> Unit): ListSecurityProfileApplicationsResponse = listSecurityProfileApplications(ListSecurityProfileApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the permissions granted to a security profile.
 */
public suspend inline fun ConnectClient.listSecurityProfilePermissions(crossinline block: ListSecurityProfilePermissionsRequest.Builder.() -> Unit): ListSecurityProfilePermissionsResponse = listSecurityProfilePermissions(ListSecurityProfilePermissionsRequest.Builder().apply(block).build())

/**
 * Provides summary information about the security profiles for the specified Amazon Connect instance.
 *
 * For more information about security profiles, see [Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.listSecurityProfiles(crossinline block: ListSecurityProfilesRequest.Builder.() -> Unit): ListSecurityProfilesResponse = listSecurityProfiles(ListSecurityProfilesRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 *
 * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists task templates for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listTaskTemplates(crossinline block: ListTaskTemplatesRequest.Builder.() -> Unit): ListTaskTemplatesResponse = listTaskTemplates(ListTaskTemplatesRequest.Builder().apply(block).build())

/**
 * Lists traffic distribution group users.
 */
public suspend inline fun ConnectClient.listTrafficDistributionGroupUsers(crossinline block: ListTrafficDistributionGroupUsersRequest.Builder.() -> Unit): ListTrafficDistributionGroupUsersResponse = listTrafficDistributionGroupUsers(ListTrafficDistributionGroupUsersRequest.Builder().apply(block).build())

/**
 * Lists traffic distribution groups.
 */
public suspend inline fun ConnectClient.listTrafficDistributionGroups(crossinline block: ListTrafficDistributionGroupsRequest.Builder.() -> Unit): ListTrafficDistributionGroupsResponse = listTrafficDistributionGroups(ListTrafficDistributionGroupsRequest.Builder().apply(block).build())

/**
 * Lists the use cases for the integration association.
 */
public suspend inline fun ConnectClient.listUseCases(crossinline block: ListUseCasesRequest.Builder.() -> Unit): ListUseCasesResponse = listUseCases(ListUseCasesRequest.Builder().apply(block).build())

/**
 * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
 *
 * For more information about agent hierarchies, see [Set Up Agent Hierarchies](https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.listUserHierarchyGroups(crossinline block: ListUserHierarchyGroupsRequest.Builder.() -> Unit): ListUserHierarchyGroupsResponse = listUserHierarchyGroups(ListUserHierarchyGroupsRequest.Builder().apply(block).build())

/**
 * Lists proficiencies associated with a user.
 */
public suspend inline fun ConnectClient.listUserProficiencies(crossinline block: ListUserProficienciesRequest.Builder.() -> Unit): ListUserProficienciesResponse = listUserProficiencies(ListUserProficienciesRequest.Builder().apply(block).build())

/**
 * Provides summary information about the users for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Returns all the available versions for the specified Amazon Connect instance and view identifier.
 *
 * Results will be sorted from highest to lowest.
 */
public suspend inline fun ConnectClient.listViewVersions(crossinline block: ListViewVersionsRequest.Builder.() -> Unit): ListViewVersionsResponse = listViewVersions(ListViewVersionsRequest.Builder().apply(block).build())

/**
 * Returns views in the given instance.
 *
 * Results are sorted primarily by type, and secondarily by name.
 */
public suspend inline fun ConnectClient.listViews(crossinline block: ListViewsRequest.Builder.() -> Unit): ListViewsResponse = listViews(ListViewsRequest.Builder().apply(block).build())

/**
 * Initiates silent monitoring of a contact. The Contact Control Panel (CCP) of the user specified by *userId* will be set to silent monitoring mode on the contact.
 */
public suspend inline fun ConnectClient.monitorContact(crossinline block: MonitorContactRequest.Builder.() -> Unit): MonitorContactResponse = monitorContact(MonitorContactRequest.Builder().apply(block).build())

/**
 * Allows pausing an ongoing task contact.
 */
public suspend inline fun ConnectClient.pauseContact(crossinline block: PauseContactRequest.Builder.() -> Unit): PauseContactResponse = pauseContact(PauseContactRequest.Builder().apply(block).build())

/**
 * Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact, this sets the agent's next status.
 *
 * For more information, see [Agent status](https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html) and [Set your next status](https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.putUserStatus(crossinline block: PutUserStatusRequest.Builder.() -> Unit): PutUserStatusResponse = putUserStatus(PutUserStatusRequest.Builder().apply(block).build())

/**
 * Releases a phone number previously claimed to an Amazon Connect instance or traffic distribution group. You can call this API only in the Amazon Web Services Region where the number was claimed.
 *
 * To release phone numbers from a traffic distribution group, use the `ReleasePhoneNumber` API, not the Amazon Connect admin website.
 *
 * After releasing a phone number, the phone number enters into a cooldown period of 30 days. It cannot be searched for or claimed again until the period has ended. If you accidentally release a phone number, contact Amazon Web Services Support.
 *
 * If you plan to claim and release numbers frequently during a 30 day period, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until 30 days past the oldest number released has expired.
 *
 * By default you can claim and release up to 200% of your maximum number of active phone numbers during any 30 day period. If you claim and release phone numbers using the UI or API during a rolling 30 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming any more numbers until 30 days past the oldest number released has expired.
 *
 * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 30 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
 */
public suspend inline fun ConnectClient.releasePhoneNumber(crossinline block: ReleasePhoneNumberRequest.Builder.() -> Unit): ReleasePhoneNumberResponse = releasePhoneNumber(ReleasePhoneNumberRequest.Builder().apply(block).build())

/**
 * Replicates an Amazon Connect instance in the specified Amazon Web Services Region and copies configuration information for Amazon Connect resources across Amazon Web Services Regions.
 *
 * For more information about replicating an Amazon Connect instance, see [Create a replica of your existing Amazon Connect instance](https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.replicateInstance(crossinline block: ReplicateInstanceRequest.Builder.() -> Unit): ReplicateInstanceResponse = replicateInstance(ReplicateInstanceRequest.Builder().apply(block).build())

/**
 * Allows resuming a task contact in a paused state.
 */
public suspend inline fun ConnectClient.resumeContact(crossinline block: ResumeContactRequest.Builder.() -> Unit): ResumeContactResponse = resumeContact(ResumeContactRequest.Builder().apply(block).build())

/**
 * When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording whatever recording is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would resume.
 *
 * Voice and screen recordings are supported.
 */
public suspend inline fun ConnectClient.resumeContactRecording(crossinline block: ResumeContactRecordingRequest.Builder.() -> Unit): ResumeContactRecordingResponse = resumeContactRecording(ResumeContactRecordingRequest.Builder().apply(block).build())

/**
 * Searches for available phone numbers that you can claim to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with the traffic distribution group.
 */
public suspend inline fun ConnectClient.searchAvailablePhoneNumbers(crossinline block: SearchAvailablePhoneNumbersRequest.Builder.() -> Unit): SearchAvailablePhoneNumbersResponse = searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest.Builder().apply(block).build())

/**
 * Searches the flow modules in an Amazon Connect instance, with optional filtering.
 */
public suspend inline fun ConnectClient.searchContactFlowModules(crossinline block: SearchContactFlowModulesRequest.Builder.() -> Unit): SearchContactFlowModulesResponse = searchContactFlowModules(SearchContactFlowModulesRequest.Builder().apply(block).build())

/**
 * Searches the contact flows in an Amazon Connect instance, with optional filtering.
 */
public suspend inline fun ConnectClient.searchContactFlows(crossinline block: SearchContactFlowsRequest.Builder.() -> Unit): SearchContactFlowsResponse = searchContactFlows(SearchContactFlowsRequest.Builder().apply(block).build())

/**
 * Searches contacts in an Amazon Connect instance.
 */
public suspend inline fun ConnectClient.searchContacts(crossinline block: SearchContactsRequest.Builder.() -> Unit): SearchContactsResponse = searchContacts(SearchContactsRequest.Builder().apply(block).build())

/**
 * Searches the hours of operation in an Amazon Connect instance, with optional filtering.
 */
public suspend inline fun ConnectClient.searchHoursOfOperations(crossinline block: SearchHoursOfOperationsRequest.Builder.() -> Unit): SearchHoursOfOperationsResponse = searchHoursOfOperations(SearchHoursOfOperationsRequest.Builder().apply(block).build())

/**
 * Predefined attributes that meet certain criteria.
 */
public suspend inline fun ConnectClient.searchPredefinedAttributes(crossinline block: SearchPredefinedAttributesRequest.Builder.() -> Unit): SearchPredefinedAttributesResponse = searchPredefinedAttributes(SearchPredefinedAttributesRequest.Builder().apply(block).build())

/**
 * Searches prompts in an Amazon Connect instance, with optional filtering.
 */
public suspend inline fun ConnectClient.searchPrompts(crossinline block: SearchPromptsRequest.Builder.() -> Unit): SearchPromptsResponse = searchPrompts(SearchPromptsRequest.Builder().apply(block).build())

/**
 * Searches queues in an Amazon Connect instance, with optional filtering.
 */
public suspend inline fun ConnectClient.searchQueues(crossinline block: SearchQueuesRequest.Builder.() -> Unit): SearchQueuesResponse = searchQueues(SearchQueuesRequest.Builder().apply(block).build())

/**
 * Searches quick connects in an Amazon Connect instance, with optional filtering.
 */
public suspend inline fun ConnectClient.searchQuickConnects(crossinline block: SearchQuickConnectsRequest.Builder.() -> Unit): SearchQuickConnectsResponse = searchQuickConnects(SearchQuickConnectsRequest.Builder().apply(block).build())

/**
 * Searches tags used in an Amazon Connect instance using optional search criteria.
 */
public suspend inline fun ConnectClient.searchResourceTags(crossinline block: SearchResourceTagsRequest.Builder.() -> Unit): SearchResourceTagsResponse = searchResourceTags(SearchResourceTagsRequest.Builder().apply(block).build())

/**
 * Searches routing profiles in an Amazon Connect instance, with optional filtering.
 */
public suspend inline fun ConnectClient.searchRoutingProfiles(crossinline block: SearchRoutingProfilesRequest.Builder.() -> Unit): SearchRoutingProfilesResponse = searchRoutingProfiles(SearchRoutingProfilesRequest.Builder().apply(block).build())

/**
 * Searches security profiles in an Amazon Connect instance, with optional filtering.
 */
public suspend inline fun ConnectClient.searchSecurityProfiles(crossinline block: SearchSecurityProfilesRequest.Builder.() -> Unit): SearchSecurityProfilesResponse = searchSecurityProfiles(SearchSecurityProfilesRequest.Builder().apply(block).build())

/**
 * Searches users in an Amazon Connect instance, with optional filtering.
 *
 * `AfterContactWorkTimeLimit` is returned in milliseconds.
 */
public suspend inline fun ConnectClient.searchUsers(crossinline block: SearchUsersRequest.Builder.() -> Unit): SearchUsersResponse = searchUsers(SearchUsersRequest.Builder().apply(block).build())

/**
 * Searches for vocabularies within a specific Amazon Connect instance using `State`, `NameStartsWith`, and `LanguageCode`.
 */
public suspend inline fun ConnectClient.searchVocabularies(crossinline block: SearchVocabulariesRequest.Builder.() -> Unit): SearchVocabulariesResponse = searchVocabularies(SearchVocabulariesRequest.Builder().apply(block).build())

/**
 * Processes chat integration events from Amazon Web Services or external integrations to Amazon Connect. A chat integration event includes:
 * + SourceId, DestinationId, and Subtype: a set of identifiers, uniquely representing a chat
 * +  ChatEvent: details of the chat action to perform such as sending a message, event, or disconnecting from a chat
 *
 * When a chat integration event is sent with chat identifiers that do not map to an active chat contact, a new chat contact is also created before handling chat action.
 *
 * Access to this API is currently restricted to Amazon Pinpoint for supporting SMS integration.
 */
public suspend inline fun ConnectClient.sendChatIntegrationEvent(crossinline block: SendChatIntegrationEventRequest.Builder.() -> Unit): SendChatIntegrationEventResponse = sendChatIntegrationEvent(SendChatIntegrationEventRequest.Builder().apply(block).build())

/**
 * Provides a pre-signed Amazon S3 URL in response for uploading your content.
 *
 * You may only use this API to upload attachments to a [Connect Case](https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html).
 */
public suspend inline fun ConnectClient.startAttachedFileUpload(crossinline block: StartAttachedFileUploadRequest.Builder.() -> Unit): StartAttachedFileUploadResponse = startAttachedFileUpload(StartAttachedFileUploadRequest.Builder().apply(block).build())

/**
 * Initiates a flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) API in the Amazon Connect Participant Service.
 *
 * When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) with WEBSOCKET and CONNECTION_CREDENTIALS.
 *
 * A 429 error occurs in the following situations:
 * + API rate limit is exceeded. API TPS throttling returns a `TooManyRequests` exception.
 * + The [quota for concurrent active chats](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) is exceeded. Active chat throttling returns a `LimitExceededException`.
 *
 * If you use the `ChatDurationInMinutes` parameter and receive a 400 error, your account may not support the ability to configure custom chat durations. For more information, contact Amazon Web Services Support.
 *
 * For more information about chat, see [Chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.startChatContact(crossinline block: StartChatContactRequest.Builder.() -> Unit): StartChatContactResponse = startChatContact(StartChatContactRequest.Builder().apply(block).build())

/**
 * Starts an empty evaluation in the specified Amazon Connect instance, using the given evaluation form for the particular contact. The evaluation form version used for the contact evaluation corresponds to the currently activated version. If no version is activated for the evaluation form, the contact evaluation cannot be started.
 *
 * Evaluations created through the public API do not contain answer values suggested from automation.
 */
public suspend inline fun ConnectClient.startContactEvaluation(crossinline block: StartContactEvaluationRequest.Builder.() -> Unit): StartContactEvaluationResponse = startContactEvaluation(StartContactEvaluationRequest.Builder().apply(block).build())

/**
 * Starts recording the contact:
 * + If the API is called *before* the agent joins the call, recording starts when the agent joins the call.
 * + If the API is called *after* the agent joins the call, recording starts at the time of the API call.
 *
 * StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.
 *
 * You can use this API to override the recording behavior configured in the [Set recording behavior](https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html) block.
 *
 * Only voice recordings are supported at this time.
 */
public suspend inline fun ConnectClient.startContactRecording(crossinline block: StartContactRecordingRequest.Builder.() -> Unit): StartContactRecordingResponse = startContactRecording(StartContactRecordingRequest.Builder().apply(block).build())

/**
 * Initiates real-time message streaming for a new chat contact.
 *
 *  For more information about message streaming, see [Enable real-time chat message streaming](https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.startContactStreaming(crossinline block: StartContactStreamingRequest.Builder.() -> Unit): StartContactStreamingResponse = startContactStreaming(StartContactStreamingRequest.Builder().apply(block).build())

/**
 * Places an outbound call to a contact, and then initiates the flow. It performs the actions in the flow that's specified (in `ContactFlowId`).
 *
 * Agents do not initiate the outbound API, which means that they do not dial the contact. If the flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.
 *
 * There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.
 *
 * UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
 *
 * Campaign calls are not allowed by default. Before you can make a call with `TrafficType` = `CAMPAIGN`, you must submit a service quota increase request to the quota [Amazon Connect campaigns](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#outbound-communications-quotas).
 */
public suspend inline fun ConnectClient.startOutboundVoiceContact(crossinline block: StartOutboundVoiceContactRequest.Builder.() -> Unit): StartOutboundVoiceContactResponse = startOutboundVoiceContact(StartOutboundVoiceContactRequest.Builder().apply(block).build())

/**
 * Initiates a flow to start a new task contact. For more information about task contacts, see [Concepts: Tasks in Amazon Connect](https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html) in the *Amazon Connect Administrator Guide*.
 *
 * When using `PreviousContactId` and `RelatedContactId` input parameters, note the following:
 * + `PreviousContactId`
 *    + Any updates to user-defined task contact attributes on any contact linked through the same `PreviousContactId` will affect every contact in the chain.
 *    + There can be a maximum of 12 linked task contacts in a chain. That is, 12 task contacts can be created that share the same `PreviousContactId`.
 * + `RelatedContactId`
 *    + Copies contact attributes from the related task contact to the new contact.
 *    + Any update on attributes in a new task contact does not update attributes on previous contact.
 *    + There’s no limit on the number of task contacts that can be created that use the same `RelatedContactId`.
 *
 * In addition, when calling StartTaskContact include only one of these parameters: `ContactFlowID`, `QuickConnectID`, or `TaskTemplateID`. Only one parameter is required as long as the task template has a flow configured to run it. If more than one parameter is specified, or only the `TaskTemplateID` is specified but it does not have a flow configured, the request returns an error because Amazon Connect cannot identify the unique flow to run when the task is created.
 *
 * A `ServiceQuotaExceededException` occurs when the number of open tasks exceeds the active tasks quota or there are already 12 tasks referencing the same `PreviousContactId`. For more information about service quotas for task contacts, see [Amazon Connect service quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.startTaskContact(crossinline block: StartTaskContactRequest.Builder.() -> Unit): StartTaskContactResponse = startTaskContact(StartTaskContactRequest.Builder().apply(block).build())

/**
 * Places an inbound in-app, web, or video call to a contact, and then initiates the flow. It performs the actions in the flow that are specified (in ContactFlowId) and present in the Amazon Connect instance (specified as InstanceId).
 */
public suspend inline fun ConnectClient.startWebRtcContact(crossinline block: StartWebRtcContactRequest.Builder.() -> Unit): StartWebRtcContactResponse = startWebRtcContact(StartWebRtcContactRequest.Builder().apply(block).build())

/**
 * Ends the specified contact. Use this API to stop queued callbacks. It does not work for voice contacts that use the following initiation methods:
 * + DISCONNECT
 * + TRANSFER
 * + QUEUE_TRANSFER
 *
 * Chat and task contacts can be terminated in any state, regardless of initiation method.
 */
public suspend inline fun ConnectClient.stopContact(crossinline block: StopContactRequest.Builder.() -> Unit): StopContactResponse = stopContact(StopContactRequest.Builder().apply(block).build())

/**
 * Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
 *
 * Only voice recordings are supported at this time.
 */
public suspend inline fun ConnectClient.stopContactRecording(crossinline block: StopContactRecordingRequest.Builder.() -> Unit): StopContactRecordingResponse = stopContactRecording(StopContactRecordingRequest.Builder().apply(block).build())

/**
 * Ends message streaming on a specified contact. To restart message streaming on that contact, call the [StartContactStreaming](https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html) API.
 */
public suspend inline fun ConnectClient.stopContactStreaming(crossinline block: StopContactStreamingRequest.Builder.() -> Unit): StopContactStreamingResponse = stopContactStreaming(StopContactStreamingRequest.Builder().apply(block).build())

/**
 * Submits a contact evaluation in the specified Amazon Connect instance. Answers included in the request are merged with existing answers for the given evaluation. If no answers or notes are passed, the evaluation is submitted with the existing answers and notes. You can delete an answer or note by passing an empty object (`{}`) to the question identifier.
 *
 * If a contact evaluation is already in submitted state, this operation will trigger a resubmission.
 */
public suspend inline fun ConnectClient.submitContactEvaluation(crossinline block: SubmitContactEvaluationRequest.Builder.() -> Unit): SubmitContactEvaluationResponse = submitContactEvaluation(SubmitContactEvaluationRequest.Builder().apply(block).build())

/**
 * When a contact is being recorded, this API suspends recording whatever is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would be suspended. For example, you might suspend the screen recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording the screen.
 *
 * The period of time that the recording is suspended is filled with silence in the final recording.
 *
 * Voice and screen recordings are supported.
 */
public suspend inline fun ConnectClient.suspendContactRecording(crossinline block: SuspendContactRecordingRequest.Builder.() -> Unit): SuspendContactRecordingResponse = suspendContactRecording(SuspendContactRecordingRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the contact resource. For more information about this API is used, see [Set up granular billing for a detailed view of your Amazon Connect usage](https://docs.aws.amazon.com/connect/latest/adminguide/granular-billing.html).
 */
public suspend inline fun ConnectClient.tagContact(crossinline block: TagContactRequest.Builder.() -> Unit): TagContactResponse = tagContact(TagContactRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified resource.
 *
 * Some of the supported resource types are agents, routing profiles, queues, quick connects, contact flows, agent statuses, hours of operation, phone numbers, security profiles, and task templates. For a complete list, see [Tagging resources in Amazon Connect](https://docs.aws.amazon.com/connect/latest/adminguide/tagging.html).
 *
 * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Transfers contacts from one agent or queue to another agent or queue at any point after a contact is created. You can transfer a contact to another queue by providing the flow which orchestrates the contact to the destination queue. This gives you more control over contact handling and helps you adhere to the service level agreement (SLA) guaranteed to your customers.
 *
 * Note the following requirements:
 * + Transfer is supported for only `TASK` contacts.
 * + Do not use both `QueueId` and `UserId` in the same call.
 * + The following flow types are supported: Inbound flow, Transfer to agent flow, and Transfer to queue flow.
 * + The `TransferContact` API can be called only on active contacts.
 * + A contact cannot be transferred more than 11 times.
 */
public suspend inline fun ConnectClient.transferContact(crossinline block: TransferContactRequest.Builder.() -> Unit): TransferContactResponse = transferContact(TransferContactRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the contact resource. For more information about this API is used, see [Set up granular billing for a detailed view of your Amazon Connect usage](https://docs.aws.amazon.com/connect/latest/adminguide/granular-billing.html).
 */
public suspend inline fun ConnectClient.untagContact(crossinline block: UntagContactRequest.Builder.() -> Unit): UntagContactResponse = untagContact(UntagContactRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified resource.
 */
public suspend inline fun ConnectClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates agent status.
 */
public suspend inline fun ConnectClient.updateAgentStatus(crossinline block: UpdateAgentStatusRequest.Builder.() -> Unit): UpdateAgentStatusResponse = updateAgentStatus(UpdateAgentStatusRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.
 *
 * You can add or update user-defined contact information for both ongoing and completed contacts.
 */
public suspend inline fun ConnectClient.updateContact(crossinline block: UpdateContactRequest.Builder.() -> Unit): UpdateContactResponse = updateContact(UpdateContactRequest.Builder().apply(block).build())

/**
 * Creates or updates user-defined contact attributes associated with the specified contact.
 *
 * You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer's name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.
 *
 * Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about contact record retention and the maximum size of the contact record attributes section, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.updateContactAttributes(crossinline block: UpdateContactAttributesRequest.Builder.() -> Unit): UpdateContactAttributesResponse = updateContactAttributes(UpdateContactAttributesRequest.Builder().apply(block).build())

/**
 * Updates details about a contact evaluation in the specified Amazon Connect instance. A contact evaluation must be in draft state. Answers included in the request are merged with existing answers for the given evaluation. An answer or note can be deleted by passing an empty object (`{}`) to the question identifier.
 */
public suspend inline fun ConnectClient.updateContactEvaluation(crossinline block: UpdateContactEvaluationRequest.Builder.() -> Unit): UpdateContactEvaluationResponse = updateContactEvaluation(UpdateContactEvaluationRequest.Builder().apply(block).build())

/**
 * Updates the specified flow.
 *
 * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
 *
 * Use the `$SAVED` alias in the request to describe the `SAVED` content of a Flow. For example, `arn:aws:.../contact-flow/{id}:$SAVED`. Once a contact flow is published, `$SAVED` needs to be supplied to view saved content that has not been published.
 */
public suspend inline fun ConnectClient.updateContactFlowContent(crossinline block: UpdateContactFlowContentRequest.Builder.() -> Unit): UpdateContactFlowContentResponse = updateContactFlowContent(UpdateContactFlowContentRequest.Builder().apply(block).build())

/**
 * Updates metadata about specified flow.
 */
public suspend inline fun ConnectClient.updateContactFlowMetadata(crossinline block: UpdateContactFlowMetadataRequest.Builder.() -> Unit): UpdateContactFlowMetadataResponse = updateContactFlowMetadata(UpdateContactFlowMetadataRequest.Builder().apply(block).build())

/**
 * Updates specified flow module for the specified Amazon Connect instance.
 *
 * Use the `$SAVED` alias in the request to describe the `SAVED` content of a Flow. For example, `arn:aws:.../contact-flow/{id}:$SAVED`. Once a contact flow is published, `$SAVED` needs to be supplied to view saved content that has not been published.
 */
public suspend inline fun ConnectClient.updateContactFlowModuleContent(crossinline block: UpdateContactFlowModuleContentRequest.Builder.() -> Unit): UpdateContactFlowModuleContentResponse = updateContactFlowModuleContent(UpdateContactFlowModuleContentRequest.Builder().apply(block).build())

/**
 * Updates metadata about specified flow module.
 */
public suspend inline fun ConnectClient.updateContactFlowModuleMetadata(crossinline block: UpdateContactFlowModuleMetadataRequest.Builder.() -> Unit): UpdateContactFlowModuleMetadataResponse = updateContactFlowModuleMetadata(UpdateContactFlowModuleMetadataRequest.Builder().apply(block).build())

/**
 * The name of the flow.
 *
 * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
 */
public suspend inline fun ConnectClient.updateContactFlowName(crossinline block: UpdateContactFlowNameRequest.Builder.() -> Unit): UpdateContactFlowNameResponse = updateContactFlowName(UpdateContactFlowNameRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates routing priority and age on the contact (**QueuePriority** and **QueueTimeAdjustmentInSeconds**). These properties can be used to change a customer's position in the queue. For example, you can move a contact to the back of the queue by setting a lower routing priority relative to other contacts in queue; or you can move a contact to the front of the queue by increasing the routing age which will make the contact look artificially older and therefore higher up in the first-in-first-out routing order. Note that adjusting the routing age of a contact affects only its position in queue, and not its actual queue wait time as reported through metrics. These properties can also be updated by using [the Set routing priority / age flow block](https://docs.aws.amazon.com/connect/latest/adminguide/change-routing-priority.html).
 */
public suspend inline fun ConnectClient.updateContactRoutingData(crossinline block: UpdateContactRoutingDataRequest.Builder.() -> Unit): UpdateContactRoutingDataResponse = updateContactRoutingData(UpdateContactRoutingDataRequest.Builder().apply(block).build())

/**
 * Updates the scheduled time of a task contact that is already scheduled.
 */
public suspend inline fun ConnectClient.updateContactSchedule(crossinline block: UpdateContactScheduleRequest.Builder.() -> Unit): UpdateContactScheduleResponse = updateContactSchedule(UpdateContactScheduleRequest.Builder().apply(block).build())

/**
 * Updates details about a specific evaluation form version in the specified Amazon Connect instance. Question and section identifiers cannot be duplicated within the same evaluation form.
 *
 * This operation does not support partial updates. Instead it does a full update of evaluation form content.
 */
public suspend inline fun ConnectClient.updateEvaluationForm(crossinline block: UpdateEvaluationFormRequest.Builder.() -> Unit): UpdateEvaluationFormResponse = updateEvaluationForm(UpdateEvaluationFormRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates the hours of operation.
 */
public suspend inline fun ConnectClient.updateHoursOfOperation(crossinline block: UpdateHoursOfOperationRequest.Builder.() -> Unit): UpdateHoursOfOperationResponse = updateHoursOfOperation(UpdateHoursOfOperationRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates the value for the specified attribute type.
 */
public suspend inline fun ConnectClient.updateInstanceAttribute(crossinline block: UpdateInstanceAttributeRequest.Builder.() -> Unit): UpdateInstanceAttributeResponse = updateInstanceAttribute(UpdateInstanceAttributeRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates an existing configuration for a resource type. This API is idempotent.
 */
public suspend inline fun ConnectClient.updateInstanceStorageConfig(crossinline block: UpdateInstanceStorageConfigRequest.Builder.() -> Unit): UpdateInstanceStorageConfigResponse = updateInstanceStorageConfig(UpdateInstanceStorageConfigRequest.Builder().apply(block).build())

/**
 * Updates timeouts for when human chat participants are to be considered idle, and when agents are automatically disconnected from a chat due to idleness. You can set four timers:
 * + Customer idle timeout
 * + Customer auto-disconnect timeout
 * + Agent idle timeout
 * + Agent auto-disconnect timeout
 *
 * For more information about how chat timeouts work, see [Set up chat timeouts for human participants](https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html).
 */
public suspend inline fun ConnectClient.updateParticipantRoleConfig(crossinline block: UpdateParticipantRoleConfigRequest.Builder.() -> Unit): UpdateParticipantRoleConfigResponse = updateParticipantRoleConfig(UpdateParticipantRoleConfigRequest.Builder().apply(block).build())

/**
 * Updates your claimed phone number from its current Amazon Connect instance or traffic distribution group to another Amazon Connect instance or traffic distribution group in the same Amazon Web Services Region.
 *
 * After using this API, you must verify that the phone number is attached to the correct flow in the target instance or traffic distribution group. You need to do this because the API switches only the phone number to a new instance or traffic distribution group. It doesn't migrate the flow configuration of the phone number, too.
 *
 * You can call [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API to verify the status of a previous [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation.
 */
public suspend inline fun ConnectClient.updatePhoneNumber(crossinline block: UpdatePhoneNumberRequest.Builder.() -> Unit): UpdatePhoneNumberResponse = updatePhoneNumber(UpdatePhoneNumberRequest.Builder().apply(block).build())

/**
 * Updates a phone number’s metadata.
 *
 * To verify the status of a previous UpdatePhoneNumberMetadata operation, call the [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API.
 */
public suspend inline fun ConnectClient.updatePhoneNumberMetadata(crossinline block: UpdatePhoneNumberMetadataRequest.Builder.() -> Unit): UpdatePhoneNumberMetadataResponse = updatePhoneNumberMetadata(UpdatePhoneNumberMetadataRequest.Builder().apply(block).build())

/**
 * Updates a predefined attribute for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectClient.updatePredefinedAttribute(crossinline block: UpdatePredefinedAttributeRequest.Builder.() -> Unit): UpdatePredefinedAttributeResponse = updatePredefinedAttribute(UpdatePredefinedAttributeRequest.Builder().apply(block).build())

/**
 * Updates a prompt.
 */
public suspend inline fun ConnectClient.updatePrompt(crossinline block: UpdatePromptRequest.Builder.() -> Unit): UpdatePromptResponse = updatePrompt(UpdatePromptRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates the hours of operation for the specified queue.
 */
public suspend inline fun ConnectClient.updateQueueHoursOfOperation(crossinline block: UpdateQueueHoursOfOperationRequest.Builder.() -> Unit): UpdateQueueHoursOfOperationResponse = updateQueueHoursOfOperation(UpdateQueueHoursOfOperationRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates the maximum number of contacts allowed in a queue before it is considered full.
 */
public suspend inline fun ConnectClient.updateQueueMaxContacts(crossinline block: UpdateQueueMaxContactsRequest.Builder.() -> Unit): UpdateQueueMaxContactsResponse = updateQueueMaxContacts(UpdateQueueMaxContactsRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates the name and description of a queue. At least `Name` or `Description` must be provided.
 */
public suspend inline fun ConnectClient.updateQueueName(crossinline block: UpdateQueueNameRequest.Builder.() -> Unit): UpdateQueueNameResponse = updateQueueName(UpdateQueueNameRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.
 *
 * + If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for `OutboundCallerIdNumberId`. However, if the phone number is claimed to a traffic distribution group that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
 * + Only use the phone number ARN format that doesn't contain `instance` in the path, for example, `arn:aws:connect:us-east-1:1234567890:phone-number/uuid`. This is the same ARN format that is returned when you call the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API.
 * + If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic distribution group, see [Allow or Deny queue API actions for phone numbers in a replica Region](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region).
 */
public suspend inline fun ConnectClient.updateQueueOutboundCallerConfig(crossinline block: UpdateQueueOutboundCallerConfigRequest.Builder.() -> Unit): UpdateQueueOutboundCallerConfigResponse = updateQueueOutboundCallerConfig(UpdateQueueOutboundCallerConfigRequest.Builder().apply(block).build())

/**
 * This API is in preview release for Amazon Connect and is subject to change.
 *
 * Updates the status of the queue.
 */
public suspend inline fun ConnectClient.updateQueueStatus(crossinline block: UpdateQueueStatusRequest.Builder.() -> Unit): UpdateQueueStatusResponse = updateQueueStatus(UpdateQueueStatusRequest.Builder().apply(block).build())

/**
 * Updates the configuration settings for the specified quick connect.
 */
public suspend inline fun ConnectClient.updateQuickConnectConfig(crossinline block: UpdateQuickConnectConfigRequest.Builder.() -> Unit): UpdateQuickConnectConfigResponse = updateQuickConnectConfig(UpdateQuickConnectConfigRequest.Builder().apply(block).build())

/**
 * Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
 */
public suspend inline fun ConnectClient.updateQuickConnectName(crossinline block: UpdateQuickConnectNameRequest.Builder.() -> Unit): UpdateQuickConnectNameResponse = updateQuickConnectName(UpdateQuickConnectNameRequest.Builder().apply(block).build())

/**
 * Whether agents with this routing profile will have their routing order calculated based on *time since their last inbound contact* or *longest idle time*.
 */
public suspend inline fun ConnectClient.updateRoutingProfileAgentAvailabilityTimer(crossinline block: UpdateRoutingProfileAgentAvailabilityTimerRequest.Builder.() -> Unit): UpdateRoutingProfileAgentAvailabilityTimerResponse = updateRoutingProfileAgentAvailabilityTimer(UpdateRoutingProfileAgentAvailabilityTimerRequest.Builder().apply(block).build())

/**
 * Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
 */
public suspend inline fun ConnectClient.updateRoutingProfileConcurrency(crossinline block: UpdateRoutingProfileConcurrencyRequest.Builder.() -> Unit): UpdateRoutingProfileConcurrencyResponse = updateRoutingProfileConcurrency(UpdateRoutingProfileConcurrencyRequest.Builder().apply(block).build())

/**
 * Updates the default outbound queue of a routing profile.
 */
public suspend inline fun ConnectClient.updateRoutingProfileDefaultOutboundQueue(crossinline block: UpdateRoutingProfileDefaultOutboundQueueRequest.Builder.() -> Unit): UpdateRoutingProfileDefaultOutboundQueueResponse = updateRoutingProfileDefaultOutboundQueue(UpdateRoutingProfileDefaultOutboundQueueRequest.Builder().apply(block).build())

/**
 * Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
 */
public suspend inline fun ConnectClient.updateRoutingProfileName(crossinline block: UpdateRoutingProfileNameRequest.Builder.() -> Unit): UpdateRoutingProfileNameResponse = updateRoutingProfileName(UpdateRoutingProfileNameRequest.Builder().apply(block).build())

/**
 * Updates the properties associated with a set of queues for a routing profile.
 */
public suspend inline fun ConnectClient.updateRoutingProfileQueues(crossinline block: UpdateRoutingProfileQueuesRequest.Builder.() -> Unit): UpdateRoutingProfileQueuesResponse = updateRoutingProfileQueues(UpdateRoutingProfileQueuesRequest.Builder().apply(block).build())

/**
 * Updates a rule for the specified Amazon Connect instance.
 *
 * Use the [Rules Function language](https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html) to code conditions for the rule.
 */
public suspend inline fun ConnectClient.updateRule(crossinline block: UpdateRuleRequest.Builder.() -> Unit): UpdateRuleResponse = updateRule(UpdateRuleRequest.Builder().apply(block).build())

/**
 * Updates a security profile.
 */
public suspend inline fun ConnectClient.updateSecurityProfile(crossinline block: UpdateSecurityProfileRequest.Builder.() -> Unit): UpdateSecurityProfileResponse = updateSecurityProfile(UpdateSecurityProfileRequest.Builder().apply(block).build())

/**
 * Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.
 */
public suspend inline fun ConnectClient.updateTaskTemplate(crossinline block: UpdateTaskTemplateRequest.Builder.() -> Unit): UpdateTaskTemplateResponse = updateTaskTemplate(UpdateTaskTemplateRequest.Builder().apply(block).build())

/**
 * Updates the traffic distribution for a given traffic distribution group.
 *
 * The `SignInConfig` distribution is available only on a default `TrafficDistributionGroup` (see the `IsDefault` parameter in the [TrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html) data type). If you call `UpdateTrafficDistribution` with a modified `SignInConfig` and a non-default `TrafficDistributionGroup`, an `InvalidRequestException` is returned.
 *
 * For more information about updating a traffic distribution group, see [Update telephony traffic distribution across Amazon Web Services Regions ](https://docs.aws.amazon.com/connect/latest/adminguide/update-telephony-traffic-distribution.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.updateTrafficDistribution(crossinline block: UpdateTrafficDistributionRequest.Builder.() -> Unit): UpdateTrafficDistributionResponse = updateTrafficDistribution(UpdateTrafficDistributionRequest.Builder().apply(block).build())

/**
 * Assigns the specified hierarchy group to the specified user.
 */
public suspend inline fun ConnectClient.updateUserHierarchy(crossinline block: UpdateUserHierarchyRequest.Builder.() -> Unit): UpdateUserHierarchyResponse = updateUserHierarchy(UpdateUserHierarchyRequest.Builder().apply(block).build())

/**
 * Updates the name of the user hierarchy group.
 */
public suspend inline fun ConnectClient.updateUserHierarchyGroupName(crossinline block: UpdateUserHierarchyGroupNameRequest.Builder.() -> Unit): UpdateUserHierarchyGroupNameResponse = updateUserHierarchyGroupName(UpdateUserHierarchyGroupNameRequest.Builder().apply(block).build())

/**
 * Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
 */
public suspend inline fun ConnectClient.updateUserHierarchyStructure(crossinline block: UpdateUserHierarchyStructureRequest.Builder.() -> Unit): UpdateUserHierarchyStructureResponse = updateUserHierarchyStructure(UpdateUserHierarchyStructureRequest.Builder().apply(block).build())

/**
 * Updates the identity information for the specified user.
 *
 * We strongly recommend limiting who has the ability to invoke `UpdateUserIdentityInfo`. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker's email address, and then reset the password through email. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun ConnectClient.updateUserIdentityInfo(crossinline block: UpdateUserIdentityInfoRequest.Builder.() -> Unit): UpdateUserIdentityInfoResponse = updateUserIdentityInfo(UpdateUserIdentityInfoRequest.Builder().apply(block).build())

/**
 * Updates the phone configuration settings for the specified user.
 */
public suspend inline fun ConnectClient.updateUserPhoneConfig(crossinline block: UpdateUserPhoneConfigRequest.Builder.() -> Unit): UpdateUserPhoneConfigResponse = updateUserPhoneConfig(UpdateUserPhoneConfigRequest.Builder().apply(block).build())

/**
 * Updates the properties associated with the proficiencies of a user.
 */
public suspend inline fun ConnectClient.updateUserProficiencies(crossinline block: UpdateUserProficienciesRequest.Builder.() -> Unit): UpdateUserProficienciesResponse = updateUserProficiencies(UpdateUserProficienciesRequest.Builder().apply(block).build())

/**
 * Assigns the specified routing profile to the specified user.
 */
public suspend inline fun ConnectClient.updateUserRoutingProfile(crossinline block: UpdateUserRoutingProfileRequest.Builder.() -> Unit): UpdateUserRoutingProfileResponse = updateUserRoutingProfile(UpdateUserRoutingProfileRequest.Builder().apply(block).build())

/**
 * Assigns the specified security profiles to the specified user.
 */
public suspend inline fun ConnectClient.updateUserSecurityProfiles(crossinline block: UpdateUserSecurityProfilesRequest.Builder.() -> Unit): UpdateUserSecurityProfilesResponse = updateUserSecurityProfiles(UpdateUserSecurityProfilesRequest.Builder().apply(block).build())

/**
 * Updates the view content of the given view identifier in the specified Amazon Connect instance.
 *
 * It performs content validation if `Status` is set to `SAVED` and performs full content validation if `Status` is `PUBLISHED`. Note that the `$SAVED` alias' content will always be updated, but the `$LATEST` alias' content will only be updated if `Status` is `PUBLISHED`.
 */
public suspend inline fun ConnectClient.updateViewContent(crossinline block: UpdateViewContentRequest.Builder.() -> Unit): UpdateViewContentResponse = updateViewContent(UpdateViewContentRequest.Builder().apply(block).build())

/**
 * Updates the view metadata. Note that either `Name` or `Description` must be provided.
 */
public suspend inline fun ConnectClient.updateViewMetadata(crossinline block: UpdateViewMetadataRequest.Builder.() -> Unit): UpdateViewMetadataResponse = updateViewMetadata(UpdateViewMetadataRequest.Builder().apply(block).build())
