// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A view resource object. Contains metadata and content necessary to render the view.
 */
public class View private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the view.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * View content containing all content necessary to render a view except for runtime input data.
     */
    public val content: aws.sdk.kotlin.services.connect.model.ViewContent? = builder.content
    /**
     * The timestamp of when the view was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description of the view.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the view.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Latest timestamp of the `UpdateViewContent` or `CreateViewVersion` operations.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the view.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates the view status as either `SAVED` or `PUBLISHED`. The `PUBLISHED` status will initiate validation on the content.
     */
    public val status: aws.sdk.kotlin.services.connect.model.ViewStatus? = builder.status
    /**
     * The tags associated with the view resource (not specific to view version).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of the view - `CUSTOMER_MANAGED`.
     */
    public val type: aws.sdk.kotlin.services.connect.model.ViewType? = builder.type
    /**
     * Current version of the view.
     */
    public val version: kotlin.Int = builder.version
    /**
     * The description of the version.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription
    /**
     * Indicates the checksum value of the latest published view content.
     */
    public val viewContentSha256: kotlin.String? = builder.viewContentSha256

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.View = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("View(")
        append("arn=$arn,")
        append("content=$content,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version,")
        append("versionDescription=$versionDescription,")
        append("viewContentSha256=$viewContentSha256")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        result = 31 * result + (viewContentSha256?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as View

        if (arn != other.arn) return false
        if (content != other.content) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false
        if (versionDescription != other.versionDescription) return false
        if (viewContentSha256 != other.viewContentSha256) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.View = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the view.
         */
        public var arn: kotlin.String? = null
        /**
         * View content containing all content necessary to render a view except for runtime input data.
         */
        public var content: aws.sdk.kotlin.services.connect.model.ViewContent? = null
        /**
         * The timestamp of when the view was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the view.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the view.
         */
        public var id: kotlin.String? = null
        /**
         * Latest timestamp of the `UpdateViewContent` or `CreateViewVersion` operations.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the view.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates the view status as either `SAVED` or `PUBLISHED`. The `PUBLISHED` status will initiate validation on the content.
         */
        public var status: aws.sdk.kotlin.services.connect.model.ViewStatus? = null
        /**
         * The tags associated with the view resource (not specific to view version).
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of the view - `CUSTOMER_MANAGED`.
         */
        public var type: aws.sdk.kotlin.services.connect.model.ViewType? = null
        /**
         * Current version of the view.
         */
        public var version: kotlin.Int = 0
        /**
         * The description of the version.
         */
        public var versionDescription: kotlin.String? = null
        /**
         * Indicates the checksum value of the latest published view content.
         */
        public var viewContentSha256: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.View) : this() {
            this.arn = x.arn
            this.content = x.content
            this.createdTime = x.createdTime
            this.description = x.description
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
            this.versionDescription = x.versionDescription
            this.viewContentSha256 = x.viewContentSha256
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.View = View(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ViewContent] inside the given [block]
         */
        public fun content(block: aws.sdk.kotlin.services.connect.model.ViewContent.Builder.() -> kotlin.Unit) {
            this.content = aws.sdk.kotlin.services.connect.model.ViewContent.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
