// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains configuration settings for a quick connect.
 */
public class QuickConnectConfig private constructor(builder: Builder) {
    /**
     * The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
     */
    public val phoneConfig: aws.sdk.kotlin.services.connect.model.PhoneNumberQuickConnectConfig? = builder.phoneConfig
    /**
     * The queue configuration. This is required only if QuickConnectType is QUEUE.
     */
    public val queueConfig: aws.sdk.kotlin.services.connect.model.QueueQuickConnectConfig? = builder.queueConfig
    /**
     * The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     */
    public val quickConnectType: aws.sdk.kotlin.services.connect.model.QuickConnectType = requireNotNull(builder.quickConnectType) { "A non-null value must be provided for quickConnectType" }
    /**
     * The user configuration. This is required only if QuickConnectType is USER.
     */
    public val userConfig: aws.sdk.kotlin.services.connect.model.UserQuickConnectConfig? = builder.userConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.QuickConnectConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuickConnectConfig(")
        append("phoneConfig=$phoneConfig,")
        append("queueConfig=$queueConfig,")
        append("quickConnectType=$quickConnectType,")
        append("userConfig=$userConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = phoneConfig?.hashCode() ?: 0
        result = 31 * result + (queueConfig?.hashCode() ?: 0)
        result = 31 * result + (quickConnectType.hashCode())
        result = 31 * result + (userConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuickConnectConfig

        if (phoneConfig != other.phoneConfig) return false
        if (queueConfig != other.queueConfig) return false
        if (quickConnectType != other.quickConnectType) return false
        if (userConfig != other.userConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.QuickConnectConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
         */
        public var phoneConfig: aws.sdk.kotlin.services.connect.model.PhoneNumberQuickConnectConfig? = null
        /**
         * The queue configuration. This is required only if QuickConnectType is QUEUE.
         */
        public var queueConfig: aws.sdk.kotlin.services.connect.model.QueueQuickConnectConfig? = null
        /**
         * The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
         */
        public var quickConnectType: aws.sdk.kotlin.services.connect.model.QuickConnectType? = null
        /**
         * The user configuration. This is required only if QuickConnectType is USER.
         */
        public var userConfig: aws.sdk.kotlin.services.connect.model.UserQuickConnectConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.QuickConnectConfig) : this() {
            this.phoneConfig = x.phoneConfig
            this.queueConfig = x.queueConfig
            this.quickConnectType = x.quickConnectType
            this.userConfig = x.userConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.QuickConnectConfig = QuickConnectConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.PhoneNumberQuickConnectConfig] inside the given [block]
         */
        public fun phoneConfig(block: aws.sdk.kotlin.services.connect.model.PhoneNumberQuickConnectConfig.Builder.() -> kotlin.Unit) {
            this.phoneConfig = aws.sdk.kotlin.services.connect.model.PhoneNumberQuickConnectConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.QueueQuickConnectConfig] inside the given [block]
         */
        public fun queueConfig(block: aws.sdk.kotlin.services.connect.model.QueueQuickConnectConfig.Builder.() -> kotlin.Unit) {
            this.queueConfig = aws.sdk.kotlin.services.connect.model.QueueQuickConnectConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserQuickConnectConfig] inside the given [block]
         */
        public fun userConfig(block: aws.sdk.kotlin.services.connect.model.UserQuickConnectConfig.Builder.() -> kotlin.Unit) {
            this.userConfig = aws.sdk.kotlin.services.connect.model.UserQuickConnectConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (quickConnectType == null) quickConnectType = QuickConnectType.SdkUnknown("no value provided")
            return this
        }
    }
}
