// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * The status of the phone number.
 * + `CLAIMED` means the previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) or [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation succeeded.
 * + `IN_PROGRESS` means a [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html), [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html), or [UpdatePhoneNumberMetadata](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumberMetadata.html) operation is still in progress and has not yet completed. You can call [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) at a later time to verify if the previous operation has completed.
 * + `FAILED` indicates that the previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) or [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation has failed. It will include a message indicating the failure reason. A common reason for a failure may be that the `TargetArn` value you are claiming or updating a phone number to has reached its limit of total claimed numbers. If you received a `FAILED` status from a `ClaimPhoneNumber` API call, you have one day to retry claiming the phone number before the number is released back to the inventory for other customers to claim.
 */
public class PhoneNumberStatus private constructor(builder: Builder) {
    /**
     * The status message.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The status.
     */
    public val status: aws.sdk.kotlin.services.connect.model.PhoneNumberWorkflowStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.PhoneNumberStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PhoneNumberStatus(")
        append("message=$message,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PhoneNumberStatus

        if (message != other.message) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.PhoneNumberStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status message.
         */
        public var message: kotlin.String? = null
        /**
         * The status.
         */
        public var status: aws.sdk.kotlin.services.connect.model.PhoneNumberWorkflowStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.PhoneNumberStatus) : this() {
            this.message = x.message
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.PhoneNumberStatus = PhoneNumberStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
