// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains information about the filter used when retrieving metrics. `MetricFiltersV2` can be used on the following metrics: `AVG_AGENT_CONNECTING_TIME`, `CONTACTS_CREATED`, `CONTACTS_HANDLED`, `SUM_CONTACTS_DISCONNECTED`.
 */
public class MetricFilterV2 private constructor(builder: Builder) {
    /**
     * The key to use for filtering data.
     *
     * Valid metric filter keys: `INITIATION_METHOD`, `DISCONNECT_REASON`. These are the same values as the `InitiationMethod` and `DisconnectReason` in the contact record. For more information, see [ContactTraceRecord](https://docs.aws.amazon.com/connect/latest/adminguide/ctr-data-model.html#ctr-ContactTraceRecord) in the *Amazon Connect Administrator's Guide*.
     */
    public val metricFilterKey: kotlin.String? = builder.metricFilterKey
    /**
     * The values to use for filtering data.
     *
     * Valid metric filter values for `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` | `TRANSFER` | `QUEUE_TRANSFER` | `CALLBACK` | `API`
     *
     * Valid metric filter values for `DISCONNECT_REASON`: `CUSTOMER_DISCONNECT` | `AGENT_DISCONNECT` | `THIRD_PARTY_DISCONNECT` | `TELECOM_PROBLEM` | `BARGED` | `CONTACT_FLOW_DISCONNECT` | `OTHER` | `EXPIRED` | `API`
     */
    public val metricFilterValues: List<String>? = builder.metricFilterValues
    /**
     * The flag to use to filter on requested metric filter values or to not filter on requested metric filter values. By default the negate is `false`, which indicates to filter on the requested metric filter.
     */
    public val negate: kotlin.Boolean = builder.negate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.MetricFilterV2 = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricFilterV2(")
        append("metricFilterKey=$metricFilterKey,")
        append("metricFilterValues=$metricFilterValues,")
        append("negate=$negate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricFilterKey?.hashCode() ?: 0
        result = 31 * result + (metricFilterValues?.hashCode() ?: 0)
        result = 31 * result + (negate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricFilterV2

        if (metricFilterKey != other.metricFilterKey) return false
        if (metricFilterValues != other.metricFilterValues) return false
        if (negate != other.negate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.MetricFilterV2 = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The key to use for filtering data.
         *
         * Valid metric filter keys: `INITIATION_METHOD`, `DISCONNECT_REASON`. These are the same values as the `InitiationMethod` and `DisconnectReason` in the contact record. For more information, see [ContactTraceRecord](https://docs.aws.amazon.com/connect/latest/adminguide/ctr-data-model.html#ctr-ContactTraceRecord) in the *Amazon Connect Administrator's Guide*.
         */
        public var metricFilterKey: kotlin.String? = null
        /**
         * The values to use for filtering data.
         *
         * Valid metric filter values for `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` | `TRANSFER` | `QUEUE_TRANSFER` | `CALLBACK` | `API`
         *
         * Valid metric filter values for `DISCONNECT_REASON`: `CUSTOMER_DISCONNECT` | `AGENT_DISCONNECT` | `THIRD_PARTY_DISCONNECT` | `TELECOM_PROBLEM` | `BARGED` | `CONTACT_FLOW_DISCONNECT` | `OTHER` | `EXPIRED` | `API`
         */
        public var metricFilterValues: List<String>? = null
        /**
         * The flag to use to filter on requested metric filter values or to not filter on requested metric filter values. By default the negate is `false`, which indicates to filter on the requested metric filter.
         */
        public var negate: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.MetricFilterV2) : this() {
            this.metricFilterKey = x.metricFilterKey
            this.metricFilterValues = x.metricFilterValues
            this.negate = x.negate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.MetricFilterV2 = MetricFilterV2(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
