// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetTaskTemplateResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN).
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Constraints that are applicable to the fields listed.
     */
    public val constraints: aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints? = builder.constraints
    /**
     * The identifier of the flow that runs by default when a task is created by referencing this template.
     */
    public val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * The timestamp when the task template was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The default values for fields when a task is created by referencing this template.
     */
    public val defaults: aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults? = builder.defaults
    /**
     * The description of the task template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Fields that are part of the template.
     */
    public val fields: List<TaskTemplateField>? = builder.fields
    /**
     * A unique identifier for the task template.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The timestamp when the task template was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the task template.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it. Tasks can only be created from `ACTIVE` templates. If a template is marked as `INACTIVE`, then a task that refers to this template cannot be created.
     */
    public val status: aws.sdk.kotlin.services.connect.model.TaskTemplateStatus? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.GetTaskTemplateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetTaskTemplateResponse(")
        append("arn=$arn,")
        append("constraints=$constraints,")
        append("contactFlowId=$contactFlowId,")
        append("createdTime=$createdTime,")
        append("defaults=$defaults,")
        append("description=$description,")
        append("fields=$fields,")
        append("id=$id,")
        append("instanceId=$instanceId,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (constraints?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (defaults?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetTaskTemplateResponse

        if (arn != other.arn) return false
        if (constraints != other.constraints) return false
        if (contactFlowId != other.contactFlowId) return false
        if (createdTime != other.createdTime) return false
        if (defaults != other.defaults) return false
        if (description != other.description) return false
        if (fields != other.fields) return false
        if (id != other.id) return false
        if (instanceId != other.instanceId) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.GetTaskTemplateResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN).
         */
        public var arn: kotlin.String? = null
        /**
         * Constraints that are applicable to the fields listed.
         */
        public var constraints: aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints? = null
        /**
         * The identifier of the flow that runs by default when a task is created by referencing this template.
         */
        public var contactFlowId: kotlin.String? = null
        /**
         * The timestamp when the task template was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The default values for fields when a task is created by referencing this template.
         */
        public var defaults: aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults? = null
        /**
         * The description of the task template.
         */
        public var description: kotlin.String? = null
        /**
         * Fields that are part of the template.
         */
        public var fields: List<TaskTemplateField>? = null
        /**
         * A unique identifier for the task template.
         */
        public var id: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The timestamp when the task template was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the task template.
         */
        public var name: kotlin.String? = null
        /**
         * Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it. Tasks can only be created from `ACTIVE` templates. If a template is marked as `INACTIVE`, then a task that refers to this template cannot be created.
         */
        public var status: aws.sdk.kotlin.services.connect.model.TaskTemplateStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.GetTaskTemplateResponse) : this() {
            this.arn = x.arn
            this.constraints = x.constraints
            this.contactFlowId = x.contactFlowId
            this.createdTime = x.createdTime
            this.defaults = x.defaults
            this.description = x.description
            this.fields = x.fields
            this.id = x.id
            this.instanceId = x.instanceId
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.GetTaskTemplateResponse = GetTaskTemplateResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints] inside the given [block]
         */
        public fun constraints(block: aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints.Builder.() -> kotlin.Unit) {
            this.constraints = aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults] inside the given [block]
         */
        public fun defaults(block: aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults.Builder.() -> kotlin.Unit) {
            this.defaults = aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
