// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMetricDataV2Request private constructor(builder: Builder) {
    /**
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be later than the start time timestamp. It cannot be later than the current timestamp.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The filters to apply to returned metrics. You can filter on the following resources:
     * + Queues
     * + Routing profiles
     * + Agents
     * + Channels
     * + User hierarchy groups
     * + Feature
     *
     * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     *
     * To filter by phone number, see [Create a historical metrics report](https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html) in the *Amazon Connect Administrator's Guide*.
     *
     * Note the following limits:
     * + **Filter keys**: A maximum of 5 filter keys are supported in a single request. Valid filter keys: `QUEUE` | `ROUTING_PROFILE` | `AGENT` | `CHANNEL` | `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE` | `FEATURE`
     * + **Filter values**: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK are valid `filterValue` for the CHANNEL filter key. They do not count towards limitation of 100 filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of 100 filter values, along with 3 channel filters. `contact_lens_conversational_analytics` is a valid filterValue for the `FEATURE` filter key. It is available only to contacts analyzed by Contact Lens conversational analytics.
     */
    public val filters: List<FilterV2>? = builder.filters
    /**
     * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are not aggregated for all queues.
     *
     * If no grouping is specified, a summary of all metrics is returned.
     *
     * Valid grouping keys: `QUEUE` | `ROUTING_PROFILE` | `AGENT` | `CHANNEL` | `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE`
     */
    public val groupings: List<String>? = builder.groupings
    /**
     * The interval period and timezone to apply to returned metrics.
     * + `IntervalPeriod`: An aggregated grouping applied to request metrics. Valid `IntervalPeriod` values are: `FIFTEEN_MIN` | `THIRTY_MIN` | `HOUR` | `DAY` | `WEEK` | `TOTAL`. For example, if `IntervalPeriod` is selected `THIRTY_MIN`, `StartTime` and `EndTime` differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the `TOTAL` interval period. The following list describes restrictions on `StartTime` and `EndTime` based on which `IntervalPeriod` is requested.
     *    + `FIFTEEN_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     *    + `THIRTY_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     *    + `HOUR`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     *    + `DAY`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     *    + `WEEK`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     *    + `TOTAL`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     * + `TimeZone`: The timezone applied to requested metrics.
     */
    public val interval: aws.sdk.kotlin.services.connect.model.IntervalDetails? = builder.interval
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical metrics are available. For a description of each metric, see [Historical metrics definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator's Guide*.
     *
     * ## ABANDONMENT_RATE
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AGENT_ADHERENT_TIME
     * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AGENT_NON_RESPONSE
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
     *
     * ## AGENT_OCCUPANCY
     * Unit: Percentage
     *
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *
     * ## AGENT_SCHEDULE_ADHERENCE
     * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
     *
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AGENT_SCHEDULED_TIME
     * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_ABANDON_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_AFTER_CONTACT_WORK_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_AGENT_CONNECTING_TIME
     * Unit: Seconds
     *
     * Valid metric filter key: `INITIATION_METHOD`. For now, this metric only supports the following as `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` | `CALLBACK` | `API`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * The `Negate` key in Metric Level Filters is not applicable for this metric.
     *
     * ## AVG_CONTACT_DURATION
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_CONVERSATION_DURATION
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_GREETING_TIME_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_HANDLE_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_HOLD_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_HOLD_TIME_ALL_CONTACTS
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_HOLDS
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_INTERACTION_AND_HOLD_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_INTERACTION_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_INTERRUPTIONS_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_INTERRUPTION_TIME_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_NON_TALK_TIME
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_QUEUE_ANSWER_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_RESOLUTION_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile
     *
     * ## AVG_TALK_TIME
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_TALK_TIME_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## AVG_TALK_TIME_CUSTOMER
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## CONTACTS_ABANDONED
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## CONTACTS_CREATED
     * Unit: Count
     *
     * Valid metric filter key: `INITIATION_METHOD`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## CONTACTS_HANDLED
     * Unit: Count
     *
     * Valid metric filter key: `INITIATION_METHOD`, `DISCONNECT_REASON`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## CONTACTS_HOLD_ABANDONS
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## CONTACTS_QUEUED
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## CONTACTS_RESOLVED_IN_X
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile
     *
     * Threshold: For `ThresholdValue` enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * ## CONTACTS_TRANSFERRED_OUT
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## CONTACTS_TRANSFERRED_OUT_BY_AGENT
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## MAX_QUEUED_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## PERCENT_NON_TALK_TIME
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Percentage
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## PERCENT_TALK_TIME
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Percentage
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## PERCENT_TALK_TIME_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Percentage
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## PERCENT_TALK_TIME_CUSTOMER
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Percentage
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * ## SERVICE_LEVEL
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     *
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile
     *
     * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * ## SUM_CONTACTS_ANSWERED_IN_X
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile
     *
     * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * ## SUM_CONTACTS_ABANDONED_IN_X
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile
     *
     * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * ## SUM_CONTACTS_DISCONNECTED
     * Valid metric filter key: `DISCONNECT_REASON`
     *
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile
     *
     * ## SUM_RETRY_CALLBACK_ATTEMPTS
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile
     */
    public val metrics: List<MetricV2>? = builder.metrics
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Resource Name (ARN) of the resource. This includes the `instanceId` an Amazon Connect instance.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be before the end time timestamp. The start and end time depends on the `IntervalPeriod` selected. By default the time range between start and end time is 35 days. Historical metrics are available for 3 months.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMetricDataV2Request(")
        append("endTime=$endTime,")
        append("filters=$filters,")
        append("groupings=$groupings,")
        append("interval=$interval,")
        append("maxResults=$maxResults,")
        append("metrics=$metrics,")
        append("nextToken=$nextToken,")
        append("resourceArn=$resourceArn,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (groupings?.hashCode() ?: 0)
        result = 31 * result + (interval?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMetricDataV2Request

        if (endTime != other.endTime) return false
        if (filters != other.filters) return false
        if (groupings != other.groupings) return false
        if (interval != other.interval) return false
        if (maxResults != other.maxResults) return false
        if (metrics != other.metrics) return false
        if (nextToken != other.nextToken) return false
        if (resourceArn != other.resourceArn) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be later than the start time timestamp. It cannot be later than the current timestamp.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The filters to apply to returned metrics. You can filter on the following resources:
         * + Queues
         * + Routing profiles
         * + Agents
         * + Channels
         * + User hierarchy groups
         * + Feature
         *
         * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
         *
         * To filter by phone number, see [Create a historical metrics report](https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html) in the *Amazon Connect Administrator's Guide*.
         *
         * Note the following limits:
         * + **Filter keys**: A maximum of 5 filter keys are supported in a single request. Valid filter keys: `QUEUE` | `ROUTING_PROFILE` | `AGENT` | `CHANNEL` | `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE` | `FEATURE`
         * + **Filter values**: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK are valid `filterValue` for the CHANNEL filter key. They do not count towards limitation of 100 filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of 100 filter values, along with 3 channel filters. `contact_lens_conversational_analytics` is a valid filterValue for the `FEATURE` filter key. It is available only to contacts analyzed by Contact Lens conversational analytics.
         */
        public var filters: List<FilterV2>? = null
        /**
         * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are not aggregated for all queues.
         *
         * If no grouping is specified, a summary of all metrics is returned.
         *
         * Valid grouping keys: `QUEUE` | `ROUTING_PROFILE` | `AGENT` | `CHANNEL` | `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE`
         */
        public var groupings: List<String>? = null
        /**
         * The interval period and timezone to apply to returned metrics.
         * + `IntervalPeriod`: An aggregated grouping applied to request metrics. Valid `IntervalPeriod` values are: `FIFTEEN_MIN` | `THIRTY_MIN` | `HOUR` | `DAY` | `WEEK` | `TOTAL`. For example, if `IntervalPeriod` is selected `THIRTY_MIN`, `StartTime` and `EndTime` differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the `TOTAL` interval period. The following list describes restrictions on `StartTime` and `EndTime` based on which `IntervalPeriod` is requested.
         *    + `FIFTEEN_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         *    + `THIRTY_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         *    + `HOUR`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         *    + `DAY`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         *    + `WEEK`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         *    + `TOTAL`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         * + `TimeZone`: The timezone applied to requested metrics.
         */
        public var interval: aws.sdk.kotlin.services.connect.model.IntervalDetails? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical metrics are available. For a description of each metric, see [Historical metrics definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator's Guide*.
         *
         * ## ABANDONMENT_RATE
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AGENT_ADHERENT_TIME
         * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AGENT_NON_RESPONSE
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
         *
         * ## AGENT_OCCUPANCY
         * Unit: Percentage
         *
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *
         * ## AGENT_SCHEDULE_ADHERENCE
         * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
         *
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AGENT_SCHEDULED_TIME
         * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_ABANDON_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_AFTER_CONTACT_WORK_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_AGENT_CONNECTING_TIME
         * Unit: Seconds
         *
         * Valid metric filter key: `INITIATION_METHOD`. For now, this metric only supports the following as `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` | `CALLBACK` | `API`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * The `Negate` key in Metric Level Filters is not applicable for this metric.
         *
         * ## AVG_CONTACT_DURATION
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_CONVERSATION_DURATION
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_GREETING_TIME_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_HANDLE_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_HOLD_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_HOLD_TIME_ALL_CONTACTS
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_HOLDS
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_INTERACTION_AND_HOLD_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_INTERACTION_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_INTERRUPTIONS_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_INTERRUPTION_TIME_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_NON_TALK_TIME
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_QUEUE_ANSWER_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_RESOLUTION_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile
         *
         * ## AVG_TALK_TIME
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_TALK_TIME_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## AVG_TALK_TIME_CUSTOMER
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## CONTACTS_ABANDONED
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## CONTACTS_CREATED
         * Unit: Count
         *
         * Valid metric filter key: `INITIATION_METHOD`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## CONTACTS_HANDLED
         * Unit: Count
         *
         * Valid metric filter key: `INITIATION_METHOD`, `DISCONNECT_REASON`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## CONTACTS_HOLD_ABANDONS
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## CONTACTS_QUEUED
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## CONTACTS_RESOLVED_IN_X
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile
         *
         * Threshold: For `ThresholdValue` enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * ## CONTACTS_TRANSFERRED_OUT
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## CONTACTS_TRANSFERRED_OUT_BY_AGENT
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## MAX_QUEUED_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## PERCENT_NON_TALK_TIME
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Percentage
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## PERCENT_TALK_TIME
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Percentage
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## PERCENT_TALK_TIME_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Percentage
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## PERCENT_TALK_TIME_CUSTOMER
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Percentage
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * ## SERVICE_LEVEL
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         *
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile
         *
         * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * ## SUM_CONTACTS_ANSWERED_IN_X
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile
         *
         * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * ## SUM_CONTACTS_ABANDONED_IN_X
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile
         *
         * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * ## SUM_CONTACTS_DISCONNECTED
         * Valid metric filter key: `DISCONNECT_REASON`
         *
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile
         *
         * ## SUM_RETRY_CALLBACK_ATTEMPTS
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile
         */
        public var metrics: List<MetricV2>? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resource. This includes the `instanceId` an Amazon Connect instance.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be before the end time timestamp. The start and end time depends on the `IntervalPeriod` selected. By default the time range between start and end time is 35 days. Historical metrics are available for 3 months.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request) : this() {
            this.endTime = x.endTime
            this.filters = x.filters
            this.groupings = x.groupings
            this.interval = x.interval
            this.maxResults = x.maxResults
            this.metrics = x.metrics
            this.nextToken = x.nextToken
            this.resourceArn = x.resourceArn
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request = GetMetricDataV2Request(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.IntervalDetails] inside the given [block]
         */
        public fun interval(block: aws.sdk.kotlin.services.connect.model.IntervalDetails.Builder.() -> kotlin.Unit) {
            this.interval = aws.sdk.kotlin.services.connect.model.IntervalDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
