// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a contact evaluation.
 */
public class Evaluation private constructor(builder: Builder) {
    /**
     * A map of question identifiers to answer value.
     */
    public val answers: Map<String, EvaluationAnswerOutput> = requireNotNull(builder.answers) { "A non-null value must be provided for answers" }
    /**
     * The timestamp for when the evaluation was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The Amazon Resource Name (ARN) for the contact evaluation resource.
     */
    public val evaluationArn: kotlin.String = requireNotNull(builder.evaluationArn) { "A non-null value must be provided for evaluationArn" }
    /**
     * A unique identifier for the contact evaluation.
     */
    public val evaluationId: kotlin.String = requireNotNull(builder.evaluationId) { "A non-null value must be provided for evaluationId" }
    /**
     * The timestamp for when the evaluation was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * Metadata about the contact evaluation.
     */
    public val metadata: aws.sdk.kotlin.services.connect.model.EvaluationMetadata? = builder.metadata
    /**
     * A map of question identifiers to note value.
     */
    public val notes: Map<String, EvaluationNote> = requireNotNull(builder.notes) { "A non-null value must be provided for notes" }
    /**
     * A map of item (section or question) identifiers to score value.
     */
    public val scores: Map<String, EvaluationScore>? = builder.scores
    /**
     * The status of the contact evaluation.
     */
    public val status: aws.sdk.kotlin.services.connect.model.EvaluationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.Evaluation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Evaluation(")
        append("answers=$answers,")
        append("createdTime=$createdTime,")
        append("evaluationArn=$evaluationArn,")
        append("evaluationId=$evaluationId,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("metadata=$metadata,")
        append("notes=$notes,")
        append("scores=$scores,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = answers.hashCode()
        result = 31 * result + (createdTime.hashCode())
        result = 31 * result + (evaluationArn.hashCode())
        result = 31 * result + (evaluationId.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (notes.hashCode())
        result = 31 * result + (scores?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Evaluation

        if (answers != other.answers) return false
        if (createdTime != other.createdTime) return false
        if (evaluationArn != other.evaluationArn) return false
        if (evaluationId != other.evaluationId) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (metadata != other.metadata) return false
        if (notes != other.notes) return false
        if (scores != other.scores) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.Evaluation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of question identifiers to answer value.
         */
        public var answers: Map<String, EvaluationAnswerOutput>? = null
        /**
         * The timestamp for when the evaluation was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the contact evaluation resource.
         */
        public var evaluationArn: kotlin.String? = null
        /**
         * A unique identifier for the contact evaluation.
         */
        public var evaluationId: kotlin.String? = null
        /**
         * The timestamp for when the evaluation was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Metadata about the contact evaluation.
         */
        public var metadata: aws.sdk.kotlin.services.connect.model.EvaluationMetadata? = null
        /**
         * A map of question identifiers to note value.
         */
        public var notes: Map<String, EvaluationNote>? = null
        /**
         * A map of item (section or question) identifiers to score value.
         */
        public var scores: Map<String, EvaluationScore>? = null
        /**
         * The status of the contact evaluation.
         */
        public var status: aws.sdk.kotlin.services.connect.model.EvaluationStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.Evaluation) : this() {
            this.answers = x.answers
            this.createdTime = x.createdTime
            this.evaluationArn = x.evaluationArn
            this.evaluationId = x.evaluationId
            this.lastModifiedTime = x.lastModifiedTime
            this.metadata = x.metadata
            this.notes = x.notes
            this.scores = x.scores
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.Evaluation = Evaluation(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.EvaluationMetadata] inside the given [block]
         */
        public fun metadata(block: aws.sdk.kotlin.services.connect.model.EvaluationMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.connect.model.EvaluationMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (answers == null) answers = emptyMap()
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (evaluationArn == null) evaluationArn = ""
            if (evaluationId == null) evaluationId = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (notes == null) notes = emptyMap()
            if (status == null) status = EvaluationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
