// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class CreatePersistentContactAssociationRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * This is the contactId of the current contact that the `CreatePersistentContactAssociation` API is being called from.
     */
    public val initialContactId: kotlin.String? = builder.initialContactId
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The contactId chosen for rehydration depends on the type chosen.
     * + `ENTIRE_PAST_SESSION`: Rehydrates a chat from the most recently terminated past chat contact of the specified past ended chat session. To use this type, provide the `initialContactId` of the past ended chat session in the `sourceContactId` field. In this type, Amazon Connect determines what the most recent chat contact on the past ended chat session and uses it to start a persistent chat.
     * + `FROM_SEGMENT`: Rehydrates a chat from the specified past chat contact provided in the `sourceContactId` field.
     *
     * The actual contactId used for rehydration is provided in the response of this API.
     *
     * To illustrate how to use rehydration type, consider the following example: A customer starts a chat session. Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This first contact creates a contact ID **C1**. Agent a1 then transfers the chat to Agent a2. This creates another contact ID **C2**. At this point Agent a2 ends the chat. The customer is forwarded to the disconnect flow for a post chat survey that creates another contact ID **C3**. After the chat survey, the chat session ends. Later, the customer returns and wants to resume their past chat session. At this point, the customer can have following use cases:
     * + **Use Case 1**: The customer wants to continue the past chat session but they want to hide the post chat survey. For this they will use the following configuration:
     *    + **Configuration**
     *       + SourceContactId = "C2"
     *       + RehydrationType = "FROM_SEGMENT"
     *    + **Expected behavior**
     *       + This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past chat sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3 is dropped from the persistent chat session.
     * + **Use Case 2**: The customer wants to continue the past chat session and see the transcript of the entire past engagement, including the post chat survey. For this they will use the following configuration:
     *    + **Configuration**
     *       + SourceContactId = "C1"
     *       + RehydrationType = "ENTIRE_PAST_SESSION"
     *    + **Expected behavior**
     *       + This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past chat sessions C3, C2 and C1 are accessible in the current persistent chat session.
     */
    public val rehydrationType: aws.sdk.kotlin.services.connect.model.RehydrationType? = builder.rehydrationType
    /**
     * The contactId from which a persistent chat session must be started.
     */
    public val sourceContactId: kotlin.String? = builder.sourceContactId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreatePersistentContactAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePersistentContactAssociationRequest(")
        append("clientToken=$clientToken,")
        append("initialContactId=$initialContactId,")
        append("instanceId=$instanceId,")
        append("rehydrationType=$rehydrationType,")
        append("sourceContactId=$sourceContactId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (initialContactId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (rehydrationType?.hashCode() ?: 0)
        result = 31 * result + (sourceContactId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePersistentContactAssociationRequest

        if (clientToken != other.clientToken) return false
        if (initialContactId != other.initialContactId) return false
        if (instanceId != other.instanceId) return false
        if (rehydrationType != other.rehydrationType) return false
        if (sourceContactId != other.sourceContactId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreatePersistentContactAssociationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * This is the contactId of the current contact that the `CreatePersistentContactAssociation` API is being called from.
         */
        public var initialContactId: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The contactId chosen for rehydration depends on the type chosen.
         * + `ENTIRE_PAST_SESSION`: Rehydrates a chat from the most recently terminated past chat contact of the specified past ended chat session. To use this type, provide the `initialContactId` of the past ended chat session in the `sourceContactId` field. In this type, Amazon Connect determines what the most recent chat contact on the past ended chat session and uses it to start a persistent chat.
         * + `FROM_SEGMENT`: Rehydrates a chat from the specified past chat contact provided in the `sourceContactId` field.
         *
         * The actual contactId used for rehydration is provided in the response of this API.
         *
         * To illustrate how to use rehydration type, consider the following example: A customer starts a chat session. Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This first contact creates a contact ID **C1**. Agent a1 then transfers the chat to Agent a2. This creates another contact ID **C2**. At this point Agent a2 ends the chat. The customer is forwarded to the disconnect flow for a post chat survey that creates another contact ID **C3**. After the chat survey, the chat session ends. Later, the customer returns and wants to resume their past chat session. At this point, the customer can have following use cases:
         * + **Use Case 1**: The customer wants to continue the past chat session but they want to hide the post chat survey. For this they will use the following configuration:
         *    + **Configuration**
         *       + SourceContactId = "C2"
         *       + RehydrationType = "FROM_SEGMENT"
         *    + **Expected behavior**
         *       + This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past chat sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3 is dropped from the persistent chat session.
         * + **Use Case 2**: The customer wants to continue the past chat session and see the transcript of the entire past engagement, including the post chat survey. For this they will use the following configuration:
         *    + **Configuration**
         *       + SourceContactId = "C1"
         *       + RehydrationType = "ENTIRE_PAST_SESSION"
         *    + **Expected behavior**
         *       + This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past chat sessions C3, C2 and C1 are accessible in the current persistent chat session.
         */
        public var rehydrationType: aws.sdk.kotlin.services.connect.model.RehydrationType? = null
        /**
         * The contactId from which a persistent chat session must be started.
         */
        public var sourceContactId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreatePersistentContactAssociationRequest) : this() {
            this.clientToken = x.clientToken
            this.initialContactId = x.initialContactId
            this.instanceId = x.instanceId
            this.rehydrationType = x.rehydrationType
            this.sourceContactId = x.sourceContactId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreatePersistentContactAssociationRequest = CreatePersistentContactAssociationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
