// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.connect.auth.ConnectAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.connect.auth.ConnectIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.connect.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.connect.model.*
import aws.sdk.kotlin.services.connect.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext


public const val ServiceApiVersion: String = "2017-08-08"

internal class DefaultConnectClient(override val config: ConnectClient.Config) : ConnectClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ConnectIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "connect")
        }
        toMap()
    }
    private val authSchemeAdapter = ConnectAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.connect"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it is available to start new evaluations based on the form.
     */
    override suspend fun activateEvaluationForm(input: ActivateEvaluationFormRequest): ActivateEvaluationFormResponse {
        val op = SdkHttpOperation.build<ActivateEvaluationFormRequest, ActivateEvaluationFormResponse> {
            serializer = ActivateEvaluationFormOperationSerializer()
            deserializer = ActivateEvaluationFormOperationDeserializer()
            operationName = "ActivateEvaluationForm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates an approved origin to an Amazon Connect instance.
     */
    override suspend fun associateApprovedOrigin(input: AssociateApprovedOriginRequest): AssociateApprovedOriginResponse {
        val op = SdkHttpOperation.build<AssociateApprovedOriginRequest, AssociateApprovedOriginResponse> {
            serializer = AssociateApprovedOriginOperationSerializer()
            deserializer = AssociateApprovedOriginOperationDeserializer()
            operationName = "AssociateApprovedOrigin"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    override suspend fun associateBot(input: AssociateBotRequest): AssociateBotResponse {
        val op = SdkHttpOperation.build<AssociateBotRequest, AssociateBotResponse> {
            serializer = AssociateBotOperationSerializer()
            deserializer = AssociateBotOperationDeserializer()
            operationName = "AssociateBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.
     */
    override suspend fun associateDefaultVocabulary(input: AssociateDefaultVocabularyRequest): AssociateDefaultVocabularyResponse {
        val op = SdkHttpOperation.build<AssociateDefaultVocabularyRequest, AssociateDefaultVocabularyResponse> {
            serializer = AssociateDefaultVocabularyOperationSerializer()
            deserializer = AssociateDefaultVocabularyOperationDeserializer()
            operationName = "AssociateDefaultVocabulary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing chat transcripts.
     *
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     */
    override suspend fun associateInstanceStorageConfig(input: AssociateInstanceStorageConfigRequest): AssociateInstanceStorageConfigResponse {
        val op = SdkHttpOperation.build<AssociateInstanceStorageConfigRequest, AssociateInstanceStorageConfigResponse> {
            serializer = AssociateInstanceStorageConfigOperationSerializer()
            deserializer = AssociateInstanceStorageConfigOperationDeserializer()
            operationName = "AssociateInstanceStorageConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     */
    override suspend fun associateLambdaFunction(input: AssociateLambdaFunctionRequest): AssociateLambdaFunctionResponse {
        val op = SdkHttpOperation.build<AssociateLambdaFunctionRequest, AssociateLambdaFunctionResponse> {
            serializer = AssociateLambdaFunctionOperationSerializer()
            deserializer = AssociateLambdaFunctionOperationDeserializer()
            operationName = "AssociateLambdaFunction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports the association of Amazon Lex V1 bots.
     */
    override suspend fun associateLexBot(input: AssociateLexBotRequest): AssociateLexBotResponse {
        val op = SdkHttpOperation.build<AssociateLexBotRequest, AssociateLexBotResponse> {
            serializer = AssociateLexBotOperationSerializer()
            deserializer = AssociateLexBotOperationDeserializer()
            operationName = "AssociateLexBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a flow with a phone number claimed to your Amazon Connect instance.
     *
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    override suspend fun associatePhoneNumberContactFlow(input: AssociatePhoneNumberContactFlowRequest): AssociatePhoneNumberContactFlowResponse {
        val op = SdkHttpOperation.build<AssociatePhoneNumberContactFlowRequest, AssociatePhoneNumberContactFlowResponse> {
            serializer = AssociatePhoneNumberContactFlowOperationSerializer()
            deserializer = AssociatePhoneNumberContactFlowOperationDeserializer()
            operationName = "AssociatePhoneNumberContactFlow"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a set of quick connects with a queue.
     */
    override suspend fun associateQueueQuickConnects(input: AssociateQueueQuickConnectsRequest): AssociateQueueQuickConnectsResponse {
        val op = SdkHttpOperation.build<AssociateQueueQuickConnectsRequest, AssociateQueueQuickConnectsResponse> {
            serializer = AssociateQueueQuickConnectsOperationSerializer()
            deserializer = AssociateQueueQuickConnectsOperationDeserializer()
            operationName = "AssociateQueueQuickConnects"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a set of queues with a routing profile.
     */
    override suspend fun associateRoutingProfileQueues(input: AssociateRoutingProfileQueuesRequest): AssociateRoutingProfileQueuesResponse {
        val op = SdkHttpOperation.build<AssociateRoutingProfileQueuesRequest, AssociateRoutingProfileQueuesResponse> {
            serializer = AssociateRoutingProfileQueuesOperationSerializer()
            deserializer = AssociateRoutingProfileQueuesOperationDeserializer()
            operationName = "AssociateRoutingProfileQueues"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a security key to the instance.
     */
    override suspend fun associateSecurityKey(input: AssociateSecurityKeyRequest): AssociateSecurityKeyResponse {
        val op = SdkHttpOperation.build<AssociateSecurityKeyRequest, AssociateSecurityKeyResponse> {
            serializer = AssociateSecurityKeyOperationSerializer()
            deserializer = AssociateSecurityKeyOperationDeserializer()
            operationName = "AssociateSecurityKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates an agent with a traffic distribution group.
     */
    override suspend fun associateTrafficDistributionGroupUser(input: AssociateTrafficDistributionGroupUserRequest): AssociateTrafficDistributionGroupUserResponse {
        val op = SdkHttpOperation.build<AssociateTrafficDistributionGroupUserRequest, AssociateTrafficDistributionGroupUserResponse> {
            serializer = AssociateTrafficDistributionGroupUserOperationSerializer()
            deserializer = AssociateTrafficDistributionGroupUserOperationDeserializer()
            operationName = "AssociateTrafficDistributionGroupUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the flow associations for the given resources.
     */
    override suspend fun batchGetFlowAssociation(input: BatchGetFlowAssociationRequest): BatchGetFlowAssociationResponse {
        val op = SdkHttpOperation.build<BatchGetFlowAssociationRequest, BatchGetFlowAssociationResponse> {
            serializer = BatchGetFlowAssociationOperationSerializer()
            deserializer = BatchGetFlowAssociationOperationDeserializer()
            operationName = "BatchGetFlowAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call this API.
     *
     * Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial requests via the [PutDialRequestBatch](https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html) API. It then uses BatchPutContact to create contacts corresponding to those dial requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting voice call uses the same contactId that was created by BatchPutContact.
     */
    override suspend fun batchPutContact(input: BatchPutContactRequest): BatchPutContactResponse {
        val op = SdkHttpOperation.build<BatchPutContactRequest, BatchPutContactResponse> {
            serializer = BatchPutContactOperationSerializer()
            deserializer = BatchPutContactOperationDeserializer()
            operationName = "BatchPutContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group was created.
     *
     * For more information about how to use this operation, see [Claim a phone number in your country](https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html) and [Claim phone numbers to traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     *
     * You can call the [SearchAvailablePhoneNumbers](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html) API for available phone numbers that you can claim. Call the [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API to verify the status of a previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) operation.
     *
     * If you plan to claim and release numbers frequently during a 30 day period, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until 30 days past the oldest number released has expired.
     *
     * By default you can claim and release up to 200% of your maximum number of active phone numbers during any 30 day period. If you claim and release phone numbers using the UI or API during a rolling 30 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming any more numbers until 30 days past the oldest number released has expired.
     *
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 30 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     */
    override suspend fun claimPhoneNumber(input: ClaimPhoneNumberRequest): ClaimPhoneNumberResponse {
        val op = SdkHttpOperation.build<ClaimPhoneNumberRequest, ClaimPhoneNumberResponse> {
            serializer = ClaimPhoneNumberOperationSerializer()
            deserializer = ClaimPhoneNumberOperationDeserializer()
            operationName = "ClaimPhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates an agent status for the specified Amazon Connect instance.
     */
    override suspend fun createAgentStatus(input: CreateAgentStatusRequest): CreateAgentStatusResponse {
        val op = SdkHttpOperation.build<CreateAgentStatusRequest, CreateAgentStatusResponse> {
            serializer = CreateAgentStatusOperationSerializer()
            deserializer = CreateAgentStatusOperationDeserializer()
            operationName = "CreateAgentStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a flow for the specified Amazon Connect instance.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    override suspend fun createContactFlow(input: CreateContactFlowRequest): CreateContactFlowResponse {
        val op = SdkHttpOperation.build<CreateContactFlowRequest, CreateContactFlowResponse> {
            serializer = CreateContactFlowOperationSerializer()
            deserializer = CreateContactFlowOperationDeserializer()
            operationName = "CreateContactFlow"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a flow module for the specified Amazon Connect instance.
     */
    override suspend fun createContactFlowModule(input: CreateContactFlowModuleRequest): CreateContactFlowModuleResponse {
        val op = SdkHttpOperation.build<CreateContactFlowModuleRequest, CreateContactFlowModuleResponse> {
            serializer = CreateContactFlowModuleOperationSerializer()
            deserializer = CreateContactFlowModuleOperationDeserializer()
            operationName = "CreateContactFlowModule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions related to agent performance, and create sections to organize such questions. Question and section identifiers cannot be duplicated within the same evaluation form.
     */
    override suspend fun createEvaluationForm(input: CreateEvaluationFormRequest): CreateEvaluationFormResponse {
        val op = SdkHttpOperation.build<CreateEvaluationFormRequest, CreateEvaluationFormResponse> {
            serializer = CreateEvaluationFormOperationSerializer()
            deserializer = CreateEvaluationFormOperationDeserializer()
            operationName = "CreateEvaluationForm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates hours of operation.
     */
    override suspend fun createHoursOfOperation(input: CreateHoursOfOperationRequest): CreateHoursOfOperationResponse {
        val op = SdkHttpOperation.build<CreateHoursOfOperationRequest, CreateHoursOfOperationResponse> {
            serializer = CreateHoursOfOperationOperationSerializer()
            deserializer = CreateHoursOfOperationOperationDeserializer()
            operationName = "CreateHoursOfOperation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    override suspend fun createInstance(input: CreateInstanceRequest): CreateInstanceResponse {
        val op = SdkHttpOperation.build<CreateInstanceRequest, CreateInstanceResponse> {
            serializer = CreateInstanceOperationSerializer()
            deserializer = CreateInstanceOperationDeserializer()
            operationName = "CreateInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     */
    override suspend fun createIntegrationAssociation(input: CreateIntegrationAssociationRequest): CreateIntegrationAssociationResponse {
        val op = SdkHttpOperation.build<CreateIntegrationAssociationRequest, CreateIntegrationAssociationResponse> {
            serializer = CreateIntegrationAssociationOperationSerializer()
            deserializer = CreateIntegrationAssociationOperationDeserializer()
            operationName = "CreateIntegrationAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new participant into an on-going chat contact. For more information, see [Customize chat flow experiences by integrating custom participants](https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html).
     */
    override suspend fun createParticipant(input: CreateParticipantRequest): CreateParticipantResponse {
        val op = SdkHttpOperation.build<CreateParticipantRequest, CreateParticipantResponse> {
            serializer = CreateParticipantOperationSerializer()
            deserializer = CreateParticipantOperationDeserializer()
            operationName = "CreateParticipant"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun createPersistentContactAssociation(input: CreatePersistentContactAssociationRequest): CreatePersistentContactAssociationResponse {
        val op = SdkHttpOperation.build<CreatePersistentContactAssociationRequest, CreatePersistentContactAssociationResponse> {
            serializer = CreatePersistentContactAssociationOperationSerializer()
            deserializer = CreatePersistentContactAssociationOperationDeserializer()
            operationName = "CreatePersistentContactAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a prompt. For more information about prompts, such as supported file types and maximum length, see [Create prompts](https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html) in the *Amazon Connect Administrator's Guide*.
     */
    override suspend fun createPrompt(input: CreatePromptRequest): CreatePromptResponse {
        val op = SdkHttpOperation.build<CreatePromptRequest, CreatePromptResponse> {
            serializer = CreatePromptOperationSerializer()
            deserializer = CreatePromptOperationDeserializer()
            operationName = "CreatePrompt"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates a new queue for the specified Amazon Connect instance.
     *
     * + If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for `OutboundCallerIdNumberId`. However, if the phone number is claimed to a traffic distribution group that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     * + Only use the phone number ARN format that doesn't contain `instance` in the path, for example, `arn:aws:connect:us-east-1:1234567890:phone-number/uuid`. This is the same ARN format that is returned when you call the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API.
     * + If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic distribution group, see [Allow or Deny queue API actions for phone numbers in a replica Region](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region).
     */
    override suspend fun createQueue(input: CreateQueueRequest): CreateQueueResponse {
        val op = SdkHttpOperation.build<CreateQueueRequest, CreateQueueResponse> {
            serializer = CreateQueueOperationSerializer()
            deserializer = CreateQueueOperationDeserializer()
            operationName = "CreateQueue"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a quick connect for the specified Amazon Connect instance.
     */
    override suspend fun createQuickConnect(input: CreateQuickConnectRequest): CreateQuickConnectResponse {
        val op = SdkHttpOperation.build<CreateQuickConnectRequest, CreateQuickConnectResponse> {
            serializer = CreateQuickConnectOperationSerializer()
            deserializer = CreateQuickConnectOperationDeserializer()
            operationName = "CreateQuickConnect"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new routing profile.
     */
    override suspend fun createRoutingProfile(input: CreateRoutingProfileRequest): CreateRoutingProfileResponse {
        val op = SdkHttpOperation.build<CreateRoutingProfileRequest, CreateRoutingProfileResponse> {
            serializer = CreateRoutingProfileOperationSerializer()
            deserializer = CreateRoutingProfileOperationDeserializer()
            operationName = "CreateRoutingProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a rule for the specified Amazon Connect instance.
     *
     * Use the [Rules Function language](https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html) to code conditions for the rule.
     */
    override suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse {
        val op = SdkHttpOperation.build<CreateRuleRequest, CreateRuleResponse> {
            serializer = CreateRuleOperationSerializer()
            deserializer = CreateRuleOperationDeserializer()
            operationName = "CreateRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a security profile.
     */
    override suspend fun createSecurityProfile(input: CreateSecurityProfileRequest): CreateSecurityProfileResponse {
        val op = SdkHttpOperation.build<CreateSecurityProfileRequest, CreateSecurityProfileResponse> {
            serializer = CreateSecurityProfileOperationSerializer()
            deserializer = CreateSecurityProfileOperationDeserializer()
            operationName = "CreateSecurityProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new task template in the specified Amazon Connect instance.
     */
    override suspend fun createTaskTemplate(input: CreateTaskTemplateRequest): CreateTaskTemplateResponse {
        val op = SdkHttpOperation.build<CreateTaskTemplateRequest, CreateTaskTemplateResponse> {
            serializer = CreateTaskTemplateOperationSerializer()
            deserializer = CreateTaskTemplateOperationDeserializer()
            operationName = "CreateTaskTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
     *
     * The `SignInConfig` distribution is available only on a default `TrafficDistributionGroup` (see the `IsDefault` parameter in the [TrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html) data type). If you call `UpdateTrafficDistribution` with a modified `SignInConfig` and a non-default `TrafficDistributionGroup`, an `InvalidRequestException` is returned.
     *
     * For more information about creating traffic distribution groups, see [Set up traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun createTrafficDistributionGroup(input: CreateTrafficDistributionGroupRequest): CreateTrafficDistributionGroupResponse {
        val op = SdkHttpOperation.build<CreateTrafficDistributionGroupRequest, CreateTrafficDistributionGroupResponse> {
            serializer = CreateTrafficDistributionGroupOperationSerializer()
            deserializer = CreateTrafficDistributionGroupOperationDeserializer()
            operationName = "CreateTrafficDistributionGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a use case for an integration association.
     */
    override suspend fun createUseCase(input: CreateUseCaseRequest): CreateUseCaseResponse {
        val op = SdkHttpOperation.build<CreateUseCaseRequest, CreateUseCaseResponse> {
            serializer = CreateUseCaseOperationSerializer()
            deserializer = CreateUseCaseOperationDeserializer()
            operationName = "CreateUseCase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user account for the specified Amazon Connect instance.
     *
     * Certain [UserIdentityInfo](https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html) parameters are required in some situations. For example, `Email` is required if you are using SAML for identity management. `FirstName` and `LastName` are required if you are using Amazon Connect or SAML for identity management.
     *
     * For information about how to create user accounts using the Amazon Connect console, see [Add Users](https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            operationName = "CreateUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new user hierarchy group.
     */
    override suspend fun createUserHierarchyGroup(input: CreateUserHierarchyGroupRequest): CreateUserHierarchyGroupResponse {
        val op = SdkHttpOperation.build<CreateUserHierarchyGroupRequest, CreateUserHierarchyGroupResponse> {
            serializer = CreateUserHierarchyGroupOperationSerializer()
            deserializer = CreateUserHierarchyGroupOperationDeserializer()
            operationName = "CreateUserHierarchyGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new view with the possible status of `SAVED` or `PUBLISHED`.
     *
     * The views will have a unique name for each connect instance.
     *
     * It performs basic content validation if the status is `SAVED` or full content validation if the status is set to `PUBLISHED`. An error is returned if validation fails. It associates either the `$SAVED` qualifier or both of the `$SAVED` and `$LATEST` qualifiers with the provided view content based on the status. The view is idempotent if ClientToken is provided.
     */
    override suspend fun createView(input: CreateViewRequest): CreateViewResponse {
        val op = SdkHttpOperation.build<CreateViewRequest, CreateViewResponse> {
            serializer = CreateViewOperationSerializer()
            deserializer = CreateViewOperationDeserializer()
            operationName = "CreateView"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Publishes a new version of the view identifier.
     *
     * Versions are immutable and monotonically increasing.
     *
     * It returns the highest version if there is no change in content compared to that version. An error is displayed if the supplied ViewContentSha256 is different from the ViewContentSha256 of the `$LATEST` alias.
     */
    override suspend fun createViewVersion(input: CreateViewVersionRequest): CreateViewVersionResponse {
        val op = SdkHttpOperation.build<CreateViewVersionRequest, CreateViewVersionResponse> {
            serializer = CreateViewVersionOperationSerializer()
            deserializer = CreateViewVersionOperationDeserializer()
            operationName = "CreateViewVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.
     */
    override suspend fun createVocabulary(input: CreateVocabularyRequest): CreateVocabularyResponse {
        val op = SdkHttpOperation.build<CreateVocabularyRequest, CreateVocabularyResponse> {
            serializer = CreateVocabularyOperationSerializer()
            deserializer = CreateVocabularyOperationDeserializer()
            operationName = "CreateVocabulary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no longer available for users to start new evaluations based on the form.
     */
    override suspend fun deactivateEvaluationForm(input: DeactivateEvaluationFormRequest): DeactivateEvaluationFormResponse {
        val op = SdkHttpOperation.build<DeactivateEvaluationFormRequest, DeactivateEvaluationFormResponse> {
            serializer = DeactivateEvaluationFormOperationSerializer()
            deserializer = DeactivateEvaluationFormOperationDeserializer()
            operationName = "DeactivateEvaluationForm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a contact evaluation in the specified Amazon Connect instance.
     */
    override suspend fun deleteContactEvaluation(input: DeleteContactEvaluationRequest): DeleteContactEvaluationResponse {
        val op = SdkHttpOperation.build<DeleteContactEvaluationRequest, DeleteContactEvaluationResponse> {
            serializer = DeleteContactEvaluationOperationSerializer()
            deserializer = DeleteContactEvaluationOperationDeserializer()
            operationName = "DeleteContactEvaluation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a flow for the specified Amazon Connect instance.
     */
    override suspend fun deleteContactFlow(input: DeleteContactFlowRequest): DeleteContactFlowResponse {
        val op = SdkHttpOperation.build<DeleteContactFlowRequest, DeleteContactFlowResponse> {
            serializer = DeleteContactFlowOperationSerializer()
            deserializer = DeleteContactFlowOperationDeserializer()
            operationName = "DeleteContactFlow"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified flow module.
     */
    override suspend fun deleteContactFlowModule(input: DeleteContactFlowModuleRequest): DeleteContactFlowModuleResponse {
        val op = SdkHttpOperation.build<DeleteContactFlowModuleRequest, DeleteContactFlowModuleResponse> {
            serializer = DeleteContactFlowModuleOperationSerializer()
            deserializer = DeleteContactFlowModuleOperationDeserializer()
            operationName = "DeleteContactFlowModule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an evaluation form in the specified Amazon Connect instance.
     * + If the version property is provided, only the specified version of the evaluation form is deleted.
     * + If no version is provided, then the full form (all versions) is deleted.
     */
    override suspend fun deleteEvaluationForm(input: DeleteEvaluationFormRequest): DeleteEvaluationFormResponse {
        val op = SdkHttpOperation.build<DeleteEvaluationFormRequest, DeleteEvaluationFormResponse> {
            serializer = DeleteEvaluationFormOperationSerializer()
            deserializer = DeleteEvaluationFormOperationDeserializer()
            operationName = "DeleteEvaluationForm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes an hours of operation.
     */
    override suspend fun deleteHoursOfOperation(input: DeleteHoursOfOperationRequest): DeleteHoursOfOperationResponse {
        val op = SdkHttpOperation.build<DeleteHoursOfOperationRequest, DeleteHoursOfOperationResponse> {
            serializer = DeleteHoursOfOperationOperationSerializer()
            deserializer = DeleteHoursOfOperationOperationDeserializer()
            operationName = "DeleteHoursOfOperation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the Amazon Connect instance.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    override suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse {
        val op = SdkHttpOperation.build<DeleteInstanceRequest, DeleteInstanceResponse> {
            serializer = DeleteInstanceOperationSerializer()
            deserializer = DeleteInstanceOperationDeserializer()
            operationName = "DeleteInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.
     */
    override suspend fun deleteIntegrationAssociation(input: DeleteIntegrationAssociationRequest): DeleteIntegrationAssociationResponse {
        val op = SdkHttpOperation.build<DeleteIntegrationAssociationRequest, DeleteIntegrationAssociationResponse> {
            serializer = DeleteIntegrationAssociationOperationSerializer()
            deserializer = DeleteIntegrationAssociationOperationDeserializer()
            operationName = "DeleteIntegrationAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a prompt.
     */
    override suspend fun deletePrompt(input: DeletePromptRequest): DeletePromptResponse {
        val op = SdkHttpOperation.build<DeletePromptRequest, DeletePromptResponse> {
            serializer = DeletePromptOperationSerializer()
            deserializer = DeletePromptOperationDeserializer()
            operationName = "DeletePrompt"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a queue.
     */
    override suspend fun deleteQueue(input: DeleteQueueRequest): DeleteQueueResponse {
        val op = SdkHttpOperation.build<DeleteQueueRequest, DeleteQueueResponse> {
            serializer = DeleteQueueOperationSerializer()
            deserializer = DeleteQueueOperationDeserializer()
            operationName = "DeleteQueue"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a quick connect.
     */
    override suspend fun deleteQuickConnect(input: DeleteQuickConnectRequest): DeleteQuickConnectResponse {
        val op = SdkHttpOperation.build<DeleteQuickConnectRequest, DeleteQuickConnectResponse> {
            serializer = DeleteQuickConnectOperationSerializer()
            deserializer = DeleteQuickConnectOperationDeserializer()
            operationName = "DeleteQuickConnect"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a routing profile.
     */
    override suspend fun deleteRoutingProfile(input: DeleteRoutingProfileRequest): DeleteRoutingProfileResponse {
        val op = SdkHttpOperation.build<DeleteRoutingProfileRequest, DeleteRoutingProfileResponse> {
            serializer = DeleteRoutingProfileOperationSerializer()
            deserializer = DeleteRoutingProfileOperationDeserializer()
            operationName = "DeleteRoutingProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a rule for the specified Amazon Connect instance.
     */
    override suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse {
        val op = SdkHttpOperation.build<DeleteRuleRequest, DeleteRuleResponse> {
            serializer = DeleteRuleOperationSerializer()
            deserializer = DeleteRuleOperationDeserializer()
            operationName = "DeleteRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a security profile.
     */
    override suspend fun deleteSecurityProfile(input: DeleteSecurityProfileRequest): DeleteSecurityProfileResponse {
        val op = SdkHttpOperation.build<DeleteSecurityProfileRequest, DeleteSecurityProfileResponse> {
            serializer = DeleteSecurityProfileOperationSerializer()
            deserializer = DeleteSecurityProfileOperationDeserializer()
            operationName = "DeleteSecurityProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the task template.
     */
    override suspend fun deleteTaskTemplate(input: DeleteTaskTemplateRequest): DeleteTaskTemplateResponse {
        val op = SdkHttpOperation.build<DeleteTaskTemplateRequest, DeleteTaskTemplateResponse> {
            serializer = DeleteTaskTemplateOperationSerializer()
            deserializer = DeleteTaskTemplateOperationDeserializer()
            operationName = "DeleteTaskTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution group is created.
     *
     * For more information about deleting traffic distribution groups, see [Delete traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun deleteTrafficDistributionGroup(input: DeleteTrafficDistributionGroupRequest): DeleteTrafficDistributionGroupResponse {
        val op = SdkHttpOperation.build<DeleteTrafficDistributionGroupRequest, DeleteTrafficDistributionGroupResponse> {
            serializer = DeleteTrafficDistributionGroupOperationSerializer()
            deserializer = DeleteTrafficDistributionGroupOperationDeserializer()
            operationName = "DeleteTrafficDistributionGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a use case from an integration association.
     */
    override suspend fun deleteUseCase(input: DeleteUseCaseRequest): DeleteUseCaseResponse {
        val op = SdkHttpOperation.build<DeleteUseCaseRequest, DeleteUseCaseResponse> {
            serializer = DeleteUseCaseOperationSerializer()
            deserializer = DeleteUseCaseOperationDeserializer()
            operationName = "DeleteUseCase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a user account from the specified Amazon Connect instance.
     *
     * For information about what happens to a user's data when their account is deleted, see [Delete Users from Your Amazon Connect Instance](https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            operationName = "DeleteUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.
     */
    override suspend fun deleteUserHierarchyGroup(input: DeleteUserHierarchyGroupRequest): DeleteUserHierarchyGroupResponse {
        val op = SdkHttpOperation.build<DeleteUserHierarchyGroupRequest, DeleteUserHierarchyGroupResponse> {
            serializer = DeleteUserHierarchyGroupOperationSerializer()
            deserializer = DeleteUserHierarchyGroupOperationDeserializer()
            operationName = "DeleteUserHierarchyGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).
     */
    override suspend fun deleteView(input: DeleteViewRequest): DeleteViewResponse {
        val op = SdkHttpOperation.build<DeleteViewRequest, DeleteViewResponse> {
            serializer = DeleteViewOperationSerializer()
            deserializer = DeleteViewOperationDeserializer()
            operationName = "DeleteView"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the particular version specified in `ViewVersion` identifier.
     */
    override suspend fun deleteViewVersion(input: DeleteViewVersionRequest): DeleteViewVersionResponse {
        val op = SdkHttpOperation.build<DeleteViewVersionRequest, DeleteViewVersionResponse> {
            serializer = DeleteViewVersionOperationSerializer()
            deserializer = DeleteViewVersionOperationDeserializer()
            operationName = "DeleteViewVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the vocabulary that has the given identifier.
     */
    override suspend fun deleteVocabulary(input: DeleteVocabularyRequest): DeleteVocabularyResponse {
        val op = SdkHttpOperation.build<DeleteVocabularyRequest, DeleteVocabularyResponse> {
            serializer = DeleteVocabularyOperationSerializer()
            deserializer = DeleteVocabularyOperationDeserializer()
            operationName = "DeleteVocabulary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes an agent status.
     */
    override suspend fun describeAgentStatus(input: DescribeAgentStatusRequest): DescribeAgentStatusResponse {
        val op = SdkHttpOperation.build<DescribeAgentStatusRequest, DescribeAgentStatusResponse> {
            serializer = DescribeAgentStatusOperationSerializer()
            deserializer = DescribeAgentStatusOperationDeserializer()
            operationName = "DescribeAgentStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified contact.
     *
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     *
     * Only data from November 12, 2021, and later is returned by this API.
     */
    override suspend fun describeContact(input: DescribeContactRequest): DescribeContactResponse {
        val op = SdkHttpOperation.build<DescribeContactRequest, DescribeContactResponse> {
            serializer = DescribeContactOperationSerializer()
            deserializer = DescribeContactOperationDeserializer()
            operationName = "DescribeContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a contact evaluation in the specified Amazon Connect instance.
     */
    override suspend fun describeContactEvaluation(input: DescribeContactEvaluationRequest): DescribeContactEvaluationResponse {
        val op = SdkHttpOperation.build<DescribeContactEvaluationRequest, DescribeContactEvaluationResponse> {
            serializer = DescribeContactEvaluationOperationSerializer()
            deserializer = DescribeContactEvaluationOperationDeserializer()
            operationName = "DescribeContactEvaluation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    override suspend fun describeContactFlow(input: DescribeContactFlowRequest): DescribeContactFlowResponse {
        val op = SdkHttpOperation.build<DescribeContactFlowRequest, DescribeContactFlowResponse> {
            serializer = DescribeContactFlowOperationSerializer()
            deserializer = DescribeContactFlowOperationDeserializer()
            operationName = "DescribeContactFlow"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified flow module.
     */
    override suspend fun describeContactFlowModule(input: DescribeContactFlowModuleRequest): DescribeContactFlowModuleResponse {
        val op = SdkHttpOperation.build<DescribeContactFlowModuleRequest, DescribeContactFlowModuleResponse> {
            serializer = DescribeContactFlowModuleOperationSerializer()
            deserializer = DescribeContactFlowModuleOperationDeserializer()
            operationName = "DescribeContactFlowModule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided, the latest version of the evaluation form is described.
     */
    override suspend fun describeEvaluationForm(input: DescribeEvaluationFormRequest): DescribeEvaluationFormResponse {
        val op = SdkHttpOperation.build<DescribeEvaluationFormRequest, DescribeEvaluationFormResponse> {
            serializer = DescribeEvaluationFormOperationSerializer()
            deserializer = DescribeEvaluationFormOperationDeserializer()
            operationName = "DescribeEvaluationForm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the hours of operation.
     */
    override suspend fun describeHoursOfOperation(input: DescribeHoursOfOperationRequest): DescribeHoursOfOperationResponse {
        val op = SdkHttpOperation.build<DescribeHoursOfOperationRequest, DescribeHoursOfOperationResponse> {
            serializer = DescribeHoursOfOperationOperationSerializer()
            deserializer = DescribeHoursOfOperationOperationDeserializer()
            operationName = "DescribeHoursOfOperation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable.
     *
     * If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     */
    override suspend fun describeInstance(input: DescribeInstanceRequest): DescribeInstanceResponse {
        val op = SdkHttpOperation.build<DescribeInstanceRequest, DescribeInstanceResponse> {
            serializer = DescribeInstanceOperationSerializer()
            deserializer = DescribeInstanceOperationDeserializer()
            operationName = "DescribeInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified instance attribute.
     */
    override suspend fun describeInstanceAttribute(input: DescribeInstanceAttributeRequest): DescribeInstanceAttributeResponse {
        val op = SdkHttpOperation.build<DescribeInstanceAttributeRequest, DescribeInstanceAttributeResponse> {
            serializer = DescribeInstanceAttributeOperationSerializer()
            deserializer = DescribeInstanceAttributeOperationDeserializer()
            operationName = "DescribeInstanceAttribute"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     */
    override suspend fun describeInstanceStorageConfig(input: DescribeInstanceStorageConfigRequest): DescribeInstanceStorageConfigResponse {
        val op = SdkHttpOperation.build<DescribeInstanceStorageConfigRequest, DescribeInstanceStorageConfigResponse> {
            serializer = DescribeInstanceStorageConfigOperationSerializer()
            deserializer = DescribeInstanceStorageConfigOperationDeserializer()
            operationName = "DescribeInstanceStorageConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution group.
     *
     * If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    override suspend fun describePhoneNumber(input: DescribePhoneNumberRequest): DescribePhoneNumberResponse {
        val op = SdkHttpOperation.build<DescribePhoneNumberRequest, DescribePhoneNumberResponse> {
            serializer = DescribePhoneNumberOperationSerializer()
            deserializer = DescribePhoneNumberOperationDeserializer()
            operationName = "DescribePhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the prompt.
     */
    override suspend fun describePrompt(input: DescribePromptRequest): DescribePromptResponse {
        val op = SdkHttpOperation.build<DescribePromptRequest, DescribePromptResponse> {
            serializer = DescribePromptOperationSerializer()
            deserializer = DescribePromptOperationDeserializer()
            operationName = "DescribePrompt"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified queue.
     */
    override suspend fun describeQueue(input: DescribeQueueRequest): DescribeQueueResponse {
        val op = SdkHttpOperation.build<DescribeQueueRequest, DescribeQueueResponse> {
            serializer = DescribeQueueOperationSerializer()
            deserializer = DescribeQueueOperationDeserializer()
            operationName = "DescribeQueue"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the quick connect.
     */
    override suspend fun describeQuickConnect(input: DescribeQuickConnectRequest): DescribeQuickConnectResponse {
        val op = SdkHttpOperation.build<DescribeQuickConnectRequest, DescribeQuickConnectResponse> {
            serializer = DescribeQuickConnectOperationSerializer()
            deserializer = DescribeQuickConnectOperationDeserializer()
            operationName = "DescribeQuickConnect"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified routing profile.
     */
    override suspend fun describeRoutingProfile(input: DescribeRoutingProfileRequest): DescribeRoutingProfileResponse {
        val op = SdkHttpOperation.build<DescribeRoutingProfileRequest, DescribeRoutingProfileResponse> {
            serializer = DescribeRoutingProfileOperationSerializer()
            deserializer = DescribeRoutingProfileOperationDeserializer()
            operationName = "DescribeRoutingProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a rule for the specified Amazon Connect instance.
     */
    override suspend fun describeRule(input: DescribeRuleRequest): DescribeRuleResponse {
        val op = SdkHttpOperation.build<DescribeRuleRequest, DescribeRuleResponse> {
            serializer = DescribeRuleOperationSerializer()
            deserializer = DescribeRuleOperationDeserializer()
            operationName = "DescribeRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets basic information about the security profle.
     */
    override suspend fun describeSecurityProfile(input: DescribeSecurityProfileRequest): DescribeSecurityProfileResponse {
        val op = SdkHttpOperation.build<DescribeSecurityProfileRequest, DescribeSecurityProfileResponse> {
            serializer = DescribeSecurityProfileOperationSerializer()
            deserializer = DescribeSecurityProfileOperationDeserializer()
            operationName = "DescribeSecurityProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details and status of a traffic distribution group.
     */
    override suspend fun describeTrafficDistributionGroup(input: DescribeTrafficDistributionGroupRequest): DescribeTrafficDistributionGroupResponse {
        val op = SdkHttpOperation.build<DescribeTrafficDistributionGroupRequest, DescribeTrafficDistributionGroupResponse> {
            serializer = DescribeTrafficDistributionGroupOperationSerializer()
            deserializer = DescribeTrafficDistributionGroupOperationDeserializer()
            operationName = "DescribeTrafficDistributionGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified user account. You can [find the instance ID in the Amazon Connect console](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
     */
    override suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse {
        val op = SdkHttpOperation.build<DescribeUserRequest, DescribeUserResponse> {
            serializer = DescribeUserOperationSerializer()
            deserializer = DescribeUserOperationDeserializer()
            operationName = "DescribeUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified hierarchy group.
     */
    override suspend fun describeUserHierarchyGroup(input: DescribeUserHierarchyGroupRequest): DescribeUserHierarchyGroupResponse {
        val op = SdkHttpOperation.build<DescribeUserHierarchyGroupRequest, DescribeUserHierarchyGroupResponse> {
            serializer = DescribeUserHierarchyGroupOperationSerializer()
            deserializer = DescribeUserHierarchyGroupOperationDeserializer()
            operationName = "DescribeUserHierarchyGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     */
    override suspend fun describeUserHierarchyStructure(input: DescribeUserHierarchyStructureRequest): DescribeUserHierarchyStructureResponse {
        val op = SdkHttpOperation.build<DescribeUserHierarchyStructureRequest, DescribeUserHierarchyStructureResponse> {
            serializer = DescribeUserHierarchyStructureOperationSerializer()
            deserializer = DescribeUserHierarchyStructureOperationDeserializer()
            operationName = "DescribeUserHierarchyStructure"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the view for the specified Amazon Connect instance and view identifier.
     *
     * The view identifier can be supplied as a ViewId or ARN.
     *
     * `$SAVED` needs to be supplied if a view is unpublished.
     *
     * The view identifier can contain an optional qualifier, for example, `<view-id>:$SAVED`, which is either an actual version number or an Amazon Connect managed qualifier `$SAVED | $LATEST`. If it is not supplied, then `$LATEST` is assumed for customer managed views and an error is returned if there is no published content available. Version 1 is assumed for Amazon Web Services managed views.
     */
    override suspend fun describeView(input: DescribeViewRequest): DescribeViewResponse {
        val op = SdkHttpOperation.build<DescribeViewRequest, DescribeViewResponse> {
            serializer = DescribeViewOperationSerializer()
            deserializer = DescribeViewOperationDeserializer()
            operationName = "DescribeView"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified vocabulary.
     */
    override suspend fun describeVocabulary(input: DescribeVocabularyRequest): DescribeVocabularyResponse {
        val op = SdkHttpOperation.build<DescribeVocabularyRequest, DescribeVocabularyResponse> {
            serializer = DescribeVocabularyOperationSerializer()
            deserializer = DescribeVocabularyOperationDeserializer()
            operationName = "DescribeVocabulary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes access to integrated applications from Amazon Connect.
     */
    override suspend fun disassociateApprovedOrigin(input: DisassociateApprovedOriginRequest): DisassociateApprovedOriginResponse {
        val op = SdkHttpOperation.build<DisassociateApprovedOriginRequest, DisassociateApprovedOriginResponse> {
            serializer = DisassociateApprovedOriginOperationSerializer()
            deserializer = DisassociateApprovedOriginOperationDeserializer()
            operationName = "DisassociateApprovedOrigin"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    override suspend fun disassociateBot(input: DisassociateBotRequest): DisassociateBotResponse {
        val op = SdkHttpOperation.build<DisassociateBotRequest, DisassociateBotResponse> {
            serializer = DisassociateBotOperationSerializer()
            deserializer = DisassociateBotOperationDeserializer()
            operationName = "DisassociateBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Removes the storage type configurations for the specified resource type and association ID.
     */
    override suspend fun disassociateInstanceStorageConfig(input: DisassociateInstanceStorageConfigRequest): DisassociateInstanceStorageConfigResponse {
        val op = SdkHttpOperation.build<DisassociateInstanceStorageConfigRequest, DisassociateInstanceStorageConfigResponse> {
            serializer = DisassociateInstanceStorageConfigOperationSerializer()
            deserializer = DisassociateInstanceStorageConfigOperationDeserializer()
            operationName = "DisassociateInstanceStorageConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Remove the Lambda function from the dropdown options available in the relevant flow blocks.
     */
    override suspend fun disassociateLambdaFunction(input: DisassociateLambdaFunctionRequest): DisassociateLambdaFunctionResponse {
        val op = SdkHttpOperation.build<DisassociateLambdaFunctionRequest, DisassociateLambdaFunctionResponse> {
            serializer = DisassociateLambdaFunctionOperationSerializer()
            deserializer = DisassociateLambdaFunctionOperationDeserializer()
            operationName = "DisassociateLambdaFunction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     */
    override suspend fun disassociateLexBot(input: DisassociateLexBotRequest): DisassociateLexBotResponse {
        val op = SdkHttpOperation.build<DisassociateLexBotRequest, DisassociateLexBotResponse> {
            serializer = DisassociateLexBotOperationSerializer()
            deserializer = DisassociateLexBotOperationDeserializer()
            operationName = "DisassociateLexBot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the flow association from a phone number claimed to your Amazon Connect instance.
     *
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    override suspend fun disassociatePhoneNumberContactFlow(input: DisassociatePhoneNumberContactFlowRequest): DisassociatePhoneNumberContactFlowResponse {
        val op = SdkHttpOperation.build<DisassociatePhoneNumberContactFlowRequest, DisassociatePhoneNumberContactFlowResponse> {
            serializer = DisassociatePhoneNumberContactFlowOperationSerializer()
            deserializer = DisassociatePhoneNumberContactFlowOperationDeserializer()
            operationName = "DisassociatePhoneNumberContactFlow"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Disassociates a set of quick connects from a queue.
     */
    override suspend fun disassociateQueueQuickConnects(input: DisassociateQueueQuickConnectsRequest): DisassociateQueueQuickConnectsResponse {
        val op = SdkHttpOperation.build<DisassociateQueueQuickConnectsRequest, DisassociateQueueQuickConnectsResponse> {
            serializer = DisassociateQueueQuickConnectsOperationSerializer()
            deserializer = DisassociateQueueQuickConnectsOperationDeserializer()
            operationName = "DisassociateQueueQuickConnects"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a set of queues from a routing profile.
     */
    override suspend fun disassociateRoutingProfileQueues(input: DisassociateRoutingProfileQueuesRequest): DisassociateRoutingProfileQueuesResponse {
        val op = SdkHttpOperation.build<DisassociateRoutingProfileQueuesRequest, DisassociateRoutingProfileQueuesResponse> {
            serializer = DisassociateRoutingProfileQueuesOperationSerializer()
            deserializer = DisassociateRoutingProfileQueuesOperationDeserializer()
            operationName = "DisassociateRoutingProfileQueues"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the specified security key.
     */
    override suspend fun disassociateSecurityKey(input: DisassociateSecurityKeyRequest): DisassociateSecurityKeyResponse {
        val op = SdkHttpOperation.build<DisassociateSecurityKeyRequest, DisassociateSecurityKeyResponse> {
            serializer = DisassociateSecurityKeyOperationSerializer()
            deserializer = DisassociateSecurityKeyOperationDeserializer()
            operationName = "DisassociateSecurityKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an agent from a traffic distribution group.
     */
    override suspend fun disassociateTrafficDistributionGroupUser(input: DisassociateTrafficDistributionGroupUserRequest): DisassociateTrafficDistributionGroupUserResponse {
        val op = SdkHttpOperation.build<DisassociateTrafficDistributionGroupUserRequest, DisassociateTrafficDistributionGroupUserResponse> {
            serializer = DisassociateTrafficDistributionGroupUserOperationSerializer()
            deserializer = DisassociateTrafficDistributionGroupUserOperationDeserializer()
            operationName = "DisassociateTrafficDistributionGroupUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to receive a new routed contact. Contacts can only be dismissed if they are in a `MISSED`, `ERROR`, `ENDED`, or `REJECTED` state in the [Agent Event Stream](https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
     */
    override suspend fun dismissUserContact(input: DismissUserContactRequest): DismissUserContactResponse {
        val op = SdkHttpOperation.build<DismissUserContactRequest, DismissUserContactResponse> {
            serializer = DismissUserContactOperationSerializer()
            deserializer = DismissUserContactOperationDeserializer()
            operationName = "DismissUserContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the contact attributes for the specified contact.
     */
    override suspend fun getContactAttributes(input: GetContactAttributesRequest): GetContactAttributesResponse {
        val op = SdkHttpOperation.build<GetContactAttributesRequest, GetContactAttributesResponse> {
            serializer = GetContactAttributesOperationSerializer()
            deserializer = GetContactAttributesOperationDeserializer()
            operationName = "GetContactAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the real-time metric data from the specified Amazon Connect instance.
     *
     * For a description of each metric, see [Real-time Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun getCurrentMetricData(input: GetCurrentMetricDataRequest): GetCurrentMetricDataResponse {
        val op = SdkHttpOperation.build<GetCurrentMetricDataRequest, GetCurrentMetricDataResponse> {
            serializer = GetCurrentMetricDataOperationSerializer()
            deserializer = GetCurrentMetricDataOperationDeserializer()
            operationName = "GetCurrentMetricData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the real-time active user data from the specified Amazon Connect instance.
     */
    override suspend fun getCurrentUserData(input: GetCurrentUserDataRequest): GetCurrentUserDataResponse {
        val op = SdkHttpOperation.build<GetCurrentUserDataRequest, GetCurrentUserDataResponse> {
            serializer = GetCurrentUserDataOperationSerializer()
            deserializer = GetCurrentUserDataOperationDeserializer()
            operationName = "GetCurrentUserData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect user which corresponds to the IAM credentials that were used to invoke this action.
     *
     * For more information about how SAML sign-in works in Amazon Connect, see *Amazon Connect Administrator Guide*[.](https://docs.aws.amazon.com/connect/latest/adminguide/configure-saml.html )
     *
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears:
     *
     * `Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect`
     */
    override suspend fun getFederationToken(input: GetFederationTokenRequest): GetFederationTokenResponse {
        val op = SdkHttpOperation.build<GetFederationTokenRequest, GetFederationTokenResponse> {
            serializer = GetFederationTokenOperationSerializer()
            deserializer = GetFederationTokenOperationDeserializer()
            operationName = "GetFederationToken"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets historical metric data from the specified Amazon Connect instance.
     *
     * For a description of each historical metric, see [Historical Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     *
     * We recommend using the [GetMetricDataV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html) API. It provides more flexibility, features, and the ability to query longer time ranges than `GetMetricData`. Use it to retrieve historical agent and contact metrics for the last 3 months, at varying intervals. You can also use it to build custom dashboards to measure historical queue and agent performance. For example, you can track the number of incoming contacts for the last 7 days, with data split by day, to see how contact volume changed per day of the week.
     */
    override suspend fun getMetricData(input: GetMetricDataRequest): GetMetricDataResponse {
        val op = SdkHttpOperation.build<GetMetricDataRequest, GetMetricDataResponse> {
            serializer = GetMetricDataOperationSerializer()
            deserializer = GetMetricDataOperationDeserializer()
            operationName = "GetMetricData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets metric data from the specified Amazon Connect instance.
     *
     * `GetMetricDataV2` offers more features than [GetMetricData](https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html), the previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve historical data for the last 3 months, at varying intervals.
     *
     * For a description of the historical metrics that are supported by `GetMetricDataV2` and `GetMetricData`, see [Historical metrics definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator's Guide*.
     */
    override suspend fun getMetricDataV2(input: GetMetricDataV2Request): GetMetricDataV2Response {
        val op = SdkHttpOperation.build<GetMetricDataV2Request, GetMetricDataV2Response> {
            serializer = GetMetricDataV2OperationSerializer()
            deserializer = GetMetricDataV2OperationDeserializer()
            operationName = "GetMetricDataV2"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the prompt file.
     */
    override suspend fun getPromptFile(input: GetPromptFileRequest): GetPromptFileResponse {
        val op = SdkHttpOperation.build<GetPromptFileRequest, GetPromptFileResponse> {
            serializer = GetPromptFileOperationSerializer()
            deserializer = GetPromptFileOperationDeserializer()
            operationName = "GetPromptFile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a specific task template in the specified Amazon Connect instance.
     */
    override suspend fun getTaskTemplate(input: GetTaskTemplateRequest): GetTaskTemplateResponse {
        val op = SdkHttpOperation.build<GetTaskTemplateRequest, GetTaskTemplateResponse> {
            serializer = GetTaskTemplateOperationSerializer()
            deserializer = GetTaskTemplateOperationDeserializer()
            operationName = "GetTaskTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current traffic distribution for a given traffic distribution group.
     */
    override suspend fun getTrafficDistribution(input: GetTrafficDistributionRequest): GetTrafficDistributionResponse {
        val op = SdkHttpOperation.build<GetTrafficDistributionRequest, GetTrafficDistributionResponse> {
            serializer = GetTrafficDistributionOperationSerializer()
            deserializer = GetTrafficDistributionOperationDeserializer()
            operationName = "GetTrafficDistribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists agent statuses.
     */
    override suspend fun listAgentStatuses(input: ListAgentStatusesRequest): ListAgentStatusesResponse {
        val op = SdkHttpOperation.build<ListAgentStatusesRequest, ListAgentStatusesResponse> {
            serializer = ListAgentStatusesOperationSerializer()
            deserializer = ListAgentStatusesOperationDeserializer()
            operationName = "ListAgentStatuses"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all approved origins associated with the instance.
     */
    override suspend fun listApprovedOrigins(input: ListApprovedOriginsRequest): ListApprovedOriginsResponse {
        val op = SdkHttpOperation.build<ListApprovedOriginsRequest, ListApprovedOriginsResponse> {
            serializer = ListApprovedOriginsOperationSerializer()
            deserializer = ListApprovedOriginsOperationDeserializer()
            operationName = "ListApprovedOrigins"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance. Use this API to returns both Amazon Lex V1 and V2 bots.
     */
    override suspend fun listBots(input: ListBotsRequest): ListBotsResponse {
        val op = SdkHttpOperation.build<ListBotsRequest, ListBotsResponse> {
            serializer = ListBotsOperationSerializer()
            deserializer = ListBotsOperationDeserializer()
            operationName = "ListBots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists contact evaluations in the specified Amazon Connect instance.
     */
    override suspend fun listContactEvaluations(input: ListContactEvaluationsRequest): ListContactEvaluationsResponse {
        val op = SdkHttpOperation.build<ListContactEvaluationsRequest, ListContactEvaluationsResponse> {
            serializer = ListContactEvaluationsOperationSerializer()
            deserializer = ListContactEvaluationsOperationDeserializer()
            operationName = "ListContactEvaluations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the flow modules for the specified Amazon Connect instance.
     */
    override suspend fun listContactFlowModules(input: ListContactFlowModulesRequest): ListContactFlowModulesResponse {
        val op = SdkHttpOperation.build<ListContactFlowModulesRequest, ListContactFlowModulesResponse> {
            serializer = ListContactFlowModulesOperationSerializer()
            deserializer = ListContactFlowModulesOperationDeserializer()
            operationName = "ListContactFlowModules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the flows for the specified Amazon Connect instance.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     *
     * For more information about flows, see [Flows](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listContactFlows(input: ListContactFlowsRequest): ListContactFlowsResponse {
        val op = SdkHttpOperation.build<ListContactFlowsRequest, ListContactFlowsResponse> {
            serializer = ListContactFlowsOperationSerializer()
            deserializer = ListContactFlowsOperationDeserializer()
            operationName = "ListContactFlows"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified `referenceTypes`, returns a list of references associated with the contact.
     */
    override suspend fun listContactReferences(input: ListContactReferencesRequest): ListContactReferencesResponse {
        val op = SdkHttpOperation.build<ListContactReferencesRequest, ListContactReferencesResponse> {
            serializer = ListContactReferencesOperationSerializer()
            deserializer = ListContactReferencesOperationDeserializer()
            operationName = "ListContactReferences"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the default vocabularies for the specified Amazon Connect instance.
     */
    override suspend fun listDefaultVocabularies(input: ListDefaultVocabulariesRequest): ListDefaultVocabulariesResponse {
        val op = SdkHttpOperation.build<ListDefaultVocabulariesRequest, ListDefaultVocabulariesResponse> {
            serializer = ListDefaultVocabulariesOperationSerializer()
            deserializer = ListDefaultVocabulariesOperationDeserializer()
            operationName = "ListDefaultVocabularies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists versions of an evaluation form in the specified Amazon Connect instance.
     */
    override suspend fun listEvaluationFormVersions(input: ListEvaluationFormVersionsRequest): ListEvaluationFormVersionsResponse {
        val op = SdkHttpOperation.build<ListEvaluationFormVersionsRequest, ListEvaluationFormVersionsResponse> {
            serializer = ListEvaluationFormVersionsOperationSerializer()
            deserializer = ListEvaluationFormVersionsOperationDeserializer()
            operationName = "ListEvaluationFormVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists evaluation forms in the specified Amazon Connect instance.
     */
    override suspend fun listEvaluationForms(input: ListEvaluationFormsRequest): ListEvaluationFormsResponse {
        val op = SdkHttpOperation.build<ListEvaluationFormsRequest, ListEvaluationFormsResponse> {
            serializer = ListEvaluationFormsOperationSerializer()
            deserializer = ListEvaluationFormsOperationDeserializer()
            operationName = "ListEvaluationForms"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     *
     * For more information about hours of operation, see [Set the Hours of Operation for a Queue](https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listHoursOfOperations(input: ListHoursOfOperationsRequest): ListHoursOfOperationsResponse {
        val op = SdkHttpOperation.build<ListHoursOfOperationsRequest, ListHoursOfOperationsResponse> {
            serializer = ListHoursOfOperationsOperationSerializer()
            deserializer = ListHoursOfOperationsOperationDeserializer()
            operationName = "ListHoursOfOperations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all attribute types for the given instance.
     */
    override suspend fun listInstanceAttributes(input: ListInstanceAttributesRequest): ListInstanceAttributesResponse {
        val op = SdkHttpOperation.build<ListInstanceAttributesRequest, ListInstanceAttributesResponse> {
            serializer = ListInstanceAttributesOperationSerializer()
            deserializer = ListInstanceAttributesOperationDeserializer()
            operationName = "ListInstanceAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of storage configs for the identified instance and resource type.
     */
    override suspend fun listInstanceStorageConfigs(input: ListInstanceStorageConfigsRequest): ListInstanceStorageConfigsResponse {
        val op = SdkHttpOperation.build<ListInstanceStorageConfigsRequest, ListInstanceStorageConfigsResponse> {
            serializer = ListInstanceStorageConfigsOperationSerializer()
            deserializer = ListInstanceStorageConfigsOperationDeserializer()
            operationName = "ListInstanceStorageConfigs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren't successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.
     */
    override suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse {
        val op = SdkHttpOperation.build<ListInstancesRequest, ListInstancesResponse> {
            serializer = ListInstancesOperationSerializer()
            deserializer = ListInstancesOperationDeserializer()
            operationName = "ListInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.
     */
    override suspend fun listIntegrationAssociations(input: ListIntegrationAssociationsRequest): ListIntegrationAssociationsResponse {
        val op = SdkHttpOperation.build<ListIntegrationAssociationsRequest, ListIntegrationAssociationsResponse> {
            serializer = ListIntegrationAssociationsOperationSerializer()
            deserializer = ListIntegrationAssociationsOperationDeserializer()
            operationName = "ListIntegrationAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant flow blocks.
     */
    override suspend fun listLambdaFunctions(input: ListLambdaFunctionsRequest): ListLambdaFunctionsResponse {
        val op = SdkHttpOperation.build<ListLambdaFunctionsRequest, ListLambdaFunctionsResponse> {
            serializer = ListLambdaFunctionsOperationSerializer()
            deserializer = ListLambdaFunctionsOperationDeserializer()
            operationName = "ListLambdaFunctions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all the Amazon Lex V1 bots currently associated with the instance. To return both Amazon Lex V1 and V2 bots, use the [ListBots](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListBots.html) API.
     */
    override suspend fun listLexBots(input: ListLexBotsRequest): ListLexBotsResponse {
        val op = SdkHttpOperation.build<ListLexBotsRequest, ListLexBotsResponse> {
            serializer = ListLexBotsOperationSerializer()
            deserializer = ListLexBotsOperationDeserializer()
            operationName = "ListLexBots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     *
     * + We recommend using [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) to return phone number types. ListPhoneNumbers doesn't support number types `UIFN`, `SHARED`, `THIRD_PARTY_TF`, and `THIRD_PARTY_DID`. While it returns numbers of those types, it incorrectly lists them as `TOLL_FREE` or `DID`.
     * + The phone number `Arn` value that is returned from each of the items in the [PhoneNumberSummaryList](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html#connect-ListPhoneNumbers-response-PhoneNumberSummaryList) cannot be used to tag phone number resources. It will fail with a `ResourceNotFoundException`. Instead, use the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API. It returns the new phone number ARN that can be used to tag phone number resources.
     */
    override suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest): ListPhoneNumbersResponse {
        val op = SdkHttpOperation.build<ListPhoneNumbersRequest, ListPhoneNumbersResponse> {
            serializer = ListPhoneNumbersOperationSerializer()
            deserializer = ListPhoneNumbersOperationDeserializer()
            operationName = "ListPhoneNumbers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists phone numbers claimed to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with traffic distribution group.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     *
     * + When given an instance ARN, `ListPhoneNumbersV2` returns only the phone numbers claimed to the instance.
     * + When given a traffic distribution group ARN `ListPhoneNumbersV2` returns only the phone numbers claimed to the traffic distribution group.
     */
    override suspend fun listPhoneNumbersV2(input: ListPhoneNumbersV2Request): ListPhoneNumbersV2Response {
        val op = SdkHttpOperation.build<ListPhoneNumbersV2Request, ListPhoneNumbersV2Response> {
            serializer = ListPhoneNumbersV2OperationSerializer()
            deserializer = ListPhoneNumbersV2OperationDeserializer()
            operationName = "ListPhoneNumbersV2"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the prompts for the specified Amazon Connect instance.
     */
    override suspend fun listPrompts(input: ListPromptsRequest): ListPromptsResponse {
        val op = SdkHttpOperation.build<ListPromptsRequest, ListPromptsResponse> {
            serializer = ListPromptsOperationSerializer()
            deserializer = ListPromptsOperationDeserializer()
            operationName = "ListPrompts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the quick connects associated with a queue.
     */
    override suspend fun listQueueQuickConnects(input: ListQueueQuickConnectsRequest): ListQueueQuickConnectsResponse {
        val op = SdkHttpOperation.build<ListQueueQuickConnectsRequest, ListQueueQuickConnectsResponse> {
            serializer = ListQueueQuickConnectsOperationSerializer()
            deserializer = ListQueueQuickConnectsOperationDeserializer()
            operationName = "ListQueueQuickConnects"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the queues for the specified Amazon Connect instance.
     *
     * If you do not specify a `QueueTypes` parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.
     *
     * For more information about queues, see [Queues: Standard and Agent](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listQueues(input: ListQueuesRequest): ListQueuesResponse {
        val op = SdkHttpOperation.build<ListQueuesRequest, ListQueuesResponse> {
            serializer = ListQueuesOperationSerializer()
            deserializer = ListQueuesOperationDeserializer()
            operationName = "ListQueues"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the quick connects for the specified Amazon Connect instance.
     */
    override suspend fun listQuickConnects(input: ListQuickConnectsRequest): ListQuickConnectsResponse {
        val op = SdkHttpOperation.build<ListQuickConnectsRequest, ListQuickConnectsResponse> {
            serializer = ListQuickConnectsOperationSerializer()
            deserializer = ListQuickConnectsOperationDeserializer()
            operationName = "ListQuickConnects"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the queues associated with a routing profile.
     */
    override suspend fun listRoutingProfileQueues(input: ListRoutingProfileQueuesRequest): ListRoutingProfileQueuesResponse {
        val op = SdkHttpOperation.build<ListRoutingProfileQueuesRequest, ListRoutingProfileQueuesResponse> {
            serializer = ListRoutingProfileQueuesOperationSerializer()
            deserializer = ListRoutingProfileQueuesOperationDeserializer()
            operationName = "ListRoutingProfileQueues"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     *
     * For more information about routing profiles, see [Routing Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html) and [Create a Routing Profile](https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listRoutingProfiles(input: ListRoutingProfilesRequest): ListRoutingProfilesResponse {
        val op = SdkHttpOperation.build<ListRoutingProfilesRequest, ListRoutingProfilesResponse> {
            serializer = ListRoutingProfilesOperationSerializer()
            deserializer = ListRoutingProfilesOperationDeserializer()
            operationName = "ListRoutingProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List all rules for the specified Amazon Connect instance.
     */
    override suspend fun listRules(input: ListRulesRequest): ListRulesResponse {
        val op = SdkHttpOperation.build<ListRulesRequest, ListRulesResponse> {
            serializer = ListRulesOperationSerializer()
            deserializer = ListRulesOperationDeserializer()
            operationName = "ListRules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all security keys associated with the instance.
     */
    override suspend fun listSecurityKeys(input: ListSecurityKeysRequest): ListSecurityKeysResponse {
        val op = SdkHttpOperation.build<ListSecurityKeysRequest, ListSecurityKeysResponse> {
            serializer = ListSecurityKeysOperationSerializer()
            deserializer = ListSecurityKeysOperationDeserializer()
            operationName = "ListSecurityKeys"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of third-party applications in a specific security profile.
     */
    override suspend fun listSecurityProfileApplications(input: ListSecurityProfileApplicationsRequest): ListSecurityProfileApplicationsResponse {
        val op = SdkHttpOperation.build<ListSecurityProfileApplicationsRequest, ListSecurityProfileApplicationsResponse> {
            serializer = ListSecurityProfileApplicationsOperationSerializer()
            deserializer = ListSecurityProfileApplicationsOperationDeserializer()
            operationName = "ListSecurityProfileApplications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the permissions granted to a security profile.
     */
    override suspend fun listSecurityProfilePermissions(input: ListSecurityProfilePermissionsRequest): ListSecurityProfilePermissionsResponse {
        val op = SdkHttpOperation.build<ListSecurityProfilePermissionsRequest, ListSecurityProfilePermissionsResponse> {
            serializer = ListSecurityProfilePermissionsOperationSerializer()
            deserializer = ListSecurityProfilePermissionsOperationDeserializer()
            operationName = "ListSecurityProfilePermissions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     *
     * For more information about security profiles, see [Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listSecurityProfiles(input: ListSecurityProfilesRequest): ListSecurityProfilesResponse {
        val op = SdkHttpOperation.build<ListSecurityProfilesRequest, ListSecurityProfilesResponse> {
            serializer = ListSecurityProfilesOperationSerializer()
            deserializer = ListSecurityProfilesOperationDeserializer()
            operationName = "ListSecurityProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for the specified resource.
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists task templates for the specified Amazon Connect instance.
     */
    override suspend fun listTaskTemplates(input: ListTaskTemplatesRequest): ListTaskTemplatesResponse {
        val op = SdkHttpOperation.build<ListTaskTemplatesRequest, ListTaskTemplatesResponse> {
            serializer = ListTaskTemplatesOperationSerializer()
            deserializer = ListTaskTemplatesOperationDeserializer()
            operationName = "ListTaskTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists traffic distribution group users.
     */
    override suspend fun listTrafficDistributionGroupUsers(input: ListTrafficDistributionGroupUsersRequest): ListTrafficDistributionGroupUsersResponse {
        val op = SdkHttpOperation.build<ListTrafficDistributionGroupUsersRequest, ListTrafficDistributionGroupUsersResponse> {
            serializer = ListTrafficDistributionGroupUsersOperationSerializer()
            deserializer = ListTrafficDistributionGroupUsersOperationDeserializer()
            operationName = "ListTrafficDistributionGroupUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists traffic distribution groups.
     */
    override suspend fun listTrafficDistributionGroups(input: ListTrafficDistributionGroupsRequest): ListTrafficDistributionGroupsResponse {
        val op = SdkHttpOperation.build<ListTrafficDistributionGroupsRequest, ListTrafficDistributionGroupsResponse> {
            serializer = ListTrafficDistributionGroupsOperationSerializer()
            deserializer = ListTrafficDistributionGroupsOperationDeserializer()
            operationName = "ListTrafficDistributionGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the use cases for the integration association.
     */
    override suspend fun listUseCases(input: ListUseCasesRequest): ListUseCasesResponse {
        val op = SdkHttpOperation.build<ListUseCasesRequest, ListUseCasesResponse> {
            serializer = ListUseCasesOperationSerializer()
            deserializer = ListUseCasesOperationDeserializer()
            operationName = "ListUseCases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     *
     * For more information about agent hierarchies, see [Set Up Agent Hierarchies](https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listUserHierarchyGroups(input: ListUserHierarchyGroupsRequest): ListUserHierarchyGroupsResponse {
        val op = SdkHttpOperation.build<ListUserHierarchyGroupsRequest, ListUserHierarchyGroupsResponse> {
            serializer = ListUserHierarchyGroupsOperationSerializer()
            deserializer = ListUserHierarchyGroupsOperationDeserializer()
            operationName = "ListUserHierarchyGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides summary information about the users for the specified Amazon Connect instance.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializer = ListUsersOperationSerializer()
            deserializer = ListUsersOperationDeserializer()
            operationName = "ListUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns all the available versions for the specified Amazon Connect instance and view identifier.
     *
     * Results will be sorted from highest to lowest.
     */
    override suspend fun listViewVersions(input: ListViewVersionsRequest): ListViewVersionsResponse {
        val op = SdkHttpOperation.build<ListViewVersionsRequest, ListViewVersionsResponse> {
            serializer = ListViewVersionsOperationSerializer()
            deserializer = ListViewVersionsOperationDeserializer()
            operationName = "ListViewVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns views in the given instance.
     *
     * Results are sorted primarily by type, and secondarily by name.
     */
    override suspend fun listViews(input: ListViewsRequest): ListViewsResponse {
        val op = SdkHttpOperation.build<ListViewsRequest, ListViewsResponse> {
            serializer = ListViewsOperationSerializer()
            deserializer = ListViewsOperationDeserializer()
            operationName = "ListViews"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates silent monitoring of a contact. The Contact Control Panel (CCP) of the user specified by *userId* will be set to silent monitoring mode on the contact.
     */
    override suspend fun monitorContact(input: MonitorContactRequest): MonitorContactResponse {
        val op = SdkHttpOperation.build<MonitorContactRequest, MonitorContactResponse> {
            serializer = MonitorContactOperationSerializer()
            deserializer = MonitorContactOperationDeserializer()
            operationName = "MonitorContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact, this sets the agent's next status.
     *
     * For more information, see [Agent status](https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html) and [Set your next status](https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun putUserStatus(input: PutUserStatusRequest): PutUserStatusResponse {
        val op = SdkHttpOperation.build<PutUserStatusRequest, PutUserStatusResponse> {
            serializer = PutUserStatusOperationSerializer()
            deserializer = PutUserStatusOperationDeserializer()
            operationName = "PutUserStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Releases a phone number previously claimed to an Amazon Connect instance or traffic distribution group. You can call this API only in the Amazon Web Services Region where the number was claimed.
     *
     * To release phone numbers from a traffic distribution group, use the `ReleasePhoneNumber` API, not the Amazon Connect console.
     *
     * After releasing a phone number, the phone number enters into a cooldown period of 30 days. It cannot be searched for or claimed again until the period has ended. If you accidentally release a phone number, contact Amazon Web Services Support.
     *
     * If you plan to claim and release numbers frequently during a 30 day period, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until 30 days past the oldest number released has expired.
     *
     * By default you can claim and release up to 200% of your maximum number of active phone numbers during any 30 day period. If you claim and release phone numbers using the UI or API during a rolling 30 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming any more numbers until 30 days past the oldest number released has expired.
     *
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 30 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     */
    override suspend fun releasePhoneNumber(input: ReleasePhoneNumberRequest): ReleasePhoneNumberResponse {
        val op = SdkHttpOperation.build<ReleasePhoneNumberRequest, ReleasePhoneNumberResponse> {
            serializer = ReleasePhoneNumberOperationSerializer()
            deserializer = ReleasePhoneNumberOperationDeserializer()
            operationName = "ReleasePhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Replicates an Amazon Connect instance in the specified Amazon Web Services Region and copies configuration information for Amazon Connect resources across Amazon Web Services Regions.
     *
     * For more information about replicating an Amazon Connect instance, see [Create a replica of your existing Amazon Connect instance](https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun replicateInstance(input: ReplicateInstanceRequest): ReplicateInstanceResponse {
        val op = SdkHttpOperation.build<ReplicateInstanceRequest, ReplicateInstanceResponse> {
            serializer = ReplicateInstanceOperationSerializer()
            deserializer = ReplicateInstanceOperationDeserializer()
            operationName = "ReplicateInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording whatever recording is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would resume.
     *
     * Voice and screen recordings are supported.
     */
    override suspend fun resumeContactRecording(input: ResumeContactRecordingRequest): ResumeContactRecordingResponse {
        val op = SdkHttpOperation.build<ResumeContactRecordingRequest, ResumeContactRecordingResponse> {
            serializer = ResumeContactRecordingOperationSerializer()
            deserializer = ResumeContactRecordingOperationDeserializer()
            operationName = "ResumeContactRecording"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for available phone numbers that you can claim to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with the traffic distribution group.
     */
    override suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest): SearchAvailablePhoneNumbersResponse {
        val op = SdkHttpOperation.build<SearchAvailablePhoneNumbersRequest, SearchAvailablePhoneNumbersResponse> {
            serializer = SearchAvailablePhoneNumbersOperationSerializer()
            deserializer = SearchAvailablePhoneNumbersOperationDeserializer()
            operationName = "SearchAvailablePhoneNumbers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches the hours of operation in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchHoursOfOperations(input: SearchHoursOfOperationsRequest): SearchHoursOfOperationsResponse {
        val op = SdkHttpOperation.build<SearchHoursOfOperationsRequest, SearchHoursOfOperationsResponse> {
            serializer = SearchHoursOfOperationsOperationSerializer()
            deserializer = SearchHoursOfOperationsOperationDeserializer()
            operationName = "SearchHoursOfOperations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches prompts in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchPrompts(input: SearchPromptsRequest): SearchPromptsResponse {
        val op = SdkHttpOperation.build<SearchPromptsRequest, SearchPromptsResponse> {
            serializer = SearchPromptsOperationSerializer()
            deserializer = SearchPromptsOperationDeserializer()
            operationName = "SearchPrompts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches queues in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchQueues(input: SearchQueuesRequest): SearchQueuesResponse {
        val op = SdkHttpOperation.build<SearchQueuesRequest, SearchQueuesResponse> {
            serializer = SearchQueuesOperationSerializer()
            deserializer = SearchQueuesOperationDeserializer()
            operationName = "SearchQueues"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches quick connects in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchQuickConnects(input: SearchQuickConnectsRequest): SearchQuickConnectsResponse {
        val op = SdkHttpOperation.build<SearchQuickConnectsRequest, SearchQuickConnectsResponse> {
            serializer = SearchQuickConnectsOperationSerializer()
            deserializer = SearchQuickConnectsOperationDeserializer()
            operationName = "SearchQuickConnects"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches tags used in an Amazon Connect instance using optional search criteria.
     */
    override suspend fun searchResourceTags(input: SearchResourceTagsRequest): SearchResourceTagsResponse {
        val op = SdkHttpOperation.build<SearchResourceTagsRequest, SearchResourceTagsResponse> {
            serializer = SearchResourceTagsOperationSerializer()
            deserializer = SearchResourceTagsOperationDeserializer()
            operationName = "SearchResourceTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches routing profiles in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchRoutingProfiles(input: SearchRoutingProfilesRequest): SearchRoutingProfilesResponse {
        val op = SdkHttpOperation.build<SearchRoutingProfilesRequest, SearchRoutingProfilesResponse> {
            serializer = SearchRoutingProfilesOperationSerializer()
            deserializer = SearchRoutingProfilesOperationDeserializer()
            operationName = "SearchRoutingProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches security profiles in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchSecurityProfiles(input: SearchSecurityProfilesRequest): SearchSecurityProfilesResponse {
        val op = SdkHttpOperation.build<SearchSecurityProfilesRequest, SearchSecurityProfilesResponse> {
            serializer = SearchSecurityProfilesOperationSerializer()
            deserializer = SearchSecurityProfilesOperationDeserializer()
            operationName = "SearchSecurityProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches users in an Amazon Connect instance, with optional filtering.
     *
     * `AfterContactWorkTimeLimit` is returned in milliseconds.
     */
    override suspend fun searchUsers(input: SearchUsersRequest): SearchUsersResponse {
        val op = SdkHttpOperation.build<SearchUsersRequest, SearchUsersResponse> {
            serializer = SearchUsersOperationSerializer()
            deserializer = SearchUsersOperationDeserializer()
            operationName = "SearchUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for vocabularies within a specific Amazon Connect instance using `State`, `NameStartsWith`, and `LanguageCode`.
     */
    override suspend fun searchVocabularies(input: SearchVocabulariesRequest): SearchVocabulariesResponse {
        val op = SdkHttpOperation.build<SearchVocabulariesRequest, SearchVocabulariesResponse> {
            serializer = SearchVocabulariesOperationSerializer()
            deserializer = SearchVocabulariesOperationDeserializer()
            operationName = "SearchVocabularies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates a flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) API in the Amazon Connect Participant Service.
     *
     * When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) with WEBSOCKET and CONNECTION_CREDENTIALS.
     *
     * A 429 error occurs in the following situations:
     * + API rate limit is exceeded. API TPS throttling returns a `TooManyRequests` exception.
     * + The [quota for concurrent active chats](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) is exceeded. Active chat throttling returns a `LimitExceededException`.
     *
     * If you use the `ChatDurationInMinutes` parameter and receive a 400 error, your account may not support the ability to configure custom chat durations. For more information, contact Amazon Web Services Support.
     *
     * For more information about chat, see [Chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun startChatContact(input: StartChatContactRequest): StartChatContactResponse {
        val op = SdkHttpOperation.build<StartChatContactRequest, StartChatContactResponse> {
            serializer = StartChatContactOperationSerializer()
            deserializer = StartChatContactOperationDeserializer()
            operationName = "StartChatContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts an empty evaluation in the specified Amazon Connect instance, using the given evaluation form for the particular contact. The evaluation form version used for the contact evaluation corresponds to the currently activated version. If no version is activated for the evaluation form, the contact evaluation cannot be started.
     *
     * Evaluations created through the public API do not contain answer values suggested from automation.
     */
    override suspend fun startContactEvaluation(input: StartContactEvaluationRequest): StartContactEvaluationResponse {
        val op = SdkHttpOperation.build<StartContactEvaluationRequest, StartContactEvaluationResponse> {
            serializer = StartContactEvaluationOperationSerializer()
            deserializer = StartContactEvaluationOperationDeserializer()
            operationName = "StartContactEvaluation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts recording the contact:
     * + If the API is called *before* the agent joins the call, recording starts when the agent joins the call.
     * + If the API is called *after* the agent joins the call, recording starts at the time of the API call.
     *
     * StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.
     *
     * You can use this API to override the recording behavior configured in the [Set recording behavior](https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html) block.
     *
     * Only voice recordings are supported at this time.
     */
    override suspend fun startContactRecording(input: StartContactRecordingRequest): StartContactRecordingResponse {
        val op = SdkHttpOperation.build<StartContactRecordingRequest, StartContactRecordingResponse> {
            serializer = StartContactRecordingOperationSerializer()
            deserializer = StartContactRecordingOperationDeserializer()
            operationName = "StartContactRecording"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates real-time message streaming for a new chat contact.
     *
     *  For more information about message streaming, see [Enable real-time chat message streaming](https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun startContactStreaming(input: StartContactStreamingRequest): StartContactStreamingResponse {
        val op = SdkHttpOperation.build<StartContactStreamingRequest, StartContactStreamingResponse> {
            serializer = StartContactStreamingOperationSerializer()
            deserializer = StartContactStreamingOperationDeserializer()
            operationName = "StartContactStreaming"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Places an outbound call to a contact, and then initiates the flow. It performs the actions in the flow that's specified (in `ContactFlowId`).
     *
     * Agents do not initiate the outbound API, which means that they do not dial the contact. If the flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.
     *
     * There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.
     *
     * UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     *
     * Campaign calls are not allowed by default. Before you can make a call with `TrafficType` = `CAMPAIGN`, you must submit a service quota increase request to the quota [Amazon Connect campaigns](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#outbound-communications-quotas).
     */
    override suspend fun startOutboundVoiceContact(input: StartOutboundVoiceContactRequest): StartOutboundVoiceContactResponse {
        val op = SdkHttpOperation.build<StartOutboundVoiceContactRequest, StartOutboundVoiceContactResponse> {
            serializer = StartOutboundVoiceContactOperationSerializer()
            deserializer = StartOutboundVoiceContactOperationDeserializer()
            operationName = "StartOutboundVoiceContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates a flow to start a new task contact. For more information about task contacts, see [Concepts: Tasks in Amazon Connect](https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html) in the *Amazon Connect Administrator Guide*.
     *
     * When using `PreviousContactId` and `RelatedContactId` input parameters, note the following:
     * + `PreviousContactId`
     *    + Any updates to user-defined task contact attributes on any contact linked through the same `PreviousContactId` will affect every contact in the chain.
     *    + There can be a maximum of 12 linked task contacts in a chain. That is, 12 task contacts can be created that share the same `PreviousContactId`.
     * + `RelatedContactId`
     *    + Copies contact attributes from the related task contact to the new contact.
     *    + Any update on attributes in a new task contact does not update attributes on previous contact.
     *    + There’s no limit on the number of task contacts that can be created that use the same `RelatedContactId`.
     *
     * In addition, when calling StartTaskContact include only one of these parameters: `ContactFlowID`, `QuickConnectID`, or `TaskTemplateID`. Only one parameter is required as long as the task template has a flow configured to run it. If more than one parameter is specified, or only the `TaskTemplateID` is specified but it does not have a flow configured, the request returns an error because Amazon Connect cannot identify the unique flow to run when the task is created.
     *
     * A `ServiceQuotaExceededException` occurs when the number of open tasks exceeds the active tasks quota or there are already 12 tasks referencing the same `PreviousContactId`. For more information about service quotas for task contacts, see [Amazon Connect service quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun startTaskContact(input: StartTaskContactRequest): StartTaskContactResponse {
        val op = SdkHttpOperation.build<StartTaskContactRequest, StartTaskContactResponse> {
            serializer = StartTaskContactOperationSerializer()
            deserializer = StartTaskContactOperationDeserializer()
            operationName = "StartTaskContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Ends the specified contact. This call does not work for voice contacts that use the following initiation methods:
     * + DISCONNECT
     * + TRANSFER
     * + QUEUE_TRANSFER
     *
     * Chat and task contacts, however, can be terminated in any state, regardless of initiation method.
     */
    override suspend fun stopContact(input: StopContactRequest): StopContactResponse {
        val op = SdkHttpOperation.build<StopContactRequest, StopContactResponse> {
            serializer = StopContactOperationSerializer()
            deserializer = StopContactOperationDeserializer()
            operationName = "StopContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
     *
     * Only voice recordings are supported at this time.
     */
    override suspend fun stopContactRecording(input: StopContactRecordingRequest): StopContactRecordingResponse {
        val op = SdkHttpOperation.build<StopContactRecordingRequest, StopContactRecordingResponse> {
            serializer = StopContactRecordingOperationSerializer()
            deserializer = StopContactRecordingOperationDeserializer()
            operationName = "StopContactRecording"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Ends message streaming on a specified contact. To restart message streaming on that contact, call the [StartContactStreaming](https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html) API.
     */
    override suspend fun stopContactStreaming(input: StopContactStreamingRequest): StopContactStreamingResponse {
        val op = SdkHttpOperation.build<StopContactStreamingRequest, StopContactStreamingResponse> {
            serializer = StopContactStreamingOperationSerializer()
            deserializer = StopContactStreamingOperationDeserializer()
            operationName = "StopContactStreaming"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Submits a contact evaluation in the specified Amazon Connect instance. Answers included in the request are merged with existing answers for the given evaluation. If no answers or notes are passed, the evaluation is submitted with the existing answers and notes. You can delete an answer or note by passing an empty object (`{}`) to the question identifier.
     *
     * If a contact evaluation is already in submitted state, this operation will trigger a resubmission.
     */
    override suspend fun submitContactEvaluation(input: SubmitContactEvaluationRequest): SubmitContactEvaluationResponse {
        val op = SdkHttpOperation.build<SubmitContactEvaluationRequest, SubmitContactEvaluationResponse> {
            serializer = SubmitContactEvaluationOperationSerializer()
            deserializer = SubmitContactEvaluationOperationDeserializer()
            operationName = "SubmitContactEvaluation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * When a contact is being recorded, this API suspends recording whatever is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would be suspended. For example, you might suspend the screen recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording the screen.
     *
     * The period of time that the recording is suspended is filled with silence in the final recording.
     *
     * Voice and screen recordings are supported.
     */
    override suspend fun suspendContactRecording(input: SuspendContactRecordingRequest): SuspendContactRecordingResponse {
        val op = SdkHttpOperation.build<SuspendContactRecordingRequest, SuspendContactRecordingResponse> {
            serializer = SuspendContactRecordingOperationSerializer()
            deserializer = SuspendContactRecordingOperationDeserializer()
            operationName = "SuspendContactRecording"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified tags to the specified resource.
     *
     * Some of the supported resource types are agents, routing profiles, queues, quick connects, contact flows, agent statuses, hours of operation, phone numbers, security profiles, and task templates. For a complete list, see [Tagging resources in Amazon Connect](https://docs.aws.amazon.com/connect/latest/adminguide/tagging.html).
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Transfers contacts from one agent or queue to another agent or queue at any point after a contact is created. You can transfer a contact to another queue by providing the flow which orchestrates the contact to the destination queue. This gives you more control over contact handling and helps you adhere to the service level agreement (SLA) guaranteed to your customers.
     *
     * Note the following requirements:
     * + Transfer is supported for only `TASK` contacts.
     * + Do not use both `QueueId` and `UserId` in the same call.
     * + The following flow types are supported: Inbound flow, Transfer to agent flow, and Transfer to queue flow.
     * + The `TransferContact` API can be called only on active contacts.
     * + A contact cannot be transferred more than 11 times.
     */
    override suspend fun transferContact(input: TransferContactRequest): TransferContactResponse {
        val op = SdkHttpOperation.build<TransferContactRequest, TransferContactResponse> {
            serializer = TransferContactOperationSerializer()
            deserializer = TransferContactOperationDeserializer()
            operationName = "TransferContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates agent status.
     */
    override suspend fun updateAgentStatus(input: UpdateAgentStatusRequest): UpdateAgentStatusResponse {
        val op = SdkHttpOperation.build<UpdateAgentStatusRequest, UpdateAgentStatusResponse> {
            serializer = UpdateAgentStatusOperationSerializer()
            deserializer = UpdateAgentStatusOperationDeserializer()
            operationName = "UpdateAgentStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.
     *
     * You can add or update user-defined contact information for both ongoing and completed contacts.
     */
    override suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse {
        val op = SdkHttpOperation.build<UpdateContactRequest, UpdateContactResponse> {
            serializer = UpdateContactOperationSerializer()
            deserializer = UpdateContactOperationDeserializer()
            operationName = "UpdateContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates user-defined contact attributes associated with the specified contact.
     *
     * You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer's name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.
     *
     * Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about contact record retention and the maximum size of the contact record attributes section, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun updateContactAttributes(input: UpdateContactAttributesRequest): UpdateContactAttributesResponse {
        val op = SdkHttpOperation.build<UpdateContactAttributesRequest, UpdateContactAttributesResponse> {
            serializer = UpdateContactAttributesOperationSerializer()
            deserializer = UpdateContactAttributesOperationDeserializer()
            operationName = "UpdateContactAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates details about a contact evaluation in the specified Amazon Connect instance. A contact evaluation must be in draft state. Answers included in the request are merged with existing answers for the given evaluation. An answer or note can be deleted by passing an empty object (`{}`) to the question identifier.
     */
    override suspend fun updateContactEvaluation(input: UpdateContactEvaluationRequest): UpdateContactEvaluationResponse {
        val op = SdkHttpOperation.build<UpdateContactEvaluationRequest, UpdateContactEvaluationResponse> {
            serializer = UpdateContactEvaluationOperationSerializer()
            deserializer = UpdateContactEvaluationOperationDeserializer()
            operationName = "UpdateContactEvaluation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    override suspend fun updateContactFlowContent(input: UpdateContactFlowContentRequest): UpdateContactFlowContentResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowContentRequest, UpdateContactFlowContentResponse> {
            serializer = UpdateContactFlowContentOperationSerializer()
            deserializer = UpdateContactFlowContentOperationDeserializer()
            operationName = "UpdateContactFlowContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates metadata about specified flow.
     */
    override suspend fun updateContactFlowMetadata(input: UpdateContactFlowMetadataRequest): UpdateContactFlowMetadataResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowMetadataRequest, UpdateContactFlowMetadataResponse> {
            serializer = UpdateContactFlowMetadataOperationSerializer()
            deserializer = UpdateContactFlowMetadataOperationDeserializer()
            operationName = "UpdateContactFlowMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates specified flow module for the specified Amazon Connect instance.
     */
    override suspend fun updateContactFlowModuleContent(input: UpdateContactFlowModuleContentRequest): UpdateContactFlowModuleContentResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowModuleContentRequest, UpdateContactFlowModuleContentResponse> {
            serializer = UpdateContactFlowModuleContentOperationSerializer()
            deserializer = UpdateContactFlowModuleContentOperationDeserializer()
            operationName = "UpdateContactFlowModuleContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates metadata about specified flow module.
     */
    override suspend fun updateContactFlowModuleMetadata(input: UpdateContactFlowModuleMetadataRequest): UpdateContactFlowModuleMetadataResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowModuleMetadataRequest, UpdateContactFlowModuleMetadataResponse> {
            serializer = UpdateContactFlowModuleMetadataOperationSerializer()
            deserializer = UpdateContactFlowModuleMetadataOperationDeserializer()
            operationName = "UpdateContactFlowModuleMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The name of the flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    override suspend fun updateContactFlowName(input: UpdateContactFlowNameRequest): UpdateContactFlowNameResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowNameRequest, UpdateContactFlowNameResponse> {
            serializer = UpdateContactFlowNameOperationSerializer()
            deserializer = UpdateContactFlowNameOperationDeserializer()
            operationName = "UpdateContactFlowName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the scheduled time of a task contact that is already scheduled.
     */
    override suspend fun updateContactSchedule(input: UpdateContactScheduleRequest): UpdateContactScheduleResponse {
        val op = SdkHttpOperation.build<UpdateContactScheduleRequest, UpdateContactScheduleResponse> {
            serializer = UpdateContactScheduleOperationSerializer()
            deserializer = UpdateContactScheduleOperationDeserializer()
            operationName = "UpdateContactSchedule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates details about a specific evaluation form version in the specified Amazon Connect instance. Question and section identifiers cannot be duplicated within the same evaluation form.
     *
     * This operation does not support partial updates. Instead it does a full update of evaluation form content.
     */
    override suspend fun updateEvaluationForm(input: UpdateEvaluationFormRequest): UpdateEvaluationFormResponse {
        val op = SdkHttpOperation.build<UpdateEvaluationFormRequest, UpdateEvaluationFormResponse> {
            serializer = UpdateEvaluationFormOperationSerializer()
            deserializer = UpdateEvaluationFormOperationDeserializer()
            operationName = "UpdateEvaluationForm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation.
     */
    override suspend fun updateHoursOfOperation(input: UpdateHoursOfOperationRequest): UpdateHoursOfOperationResponse {
        val op = SdkHttpOperation.build<UpdateHoursOfOperationRequest, UpdateHoursOfOperationResponse> {
            serializer = UpdateHoursOfOperationOperationSerializer()
            deserializer = UpdateHoursOfOperationOperationDeserializer()
            operationName = "UpdateHoursOfOperation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the value for the specified attribute type.
     */
    override suspend fun updateInstanceAttribute(input: UpdateInstanceAttributeRequest): UpdateInstanceAttributeResponse {
        val op = SdkHttpOperation.build<UpdateInstanceAttributeRequest, UpdateInstanceAttributeResponse> {
            serializer = UpdateInstanceAttributeOperationSerializer()
            deserializer = UpdateInstanceAttributeOperationDeserializer()
            operationName = "UpdateInstanceAttribute"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates an existing configuration for a resource type. This API is idempotent.
     */
    override suspend fun updateInstanceStorageConfig(input: UpdateInstanceStorageConfigRequest): UpdateInstanceStorageConfigResponse {
        val op = SdkHttpOperation.build<UpdateInstanceStorageConfigRequest, UpdateInstanceStorageConfigResponse> {
            serializer = UpdateInstanceStorageConfigOperationSerializer()
            deserializer = UpdateInstanceStorageConfigOperationDeserializer()
            operationName = "UpdateInstanceStorageConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates timeouts for when human chat participants are to be considered idle, and when agents are automatically disconnected from a chat due to idleness. You can set four timers:
     * + Customer idle timeout
     * + Customer auto-disconnect timeout
     * + Agent idle timeout
     * + Agent auto-disconnect timeout
     *
     * For more information about how chat timeouts work, see [Set up chat timeouts for human participants](https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html).
     */
    override suspend fun updateParticipantRoleConfig(input: UpdateParticipantRoleConfigRequest): UpdateParticipantRoleConfigResponse {
        val op = SdkHttpOperation.build<UpdateParticipantRoleConfigRequest, UpdateParticipantRoleConfigResponse> {
            serializer = UpdateParticipantRoleConfigOperationSerializer()
            deserializer = UpdateParticipantRoleConfigOperationDeserializer()
            operationName = "UpdateParticipantRoleConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates your claimed phone number from its current Amazon Connect instance or traffic distribution group to another Amazon Connect instance or traffic distribution group in the same Amazon Web Services Region.
     *
     * After using this API, you must verify that the phone number is attached to the correct flow in the target instance or traffic distribution group. You need to do this because the API switches only the phone number to a new instance or traffic distribution group. It doesn't migrate the flow configuration of the phone number, too.
     *
     * You can call [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API to verify the status of a previous [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation.
     */
    override suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse {
        val op = SdkHttpOperation.build<UpdatePhoneNumberRequest, UpdatePhoneNumberResponse> {
            serializer = UpdatePhoneNumberOperationSerializer()
            deserializer = UpdatePhoneNumberOperationDeserializer()
            operationName = "UpdatePhoneNumber"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a phone number’s metadata.
     *
     * To verify the status of a previous UpdatePhoneNumberMetadata operation, call the [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API.
     */
    override suspend fun updatePhoneNumberMetadata(input: UpdatePhoneNumberMetadataRequest): UpdatePhoneNumberMetadataResponse {
        val op = SdkHttpOperation.build<UpdatePhoneNumberMetadataRequest, UpdatePhoneNumberMetadataResponse> {
            serializer = UpdatePhoneNumberMetadataOperationSerializer()
            deserializer = UpdatePhoneNumberMetadataOperationDeserializer()
            operationName = "UpdatePhoneNumberMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a prompt.
     */
    override suspend fun updatePrompt(input: UpdatePromptRequest): UpdatePromptResponse {
        val op = SdkHttpOperation.build<UpdatePromptRequest, UpdatePromptResponse> {
            serializer = UpdatePromptOperationSerializer()
            deserializer = UpdatePromptOperationDeserializer()
            operationName = "UpdatePrompt"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation for the specified queue.
     */
    override suspend fun updateQueueHoursOfOperation(input: UpdateQueueHoursOfOperationRequest): UpdateQueueHoursOfOperationResponse {
        val op = SdkHttpOperation.build<UpdateQueueHoursOfOperationRequest, UpdateQueueHoursOfOperationResponse> {
            serializer = UpdateQueueHoursOfOperationOperationSerializer()
            deserializer = UpdateQueueHoursOfOperationOperationDeserializer()
            operationName = "UpdateQueueHoursOfOperation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the maximum number of contacts allowed in a queue before it is considered full.
     */
    override suspend fun updateQueueMaxContacts(input: UpdateQueueMaxContactsRequest): UpdateQueueMaxContactsResponse {
        val op = SdkHttpOperation.build<UpdateQueueMaxContactsRequest, UpdateQueueMaxContactsResponse> {
            serializer = UpdateQueueMaxContactsOperationSerializer()
            deserializer = UpdateQueueMaxContactsOperationDeserializer()
            operationName = "UpdateQueueMaxContacts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the name and description of a queue. At least `Name` or `Description` must be provided.
     */
    override suspend fun updateQueueName(input: UpdateQueueNameRequest): UpdateQueueNameResponse {
        val op = SdkHttpOperation.build<UpdateQueueNameRequest, UpdateQueueNameResponse> {
            serializer = UpdateQueueNameOperationSerializer()
            deserializer = UpdateQueueNameOperationDeserializer()
            operationName = "UpdateQueueName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.
     *
     * + If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for `OutboundCallerIdNumberId`. However, if the phone number is claimed to a traffic distribution group that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     * + Only use the phone number ARN format that doesn't contain `instance` in the path, for example, `arn:aws:connect:us-east-1:1234567890:phone-number/uuid`. This is the same ARN format that is returned when you call the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API.
     * + If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic distribution group, see [Allow or Deny queue API actions for phone numbers in a replica Region](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region).
     */
    override suspend fun updateQueueOutboundCallerConfig(input: UpdateQueueOutboundCallerConfigRequest): UpdateQueueOutboundCallerConfigResponse {
        val op = SdkHttpOperation.build<UpdateQueueOutboundCallerConfigRequest, UpdateQueueOutboundCallerConfigResponse> {
            serializer = UpdateQueueOutboundCallerConfigOperationSerializer()
            deserializer = UpdateQueueOutboundCallerConfigOperationDeserializer()
            operationName = "UpdateQueueOutboundCallerConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the status of the queue.
     */
    override suspend fun updateQueueStatus(input: UpdateQueueStatusRequest): UpdateQueueStatusResponse {
        val op = SdkHttpOperation.build<UpdateQueueStatusRequest, UpdateQueueStatusResponse> {
            serializer = UpdateQueueStatusOperationSerializer()
            deserializer = UpdateQueueStatusOperationDeserializer()
            operationName = "UpdateQueueStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration settings for the specified quick connect.
     */
    override suspend fun updateQuickConnectConfig(input: UpdateQuickConnectConfigRequest): UpdateQuickConnectConfigResponse {
        val op = SdkHttpOperation.build<UpdateQuickConnectConfigRequest, UpdateQuickConnectConfigResponse> {
            serializer = UpdateQuickConnectConfigOperationSerializer()
            deserializer = UpdateQuickConnectConfigOperationDeserializer()
            operationName = "UpdateQuickConnectConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    override suspend fun updateQuickConnectName(input: UpdateQuickConnectNameRequest): UpdateQuickConnectNameResponse {
        val op = SdkHttpOperation.build<UpdateQuickConnectNameRequest, UpdateQuickConnectNameResponse> {
            serializer = UpdateQuickConnectNameOperationSerializer()
            deserializer = UpdateQuickConnectNameOperationDeserializer()
            operationName = "UpdateQuickConnectName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Whether agents with this routing profile will have their routing order calculated based on *time since their last inbound contact* or *longest idle time*.
     */
    override suspend fun updateRoutingProfileAgentAvailabilityTimer(input: UpdateRoutingProfileAgentAvailabilityTimerRequest): UpdateRoutingProfileAgentAvailabilityTimerResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileAgentAvailabilityTimerRequest, UpdateRoutingProfileAgentAvailabilityTimerResponse> {
            serializer = UpdateRoutingProfileAgentAvailabilityTimerOperationSerializer()
            deserializer = UpdateRoutingProfileAgentAvailabilityTimerOperationDeserializer()
            operationName = "UpdateRoutingProfileAgentAvailabilityTimer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
     */
    override suspend fun updateRoutingProfileConcurrency(input: UpdateRoutingProfileConcurrencyRequest): UpdateRoutingProfileConcurrencyResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileConcurrencyRequest, UpdateRoutingProfileConcurrencyResponse> {
            serializer = UpdateRoutingProfileConcurrencyOperationSerializer()
            deserializer = UpdateRoutingProfileConcurrencyOperationDeserializer()
            operationName = "UpdateRoutingProfileConcurrency"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the default outbound queue of a routing profile.
     */
    override suspend fun updateRoutingProfileDefaultOutboundQueue(input: UpdateRoutingProfileDefaultOutboundQueueRequest): UpdateRoutingProfileDefaultOutboundQueueResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileDefaultOutboundQueueRequest, UpdateRoutingProfileDefaultOutboundQueueResponse> {
            serializer = UpdateRoutingProfileDefaultOutboundQueueOperationSerializer()
            deserializer = UpdateRoutingProfileDefaultOutboundQueueOperationDeserializer()
            operationName = "UpdateRoutingProfileDefaultOutboundQueue"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    override suspend fun updateRoutingProfileName(input: UpdateRoutingProfileNameRequest): UpdateRoutingProfileNameResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileNameRequest, UpdateRoutingProfileNameResponse> {
            serializer = UpdateRoutingProfileNameOperationSerializer()
            deserializer = UpdateRoutingProfileNameOperationDeserializer()
            operationName = "UpdateRoutingProfileName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the properties associated with a set of queues for a routing profile.
     */
    override suspend fun updateRoutingProfileQueues(input: UpdateRoutingProfileQueuesRequest): UpdateRoutingProfileQueuesResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileQueuesRequest, UpdateRoutingProfileQueuesResponse> {
            serializer = UpdateRoutingProfileQueuesOperationSerializer()
            deserializer = UpdateRoutingProfileQueuesOperationDeserializer()
            operationName = "UpdateRoutingProfileQueues"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a rule for the specified Amazon Connect instance.
     *
     * Use the [Rules Function language](https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html) to code conditions for the rule.
     */
    override suspend fun updateRule(input: UpdateRuleRequest): UpdateRuleResponse {
        val op = SdkHttpOperation.build<UpdateRuleRequest, UpdateRuleResponse> {
            serializer = UpdateRuleOperationSerializer()
            deserializer = UpdateRuleOperationDeserializer()
            operationName = "UpdateRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a security profile.
     */
    override suspend fun updateSecurityProfile(input: UpdateSecurityProfileRequest): UpdateSecurityProfileResponse {
        val op = SdkHttpOperation.build<UpdateSecurityProfileRequest, UpdateSecurityProfileResponse> {
            serializer = UpdateSecurityProfileOperationSerializer()
            deserializer = UpdateSecurityProfileOperationDeserializer()
            operationName = "UpdateSecurityProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.
     */
    override suspend fun updateTaskTemplate(input: UpdateTaskTemplateRequest): UpdateTaskTemplateResponse {
        val op = SdkHttpOperation.build<UpdateTaskTemplateRequest, UpdateTaskTemplateResponse> {
            serializer = UpdateTaskTemplateOperationSerializer()
            deserializer = UpdateTaskTemplateOperationDeserializer()
            operationName = "UpdateTaskTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the traffic distribution for a given traffic distribution group.
     *
     * The `SignInConfig` distribution is available only on a default `TrafficDistributionGroup` (see the `IsDefault` parameter in the [TrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html) data type). If you call `UpdateTrafficDistribution` with a modified `SignInConfig` and a non-default `TrafficDistributionGroup`, an `InvalidRequestException` is returned.
     *
     * For more information about updating a traffic distribution group, see [Update telephony traffic distribution across Amazon Web Services Regions ](https://docs.aws.amazon.com/connect/latest/adminguide/update-telephony-traffic-distribution.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun updateTrafficDistribution(input: UpdateTrafficDistributionRequest): UpdateTrafficDistributionResponse {
        val op = SdkHttpOperation.build<UpdateTrafficDistributionRequest, UpdateTrafficDistributionResponse> {
            serializer = UpdateTrafficDistributionOperationSerializer()
            deserializer = UpdateTrafficDistributionOperationDeserializer()
            operationName = "UpdateTrafficDistribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Assigns the specified hierarchy group to the specified user.
     */
    override suspend fun updateUserHierarchy(input: UpdateUserHierarchyRequest): UpdateUserHierarchyResponse {
        val op = SdkHttpOperation.build<UpdateUserHierarchyRequest, UpdateUserHierarchyResponse> {
            serializer = UpdateUserHierarchyOperationSerializer()
            deserializer = UpdateUserHierarchyOperationDeserializer()
            operationName = "UpdateUserHierarchy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name of the user hierarchy group.
     */
    override suspend fun updateUserHierarchyGroupName(input: UpdateUserHierarchyGroupNameRequest): UpdateUserHierarchyGroupNameResponse {
        val op = SdkHttpOperation.build<UpdateUserHierarchyGroupNameRequest, UpdateUserHierarchyGroupNameResponse> {
            serializer = UpdateUserHierarchyGroupNameOperationSerializer()
            deserializer = UpdateUserHierarchyGroupNameOperationDeserializer()
            operationName = "UpdateUserHierarchyGroupName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
     */
    override suspend fun updateUserHierarchyStructure(input: UpdateUserHierarchyStructureRequest): UpdateUserHierarchyStructureResponse {
        val op = SdkHttpOperation.build<UpdateUserHierarchyStructureRequest, UpdateUserHierarchyStructureResponse> {
            serializer = UpdateUserHierarchyStructureOperationSerializer()
            deserializer = UpdateUserHierarchyStructureOperationDeserializer()
            operationName = "UpdateUserHierarchyStructure"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the identity information for the specified user.
     *
     * We strongly recommend limiting who has the ability to invoke `UpdateUserIdentityInfo`. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker's email address, and then reset the password through email. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun updateUserIdentityInfo(input: UpdateUserIdentityInfoRequest): UpdateUserIdentityInfoResponse {
        val op = SdkHttpOperation.build<UpdateUserIdentityInfoRequest, UpdateUserIdentityInfoResponse> {
            serializer = UpdateUserIdentityInfoOperationSerializer()
            deserializer = UpdateUserIdentityInfoOperationDeserializer()
            operationName = "UpdateUserIdentityInfo"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the phone configuration settings for the specified user.
     */
    override suspend fun updateUserPhoneConfig(input: UpdateUserPhoneConfigRequest): UpdateUserPhoneConfigResponse {
        val op = SdkHttpOperation.build<UpdateUserPhoneConfigRequest, UpdateUserPhoneConfigResponse> {
            serializer = UpdateUserPhoneConfigOperationSerializer()
            deserializer = UpdateUserPhoneConfigOperationDeserializer()
            operationName = "UpdateUserPhoneConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Assigns the specified routing profile to the specified user.
     */
    override suspend fun updateUserRoutingProfile(input: UpdateUserRoutingProfileRequest): UpdateUserRoutingProfileResponse {
        val op = SdkHttpOperation.build<UpdateUserRoutingProfileRequest, UpdateUserRoutingProfileResponse> {
            serializer = UpdateUserRoutingProfileOperationSerializer()
            deserializer = UpdateUserRoutingProfileOperationDeserializer()
            operationName = "UpdateUserRoutingProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Assigns the specified security profiles to the specified user.
     */
    override suspend fun updateUserSecurityProfiles(input: UpdateUserSecurityProfilesRequest): UpdateUserSecurityProfilesResponse {
        val op = SdkHttpOperation.build<UpdateUserSecurityProfilesRequest, UpdateUserSecurityProfilesResponse> {
            serializer = UpdateUserSecurityProfilesOperationSerializer()
            deserializer = UpdateUserSecurityProfilesOperationDeserializer()
            operationName = "UpdateUserSecurityProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the view content of the given view identifier in the specified Amazon Connect instance.
     *
     * It performs content validation if `Status` is set to `SAVED` and performs full content validation if `Status` is `PUBLISHED`. Note that the `$SAVED` alias' content will always be updated, but the `$LATEST` alias' content will only be updated if `Status` is `PUBLISHED`.
     */
    override suspend fun updateViewContent(input: UpdateViewContentRequest): UpdateViewContentResponse {
        val op = SdkHttpOperation.build<UpdateViewContentRequest, UpdateViewContentResponse> {
            serializer = UpdateViewContentOperationSerializer()
            deserializer = UpdateViewContentOperationDeserializer()
            operationName = "UpdateViewContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the view metadata. Note that either `Name` or `Description` must be provided.
     */
    override suspend fun updateViewMetadata(input: UpdateViewMetadataRequest): UpdateViewMetadataResponse {
        val op = SdkHttpOperation.build<UpdateViewMetadataRequest, UpdateViewMetadataResponse> {
            serializer = UpdateViewMetadataOperationSerializer()
            deserializer = UpdateViewMetadataOperationDeserializer()
            operationName = "UpdateViewMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "connect")
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
    }
}
