// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.Application
import aws.sdk.kotlin.services.connect.model.UpdateSecurityProfileRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateSecurityProfileOperationSerializer: HttpSerialize<UpdateSecurityProfileRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateSecurityProfileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            requireNotNull(input.securityProfileId) { "securityProfileId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("security-profiles"))
                add(PercentEncoding.SmithyLabel.encode("${input.instanceId}"))
                add(PercentEncoding.SmithyLabel.encode("${input.securityProfileId}"))
            }
        }

        val payload = serializeUpdateSecurityProfileOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSecurityProfileOperationBody(context: ExecutionContext, input: UpdateSecurityProfileRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALLOWEDACCESSCONTROLTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("AllowedAccessControlTags"))
    val APPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Applications"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val TAGRESTRICTEDRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagRestrictedResources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWEDACCESSCONTROLTAGS_DESCRIPTOR)
        field(APPLICATIONS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(TAGRESTRICTEDRESOURCES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.allowedAccessControlTags != null) {
            mapField(ALLOWEDACCESSCONTROLTAGS_DESCRIPTOR) {
                input.allowedAccessControlTags.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.applications != null) {
            listField(APPLICATIONS_DESCRIPTOR) {
                for (el0 in input.applications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeApplicationDocument))
                }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeString(el0)
                }
            }
        }
        if (input.tagRestrictedResources != null) {
            listField(TAGRESTRICTEDRESOURCES_DESCRIPTOR) {
                for (el0 in input.tagRestrictedResources) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
