// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.SendChatIntegrationEventResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendChatIntegrationEventOperationDeserializer: HttpDeserialize<SendChatIntegrationEventResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SendChatIntegrationEventResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendChatIntegrationEventError(context, call)
        }
        val builder = SendChatIntegrationEventResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendChatIntegrationEventOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSendChatIntegrationEventError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSendChatIntegrationEventOperationBody(builder: SendChatIntegrationEventResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INITIALCONTACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InitialContactId"))
    val NEWCHATCREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("NewChatCreated"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INITIALCONTACTID_DESCRIPTOR)
        field(NEWCHATCREATED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INITIALCONTACTID_DESCRIPTOR.index -> builder.initialContactId = deserializeString()
                NEWCHATCREATED_DESCRIPTOR.index -> builder.newChatCreated = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
