// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.BatchPutContactRequest
import aws.sdk.kotlin.services.connect.model.ContactDataRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class BatchPutContactOperationSerializer: HttpSerialize<BatchPutContactRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchPutContactRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("contact"))
                add(PercentEncoding.Path.encode("batch"))
                add(PercentEncoding.SmithyLabel.encode("${input.instanceId}"))
            }
        }

        val payload = serializeBatchPutContactOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchPutContactOperationBody(context: ExecutionContext, input: BatchPutContactRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val CONTACTDATAREQUESTLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ContactDataRequestList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTACTDATAREQUESTLIST_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.contactDataRequestList != null) {
            listField(CONTACTDATAREQUESTLIST_DESCRIPTOR) {
                for (el0 in input.contactDataRequestList) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeContactDataRequestDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
