// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.AssociateAnalyticsDataSetResponse
import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AssociateAnalyticsDataSetOperationDeserializer: HttpDeserialize<AssociateAnalyticsDataSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AssociateAnalyticsDataSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssociateAnalyticsDataSetError(context, call)
        }
        val builder = AssociateAnalyticsDataSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssociateAnalyticsDataSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAssociateAnalyticsDataSetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssociateAnalyticsDataSetOperationBody(builder: AssociateAnalyticsDataSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATASETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataSetId"))
    val RESOURCESHAREARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceShareArn"))
    val RESOURCESHAREID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceShareId"))
    val TARGETACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetAccountId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASETID_DESCRIPTOR)
        field(RESOURCESHAREARN_DESCRIPTOR)
        field(RESOURCESHAREID_DESCRIPTOR)
        field(TARGETACCOUNTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATASETID_DESCRIPTOR.index -> builder.dataSetId = deserializeString()
                RESOURCESHAREARN_DESCRIPTOR.index -> builder.resourceShareArn = deserializeString()
                RESOURCESHAREID_DESCRIPTOR.index -> builder.resourceShareId = deserializeString()
                TARGETACCOUNTID_DESCRIPTOR.index -> builder.targetAccountId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
