// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Data for a user.
 */
public class UserData private constructor(builder: Builder) {
    /**
     * A map of active slots by channel. The key is a channel name. The value is an integer: the number of active slots.
     */
    public val activeSlotsByChannel: Map<String, Int>? = builder.activeSlotsByChannel
    /**
     * A map of available slots by channel. The key is a channel name. The value is an integer: the available number of slots.
     */
    public val availableSlotsByChannel: Map<String, Int>? = builder.availableSlotsByChannel
    /**
     * A list of contact reference information.
     */
    public val contacts: List<AgentContactReference>? = builder.contacts
    /**
     * Contains information about the levels of a hierarchy group assigned to a user.
     */
    public val hierarchyPath: aws.sdk.kotlin.services.connect.model.HierarchyPathReference? = builder.hierarchyPath
    /**
     * A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of slots. This is calculated from [MediaConcurrency](https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html) of the `RoutingProfile` assigned to the agent.
     */
    public val maxSlotsByChannel: Map<String, Int>? = builder.maxSlotsByChannel
    /**
     * The Next status of the agent.
     */
    public val nextStatus: kotlin.String? = builder.nextStatus
    /**
     * Information about the routing profile that is assigned to the user.
     */
    public val routingProfile: aws.sdk.kotlin.services.connect.model.RoutingProfileReference? = builder.routingProfile
    /**
     * The status of the agent that they manually set in their Contact Control Panel (CCP), or that the supervisor manually changes in the real-time metrics report.
     */
    public val status: aws.sdk.kotlin.services.connect.model.AgentStatusReference? = builder.status
    /**
     * Information about the user for the data that is returned. It contains the `resourceId` and ARN of the user.
     */
    public val user: aws.sdk.kotlin.services.connect.model.UserReference? = builder.user

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.UserData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserData(")
        append("activeSlotsByChannel=$activeSlotsByChannel,")
        append("availableSlotsByChannel=$availableSlotsByChannel,")
        append("contacts=$contacts,")
        append("hierarchyPath=$hierarchyPath,")
        append("maxSlotsByChannel=$maxSlotsByChannel,")
        append("nextStatus=$nextStatus,")
        append("routingProfile=$routingProfile,")
        append("status=$status,")
        append("user=$user")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeSlotsByChannel?.hashCode() ?: 0
        result = 31 * result + (availableSlotsByChannel?.hashCode() ?: 0)
        result = 31 * result + (contacts?.hashCode() ?: 0)
        result = 31 * result + (hierarchyPath?.hashCode() ?: 0)
        result = 31 * result + (maxSlotsByChannel?.hashCode() ?: 0)
        result = 31 * result + (nextStatus?.hashCode() ?: 0)
        result = 31 * result + (routingProfile?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserData

        if (activeSlotsByChannel != other.activeSlotsByChannel) return false
        if (availableSlotsByChannel != other.availableSlotsByChannel) return false
        if (contacts != other.contacts) return false
        if (hierarchyPath != other.hierarchyPath) return false
        if (maxSlotsByChannel != other.maxSlotsByChannel) return false
        if (nextStatus != other.nextStatus) return false
        if (routingProfile != other.routingProfile) return false
        if (status != other.status) return false
        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.UserData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of active slots by channel. The key is a channel name. The value is an integer: the number of active slots.
         */
        public var activeSlotsByChannel: Map<String, Int>? = null
        /**
         * A map of available slots by channel. The key is a channel name. The value is an integer: the available number of slots.
         */
        public var availableSlotsByChannel: Map<String, Int>? = null
        /**
         * A list of contact reference information.
         */
        public var contacts: List<AgentContactReference>? = null
        /**
         * Contains information about the levels of a hierarchy group assigned to a user.
         */
        public var hierarchyPath: aws.sdk.kotlin.services.connect.model.HierarchyPathReference? = null
        /**
         * A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of slots. This is calculated from [MediaConcurrency](https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html) of the `RoutingProfile` assigned to the agent.
         */
        public var maxSlotsByChannel: Map<String, Int>? = null
        /**
         * The Next status of the agent.
         */
        public var nextStatus: kotlin.String? = null
        /**
         * Information about the routing profile that is assigned to the user.
         */
        public var routingProfile: aws.sdk.kotlin.services.connect.model.RoutingProfileReference? = null
        /**
         * The status of the agent that they manually set in their Contact Control Panel (CCP), or that the supervisor manually changes in the real-time metrics report.
         */
        public var status: aws.sdk.kotlin.services.connect.model.AgentStatusReference? = null
        /**
         * Information about the user for the data that is returned. It contains the `resourceId` and ARN of the user.
         */
        public var user: aws.sdk.kotlin.services.connect.model.UserReference? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.UserData) : this() {
            this.activeSlotsByChannel = x.activeSlotsByChannel
            this.availableSlotsByChannel = x.availableSlotsByChannel
            this.contacts = x.contacts
            this.hierarchyPath = x.hierarchyPath
            this.maxSlotsByChannel = x.maxSlotsByChannel
            this.nextStatus = x.nextStatus
            this.routingProfile = x.routingProfile
            this.status = x.status
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.UserData = UserData(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.HierarchyPathReference] inside the given [block]
         */
        public fun hierarchyPath(block: aws.sdk.kotlin.services.connect.model.HierarchyPathReference.Builder.() -> kotlin.Unit) {
            this.hierarchyPath = aws.sdk.kotlin.services.connect.model.HierarchyPathReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.RoutingProfileReference] inside the given [block]
         */
        public fun routingProfile(block: aws.sdk.kotlin.services.connect.model.RoutingProfileReference.Builder.() -> kotlin.Unit) {
            this.routingProfile = aws.sdk.kotlin.services.connect.model.RoutingProfileReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.AgentStatusReference] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.connect.model.AgentStatusReference.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.connect.model.AgentStatusReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserReference] inside the given [block]
         */
        public fun user(block: aws.sdk.kotlin.services.connect.model.UserReference.Builder.() -> kotlin.Unit) {
            this.user = aws.sdk.kotlin.services.connect.model.UserReference.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
