// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a user account for an Amazon Connect instance.
 */
public class User private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the user account.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The identifier of the user account in the directory used for identity management.
     */
    public val directoryUserId: kotlin.String? = builder.directoryUserId
    /**
     * The identifier of the hierarchy group for the user.
     */
    public val hierarchyGroupId: kotlin.String? = builder.hierarchyGroupId
    /**
     * The identifier of the user account.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Information about the user identity.
     */
    public val identityInfo: aws.sdk.kotlin.services.connect.model.UserIdentityInfo? = builder.identityInfo
    /**
     * The Amazon Web Services Region where this resource was last modified.
     */
    public val lastModifiedRegion: kotlin.String? = builder.lastModifiedRegion
    /**
     * The timestamp when this resource was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Information about the phone configuration for the user.
     */
    public val phoneConfig: aws.sdk.kotlin.services.connect.model.UserPhoneConfig? = builder.phoneConfig
    /**
     * The identifier of the routing profile for the user.
     */
    public val routingProfileId: kotlin.String? = builder.routingProfileId
    /**
     * The identifiers of the security profiles for the user.
     */
    public val securityProfileIds: List<String>? = builder.securityProfileIds
    /**
     * The tags.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The user name assigned to the user account.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.User = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("arn=$arn,")
        append("directoryUserId=$directoryUserId,")
        append("hierarchyGroupId=$hierarchyGroupId,")
        append("id=$id,")
        append("identityInfo=$identityInfo,")
        append("lastModifiedRegion=$lastModifiedRegion,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("phoneConfig=$phoneConfig,")
        append("routingProfileId=$routingProfileId,")
        append("securityProfileIds=$securityProfileIds,")
        append("tags=$tags,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (directoryUserId?.hashCode() ?: 0)
        result = 31 * result + (hierarchyGroupId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (identityInfo?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedRegion?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (phoneConfig?.hashCode() ?: 0)
        result = 31 * result + (routingProfileId?.hashCode() ?: 0)
        result = 31 * result + (securityProfileIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as User

        if (arn != other.arn) return false
        if (directoryUserId != other.directoryUserId) return false
        if (hierarchyGroupId != other.hierarchyGroupId) return false
        if (id != other.id) return false
        if (identityInfo != other.identityInfo) return false
        if (lastModifiedRegion != other.lastModifiedRegion) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (phoneConfig != other.phoneConfig) return false
        if (routingProfileId != other.routingProfileId) return false
        if (securityProfileIds != other.securityProfileIds) return false
        if (tags != other.tags) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.User = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the user account.
         */
        public var arn: kotlin.String? = null
        /**
         * The identifier of the user account in the directory used for identity management.
         */
        public var directoryUserId: kotlin.String? = null
        /**
         * The identifier of the hierarchy group for the user.
         */
        public var hierarchyGroupId: kotlin.String? = null
        /**
         * The identifier of the user account.
         */
        public var id: kotlin.String? = null
        /**
         * Information about the user identity.
         */
        public var identityInfo: aws.sdk.kotlin.services.connect.model.UserIdentityInfo? = null
        /**
         * The Amazon Web Services Region where this resource was last modified.
         */
        public var lastModifiedRegion: kotlin.String? = null
        /**
         * The timestamp when this resource was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the phone configuration for the user.
         */
        public var phoneConfig: aws.sdk.kotlin.services.connect.model.UserPhoneConfig? = null
        /**
         * The identifier of the routing profile for the user.
         */
        public var routingProfileId: kotlin.String? = null
        /**
         * The identifiers of the security profiles for the user.
         */
        public var securityProfileIds: List<String>? = null
        /**
         * The tags.
         */
        public var tags: Map<String, String>? = null
        /**
         * The user name assigned to the user account.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.User) : this() {
            this.arn = x.arn
            this.directoryUserId = x.directoryUserId
            this.hierarchyGroupId = x.hierarchyGroupId
            this.id = x.id
            this.identityInfo = x.identityInfo
            this.lastModifiedRegion = x.lastModifiedRegion
            this.lastModifiedTime = x.lastModifiedTime
            this.phoneConfig = x.phoneConfig
            this.routingProfileId = x.routingProfileId
            this.securityProfileIds = x.securityProfileIds
            this.tags = x.tags
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.User = User(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserIdentityInfo] inside the given [block]
         */
        public fun identityInfo(block: aws.sdk.kotlin.services.connect.model.UserIdentityInfo.Builder.() -> kotlin.Unit) {
            this.identityInfo = aws.sdk.kotlin.services.connect.model.UserIdentityInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserPhoneConfig] inside the given [block]
         */
        public fun phoneConfig(block: aws.sdk.kotlin.services.connect.model.UserPhoneConfig.Builder.() -> kotlin.Unit) {
            this.phoneConfig = aws.sdk.kotlin.services.connect.model.UserPhoneConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
