// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a rule.
 */
public class Rule private constructor(builder: Builder) {
    /**
     * A list of actions to be run when the rule is triggered.
     */
    public val actions: List<RuleAction> = requireNotNull(builder.actions) { "A non-null value must be provided for actions" }
    /**
     * The timestamp for when the rule was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The conditions of the rule.
     */
    public val function: kotlin.String = requireNotNull(builder.function) { "A non-null value must be provided for function" }
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the rule.
     */
    public val lastUpdatedBy: kotlin.String = requireNotNull(builder.lastUpdatedBy) { "A non-null value must be provided for lastUpdatedBy" }
    /**
     * The timestamp for the when the rule was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedTime) { "A non-null value must be provided for lastUpdatedTime" }
    /**
     * The name of the rule.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The publish status of the rule.
     */
    public val publishStatus: aws.sdk.kotlin.services.connect.model.RulePublishStatus = requireNotNull(builder.publishStatus) { "A non-null value must be provided for publishStatus" }
    /**
     * The Amazon Resource Name (ARN) of the rule.
     */
    public val ruleArn: kotlin.String = requireNotNull(builder.ruleArn) { "A non-null value must be provided for ruleArn" }
    /**
     * A unique identifier for the rule.
     */
    public val ruleId: kotlin.String = requireNotNull(builder.ruleId) { "A non-null value must be provided for ruleId" }
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The event source to trigger the rule.
     */
    public val triggerEventSource: aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource? = builder.triggerEventSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.Rule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Rule(")
        append("actions=$actions,")
        append("createdTime=$createdTime,")
        append("function=$function,")
        append("lastUpdatedBy=$lastUpdatedBy,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("publishStatus=$publishStatus,")
        append("ruleArn=$ruleArn,")
        append("ruleId=$ruleId,")
        append("tags=$tags,")
        append("triggerEventSource=$triggerEventSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions.hashCode()
        result = 31 * result + (createdTime.hashCode())
        result = 31 * result + (function.hashCode())
        result = 31 * result + (lastUpdatedBy.hashCode())
        result = 31 * result + (lastUpdatedTime.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (publishStatus.hashCode())
        result = 31 * result + (ruleArn.hashCode())
        result = 31 * result + (ruleId.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (triggerEventSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Rule

        if (actions != other.actions) return false
        if (createdTime != other.createdTime) return false
        if (function != other.function) return false
        if (lastUpdatedBy != other.lastUpdatedBy) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (publishStatus != other.publishStatus) return false
        if (ruleArn != other.ruleArn) return false
        if (ruleId != other.ruleId) return false
        if (tags != other.tags) return false
        if (triggerEventSource != other.triggerEventSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.Rule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of actions to be run when the rule is triggered.
         */
        public var actions: List<RuleAction>? = null
        /**
         * The timestamp for when the rule was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The conditions of the rule.
         */
        public var function: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the rule.
         */
        public var lastUpdatedBy: kotlin.String? = null
        /**
         * The timestamp for the when the rule was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the rule.
         */
        public var name: kotlin.String? = null
        /**
         * The publish status of the rule.
         */
        public var publishStatus: aws.sdk.kotlin.services.connect.model.RulePublishStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the rule.
         */
        public var ruleArn: kotlin.String? = null
        /**
         * A unique identifier for the rule.
         */
        public var ruleId: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null
        /**
         * The event source to trigger the rule.
         */
        public var triggerEventSource: aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.Rule) : this() {
            this.actions = x.actions
            this.createdTime = x.createdTime
            this.function = x.function
            this.lastUpdatedBy = x.lastUpdatedBy
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.publishStatus = x.publishStatus
            this.ruleArn = x.ruleArn
            this.ruleId = x.ruleId
            this.tags = x.tags
            this.triggerEventSource = x.triggerEventSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.Rule = Rule(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource] inside the given [block]
         */
        public fun triggerEventSource(block: aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource.Builder.() -> kotlin.Unit) {
            this.triggerEventSource = aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (actions == null) actions = emptyList()
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (function == null) function = ""
            if (lastUpdatedBy == null) lastUpdatedBy = ""
            if (lastUpdatedTime == null) lastUpdatedTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (publishStatus == null) publishStatus = RulePublishStatus.SdkUnknown("no value provided")
            if (ruleArn == null) ruleArn = ""
            if (ruleId == null) ruleId = ""
            return this
        }
    }
}
