// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains information about which channels are supported, and how many contacts an agent can have on a channel simultaneously.
 */
public class MediaConcurrency private constructor(builder: Builder) {
    /**
     * The channels that agents can handle in the Contact Control Panel (CCP).
     */
    public val channel: aws.sdk.kotlin.services.connect.model.Channel = requireNotNull(builder.channel) { "A non-null value must be provided for channel" }
    /**
     * The number of contacts an agent can have on a channel simultaneously.
     *
     * Valid Range for `VOICE`: Minimum value of 1. Maximum value of 1.
     *
     * Valid Range for `CHAT`: Minimum value of 1. Maximum value of 10.
     *
     * Valid Range for `TASK`: Minimum value of 1. Maximum value of 10.
     */
    public val concurrency: kotlin.Int = requireNotNull(builder.concurrency) { "A non-null value must be provided for concurrency" }
    /**
     * Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For example, this allows you to offer an agent a different contact from another channel when they are currently working with a contact from a Voice channel.
     */
    public val crossChannelBehavior: aws.sdk.kotlin.services.connect.model.CrossChannelBehavior? = builder.crossChannelBehavior

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.MediaConcurrency = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaConcurrency(")
        append("channel=$channel,")
        append("concurrency=$concurrency,")
        append("crossChannelBehavior=$crossChannelBehavior")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channel.hashCode()
        result = 31 * result + (concurrency)
        result = 31 * result + (crossChannelBehavior?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaConcurrency

        if (channel != other.channel) return false
        if (concurrency != other.concurrency) return false
        if (crossChannelBehavior != other.crossChannelBehavior) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.MediaConcurrency = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The channels that agents can handle in the Contact Control Panel (CCP).
         */
        public var channel: aws.sdk.kotlin.services.connect.model.Channel? = null
        /**
         * The number of contacts an agent can have on a channel simultaneously.
         *
         * Valid Range for `VOICE`: Minimum value of 1. Maximum value of 1.
         *
         * Valid Range for `CHAT`: Minimum value of 1. Maximum value of 10.
         *
         * Valid Range for `TASK`: Minimum value of 1. Maximum value of 10.
         */
        public var concurrency: kotlin.Int? = null
        /**
         * Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For example, this allows you to offer an agent a different contact from another channel when they are currently working with a contact from a Voice channel.
         */
        public var crossChannelBehavior: aws.sdk.kotlin.services.connect.model.CrossChannelBehavior? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.MediaConcurrency) : this() {
            this.channel = x.channel
            this.concurrency = x.concurrency
            this.crossChannelBehavior = x.crossChannelBehavior
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.MediaConcurrency = MediaConcurrency(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.CrossChannelBehavior] inside the given [block]
         */
        public fun crossChannelBehavior(block: aws.sdk.kotlin.services.connect.model.CrossChannelBehavior.Builder.() -> kotlin.Unit) {
            this.crossChannelBehavior = aws.sdk.kotlin.services.connect.model.CrossChannelBehavior.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (channel == null) channel = Channel.SdkUnknown("no value provided")
            if (concurrency == null) concurrency = 0
            return this
        }
    }
}
