// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class ListTaskTemplatesRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of results to return per page.
     *
     * It is not expected that you set this.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The name of the task template.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     *
     * It is not expected that you set this because the value returned in the previous response is always null.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it. Tasks can only be created from `ACTIVE` templates. If a template is marked as `INACTIVE`, then a task that refers to this template cannot be created.
     */
    public val status: aws.sdk.kotlin.services.connect.model.TaskTemplateStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ListTaskTemplatesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTaskTemplatesRequest(")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("name=$name,")
        append("nextToken=$nextToken,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTaskTemplatesRequest

        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ListTaskTemplatesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         *
         * It is not expected that you set this.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The name of the task template.
         */
        public var name: kotlin.String? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         *
         * It is not expected that you set this because the value returned in the previous response is always null.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it. Tasks can only be created from `ACTIVE` templates. If a template is marked as `INACTIVE`, then a task that refers to this template cannot be created.
         */
        public var status: aws.sdk.kotlin.services.connect.model.TaskTemplateStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ListTaskTemplatesRequest) : this() {
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.name = x.name
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ListTaskTemplatesRequest = ListTaskTemplatesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
