// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a contact evaluation.
 */
public class EvaluationSummary private constructor(builder: Builder) {
    /**
     * The timestamp for when the evaluation was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The Amazon Resource Name (ARN) for the contact evaluation resource.
     */
    public val evaluationArn: kotlin.String = requireNotNull(builder.evaluationArn) { "A non-null value must be provided for evaluationArn" }
    /**
     * The unique identifier for the evaluation form.
     */
    public val evaluationFormId: kotlin.String = requireNotNull(builder.evaluationFormId) { "A non-null value must be provided for evaluationFormId" }
    /**
     * A title of the evaluation form.
     */
    public val evaluationFormTitle: kotlin.String = requireNotNull(builder.evaluationFormTitle) { "A non-null value must be provided for evaluationFormTitle" }
    /**
     * A unique identifier for the contact evaluation.
     */
    public val evaluationId: kotlin.String = requireNotNull(builder.evaluationId) { "A non-null value must be provided for evaluationId" }
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation.
     */
    public val evaluatorArn: kotlin.String = requireNotNull(builder.evaluatorArn) { "A non-null value must be provided for evaluatorArn" }
    /**
     * The timestamp for when the evaluation was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The overall score of the contact evaluation.
     */
    public val score: aws.sdk.kotlin.services.connect.model.EvaluationScore? = builder.score
    /**
     * The status of the contact evaluation.
     */
    public val status: aws.sdk.kotlin.services.connect.model.EvaluationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.EvaluationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationSummary(")
        append("createdTime=$createdTime,")
        append("evaluationArn=$evaluationArn,")
        append("evaluationFormId=$evaluationFormId,")
        append("evaluationFormTitle=$evaluationFormTitle,")
        append("evaluationId=$evaluationId,")
        append("evaluatorArn=$evaluatorArn,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("score=$score,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime.hashCode()
        result = 31 * result + (evaluationArn.hashCode())
        result = 31 * result + (evaluationFormId.hashCode())
        result = 31 * result + (evaluationFormTitle.hashCode())
        result = 31 * result + (evaluationId.hashCode())
        result = 31 * result + (evaluatorArn.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (score?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationSummary

        if (createdTime != other.createdTime) return false
        if (evaluationArn != other.evaluationArn) return false
        if (evaluationFormId != other.evaluationFormId) return false
        if (evaluationFormTitle != other.evaluationFormTitle) return false
        if (evaluationId != other.evaluationId) return false
        if (evaluatorArn != other.evaluatorArn) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (score != other.score) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.EvaluationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp for when the evaluation was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the contact evaluation resource.
         */
        public var evaluationArn: kotlin.String? = null
        /**
         * The unique identifier for the evaluation form.
         */
        public var evaluationFormId: kotlin.String? = null
        /**
         * A title of the evaluation form.
         */
        public var evaluationFormTitle: kotlin.String? = null
        /**
         * A unique identifier for the contact evaluation.
         */
        public var evaluationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation.
         */
        public var evaluatorArn: kotlin.String? = null
        /**
         * The timestamp for when the evaluation was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The overall score of the contact evaluation.
         */
        public var score: aws.sdk.kotlin.services.connect.model.EvaluationScore? = null
        /**
         * The status of the contact evaluation.
         */
        public var status: aws.sdk.kotlin.services.connect.model.EvaluationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.EvaluationSummary) : this() {
            this.createdTime = x.createdTime
            this.evaluationArn = x.evaluationArn
            this.evaluationFormId = x.evaluationFormId
            this.evaluationFormTitle = x.evaluationFormTitle
            this.evaluationId = x.evaluationId
            this.evaluatorArn = x.evaluatorArn
            this.lastModifiedTime = x.lastModifiedTime
            this.score = x.score
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.EvaluationSummary = EvaluationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.EvaluationScore] inside the given [block]
         */
        public fun score(block: aws.sdk.kotlin.services.connect.model.EvaluationScore.Builder.() -> kotlin.Unit) {
            this.score = aws.sdk.kotlin.services.connect.model.EvaluationScore.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (evaluationArn == null) evaluationArn = ""
            if (evaluationFormId == null) evaluationFormId = ""
            if (evaluationFormTitle == null) evaluationFormTitle = ""
            if (evaluationId == null) evaluationId = ""
            if (evaluatorArn == null) evaluatorArn = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (status == null) status = EvaluationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
