// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about an evaluation form.
 */
public class EvaluationFormSummary private constructor(builder: Builder) {
    /**
     * The version of the active evaluation form version.
     */
    public val activeVersion: kotlin.Int? = builder.activeVersion
    /**
     * The Amazon Resource Name (ARN) of the user who created the evaluation form.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The timestamp for when the evaluation form was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The Amazon Resource Name (ARN) for the evaluation form resource.
     */
    public val evaluationFormArn: kotlin.String = requireNotNull(builder.evaluationFormArn) { "A non-null value must be provided for evaluationFormArn" }
    /**
     * The unique identifier for the evaluation form.
     */
    public val evaluationFormId: kotlin.String = requireNotNull(builder.evaluationFormId) { "A non-null value must be provided for evaluationFormId" }
    /**
     * The Amazon Resource Name (ARN) of the user who last activated the evaluation form.
     */
    public val lastActivatedBy: kotlin.String? = builder.lastActivatedBy
    /**
     * The timestamp for when the evaluation form was last activated.
     */
    public val lastActivatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastActivatedTime
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
     */
    public val lastModifiedBy: kotlin.String = requireNotNull(builder.lastModifiedBy) { "A non-null value must be provided for lastModifiedBy" }
    /**
     * The timestamp for when the evaluation form was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The version number of the latest evaluation form version.
     */
    public val latestVersion: kotlin.Int = builder.latestVersion
    /**
     * A title of the evaluation form.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.EvaluationFormSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationFormSummary(")
        append("activeVersion=$activeVersion,")
        append("createdBy=$createdBy,")
        append("createdTime=$createdTime,")
        append("evaluationFormArn=$evaluationFormArn,")
        append("evaluationFormId=$evaluationFormId,")
        append("lastActivatedBy=$lastActivatedBy,")
        append("lastActivatedTime=$lastActivatedTime,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("latestVersion=$latestVersion,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeVersion ?: 0
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (createdTime.hashCode())
        result = 31 * result + (evaluationFormArn.hashCode())
        result = 31 * result + (evaluationFormId.hashCode())
        result = 31 * result + (lastActivatedBy?.hashCode() ?: 0)
        result = 31 * result + (lastActivatedTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (latestVersion)
        result = 31 * result + (title.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationFormSummary

        if (activeVersion != other.activeVersion) return false
        if (createdBy != other.createdBy) return false
        if (createdTime != other.createdTime) return false
        if (evaluationFormArn != other.evaluationFormArn) return false
        if (evaluationFormId != other.evaluationFormId) return false
        if (lastActivatedBy != other.lastActivatedBy) return false
        if (lastActivatedTime != other.lastActivatedTime) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (latestVersion != other.latestVersion) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.EvaluationFormSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The version of the active evaluation form version.
         */
        public var activeVersion: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the user who created the evaluation form.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The timestamp for when the evaluation form was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the evaluation form resource.
         */
        public var evaluationFormArn: kotlin.String? = null
        /**
         * The unique identifier for the evaluation form.
         */
        public var evaluationFormId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last activated the evaluation form.
         */
        public var lastActivatedBy: kotlin.String? = null
        /**
         * The timestamp for when the evaluation form was last activated.
         */
        public var lastActivatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The timestamp for when the evaluation form was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version number of the latest evaluation form version.
         */
        public var latestVersion: kotlin.Int = 0
        /**
         * A title of the evaluation form.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.EvaluationFormSummary) : this() {
            this.activeVersion = x.activeVersion
            this.createdBy = x.createdBy
            this.createdTime = x.createdTime
            this.evaluationFormArn = x.evaluationFormArn
            this.evaluationFormId = x.evaluationFormId
            this.lastActivatedBy = x.lastActivatedBy
            this.lastActivatedTime = x.lastActivatedTime
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.latestVersion = x.latestVersion
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.EvaluationFormSummary = EvaluationFormSummary(this)

        internal fun correctErrors(): Builder {
            if (createdBy == null) createdBy = ""
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (evaluationFormArn == null) evaluationFormArn = ""
            if (evaluationFormId == null) evaluationFormId = ""
            if (lastModifiedBy == null) lastModifiedBy = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (title == null) title = ""
            return this
        }
    }
}
