// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * The encryption configuration.
 */
public class EncryptionConfig private constructor(builder: Builder) {
    /**
     * The type of encryption.
     */
    public val encryptionType: aws.sdk.kotlin.services.connect.model.EncryptionType = requireNotNull(builder.encryptionType) { "A non-null value must be provided for encryptionType" }
    /**
     * The full ARN of the encryption key.
     *
     * Be sure to provide the full ARN of the encryption key, not just the ID.
     *
     * Amazon Connect supports only KMS keys with the default key spec of `SYMMETRIC_DEFAULT`[](https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-symmetric-default).
     */
    public val keyId: kotlin.String = requireNotNull(builder.keyId) { "A non-null value must be provided for keyId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.EncryptionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfig(")
        append("encryptionType=$encryptionType,")
        append("keyId=$keyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionType.hashCode()
        result = 31 * result + (keyId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfig

        if (encryptionType != other.encryptionType) return false
        if (keyId != other.keyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.EncryptionConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of encryption.
         */
        public var encryptionType: aws.sdk.kotlin.services.connect.model.EncryptionType? = null
        /**
         * The full ARN of the encryption key.
         *
         * Be sure to provide the full ARN of the encryption key, not just the ID.
         *
         * Amazon Connect supports only KMS keys with the default key spec of `SYMMETRIC_DEFAULT`[](https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-symmetric-default).
         */
        public var keyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.EncryptionConfig) : this() {
            this.encryptionType = x.encryptionType
            this.keyId = x.keyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.EncryptionConfig = EncryptionConfig(this)

        internal fun correctErrors(): Builder {
            if (encryptionType == null) encryptionType = EncryptionType.SdkUnknown("no value provided")
            if (keyId == null) keyId = ""
            return this
        }
    }
}
