// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class CreateRuleRequest private constructor(builder: Builder) {
    /**
     * A list of actions to be run when the rule is triggered.
     */
    public val actions: List<RuleAction>? = builder.actions
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The conditions of the rule.
     */
    public val function: kotlin.String? = builder.function
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * A unique name for the rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The publish status of the rule.
     */
    public val publishStatus: aws.sdk.kotlin.services.connect.model.RulePublishStatus? = builder.publishStatus
    /**
     * The event source to trigger the rule.
     */
    public val triggerEventSource: aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource? = builder.triggerEventSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRuleRequest(")
        append("actions=$actions,")
        append("clientToken=$clientToken,")
        append("function=$function,")
        append("instanceId=$instanceId,")
        append("name=$name,")
        append("publishStatus=$publishStatus,")
        append("triggerEventSource=$triggerEventSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (function?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (publishStatus?.hashCode() ?: 0)
        result = 31 * result + (triggerEventSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRuleRequest

        if (actions != other.actions) return false
        if (clientToken != other.clientToken) return false
        if (function != other.function) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (publishStatus != other.publishStatus) return false
        if (triggerEventSource != other.triggerEventSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of actions to be run when the rule is triggered.
         */
        public var actions: List<RuleAction>? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The conditions of the rule.
         */
        public var function: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * A unique name for the rule.
         */
        public var name: kotlin.String? = null
        /**
         * The publish status of the rule.
         */
        public var publishStatus: aws.sdk.kotlin.services.connect.model.RulePublishStatus? = null
        /**
         * The event source to trigger the rule.
         */
        public var triggerEventSource: aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateRuleRequest) : this() {
            this.actions = x.actions
            this.clientToken = x.clientToken
            this.function = x.function
            this.instanceId = x.instanceId
            this.name = x.name
            this.publishStatus = x.publishStatus
            this.triggerEventSource = x.triggerEventSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateRuleRequest = CreateRuleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource] inside the given [block]
         */
        public fun triggerEventSource(block: aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource.Builder.() -> kotlin.Unit) {
            this.triggerEventSource = aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
