// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Chat integration event containing payload to perform different chat actions such as:
 * + Sending a chat message
 * + Sending a chat event, such as typing
 * + Disconnecting from a chat
 */
public class ChatEvent private constructor(builder: Builder) {
    /**
     * Content of the message or event. This is required when `Type` is `MESSAGE` and for certain `ContentTypes` when `Type` is `EVENT`.
     * + For allowed message content, see the `Content` parameter in the [SendMessage](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html) topic in the *Amazon Connect Participant Service API Reference*.
     * + For allowed event content, see the `Content` parameter in the [SendEvent](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html) topic in the *Amazon Connect Participant Service API Reference*.
     */
    public val content: kotlin.String? = builder.content
    /**
     * Type of content. This is required when `Type` is `MESSAGE` or `EVENT`.
     * + For allowed message content types, see the `ContentType` parameter in the [SendMessage](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html) topic in the *Amazon Connect Participant Service API Reference*.
     * + For allowed event content types, see the `ContentType` parameter in the [SendEvent](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html) topic in the *Amazon Connect Participant Service API Reference*.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * Type of chat integration event.
     */
    public val type: aws.sdk.kotlin.services.connect.model.ChatEventType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ChatEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChatEvent(")
        append("content=$content,")
        append("contentType=$contentType,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChatEvent

        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ChatEvent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Content of the message or event. This is required when `Type` is `MESSAGE` and for certain `ContentTypes` when `Type` is `EVENT`.
         * + For allowed message content, see the `Content` parameter in the [SendMessage](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html) topic in the *Amazon Connect Participant Service API Reference*.
         * + For allowed event content, see the `Content` parameter in the [SendEvent](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html) topic in the *Amazon Connect Participant Service API Reference*.
         */
        public var content: kotlin.String? = null
        /**
         * Type of content. This is required when `Type` is `MESSAGE` or `EVENT`.
         * + For allowed message content types, see the `ContentType` parameter in the [SendMessage](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html) topic in the *Amazon Connect Participant Service API Reference*.
         * + For allowed event content types, see the `ContentType` parameter in the [SendEvent](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html) topic in the *Amazon Connect Participant Service API Reference*.
         */
        public var contentType: kotlin.String? = null
        /**
         * Type of chat integration event.
         */
        public var type: aws.sdk.kotlin.services.connect.model.ChatEventType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ChatEvent) : this() {
            this.content = x.content
            this.contentType = x.contentType
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ChatEvent = ChatEvent(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = ChatEventType.SdkUnknown("no value provided")
            return this
        }
    }
}
