// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.InstanceStorageConfig
import aws.sdk.kotlin.services.connect.model.InstanceStorageResourceType
import aws.sdk.kotlin.services.connect.model.UpdateInstanceStorageConfigRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateInstanceStorageConfigOperationSerializer: HttpSerialize<UpdateInstanceStorageConfigRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateInstanceStorageConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "instance",
                "${input.instanceId}".encodeLabel(),
                "storage-config",
                "${input.associationId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.resourceType != null) append("resourceType", input.resourceType.value)
            }
        }

        val payload = serializeUpdateInstanceStorageConfigOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateInstanceStorageConfigOperationBody(context: ExecutionContext, input: UpdateInstanceStorageConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val STORAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StorageConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STORAGECONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.storageConfig?.let { field(STORAGECONFIG_DESCRIPTOR, it, ::serializeInstanceStorageConfigDocument) }
    }
    return serializer.toByteArray()
}
