// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.StopContactRecordingResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class StopContactRecordingOperationDeserializer: HttpDeserialize<StopContactRecordingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StopContactRecordingResponse {
        if (!response.status.isSuccess()) {
            throwStopContactRecordingError(context, response)
        }
        val builder = StopContactRecordingResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwStopContactRecordingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
