// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.CurrentMetric
import aws.sdk.kotlin.services.connect.model.Filters
import aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataRequest
import aws.sdk.kotlin.services.connect.model.Grouping
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCurrentMetricDataOperationSerializer: HttpSerialize<GetCurrentMetricDataRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetCurrentMetricDataRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "metrics",
                "current",
                "${input.instanceId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeGetCurrentMetricDataOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetCurrentMetricDataOperationBody(context: ExecutionContext, input: GetCurrentMetricDataRequest): ByteArray {
    val serializer = JsonSerializer()
    val CURRENTMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CurrentMetrics"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filters"))
    val GROUPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Groupings"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CURRENTMETRICS_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(GROUPINGS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.currentMetrics != null) {
            listField(CURRENTMETRICS_DESCRIPTOR) {
                for (el0 in input.currentMetrics) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCurrentMetricDocument))
                }
            }
        }
        input.filters?.let { field(FILTERS_DESCRIPTOR, it, ::serializeFiltersDocument) }
        if (input.groupings != null) {
            listField(GROUPINGS_DESCRIPTOR) {
                for (el0 in input.groupings) {
                    serializeString(el0.value)
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
