// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.CreateUserRequest
import aws.sdk.kotlin.services.connect.model.UserIdentityInfo
import aws.sdk.kotlin.services.connect.model.UserPhoneConfig
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateUserOperationSerializer: HttpSerialize<CreateUserRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "users",
                "${input.instanceId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateUserOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateUserOperationBody(context: ExecutionContext, input: CreateUserRequest): ByteArray {
    val serializer = JsonSerializer()
    val DIRECTORYUSERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DirectoryUserId"))
    val HIERARCHYGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HierarchyGroupId"))
    val IDENTITYINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IdentityInfo"))
    val PASSWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Password"))
    val PHONECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PhoneConfig"))
    val ROUTINGPROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoutingProfileId"))
    val SECURITYPROFILEIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecurityProfileIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Username"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DIRECTORYUSERID_DESCRIPTOR)
        field(HIERARCHYGROUPID_DESCRIPTOR)
        field(IDENTITYINFO_DESCRIPTOR)
        field(PASSWORD_DESCRIPTOR)
        field(PHONECONFIG_DESCRIPTOR)
        field(ROUTINGPROFILEID_DESCRIPTOR)
        field(SECURITYPROFILEIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.directoryUserId?.let { field(DIRECTORYUSERID_DESCRIPTOR, it) }
        input.hierarchyGroupId?.let { field(HIERARCHYGROUPID_DESCRIPTOR, it) }
        input.identityInfo?.let { field(IDENTITYINFO_DESCRIPTOR, it, ::serializeUserIdentityInfoDocument) }
        input.password?.let { field(PASSWORD_DESCRIPTOR, it) }
        input.phoneConfig?.let { field(PHONECONFIG_DESCRIPTOR, it, ::serializeUserPhoneConfigDocument) }
        input.routingProfileId?.let { field(ROUTINGPROFILEID_DESCRIPTOR, it) }
        if (input.securityProfileIds != null) {
            listField(SECURITYPROFILEIDS_DESCRIPTOR) {
                for (el0 in input.securityProfileIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.username?.let { field(USERNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
