// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class UpdateSecurityProfileRequest private constructor(builder: Builder) {
    /**
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     */
    public val allowedAccessControlTags: Map<String, String>? = builder.allowedAccessControlTags
    /**
     * The description of the security profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The permissions granted to a security profile. For a list of valid permissions, see [List of security profile permissions](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
     */
    public val permissions: List<String>? = builder.permissions
    /**
     * The identifier for the security profle.
     */
    public val securityProfileId: kotlin.String? = requireNotNull(builder.securityProfileId) { "A non-null value must be provided for securityProfileId" }
    /**
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     */
    public val tagRestrictedResources: List<String>? = builder.tagRestrictedResources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.UpdateSecurityProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSecurityProfileRequest(")
        append("allowedAccessControlTags=$allowedAccessControlTags,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("permissions=$permissions,")
        append("securityProfileId=$securityProfileId,")
        append("tagRestrictedResources=$tagRestrictedResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedAccessControlTags?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (securityProfileId?.hashCode() ?: 0)
        result = 31 * result + (tagRestrictedResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSecurityProfileRequest

        if (allowedAccessControlTags != other.allowedAccessControlTags) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (permissions != other.permissions) return false
        if (securityProfileId != other.securityProfileId) return false
        if (tagRestrictedResources != other.tagRestrictedResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.UpdateSecurityProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         */
        public var allowedAccessControlTags: Map<String, String>? = null
        /**
         * The description of the security profile.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The permissions granted to a security profile. For a list of valid permissions, see [List of security profile permissions](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
         */
        public var permissions: List<String>? = null
        /**
         * The identifier for the security profle.
         */
        public var securityProfileId: kotlin.String? = null
        /**
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         */
        public var tagRestrictedResources: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.UpdateSecurityProfileRequest) : this() {
            this.allowedAccessControlTags = x.allowedAccessControlTags
            this.description = x.description
            this.instanceId = x.instanceId
            this.permissions = x.permissions
            this.securityProfileId = x.securityProfileId
            this.tagRestrictedResources = x.tagRestrictedResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.UpdateSecurityProfileRequest = UpdateSecurityProfileRequest(this)
    }
}
