// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.time.Instant

public class StartTaskContactRequest private constructor(builder: Builder) {
    /**
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
     *
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
     *
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
     */
    public val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * A description of the task that is shown to an agent in the Contact Control Panel (CCP).
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of a task that is shown to an agent in the Contact Control Panel (CCP).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The identifier of the previous chat, voice, or task contact.
     */
    public val previousContactId: kotlin.String? = builder.previousContactId
    /**
     * The identifier for the quick connect.
     */
    public val quickConnectId: kotlin.String? = builder.quickConnectId
    /**
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP).
     */
    public val references: Map<String, Reference>? = builder.references
    /**
     * The timestamp, in Unix Epoch seconds format, at which to start running the inbound flow. The scheduled time cannot be in the past. It must be within up to 6 days in future.
     */
    public val scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTime
    /**
     * A unique identifier for the task template.
     */
    public val taskTemplateId: kotlin.String? = builder.taskTemplateId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.StartTaskContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTaskContactRequest(")
        append("attributes=$attributes,")
        append("clientToken=$clientToken,")
        append("contactFlowId=$contactFlowId,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("name=$name,")
        append("previousContactId=$previousContactId,")
        append("quickConnectId=$quickConnectId,")
        append("references=$references,")
        append("scheduledTime=$scheduledTime,")
        append("taskTemplateId=$taskTemplateId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (previousContactId?.hashCode() ?: 0)
        result = 31 * result + (quickConnectId?.hashCode() ?: 0)
        result = 31 * result + (references?.hashCode() ?: 0)
        result = 31 * result + (scheduledTime?.hashCode() ?: 0)
        result = 31 * result + (taskTemplateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTaskContactRequest

        if (attributes != other.attributes) return false
        if (clientToken != other.clientToken) return false
        if (contactFlowId != other.contactFlowId) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (previousContactId != other.previousContactId) return false
        if (quickConnectId != other.quickConnectId) return false
        if (references != other.references) return false
        if (scheduledTime != other.scheduledTime) return false
        if (taskTemplateId != other.taskTemplateId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.StartTaskContactRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
         *
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
         */
        public var attributes: Map<String, String>? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
         *
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
         */
        public var contactFlowId: kotlin.String? = null
        /**
         * A description of the task that is shown to an agent in the Contact Control Panel (CCP).
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of a task that is shown to an agent in the Contact Control Panel (CCP).
         */
        public var name: kotlin.String? = null
        /**
         * The identifier of the previous chat, voice, or task contact.
         */
        public var previousContactId: kotlin.String? = null
        /**
         * The identifier for the quick connect.
         */
        public var quickConnectId: kotlin.String? = null
        /**
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP).
         */
        public var references: Map<String, Reference>? = null
        /**
         * The timestamp, in Unix Epoch seconds format, at which to start running the inbound flow. The scheduled time cannot be in the past. It must be within up to 6 days in future.
         */
        public var scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique identifier for the task template.
         */
        public var taskTemplateId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.StartTaskContactRequest) : this() {
            this.attributes = x.attributes
            this.clientToken = x.clientToken
            this.contactFlowId = x.contactFlowId
            this.description = x.description
            this.instanceId = x.instanceId
            this.name = x.name
            this.previousContactId = x.previousContactId
            this.quickConnectId = x.quickConnectId
            this.references = x.references
            this.scheduledTime = x.scheduledTime
            this.taskTemplateId = x.taskTemplateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.StartTaskContactRequest = StartTaskContactRequest(this)
    }
}
