// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class SearchQueuesRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The search criteria to be used to return queues.
     *
     * The `name` and `description` fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results.
     */
    public val searchCriteria: aws.sdk.kotlin.services.connect.model.QueueSearchCriteria? = builder.searchCriteria
    /**
     * Filters to be applied to search results.
     */
    public val searchFilter: aws.sdk.kotlin.services.connect.model.QueueSearchFilter? = builder.searchFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.SearchQueuesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchQueuesRequest(")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("searchCriteria=$searchCriteria,")
        append("searchFilter=$searchFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (searchCriteria?.hashCode() ?: 0)
        result = 31 * result + (searchFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchQueuesRequest

        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (searchCriteria != other.searchCriteria) return false
        if (searchFilter != other.searchFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.SearchQueuesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The search criteria to be used to return queues.
         *
         * The `name` and `description` fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results.
         */
        public var searchCriteria: aws.sdk.kotlin.services.connect.model.QueueSearchCriteria? = null
        /**
         * Filters to be applied to search results.
         */
        public var searchFilter: aws.sdk.kotlin.services.connect.model.QueueSearchFilter? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.SearchQueuesRequest) : this() {
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.searchCriteria = x.searchCriteria
            this.searchFilter = x.searchFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.SearchQueuesRequest = SearchQueuesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.QueueSearchCriteria] inside the given [block]
         */
        public fun searchCriteria(block: aws.sdk.kotlin.services.connect.model.QueueSearchCriteria.Builder.() -> kotlin.Unit) {
            this.searchCriteria = aws.sdk.kotlin.services.connect.model.QueueSearchCriteria.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.QueueSearchFilter] inside the given [block]
         */
        public fun searchFilter(block: aws.sdk.kotlin.services.connect.model.QueueSearchFilter.Builder.() -> kotlin.Unit) {
            this.searchFilter = aws.sdk.kotlin.services.connect.model.QueueSearchFilter.invoke(block)
        }
    }
}
