// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class CreateUserRequest private constructor(builder: Builder) {
    /**
     * The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.
     *
     * This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
     */
    public val directoryUserId: kotlin.String? = builder.directoryUserId
    /**
     * The identifier of the hierarchy group for the user.
     */
    public val hierarchyGroupId: kotlin.String? = builder.hierarchyGroupId
    /**
     * The information about the identity of the user.
     */
    public val identityInfo: aws.sdk.kotlin.services.connect.model.UserIdentityInfo? = builder.identityInfo
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
     */
    public val password: kotlin.String? = builder.password
    /**
     * The phone settings for the user.
     */
    public val phoneConfig: aws.sdk.kotlin.services.connect.model.UserPhoneConfig? = builder.phoneConfig
    /**
     * The identifier of the routing profile for the user.
     */
    public val routingProfileId: kotlin.String? = builder.routingProfileId
    /**
     * The identifier of the security profile for the user.
     */
    public val securityProfileIds: List<String>? = builder.securityProfileIds
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from &#91;a-zA-Z0-9_-.\@&#93;+.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUserRequest(")
        append("directoryUserId=$directoryUserId,")
        append("hierarchyGroupId=$hierarchyGroupId,")
        append("identityInfo=$identityInfo,")
        append("instanceId=$instanceId,")
        append("password=$password,")
        append("phoneConfig=$phoneConfig,")
        append("routingProfileId=$routingProfileId,")
        append("securityProfileIds=$securityProfileIds,")
        append("tags=$tags,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = directoryUserId?.hashCode() ?: 0
        result = 31 * result + (hierarchyGroupId?.hashCode() ?: 0)
        result = 31 * result + (identityInfo?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (phoneConfig?.hashCode() ?: 0)
        result = 31 * result + (routingProfileId?.hashCode() ?: 0)
        result = 31 * result + (securityProfileIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUserRequest

        if (directoryUserId != other.directoryUserId) return false
        if (hierarchyGroupId != other.hierarchyGroupId) return false
        if (identityInfo != other.identityInfo) return false
        if (instanceId != other.instanceId) return false
        if (password != other.password) return false
        if (phoneConfig != other.phoneConfig) return false
        if (routingProfileId != other.routingProfileId) return false
        if (securityProfileIds != other.securityProfileIds) return false
        if (tags != other.tags) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateUserRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.
         *
         * This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
         */
        public var directoryUserId: kotlin.String? = null
        /**
         * The identifier of the hierarchy group for the user.
         */
        public var hierarchyGroupId: kotlin.String? = null
        /**
         * The information about the identity of the user.
         */
        public var identityInfo: aws.sdk.kotlin.services.connect.model.UserIdentityInfo? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
         */
        public var password: kotlin.String? = null
        /**
         * The phone settings for the user.
         */
        public var phoneConfig: aws.sdk.kotlin.services.connect.model.UserPhoneConfig? = null
        /**
         * The identifier of the routing profile for the user.
         */
        public var routingProfileId: kotlin.String? = null
        /**
         * The identifier of the security profile for the user.
         */
        public var securityProfileIds: List<String>? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null
        /**
         * The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from &#91;a-zA-Z0-9_-.\@&#93;+.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateUserRequest) : this() {
            this.directoryUserId = x.directoryUserId
            this.hierarchyGroupId = x.hierarchyGroupId
            this.identityInfo = x.identityInfo
            this.instanceId = x.instanceId
            this.password = x.password
            this.phoneConfig = x.phoneConfig
            this.routingProfileId = x.routingProfileId
            this.securityProfileIds = x.securityProfileIds
            this.tags = x.tags
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateUserRequest = CreateUserRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserIdentityInfo] inside the given [block]
         */
        public fun identityInfo(block: aws.sdk.kotlin.services.connect.model.UserIdentityInfo.Builder.() -> kotlin.Unit) {
            this.identityInfo = aws.sdk.kotlin.services.connect.model.UserIdentityInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserPhoneConfig] inside the given [block]
         */
        public fun phoneConfig(block: aws.sdk.kotlin.services.connect.model.UserPhoneConfig.Builder.() -> kotlin.Unit) {
            this.phoneConfig = aws.sdk.kotlin.services.connect.model.UserPhoneConfig.invoke(block)
        }
    }
}
