// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class CreateSecurityProfileRequest private constructor(builder: Builder) {
    /**
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     */
    public val allowedAccessControlTags: Map<String, String>? = builder.allowedAccessControlTags
    /**
     * The description of the security profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * Permissions assigned to the security profile. For a list of valid permissions, see [List of security profile permissions](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
     */
    public val permissions: List<String>? = builder.permissions
    /**
     * The name of the security profile.
     */
    public val securityProfileName: kotlin.String? = builder.securityProfileName
    /**
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect. Following are acceptable ResourceNames: `User` | `SecurityProfile` | `Queue` | `RoutingProfile`
     */
    public val tagRestrictedResources: List<String>? = builder.tagRestrictedResources
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSecurityProfileRequest(")
        append("allowedAccessControlTags=$allowedAccessControlTags,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("permissions=$permissions,")
        append("securityProfileName=$securityProfileName,")
        append("tagRestrictedResources=$tagRestrictedResources,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedAccessControlTags?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (securityProfileName?.hashCode() ?: 0)
        result = 31 * result + (tagRestrictedResources?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSecurityProfileRequest

        if (allowedAccessControlTags != other.allowedAccessControlTags) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (permissions != other.permissions) return false
        if (securityProfileName != other.securityProfileName) return false
        if (tagRestrictedResources != other.tagRestrictedResources) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         */
        public var allowedAccessControlTags: Map<String, String>? = null
        /**
         * The description of the security profile.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Permissions assigned to the security profile. For a list of valid permissions, see [List of security profile permissions](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
         */
        public var permissions: List<String>? = null
        /**
         * The name of the security profile.
         */
        public var securityProfileName: kotlin.String? = null
        /**
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect. Following are acceptable ResourceNames: `User` | `SecurityProfile` | `Queue` | `RoutingProfile`
         */
        public var tagRestrictedResources: List<String>? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest) : this() {
            this.allowedAccessControlTags = x.allowedAccessControlTags
            this.description = x.description
            this.instanceId = x.instanceId
            this.permissions = x.permissions
            this.securityProfileName = x.securityProfileName
            this.tagRestrictedResources = x.tagRestrictedResources
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest = CreateSecurityProfileRequest(this)
    }
}
