// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints
import aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults
import aws.sdk.kotlin.services.connect.model.TaskTemplateField
import aws.sdk.kotlin.services.connect.model.TaskTemplateStatus
import aws.sdk.kotlin.services.connect.model.UpdateTaskTemplateResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateTaskTemplateOperationDeserializer: HttpDeserialize<UpdateTaskTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateTaskTemplateResponse {
        if (!response.status.isSuccess()) {
            throwUpdateTaskTemplateError(context, response)
        }
        val builder = UpdateTaskTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateTaskTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateTaskTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "PropertyValidationException" -> PropertyValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateTaskTemplateOperationBody(builder: UpdateTaskTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CONSTRAINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Constraints"))
    val CONTACTFLOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactFlowId"))
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val DEFAULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Defaults"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Fields"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CONSTRAINTS_DESCRIPTOR)
        field(CONTACTFLOWID_DESCRIPTOR)
        field(CREATEDTIME_DESCRIPTOR)
        field(DEFAULTS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FIELDS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CONSTRAINTS_DESCRIPTOR.index -> builder.constraints = deserializeTaskTemplateConstraintsDocument(deserializer)
                CONTACTFLOWID_DESCRIPTOR.index -> builder.contactFlowId = deserializeString()
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEFAULTS_DESCRIPTOR.index -> builder.defaults = deserializeTaskTemplateDefaultsDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FIELDS_DESCRIPTOR.index -> builder.fields =
                    deserializer.deserializeList(FIELDS_DESCRIPTOR) {
                        val col0 = mutableListOf<TaskTemplateField>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTaskTemplateFieldDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INSTANCEID_DESCRIPTOR.index -> builder.instanceId = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TaskTemplateStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
