// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.DescribeUserHierarchyGroupResponse
import aws.sdk.kotlin.services.connect.model.HierarchyGroup
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeUserHierarchyGroupOperationDeserializer: HttpDeserialize<DescribeUserHierarchyGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeUserHierarchyGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeUserHierarchyGroupError(context, response)
        }
        val builder = DescribeUserHierarchyGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeUserHierarchyGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeUserHierarchyGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeUserHierarchyGroupOperationBody(builder: DescribeUserHierarchyGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HIERARCHYGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HierarchyGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HIERARCHYGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HIERARCHYGROUP_DESCRIPTOR.index -> builder.hierarchyGroup = deserializeHierarchyGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
