// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.CreateInstanceResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateInstanceOperationDeserializer: HttpDeserialize<CreateInstanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateInstanceResponse {
        if (!response.status.isSuccess()) {
            throwCreateInstanceError(context, response)
        }
        val builder = CreateInstanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateInstanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateInstanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateInstanceOperationBody(builder: CreateInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
