// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Information about traffic distribution groups.
 */
public class TrafficDistributionGroupSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the traffic distribution group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Resource Name (ARN) of the traffic distribution group.
     */
    public val instanceArn: kotlin.String? = builder.instanceArn
    /**
     * The name of the traffic distribution group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the traffic distribution group.
     * + `CREATION_IN_PROGRESS` means the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
     * + `ACTIVE` means the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation has succeeded.
     * + `CREATION_FAILED` indicates that the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation has failed.
     * + `PENDING_DELETION` means the previous [DeleteTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
     * + `DELETION_FAILED` means the previous [DeleteTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html) operation has failed.
     * + `UPDATE_IN_PROGRESS` means the previous [UpdateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
     */
    public val status: aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficDistributionGroupSummary(")
        append("arn=$arn,")
        append("id=$id,")
        append("instanceArn=$instanceArn,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (instanceArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficDistributionGroupSummary

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (instanceArn != other.instanceArn) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the traffic distribution group.
         */
        public var arn: kotlin.String? = null
        /**
         * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the traffic distribution group.
         */
        public var instanceArn: kotlin.String? = null
        /**
         * The name of the traffic distribution group.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the traffic distribution group.
         * + `CREATION_IN_PROGRESS` means the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
         * + `ACTIVE` means the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation has succeeded.
         * + `CREATION_FAILED` indicates that the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation has failed.
         * + `PENDING_DELETION` means the previous [DeleteTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
         * + `DELETION_FAILED` means the previous [DeleteTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html) operation has failed.
         * + `UPDATE_IN_PROGRESS` means the previous [UpdateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
         */
        public var status: aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupSummary) : this() {
            this.arn = x.arn
            this.id = x.id
            this.instanceArn = x.instanceArn
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupSummary = TrafficDistributionGroupSummary(this)
    }
}
