// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class StartChatContactRequest private constructor(builder: Builder) {
    /**
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows just like any other contact attributes.
     *
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The total duration of the newly started chat session. If not specified, the chat session duration defaults to 25 hour. The minumum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7 days).
     */
    public val chatDurationInMinutes: kotlin.Int? = builder.chatDurationInMinutes
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
     *
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
     */
    public val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * The initial message to be sent to the newly created chat.
     */
    public val initialMessage: aws.sdk.kotlin.services.connect.model.ChatMessage? = builder.initialMessage
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Information identifying the participant.
     */
    public val participantDetails: aws.sdk.kotlin.services.connect.model.ParticipantDetails? = builder.participantDetails
    /**
     * The supported chat message content types. Content types can be text/plain or both text/plain and text/markdown.
     */
    public val supportedMessagingContentTypes: List<String>? = builder.supportedMessagingContentTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.StartChatContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartChatContactRequest(")
        append("attributes=$attributes,")
        append("chatDurationInMinutes=$chatDurationInMinutes,")
        append("clientToken=$clientToken,")
        append("contactFlowId=$contactFlowId,")
        append("initialMessage=$initialMessage,")
        append("instanceId=$instanceId,")
        append("participantDetails=$participantDetails,")
        append("supportedMessagingContentTypes=$supportedMessagingContentTypes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (chatDurationInMinutes ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (initialMessage?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (participantDetails?.hashCode() ?: 0)
        result = 31 * result + (supportedMessagingContentTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartChatContactRequest

        if (attributes != other.attributes) return false
        if (chatDurationInMinutes != other.chatDurationInMinutes) return false
        if (clientToken != other.clientToken) return false
        if (contactFlowId != other.contactFlowId) return false
        if (initialMessage != other.initialMessage) return false
        if (instanceId != other.instanceId) return false
        if (participantDetails != other.participantDetails) return false
        if (supportedMessagingContentTypes != other.supportedMessagingContentTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.StartChatContactRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows just like any other contact attributes.
         *
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The total duration of the newly started chat session. If not specified, the chat session duration defaults to 25 hour. The minumum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7 days).
         */
        public var chatDurationInMinutes: kotlin.Int? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
         *
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
         */
        public var contactFlowId: kotlin.String? = null
        /**
         * The initial message to be sent to the newly created chat.
         */
        public var initialMessage: aws.sdk.kotlin.services.connect.model.ChatMessage? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Information identifying the participant.
         */
        public var participantDetails: aws.sdk.kotlin.services.connect.model.ParticipantDetails? = null
        /**
         * The supported chat message content types. Content types can be text/plain or both text/plain and text/markdown.
         */
        public var supportedMessagingContentTypes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.StartChatContactRequest) : this() {
            this.attributes = x.attributes
            this.chatDurationInMinutes = x.chatDurationInMinutes
            this.clientToken = x.clientToken
            this.contactFlowId = x.contactFlowId
            this.initialMessage = x.initialMessage
            this.instanceId = x.instanceId
            this.participantDetails = x.participantDetails
            this.supportedMessagingContentTypes = x.supportedMessagingContentTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.StartChatContactRequest = StartChatContactRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ChatMessage] inside the given [block]
         */
        public fun initialMessage(block: aws.sdk.kotlin.services.connect.model.ChatMessage.Builder.() -> kotlin.Unit) {
            this.initialMessage = aws.sdk.kotlin.services.connect.model.ChatMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ParticipantDetails] inside the given [block]
         */
        public fun participantDetails(block: aws.sdk.kotlin.services.connect.model.ParticipantDetails.Builder.() -> kotlin.Unit) {
            this.participantDetails = aws.sdk.kotlin.services.connect.model.ParticipantDetails.invoke(block)
        }
    }
}
