// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.computeoptimizer.model.ComputeOptimizerException
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusResponse
import aws.sdk.kotlin.services.computeoptimizer.model.Status
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetEnrollmentStatusOperationDeserializer: HttpDeserialize<GetEnrollmentStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEnrollmentStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetEnrollmentStatusError(context, response)
        }
        val builder = GetEnrollmentStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEnrollmentStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetEnrollmentStatusOperationBody(builder: GetEnrollmentStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTUPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedTimestamp"))
    val MEMBERACCOUNTSENROLLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("memberAccountsEnrolled"))
    val NUMBEROFMEMBERACCOUNTSOPTEDIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("numberOfMemberAccountsOptedIn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTUPDATEDTIMESTAMP_DESCRIPTOR)
        field(MEMBERACCOUNTSENROLLED_DESCRIPTOR)
        field(NUMBEROFMEMBERACCOUNTSOPTEDIN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTUPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.lastUpdatedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                MEMBERACCOUNTSENROLLED_DESCRIPTOR.index -> builder.memberAccountsEnrolled = deserializeBoolean()
                NUMBEROFMEMBERACCOUNTSOPTEDIN_DESCRIPTOR.index -> builder.numberOfMemberAccountsOptedIn = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetEnrollmentStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_0 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer()
        "MissingAuthenticationToken" -> MissingAuthenticationTokenDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw ComputeOptimizerException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
