// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.computeoptimizer.model.ComputeOptimizerException
import aws.sdk.kotlin.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.RecommendationExportJob
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeRecommendationExportJobsOperationDeserializer: HttpDeserialize<DescribeRecommendationExportJobsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeRecommendationExportJobsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeRecommendationExportJobsError(context, response)
        }
        val builder = DescribeRecommendationExportJobsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeRecommendationExportJobsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeRecommendationExportJobsOperationBody(builder: DescribeRecommendationExportJobsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val RECOMMENDATIONEXPORTJOBS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("recommendationExportJobs"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(RECOMMENDATIONEXPORTJOBS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RECOMMENDATIONEXPORTJOBS_DESCRIPTOR.index -> builder.recommendationExportJobs =
                    deserializer.deserializeList(RECOMMENDATIONEXPORTJOBS_DESCRIPTOR) {
                        val col0 = mutableListOf<RecommendationExportJob>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRecommendationExportJobDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeRecommendationExportJobsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_0 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer()
        "MissingAuthenticationToken" -> MissingAuthenticationTokenDeserializer()
        "OptInRequiredException" -> OptInRequiredExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw ComputeOptimizerException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
