// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a recommendation option for an Amazon Elastic Block Store (Amazon EBS)
 * instance.
 */
class VolumeRecommendationOption private constructor(builder: Builder) {
    /**
     * An array of objects that describe a volume configuration.
     */
    val configuration: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration? = builder.configuration
    /**
     * The performance risk of the volume recommendation option.
     * Performance risk is the likelihood of the recommended volume type meeting the
     * performance requirement of your workload.
     * The value ranges from 0 - 4, with 0 meaning
     * that the recommended resource is predicted to always provide enough hardware capability.
     * The higher the performance risk is, the more likely you should validate whether the
     * recommendation will meet the performance requirements of your workload before migrating
     * your resource.
     */
    val performanceRisk: kotlin.Double = builder.performanceRisk
    /**
     * The rank of the volume recommendation option.
     * The top recommendation option is ranked as 1.
     */
    val rank: kotlin.Int = builder.rank

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeRecommendationOption(")
        append("configuration=$configuration,")
        append("performanceRisk=$performanceRisk,")
        append("rank=$rank)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (performanceRisk.hashCode())
        result = 31 * result + (rank)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VolumeRecommendationOption

        if (configuration != other.configuration) return false
        if (performanceRisk != other.performanceRisk) return false
        if (rank != other.rank) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendationOption = Builder(this).apply(block).build()

    class Builder {
        /**
         * An array of objects that describe a volume configuration.
         */
        var configuration: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration? = null
        /**
         * The performance risk of the volume recommendation option.
         * Performance risk is the likelihood of the recommended volume type meeting the
         * performance requirement of your workload.
         * The value ranges from 0 - 4, with 0 meaning
         * that the recommended resource is predicted to always provide enough hardware capability.
         * The higher the performance risk is, the more likely you should validate whether the
         * recommendation will meet the performance requirements of your workload before migrating
         * your resource.
         */
        var performanceRisk: kotlin.Double = 0.0
        /**
         * The rank of the volume recommendation option.
         * The top recommendation option is ranked as 1.
         */
        var rank: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendationOption) : this() {
            this.configuration = x.configuration
            this.performanceRisk = x.performanceRisk
            this.rank = x.rank
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendationOption = VolumeRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration] inside the given [block]
         */
        fun configuration(block: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration.invoke(block)
        }
    }
}
