// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Elastic Block Store (Amazon EBS) volume recommendation.
 */
class VolumeRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the volume.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * An array of objects that describe the current configuration of the volume.
     */
    val currentConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration? = builder.currentConfiguration
    /**
     * The finding classification of the volume.
     * Findings for volumes include:
     * NotOptimized
     * —A volume is
     * considered not optimized when Compute Optimizer identifies a recommendation
     * that can provide better performance for your workload.
     * Optimized
     * —An volume is
     * considered optimized when Compute Optimizer determines that the volume is
     * correctly provisioned to run your workload based on the chosen volume type. For
     * optimized resources, Compute Optimizer might recommend a new generation volume
     * type.
     */
    val finding: aws.sdk.kotlin.services.computeoptimizer.model.EbsFinding? = builder.finding
    /**
     * The timestamp of when the volume recommendation was last refreshed.
     */
    val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days for which utilization metrics were analyzed for the volume.
     */
    val lookBackPeriodInDays: kotlin.Double = builder.lookBackPeriodInDays
    /**
     * An array of objects that describe the utilization metrics of the volume.
     */
    val utilizationMetrics: List<EbsUtilizationMetric>? = builder.utilizationMetrics
    /**
     * The Amazon Resource Name (ARN) of the current volume.
     */
    val volumeArn: kotlin.String? = builder.volumeArn
    /**
     * An array of objects that describe the recommendation options for the volume.
     */
    val volumeRecommendationOptions: List<VolumeRecommendationOption>? = builder.volumeRecommendationOptions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeRecommendation(")
        append("accountId=$accountId,")
        append("currentConfiguration=$currentConfiguration,")
        append("finding=$finding,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookBackPeriodInDays=$lookBackPeriodInDays,")
        append("utilizationMetrics=$utilizationMetrics,")
        append("volumeArn=$volumeArn,")
        append("volumeRecommendationOptions=$volumeRecommendationOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriodInDays.hashCode())
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        result = 31 * result + (volumeRecommendationOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VolumeRecommendation

        if (accountId != other.accountId) return false
        if (currentConfiguration != other.currentConfiguration) return false
        if (finding != other.finding) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (lookBackPeriodInDays != other.lookBackPeriodInDays) return false
        if (utilizationMetrics != other.utilizationMetrics) return false
        if (volumeArn != other.volumeArn) return false
        if (volumeRecommendationOptions != other.volumeRecommendationOptions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services account ID of the volume.
         */
        var accountId: kotlin.String? = null
        /**
         * An array of objects that describe the current configuration of the volume.
         */
        var currentConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration? = null
        /**
         * The finding classification of the volume.
         * Findings for volumes include:
         * NotOptimized
         * —A volume is
         * considered not optimized when Compute Optimizer identifies a recommendation
         * that can provide better performance for your workload.
         * Optimized
         * —An volume is
         * considered optimized when Compute Optimizer determines that the volume is
         * correctly provisioned to run your workload based on the chosen volume type. For
         * optimized resources, Compute Optimizer might recommend a new generation volume
         * type.
         */
        var finding: aws.sdk.kotlin.services.computeoptimizer.model.EbsFinding? = null
        /**
         * The timestamp of when the volume recommendation was last refreshed.
         */
        var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days for which utilization metrics were analyzed for the volume.
         */
        var lookBackPeriodInDays: kotlin.Double = 0.0
        /**
         * An array of objects that describe the utilization metrics of the volume.
         */
        var utilizationMetrics: List<EbsUtilizationMetric>? = null
        /**
         * The Amazon Resource Name (ARN) of the current volume.
         */
        var volumeArn: kotlin.String? = null
        /**
         * An array of objects that describe the recommendation options for the volume.
         */
        var volumeRecommendationOptions: List<VolumeRecommendationOption>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation) : this() {
            this.accountId = x.accountId
            this.currentConfiguration = x.currentConfiguration
            this.finding = x.finding
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookBackPeriodInDays = x.lookBackPeriodInDays
            this.utilizationMetrics = x.utilizationMetrics
            this.volumeArn = x.volumeArn
            this.volumeRecommendationOptions = x.volumeRecommendationOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation = VolumeRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration] inside the given [block]
         */
        fun currentConfiguration(block: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.currentConfiguration = aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration.invoke(block)
        }
    }
}
