// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the configuration of an Amazon Elastic Block Store (Amazon EBS)
 * volume.
 */
class VolumeConfiguration private constructor(builder: Builder) {
    /**
     * The baseline IOPS of the volume.
     */
    val volumeBaselineIops: kotlin.Int = builder.volumeBaselineIops
    /**
     * The baseline throughput of the volume.
     */
    val volumeBaselineThroughput: kotlin.Int = builder.volumeBaselineThroughput
    /**
     * The burst IOPS of the volume.
     */
    val volumeBurstIops: kotlin.Int = builder.volumeBurstIops
    /**
     * The burst throughput of the volume.
     */
    val volumeBurstThroughput: kotlin.Int = builder.volumeBurstThroughput
    /**
     * The size of the volume, in GiB.
     */
    val volumeSize: kotlin.Int = builder.volumeSize
    /**
     * The volume type.
     * This can be gp2 for General Purpose SSD, io1 or
     * io2 for Provisioned IOPS SSD, st1 for Throughput Optimized
     * HDD, sc1 for Cold HDD, or standard for Magnetic
     * volumes.
     */
    val volumeType: kotlin.String? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeConfiguration(")
        append("volumeBaselineIops=$volumeBaselineIops,")
        append("volumeBaselineThroughput=$volumeBaselineThroughput,")
        append("volumeBurstIops=$volumeBurstIops,")
        append("volumeBurstThroughput=$volumeBurstThroughput,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = volumeBaselineIops
        result = 31 * result + (volumeBaselineThroughput)
        result = 31 * result + (volumeBurstIops)
        result = 31 * result + (volumeBurstThroughput)
        result = 31 * result + (volumeSize)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VolumeConfiguration

        if (volumeBaselineIops != other.volumeBaselineIops) return false
        if (volumeBaselineThroughput != other.volumeBaselineThroughput) return false
        if (volumeBurstIops != other.volumeBurstIops) return false
        if (volumeBurstThroughput != other.volumeBurstThroughput) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The baseline IOPS of the volume.
         */
        var volumeBaselineIops: kotlin.Int = 0
        /**
         * The baseline throughput of the volume.
         */
        var volumeBaselineThroughput: kotlin.Int = 0
        /**
         * The burst IOPS of the volume.
         */
        var volumeBurstIops: kotlin.Int = 0
        /**
         * The burst throughput of the volume.
         */
        var volumeBurstThroughput: kotlin.Int = 0
        /**
         * The size of the volume, in GiB.
         */
        var volumeSize: kotlin.Int = 0
        /**
         * The volume type.
         * This can be gp2 for General Purpose SSD, io1 or
         * io2 for Provisioned IOPS SSD, st1 for Throughput Optimized
         * HDD, sc1 for Cold HDD, or standard for Magnetic
         * volumes.
         */
        var volumeType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration) : this() {
            this.volumeBaselineIops = x.volumeBaselineIops
            this.volumeBaselineThroughput = x.volumeBaselineThroughput
            this.volumeBurstIops = x.volumeBurstIops
            this.volumeBurstThroughput = x.volumeBurstThroughput
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration = VolumeConfiguration(this)
    }
}
