// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a utilization metric of an Lambda function.
 */
class LambdaFunctionUtilizationMetric private constructor(builder: Builder) {
    /**
     * The name of the utilization metric.
     * The following utilization metrics are available:
     * Duration - The amount of time that your function code spends
     * processing an event.
     * Memory - The amount of memory used per invocation.
     */
    val name: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMetricName? = builder.name
    /**
     * The statistic of the utilization metric.
     * The Compute Optimizer API, Command Line Interface (CLI), and SDKs
     * return utilization metrics using only the Maximum statistic, which is the
     * highest value observed during the specified period.
     * The Compute Optimizer console displays graphs for some utilization metrics using the
     * Average statistic, which is the value of Sum /
     * SampleCount during the specified period. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
     * recommendations in the Compute Optimizer User
     * Guide. You can also get averaged utilization metric data for your resources
     * using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
     * User Guide.
     */
    val statistic: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMetricStatistic? = builder.statistic
    /**
     * The value of the utilization metric.
     */
    val value: kotlin.Double = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionUtilizationMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionUtilizationMetric(")
        append("name=$name,")
        append("statistic=$statistic,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaFunctionUtilizationMetric

        if (name != other.name) return false
        if (statistic != other.statistic) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionUtilizationMetric = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the utilization metric.
         * The following utilization metrics are available:
         * Duration - The amount of time that your function code spends
         * processing an event.
         * Memory - The amount of memory used per invocation.
         */
        var name: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMetricName? = null
        /**
         * The statistic of the utilization metric.
         * The Compute Optimizer API, Command Line Interface (CLI), and SDKs
         * return utilization metrics using only the Maximum statistic, which is the
         * highest value observed during the specified period.
         * The Compute Optimizer console displays graphs for some utilization metrics using the
         * Average statistic, which is the value of Sum /
         * SampleCount during the specified period. For more information, see
         * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
         * recommendations in the Compute Optimizer User
         * Guide. You can also get averaged utilization metric data for your resources
         * using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
         * User Guide.
         */
        var statistic: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMetricStatistic? = null
        /**
         * The value of the utilization metric.
         */
        var value: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionUtilizationMetric) : this() {
            this.name = x.name
            this.statistic = x.statistic
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionUtilizationMetric = LambdaFunctionUtilizationMetric(this)
    }
}
