// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a filter that returns a more specific list of recommendations. Use this
 * filter with the GetAutoScalingGroupRecommendations and GetEC2InstanceRecommendations actions.
 * You can use EBSFilter with the GetEBSVolumeRecommendations action,
 * LambdaFunctionRecommendationFilter with the GetLambdaFunctionRecommendations action, and JobFilter with
 * the DescribeRecommendationExportJobs action.
 */
class Filter private constructor(builder: Builder) {
    /**
     * The name of the filter.
     * Specify Finding to return recommendations with a specific finding
     * classification (for example, Underprovisioned).
     * Specify RecommendationSourceType to return recommendations of a specific
     * resource type (for example, Ec2Instance).
     * Specify FindingReasonCodes to return recommendations with a specific
     * finding reason code (for example, CPUUnderprovisioned).
     */
    val name: aws.sdk.kotlin.services.computeoptimizer.model.FilterName? = builder.name
    /**
     * The value of the filter.
     * The valid values for this parameter are as follows, depending on what you specify for
     * the name parameter and the resource type that you wish to filter results
     * for:
     * Specify Optimized or NotOptimized if you specify the
     * name parameter as Finding and you want to filter
     * results for Auto Scaling groups.
     * Specify Underprovisioned, Overprovisioned, or
     * Optimized if you specify the name parameter as
     * Finding and you want to filter results for EC2
     * instances.
     * Specify Ec2Instance or AutoScalingGroup if you
     * specify the name parameter as
     * RecommendationSourceType.
     * Specify one of the following options if you specify the name
     * parameter as FindingReasonCodes:
     * CPUOverprovisioned
     * — The
     * instance’s CPU configuration can be sized down while still meeting the
     * performance requirements of your workload.
     * CPUUnderprovisioned
     * —
     * The instance’s CPU configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type
     * that provides better CPU performance.
     * MemoryOverprovisioned
     * —
     * The instance’s memory configuration can be sized down while still
     * meeting the performance requirements of your workload.
     * MemoryUnderprovisioned
     * —
     * The instance’s memory configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type
     * that provides better memory performance.
     * EBSThroughputOverprovisioned
     * — The
     * instance’s EBS throughput configuration can be sized down while still
     * meeting the performance requirements of your workload.
     * EBSThroughputUnderprovisioned
     * — The
     * instance’s EBS throughput configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type
     * that provides better EBS throughput performance.
     * EBSIOPSOverprovisioned
     * —
     * The instance’s EBS IOPS configuration can be sized down while still
     * meeting the performance requirements of your workload.
     * EBSIOPSUnderprovisioned
     * — The instance’s EBS IOPS configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type
     * that provides better EBS IOPS performance.
     * NetworkBandwidthOverprovisioned
     * — The
     * instance’s network bandwidth configuration can be sized down while still
     * meeting the performance requirements of your workload.
     * NetworkBandwidthUnderprovisioned
     * — The
     * instance’s network bandwidth configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type
     * that provides better network bandwidth performance. This finding reason
     * happens when the NetworkIn or NetworkOut
     * performance of an instance is impacted.
     * NetworkPPSOverprovisioned
     * — The instance’s
     * network PPS (packets per second) configuration can be sized down while
     * still meeting the performance requirements of your workload.
     * NetworkPPSUnderprovisioned
     * — The instance’s
     * network PPS (packets per second) configuration doesn't meet the
     * performance requirements of your workload and there is an alternative
     * instance type that provides better network PPS performance.
     * DiskIOPSOverprovisioned
     * — The instance’s disk IOPS configuration can be sized down while still
     * meeting the performance requirements of your workload.
     * DiskIOPSUnderprovisioned
     * — The instance’s disk IOPS configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type
     * that provides better disk IOPS performance.
     * DiskThroughputOverprovisioned
     * — The
     * instance’s disk throughput configuration can be sized down while still
     * meeting the performance requirements of your workload.
     * DiskThroughputUnderprovisioned
     * — The
     * instance’s disk throughput configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type
     * that provides better disk throughput performance.
     */
    val values: List<String>? = builder.values

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("name=$name,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Filter

        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.Filter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the filter.
         * Specify Finding to return recommendations with a specific finding
         * classification (for example, Underprovisioned).
         * Specify RecommendationSourceType to return recommendations of a specific
         * resource type (for example, Ec2Instance).
         * Specify FindingReasonCodes to return recommendations with a specific
         * finding reason code (for example, CPUUnderprovisioned).
         */
        var name: aws.sdk.kotlin.services.computeoptimizer.model.FilterName? = null
        /**
         * The value of the filter.
         * The valid values for this parameter are as follows, depending on what you specify for
         * the name parameter and the resource type that you wish to filter results
         * for:
         * Specify Optimized or NotOptimized if you specify the
         * name parameter as Finding and you want to filter
         * results for Auto Scaling groups.
         * Specify Underprovisioned, Overprovisioned, or
         * Optimized if you specify the name parameter as
         * Finding and you want to filter results for EC2
         * instances.
         * Specify Ec2Instance or AutoScalingGroup if you
         * specify the name parameter as
         * RecommendationSourceType.
         * Specify one of the following options if you specify the name
         * parameter as FindingReasonCodes:
         * CPUOverprovisioned
         * — The
         * instance’s CPU configuration can be sized down while still meeting the
         * performance requirements of your workload.
         * CPUUnderprovisioned
         * —
         * The instance’s CPU configuration doesn't meet the performance
         * requirements of your workload and there is an alternative instance type
         * that provides better CPU performance.
         * MemoryOverprovisioned
         * —
         * The instance’s memory configuration can be sized down while still
         * meeting the performance requirements of your workload.
         * MemoryUnderprovisioned
         * —
         * The instance’s memory configuration doesn't meet the performance
         * requirements of your workload and there is an alternative instance type
         * that provides better memory performance.
         * EBSThroughputOverprovisioned
         * — The
         * instance’s EBS throughput configuration can be sized down while still
         * meeting the performance requirements of your workload.
         * EBSThroughputUnderprovisioned
         * — The
         * instance’s EBS throughput configuration doesn't meet the performance
         * requirements of your workload and there is an alternative instance type
         * that provides better EBS throughput performance.
         * EBSIOPSOverprovisioned
         * —
         * The instance’s EBS IOPS configuration can be sized down while still
         * meeting the performance requirements of your workload.
         * EBSIOPSUnderprovisioned
         * — The instance’s EBS IOPS configuration doesn't meet the performance
         * requirements of your workload and there is an alternative instance type
         * that provides better EBS IOPS performance.
         * NetworkBandwidthOverprovisioned
         * — The
         * instance’s network bandwidth configuration can be sized down while still
         * meeting the performance requirements of your workload.
         * NetworkBandwidthUnderprovisioned
         * — The
         * instance’s network bandwidth configuration doesn't meet the performance
         * requirements of your workload and there is an alternative instance type
         * that provides better network bandwidth performance. This finding reason
         * happens when the NetworkIn or NetworkOut
         * performance of an instance is impacted.
         * NetworkPPSOverprovisioned
         * — The instance’s
         * network PPS (packets per second) configuration can be sized down while
         * still meeting the performance requirements of your workload.
         * NetworkPPSUnderprovisioned
         * — The instance’s
         * network PPS (packets per second) configuration doesn't meet the
         * performance requirements of your workload and there is an alternative
         * instance type that provides better network PPS performance.
         * DiskIOPSOverprovisioned
         * — The instance’s disk IOPS configuration can be sized down while still
         * meeting the performance requirements of your workload.
         * DiskIOPSUnderprovisioned
         * — The instance’s disk IOPS configuration doesn't meet the performance
         * requirements of your workload and there is an alternative instance type
         * that provides better disk IOPS performance.
         * DiskThroughputOverprovisioned
         * — The
         * instance’s disk throughput configuration can be sized down while still
         * meeting the performance requirements of your workload.
         * DiskThroughputUnderprovisioned
         * — The
         * instance’s disk throughput configuration doesn't meet the performance
         * requirements of your workload and there is an alternative instance type
         * that provides better disk throughput performance.
         */
        var values: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.Filter) : this() {
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.Filter = Filter(this)
    }
}
