// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



class ExportAutoScalingGroupRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The IDs of the Amazon Web Services accounts for which to export Auto Scaling group
     * recommendations.
     * If your account is the management account of an organization, use this parameter to
     * specify the member account for which you want to export recommendations.
     * This parameter cannot be specified together with the include member accounts
     * parameter. The parameters are mutually exclusive.
     * Recommendations for member accounts are not included in the export if this parameter,
     * or the include member accounts parameter, is omitted.
     * You can specify multiple account IDs per request.
     */
    val accountIds: List<String>? = builder.accountIds
    /**
     * The recommendations data to include in the export file. For more information about the
     * fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files in the Compute Optimizer User
     * Guide.
     */
    val fieldsToExport: List<ExportableAutoScalingGroupField>? = builder.fieldsToExport
    /**
     * The format of the export file.
     * The only export file format currently supported is Csv.
     */
    val fileFormat: aws.sdk.kotlin.services.computeoptimizer.model.FileFormat? = builder.fileFormat
    /**
     * An array of objects to specify a filter that exports a more specific set of Auto Scaling group recommendations.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * Indicates whether to include recommendations for resources in all member accounts of
     * the organization if your account is the management account of an organization.
     * The member accounts must also be opted in to Compute Optimizer, and trusted access for
     * Compute Optimizer must be enabled in the organization account. For more information,
     * see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access in the
     * Compute Optimizer User Guide.
     * Recommendations for member accounts of the organization are not included in the export
     * file if this parameter is omitted.
     * This parameter cannot be specified together with the account IDs parameter. The
     * parameters are mutually exclusive.
     * Recommendations for member accounts are not included in the export if this parameter,
     * or the account IDs parameter, is omitted.
     */
    val includeMemberAccounts: kotlin.Boolean = builder.includeMemberAccounts
    /**
     * An object to specify the preferences for the Auto Scaling group recommendations
     * to export.
     */
    val recommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences? = builder.recommendationPreferences
    /**
     * An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket
     * name and key prefix for the export job.
     * You must create the destination Amazon S3 bucket for your recommendations
     * export before you create the export job. Compute Optimizer does not create the S3 bucket
     * for you. After you create the S3 bucket, ensure that it has the required permissions
     * policy  to allow Compute Optimizer to write the export file to it. If you plan to
     * specify an object prefix when you create the export job, you must include the object
     * prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer in the
     * Compute Optimizer User Guide.
     */
    val s3DestinationConfig: aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig? = builder.s3DestinationConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportAutoScalingGroupRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("fieldsToExport=$fieldsToExport,")
        append("fileFormat=$fileFormat,")
        append("filters=$filters,")
        append("includeMemberAccounts=$includeMemberAccounts,")
        append("recommendationPreferences=$recommendationPreferences,")
        append("s3DestinationConfig=$s3DestinationConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (fieldsToExport?.hashCode() ?: 0)
        result = 31 * result + (fileFormat?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includeMemberAccounts.hashCode())
        result = 31 * result + (recommendationPreferences?.hashCode() ?: 0)
        result = 31 * result + (s3DestinationConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportAutoScalingGroupRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (fieldsToExport != other.fieldsToExport) return false
        if (fileFormat != other.fileFormat) return false
        if (filters != other.filters) return false
        if (includeMemberAccounts != other.includeMemberAccounts) return false
        if (recommendationPreferences != other.recommendationPreferences) return false
        if (s3DestinationConfig != other.s3DestinationConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The IDs of the Amazon Web Services accounts for which to export Auto Scaling group
         * recommendations.
         * If your account is the management account of an organization, use this parameter to
         * specify the member account for which you want to export recommendations.
         * This parameter cannot be specified together with the include member accounts
         * parameter. The parameters are mutually exclusive.
         * Recommendations for member accounts are not included in the export if this parameter,
         * or the include member accounts parameter, is omitted.
         * You can specify multiple account IDs per request.
         */
        var accountIds: List<String>? = null
        /**
         * The recommendations data to include in the export file. For more information about the
         * fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files in the Compute Optimizer User
         * Guide.
         */
        var fieldsToExport: List<ExportableAutoScalingGroupField>? = null
        /**
         * The format of the export file.
         * The only export file format currently supported is Csv.
         */
        var fileFormat: aws.sdk.kotlin.services.computeoptimizer.model.FileFormat? = null
        /**
         * An array of objects to specify a filter that exports a more specific set of Auto Scaling group recommendations.
         */
        var filters: List<Filter>? = null
        /**
         * Indicates whether to include recommendations for resources in all member accounts of
         * the organization if your account is the management account of an organization.
         * The member accounts must also be opted in to Compute Optimizer, and trusted access for
         * Compute Optimizer must be enabled in the organization account. For more information,
         * see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access in the
         * Compute Optimizer User Guide.
         * Recommendations for member accounts of the organization are not included in the export
         * file if this parameter is omitted.
         * This parameter cannot be specified together with the account IDs parameter. The
         * parameters are mutually exclusive.
         * Recommendations for member accounts are not included in the export if this parameter,
         * or the account IDs parameter, is omitted.
         */
        var includeMemberAccounts: kotlin.Boolean = false
        /**
         * An object to specify the preferences for the Auto Scaling group recommendations
         * to export.
         */
        var recommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences? = null
        /**
         * An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket
         * name and key prefix for the export job.
         * You must create the destination Amazon S3 bucket for your recommendations
         * export before you create the export job. Compute Optimizer does not create the S3 bucket
         * for you. After you create the S3 bucket, ensure that it has the required permissions
         * policy  to allow Compute Optimizer to write the export file to it. If you plan to
         * specify an object prefix when you create the export job, you must include the object
         * prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer in the
         * Compute Optimizer User Guide.
         */
        var s3DestinationConfig: aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.fieldsToExport = x.fieldsToExport
            this.fileFormat = x.fileFormat
            this.filters = x.filters
            this.includeMemberAccounts = x.includeMemberAccounts
            this.recommendationPreferences = x.recommendationPreferences
            this.s3DestinationConfig = x.s3DestinationConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest = ExportAutoScalingGroupRecommendationsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences] inside the given [block]
         */
        fun recommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.recommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig] inside the given [block]
         */
        fun s3DestinationConfig(block: aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig.Builder.() -> kotlin.Unit) {
            this.s3DestinationConfig = aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig.invoke(block)
        }
    }
}
